/*==================================================================
 * smurfcfg.h - Header file for Smurf pref file loading
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __SMURFCFG_H__
#define __SMURFCFG_H__

#include <glib.h>

enum
{
  SMURFCFG_INVALID = G_TOKEN_LAST,	/* dummy token to mark start */

/* VERSION is saved to both config files */

  SMURFCFG_VERSION,		/* version of Smurf that wrote config file */

/* Smurf state related values (saved into smurf_state.cfg on exit) */

  SMURFCFG_WIN_XPOS,		/* saved window geometry X position */
  SMURFCFG_WIN_YPOS,		/* saved window geometry Y position */
  SMURFCFG_WIN_WIDTH,		/* saved window geometry WIDTH */
  SMURFCFG_WIN_HEIGHT,		/* saved window geometry HEIGHT */
  SMURFCFG_TREEWIN_WIDTH,	/* width of sound font tree window pane */
  SMURFCFG_TREEWIN_HEIGHT,	/* height of sound font tree window pane */

  SMURFCFG_TIPS_POSITION,	/* position (tip #) in tips array */

  SMURFCFG_STATE_LAST,		/* dummy enum to separate state/pref vars */

/* Smurf preferences (requires manual saving by user, saved to smurf.cfg) */

  SMURFCFG_DEF_SFONT_PATH,	/* default sound font load/save path */
  SMURFCFG_DEF_SAMPLE_PATH,	/* default sample load path */
  SMURFCFG_VBNK_SEARCH_PATH,	/* colon delimited dir list to search */

  SMURFCFG_QUIT_CONFIRM,	/* type of quit confirmation, see enum below */
  SMURFCFG_DISABLE_SPLASH,	/* Set to TRUE to disable splash image */

  SMURFCFG_TIPS_ENABLED,	/* show Smurfy tips on startup? */

  SMURFCFG_SAVE_WIN_GEOM,	/* ?save window geometry on exit? */
  SMURFCFG_SET_WIN_POS,		/* set window position on startup? */

  SMURFCFG_SET_PANE_SIZE,	/* set sfont tree pane size or autosize it */

  SMURFCFG_TEMP_AUDIBLE_BANK,	/* bank to map temporary audible to */
  SMURFCFG_TEMP_AUDIBLE_PRESET,	/* preset # to map temporary audible to */
  SMURFCFG_WAVETBL_SAM_CACHING,	/* 0/1/2:off/on/auto: wavetbl sample caching */
  SMURFCFG_SAM_SFSPEC,		/* ?sfont spec sizes for min loop and pad? */
  SMURFCFG_SAM_MINLOOP,		/* if !SAM_SFSPEC, = min loop size */
  SMURFCFG_SAM_MINLOOPPAD,	/* if !SAM_SFSPEC, = min loop padding size */
  SMURFCFG_SAM_BUF_WASTE,	/* maximum allowed sample buffer waste in MB */
  SMURFCFG_SAM_CH1_POSTFIX,	/* str appended to 1st chan of stereo sample */
  SMURFCFG_SAM_CH2_POSTFIX,	/* str appended to 2nd chan of stereo sample */

  SMURFCFG_WAVETBL_DRIVER,	/* NAME of wavetable driver to use, or AUTO */
  SMURFCFG_WAVETBL_OSSDEV,	/* OSS device (i.e. /dev/sequencer) */

  SMURFCFG_SEQ_DRIVER,		/* Name of sequencer driver or AUTO */
  SMURFCFG_SEQ_ALSACLIENT,	/* ALSA sequencer client (or -1 for auto) */
  SMURFCFG_SEQ_ALSAPORT,	/* ALSA sequencer port,ignored if client==-1 */

  SMURFCFG_MIDI_DRIVER,		/* NAME of midi thru driver to use */

  SMURFCFG_MIDI_ALSA_INCLIENT,	/* ALSA seq input client (or 0 for auto) */
  SMURFCFG_MIDI_ALSA_INPORT,	/* ALSA seq input port,ignored if client==0 */
  SMURFCFG_MIDI_ALSA_OUTCLIENT,	/* ALSA seq output client (or 0 for auto) */
  SMURFCFG_MIDI_ALSA_OUTPORT,	/* ALSA seq output port,ignored if client==0 */

  SMURFCFG_MIDI_ALSACARD,	/* ALSA midi card number */
  SMURFCFG_MIDI_ALSADEVICE,	/* ALSA midi device number on ALSACARD */

  SMURFCFG_VELBAR_SCOLOR,	/* start color for velocity bar */
  SMURFCFG_VELBAR_ECOLOR,	/* end color for velocity bar */

  SMURFCFG_PIANO_LOWOCTKEYS,    /* lower octave keys */
  SMURFCFG_PIANO_HIOCTKEYS,     /* upper octave keys */

  SMURFCFG_LAST			/* dummy token to mark end */
}
SmurfCFG;

enum
{
  SMURFCFG_QUIT_CONFIRM_ALWAYS,	/* always pop a quit confirmation */
  SMURFCFG_QUIT_CONFIRM_UNSAVED,	/* only if there are unsaved files */
  SMURFCFG_QUIT_CONFIRM_NEVER	/* spontaneous combust */
};

gboolean smurfcfg_up2date;

gint smurfcfg_load (void);
gint smurfcfg_load_state (void);
gint smurfcfg_save (void);
gint smurfcfg_save_state (void);
GTokenValue *smurfcfg_get_val (guint var);
gint smurfcfg_get_int (guint var);
gchar *smurfcfg_get_str (guint var);
void smurfcfg_set_val (guint var, GTokenValue * value);
gint smurfcfg_parse_hashcolor (gchar * clr, guchar * rgb);

#endif /* __SMURFCFG_H__ */
