/*==================================================================
 * uif_piano.h - Header file for piano user interface routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __UIF_PIANO_H__
#define __UIF_PIANO_H__

#define UIPIANO_LOW_NUMKEYS	17
#define UIPIANO_HI_NUMKEYS	20
#define UIPIANO_TOTAL_NUMKEYS	(UIPIANO_LOW_NUMKEYS + UIPIANO_HI_NUMKEYS)

GtkWidget *uipiano_widg;

extern guint uipiano_default_keytable[];
extern guint uipiano_keytable[];

gint uipiano_chan;

void uipiano_create (void);
gchar * uipiano_encode_smurfcfg_octkeys (guint *keyvals, gint keycount);
void uipiano_set_chan (gint chan);
void uipiano_set_bank (gint bank);
void uipiano_set_preset (gint preset);
void uipiano_refresh_bank_preset (void);
gboolean uipiano_cb_key_event (GtkWidget * widg, GdkEventKey * event,
			       gint press);
void uipiano_create_controls (void);
void uipiano_set_all_controls (void);

#endif
