/*==================================================================
 * uif_pref.h - Header file for preference user interface routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef UIF_PREF_H_DEF
#define UIF_PREF_H_DEF

#include <gtk/gtk.h>
#include "sfont.h"

/* function prototypes */

void pref_create (void);

/* Glade callbacks */

void pref_cb_set_pref_okay (GtkWidget * btn, GtkWidget * prefwin);
void pref_cb_save_pref_clicked (GtkWidget * btn, GtkWidget * prefwin);
void pref_cb_path_browse_clicked (GtkWidget * btn, GtkWidget * entry);
void pref_cb_sam_sfspec_toggled (GtkWidget * btn, GtkWidget * prefwin);
void pref_cb_vkeyb_auto_toggled (GtkWidget * btn, GtkWidget * prefwin);
void pref_cb_mthru_inauto_toggled (GtkWidget * btn, GtkWidget * prefwin);
void pref_cb_mthru_outauto_toggled (GtkWidget * btn, GtkWidget * prefwin);
void pref_cb_piano_key_change_octave (GtkWidget * radbtn, GtkWidget * prefwin);
gboolean pref_cb_key_pressed (GtkWidget *prefwin, GdkEventKey *event);
void pref_cb_keymap_change_clicked (GtkWidget * btn, GtkWidget * clist);
void pref_cb_keymap_change_all_clicked (GtkWidget * btn, GtkWidget * clist);
gboolean pref_cb_pianokey_clist_event (GtkWidget *widget, GdkEvent *event,
				       GtkWidget *prefwin);

#endif
