-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CreateInterruptStreamVariables (For_PO         : in Dictionary.Symbol;
                                          Error_Node_Pos : in LexTokenManager.Token_Position) is
   It          : Dictionary.Iterator;
   The_Mapping : Dictionary.Symbol;
begin
   It := Dictionary.FirstInterruptStreamMapping (For_PO);
   while not Dictionary.IsNullIterator (It) loop
      The_Mapping := Dictionary.CurrentSymbol (It);
      Create_Interrupt_Stream_Variable
        (For_PO              => For_PO,
         The_Handler         => Dictionary.GetInterruptStreamMappingHandler (The_Mapping),
         The_Stream_Variable => Dictionary.GetInterruptStreamMappingStream (The_Mapping),
         Error_Node_Pos      => Error_Node_Pos);
      It := Dictionary.NextSymbol (It);
   end loop;
end CreateInterruptStreamVariables;
