/*
 * main.c
 * Copyright (C) Pietro Pilolli 2010 <pilolli@fbk.eu>
 * 
 * spotlighter is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * spotlighter is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <config.h>

#include <gtk/gtk.h>


/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif



#include "callbacks.h"
#include "utils.h"

#ifdef _WIN32
  #define UI_FILE "..\\share\\spotlighter\\ui\\spotlighter.ui" 
#else
  #define UI_FILE PACKAGE_DATA_DIR"/spotlighter/ui/spotlighter.ui"
#endif 

/* For testing propose use the local (not installed) ui file */
//#define UI_FILE "spotlighter.ui"

	
GtkWidget*
create_window (void)
{
  GtkWidget *window;
  GtkBuilder *builder;
  GError* error = NULL;

  builder = gtk_builder_new ();
  if (!gtk_builder_add_from_file (builder, UI_FILE, &error))
    {
      g_warning ("Couldn't load builder file: %s", error->message);
      g_error_free (error);
    }

  window = GTK_WIDGET (gtk_builder_get_object (builder, "window")); 

  int width = gdk_screen_width();
  int height = gdk_screen_height();
   
  gtk_widget_set_usize (window, width, height);
  
  gtk_window_fullscreen(GTK_WINDOW(window)); 
    
  /* This is important */
  gtk_builder_connect_signals (builder, NULL);
  g_object_unref (builder);
	
  return window;
}


int
main (int argc, char *argv[])
{
  GtkWidget *window;

  #ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain (GETTEXT_PACKAGE);
  #endif
	
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  GdkDisplay *display = gdk_display_get_default ();
  GdkScreen   *screen = gdk_display_get_default_screen (display);
  GdkColormap *colormap = gdk_screen_get_rgba_colormap(screen);
  if (colormap)
    {
       gtk_widget_set_default_colormap(colormap);
    }
 
  window = create_window ();
  
  #ifdef _WIN32
    gtk_widget_set_double_buffered(window, FALSE);
  #endif
  
  gtk_window_set_keep_above(GTK_WINDOW(window), TRUE);
  gtk_widget_show_all(window);
   
  gtk_main ();
  return 0;
}
