package org.stegosuite.ui.gui.embedding;

import org.stegosuite.image.embedding.EmbeddingProgress;
import org.stegosuite.model.exception.SteganoEmbedException;
import org.stegosuite.model.exception.SteganoExtractException;
import org.stegosuite.model.payload.Payload;

/**
 * Abstraction layer between the GUI and the embed/extract functions.
 */
public abstract class Embedding {

	public abstract void embed(Payload payload, EmbeddingProgress progress, EmbeddingDoneEvent event)
			throws SteganoEmbedException;

	public void embed(Payload payload, EmbeddingDoneEvent event)
			throws SteganoEmbedException {
		this.embed(payload, null, event);
	}

	public abstract void extract(Payload payload, EmbeddingProgress progress, ExtractingDoneEvent event)
			throws SteganoExtractException;

	public void extract(Payload payload, ExtractingDoneEvent event)
			throws SteganoExtractException {
		this.extract(payload, null, event);
	}

	public abstract int getCapacity();

	public abstract void setPointFilter(int a);

	public abstract Embedding getEmbeddingMethod();
}
