/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "PathSimplifier.h"
#include "svn/Path.h"


PathSimplifier::PathSimplifier( const sc::String& path1, const sc::String& path2 )
{
  if( path1 == path2 )
    simplify(path1);
  else
    simplify(path1,path2);
}

const sc::String& PathSimplifier::getPrefix() const
{
  return _prefix;
}

const sc::String& PathSimplifier::getPath1() const
{
  return _path1;
}

const sc::String& PathSimplifier::getPath2() const
{
  return _path2;
}

void PathSimplifier::simplify( const sc::String& path )
{
  _prefix = svn::Path::getDirName(path);
  _path1  = svn::Path::getBaseName(path);
  _path2  = _path1;
}

void PathSimplifier::simplify( const sc::String& path1, const sc::String& path2 )
{
  svn::Paths paths;
  paths.push_back(path1);
  paths.push_back(path2);
  _prefix = svn::Path::findPrefix(paths);

  _path1 = path1.right( path1.getCharCnt() - _prefix.getCharCnt() - 1 );
  _path2 = path2.right( path2.getCharCnt() - _prefix.getCharCnt() - 1 );
}
