/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp290_ = FALSE;
	ValaMethod* _tmp291_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp459_;
	ValaCCodeExpression* _tmp460_;
	gboolean _tmp461_ = FALSE;
	ValaMethod* _tmp462_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp490_ = FALSE;
	ValaMethod* _tmp491_;
	gboolean _tmp648_ = FALSE;
	ValaMethod* _tmp649_;
	ValaMethod* _tmp703_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp897_;
	ValaIterator* _tmp898_;
	ValaIterator* _tmp1312_;
	gboolean _tmp1322_ = FALSE;
	gboolean _tmp1323_ = FALSE;
	ValaMethod* _tmp1324_;
	gboolean _tmp1449_ = FALSE;
	ValaDelegate* _tmp1450_;
	gboolean _tmp1550_ = FALSE;
	ValaMethod* _tmp1551_;
	gboolean _tmp1567_;
	gboolean _tmp1568_;
	gboolean _tmp1611_ = FALSE;
	ValaDelegate* _tmp1612_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1630_;
	ValaDataType* _tmp1631_;
	gboolean _tmp1632_ = FALSE;
	ValaDataType* _tmp1633_;
	ValaCCodeFunctionCall* _tmp1661_;
	ValaCCodeFunctionCall* _tmp1662_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1675_;
	ValaCCodeFunctionCall* _tmp1676_;
	ValaCCodeFunctionCall* _tmp1691_;
	gboolean _tmp1706_;
	gboolean _tmp1707_;
	gboolean _tmp1731_;
	gboolean _tmp1732_;
	gboolean _tmp1767_ = FALSE;
	gboolean _tmp1768_ = FALSE;
	ValaMethod* _tmp1769_;
	gboolean _tmp1807_ = FALSE;
	gboolean _tmp1808_ = FALSE;
	gboolean _tmp1809_ = FALSE;
	gboolean _tmp1810_ = FALSE;
	gboolean _tmp1811_ = FALSE;
	ValaMethod* _tmp1812_;
	gboolean _tmp1829_ = FALSE;
	gboolean _tmp1830_ = FALSE;
	ValaMethod* _tmp1831_;
	ValaMethod* _tmp1850_;
	gboolean _tmp1966_ = FALSE;
	ValaCodeNode* _tmp1967_;
	ValaCodeNode* _tmp1968_;
	ValaList* _tmp2068_;
	ValaIterator* _tmp2069_;
	gboolean _tmp2220_ = FALSE;
	gboolean _tmp2221_ = FALSE;
	ValaMethod* _tmp2222_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp240_ = FALSE;
		ValaMemberAccess* _tmp241_;
		const gchar* _tmp242_;
		const gchar* _tmp243_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp241_ = ma;
		_tmp242_ = vala_member_access_get_member_name (_tmp241_);
		_tmp243_ = _tmp242_;
		if (g_strcmp0 (_tmp243_, "begin") == 0) {
			ValaMemberAccess* _tmp244_;
			ValaExpression* _tmp245_;
			ValaExpression* _tmp246_;
			ValaSymbol* _tmp247_;
			ValaSymbol* _tmp248_;
			ValaMemberAccess* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			_tmp244_ = ma;
			_tmp245_ = vala_member_access_get_inner (_tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = vala_expression_get_symbol_reference (_tmp246_);
			_tmp248_ = _tmp247_;
			_tmp249_ = ma;
			_tmp250_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp249_);
			_tmp251_ = _tmp250_;
			_tmp240_ = _tmp248_ == _tmp251_;
		} else {
			_tmp240_ = FALSE;
		}
		if (_tmp240_) {
			ValaCCodeFunctionCall* _tmp252_;
			ValaCCodeFunctionCall* _tmp253_;
			ValaMethod* _tmp254_;
			ValaList* _tmp255_;
			_tmp252_ = async_call;
			_tmp253_ = _vala_ccode_node_ref0 (_tmp252_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp253_;
			_tmp254_ = m;
			_tmp255_ = vala_method_get_async_begin_parameters (_tmp254_);
			_vala_iterable_unref0 (params);
			params = _tmp255_;
		} else {
			gboolean _tmp256_ = FALSE;
			ValaMemberAccess* _tmp257_;
			const gchar* _tmp258_;
			const gchar* _tmp259_;
			_tmp257_ = ma;
			_tmp258_ = vala_member_access_get_member_name (_tmp257_);
			_tmp259_ = _tmp258_;
			if (g_strcmp0 (_tmp259_, "end") == 0) {
				ValaMemberAccess* _tmp260_;
				ValaExpression* _tmp261_;
				ValaExpression* _tmp262_;
				ValaSymbol* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaMemberAccess* _tmp265_;
				ValaSymbol* _tmp266_;
				ValaSymbol* _tmp267_;
				_tmp260_ = ma;
				_tmp261_ = vala_member_access_get_inner (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = vala_expression_get_symbol_reference (_tmp262_);
				_tmp264_ = _tmp263_;
				_tmp265_ = ma;
				_tmp266_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp265_);
				_tmp267_ = _tmp266_;
				_tmp256_ = _tmp264_ == _tmp267_;
			} else {
				_tmp256_ = FALSE;
			}
			if (_tmp256_) {
				ValaCCodeFunctionCall* _tmp268_;
				ValaCCodeFunctionCall* _tmp269_;
				ValaMethod* _tmp270_;
				ValaList* _tmp271_;
				_tmp268_ = finish_call;
				_tmp269_ = _vala_ccode_node_ref0 (_tmp268_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp269_;
				_tmp270_ = m;
				_tmp271_ = vala_method_get_async_end_parameters (_tmp270_);
				_vala_iterable_unref0 (params);
				params = _tmp271_;
			} else {
				gboolean _tmp272_;
				gboolean _tmp273_;
				_tmp272_ = vala_method_call_get_is_yield_expression (expr);
				_tmp273_ = _tmp272_;
				if (!_tmp273_) {
					ValaCCodeFunctionCall* _tmp274_;
					ValaCCodeFunctionCall* _tmp275_;
					ValaMethod* _tmp276_;
					ValaList* _tmp277_;
					_tmp274_ = async_call;
					_tmp275_ = _vala_ccode_node_ref0 (_tmp274_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp275_;
					_tmp276_ = m;
					_tmp277_ = vala_method_get_async_begin_parameters (_tmp276_);
					_vala_iterable_unref0 (params);
					params = _tmp277_;
				} else {
					ValaCCodeFunctionCall* _tmp278_;
					ValaCCodeFunctionCall* _tmp279_;
					GHashFunc _tmp280_;
					GEqualFunc _tmp281_;
					GEqualFunc _tmp282_;
					ValaHashMap* _tmp283_;
					ValaHashMap* _tmp284_;
					ValaMethod* _tmp285_;
					ValaCCodeIdentifier* _tmp286_;
					ValaCCodeIdentifier* _tmp287_;
					ValaCCodeMemberAccess* _tmp288_;
					ValaCCodeMemberAccess* _tmp289_;
					_tmp278_ = finish_call;
					_tmp279_ = _vala_ccode_node_ref0 (_tmp278_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp279_;
					_tmp280_ = g_direct_hash;
					_tmp281_ = g_direct_equal;
					_tmp282_ = g_direct_equal;
					_tmp283_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp280_, _tmp281_, _tmp282_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp283_;
					_tmp284_ = out_arg_map;
					_tmp285_ = m;
					_tmp286_ = vala_ccode_identifier_new ("_data_");
					_tmp287_ = _tmp286_;
					_tmp288_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp287_, "_res_");
					_tmp289_ = _tmp288_;
					vala_map_set ((ValaMap*) _tmp284_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp285_), FALSE)), (ValaCCodeExpression*) _tmp289_);
					_vala_ccode_node_unref0 (_tmp289_);
					_vala_ccode_node_unref0 (_tmp287_);
				}
			}
		}
	}
	_tmp291_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp291_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp292_;
		ValaSymbol* _tmp293_;
		ValaSymbol* _tmp294_;
		_tmp292_ = m;
		_tmp293_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp292_);
		_tmp294_ = _tmp293_;
		_tmp290_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp294_, VALA_TYPE_CLASS);
	} else {
		_tmp290_ = FALSE;
	}
	if (_tmp290_) {
		ValaCodeContext* _tmp295_;
		ValaCodeContext* _tmp296_;
		ValaProfile _tmp297_;
		ValaProfile _tmp298_;
		ValaClass* _tmp310_;
		ValaClass* _tmp311_;
		gboolean _tmp312_;
		gboolean _tmp313_;
		_tmp295_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_code_context_get_profile (_tmp296_);
		_tmp298_ = _tmp297_;
		if (_tmp298_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp299_;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			gboolean _tmp302_;
			gboolean _tmp303_;
			_tmp299_ = m;
			_tmp300_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp299_);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp301_, VALA_TYPE_CLASS, ValaClass));
			_tmp303_ = _tmp302_;
			if (!_tmp303_) {
				ValaCCodeFunctionCall* _tmp304_;
				ValaCCodeExpression* _tmp305_;
				ValaCCodeExpression* _tmp306_;
				_tmp304_ = ccall;
				_tmp305_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp306_ = _tmp305_;
				vala_ccode_function_call_add_argument (_tmp304_, _tmp306_);
				_vala_ccode_node_unref0 (_tmp306_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp307_;
			ValaCCodeExpression* _tmp308_;
			ValaCCodeExpression* _tmp309_;
			_tmp307_ = ccall;
			_tmp308_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp309_ = _tmp308_;
			vala_ccode_function_call_add_argument (_tmp307_, _tmp309_);
			_vala_ccode_node_unref0 (_tmp309_);
		}
		_tmp310_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp311_ = _tmp310_;
		_tmp312_ = vala_class_get_is_compact (_tmp311_);
		_tmp313_ = _tmp312_;
		if (!_tmp313_) {
			ValaClass* _tmp314_;
			ValaClass* _tmp315_;
			ValaMethod* _tmp316_;
			ValaSymbol* _tmp317_;
			ValaSymbol* _tmp318_;
			_tmp314_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp315_ = _tmp314_;
			_tmp316_ = m;
			_tmp317_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp316_);
			_tmp318_ = _tmp317_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp318_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp319_;
					ValaClass* _tmp320_;
					ValaList* _tmp321_;
					ValaList* _tmp322_;
					gint _base_type_size = 0;
					ValaList* _tmp323_;
					gint _tmp324_;
					gint _tmp325_;
					gint _base_type_index = 0;
					_tmp319_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp320_ = _tmp319_;
					_tmp321_ = vala_class_get_base_types (_tmp320_);
					_tmp322_ = _vala_iterable_ref0 (_tmp321_);
					_base_type_list = _tmp322_;
					_tmp323_ = _base_type_list;
					_tmp324_ = vala_collection_get_size ((ValaCollection*) _tmp323_);
					_tmp325_ = _tmp324_;
					_base_type_size = _tmp325_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp326_;
						gint _tmp327_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp328_;
						gpointer _tmp329_;
						ValaDataType* _tmp330_;
						ValaTypeSymbol* _tmp331_;
						ValaTypeSymbol* _tmp332_;
						_base_type_index = _base_type_index + 1;
						_tmp326_ = _base_type_index;
						_tmp327_ = _base_type_size;
						if (!(_tmp326_ < _tmp327_)) {
							break;
						}
						_tmp328_ = _base_type_list;
						_tmp329_ = vala_list_get (_tmp328_, _base_type_index);
						base_type = (ValaDataType*) _tmp329_;
						_tmp330_ = base_type;
						_tmp331_ = vala_data_type_get_type_symbol (_tmp330_);
						_tmp332_ = _tmp331_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp332_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp333_;
							gchar* _tmp334_;
							gchar* _tmp335_;
							gboolean _tmp336_;
							ValaHashMap* _tmp342_;
							ValaDataType* _tmp343_;
							ValaList* _tmp344_;
							ValaList* _tmp345_;
							type_parameters = NULL;
							_tmp333_ = m;
							_tmp334_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp333_);
							_tmp335_ = _tmp334_;
							_tmp336_ = g_strcmp0 (_tmp335_, "g_object_new") == 0;
							_g_free0 (_tmp335_);
							if (_tmp336_) {
								ValaDataType* _tmp337_;
								ValaTypeSymbol* _tmp338_;
								ValaTypeSymbol* _tmp339_;
								ValaList* _tmp340_;
								ValaList* _tmp341_;
								_tmp337_ = base_type;
								_tmp338_ = vala_data_type_get_type_symbol (_tmp337_);
								_tmp339_ = _tmp338_;
								_tmp340_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp339_, VALA_TYPE_CLASS, ValaClass));
								_tmp341_ = _vala_iterable_ref0 (_tmp340_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp341_;
							}
							_tmp342_ = in_arg_map;
							_tmp343_ = base_type;
							_tmp344_ = vala_data_type_get_type_arguments (_tmp343_);
							_tmp345_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp342_, _tmp344_, (ValaCodeNode*) expr, TRUE, _tmp345_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp346_;
				ValaSymbol* _tmp347_;
				ValaSymbol* _tmp348_;
				ValaClass* _tmp349_;
				type_param_index = 0;
				_tmp346_ = m;
				_tmp347_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp346_);
				_tmp348_ = _tmp347_;
				_tmp349_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp348_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp349_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp350_;
					ValaList* _tmp351_;
					ValaList* _tmp352_;
					gint _type_param_size = 0;
					ValaList* _tmp353_;
					gint _tmp354_;
					gint _tmp355_;
					gint _type_param_index = 0;
					_tmp350_ = cl;
					_tmp351_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp350_);
					_tmp352_ = _vala_iterable_ref0 (_tmp351_);
					_type_param_list = _tmp352_;
					_tmp353_ = _type_param_list;
					_tmp354_ = vala_collection_get_size ((ValaCollection*) _tmp353_);
					_tmp355_ = _tmp354_;
					_type_param_size = _tmp355_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp356_;
						gint _tmp357_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp358_;
						gpointer _tmp359_;
						ValaHashMap* _tmp360_;
						ValaTypeParameter* _tmp361_;
						const gchar* _tmp362_;
						const gchar* _tmp363_;
						gchar* _tmp364_;
						gchar* _tmp365_;
						gchar* _tmp366_;
						gchar* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaCCodeIdentifier* _tmp369_;
						ValaHashMap* _tmp370_;
						ValaTypeParameter* _tmp371_;
						const gchar* _tmp372_;
						const gchar* _tmp373_;
						gchar* _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						ValaCCodeIdentifier* _tmp378_;
						ValaCCodeIdentifier* _tmp379_;
						ValaHashMap* _tmp380_;
						ValaTypeParameter* _tmp381_;
						const gchar* _tmp382_;
						const gchar* _tmp383_;
						gchar* _tmp384_;
						gchar* _tmp385_;
						gchar* _tmp386_;
						gchar* _tmp387_;
						ValaCCodeIdentifier* _tmp388_;
						ValaCCodeIdentifier* _tmp389_;
						gint _tmp390_;
						_type_param_index = _type_param_index + 1;
						_tmp356_ = _type_param_index;
						_tmp357_ = _type_param_size;
						if (!(_tmp356_ < _tmp357_)) {
							break;
						}
						_tmp358_ = _type_param_list;
						_tmp359_ = vala_list_get (_tmp358_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp359_;
						_tmp360_ = in_arg_map;
						_tmp361_ = type_param;
						_tmp362_ = vala_symbol_get_name ((ValaSymbol*) _tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = g_ascii_strdown (_tmp363_, (gssize) -1);
						_tmp365_ = _tmp364_;
						_tmp366_ = g_strdup_printf ("%s_type", _tmp365_);
						_tmp367_ = _tmp366_;
						_tmp368_ = vala_ccode_identifier_new (_tmp367_);
						_tmp369_ = _tmp368_;
						vala_map_set ((ValaMap*) _tmp360_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp369_);
						_vala_ccode_node_unref0 (_tmp369_);
						_g_free0 (_tmp367_);
						_g_free0 (_tmp365_);
						_tmp370_ = in_arg_map;
						_tmp371_ = type_param;
						_tmp372_ = vala_symbol_get_name ((ValaSymbol*) _tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = g_ascii_strdown (_tmp373_, (gssize) -1);
						_tmp375_ = _tmp374_;
						_tmp376_ = g_strdup_printf ("%s_dup_func", _tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_ccode_identifier_new (_tmp377_);
						_tmp379_ = _tmp378_;
						vala_map_set ((ValaMap*) _tmp370_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp379_);
						_vala_ccode_node_unref0 (_tmp379_);
						_g_free0 (_tmp377_);
						_g_free0 (_tmp375_);
						_tmp380_ = in_arg_map;
						_tmp381_ = type_param;
						_tmp382_ = vala_symbol_get_name ((ValaSymbol*) _tmp381_);
						_tmp383_ = _tmp382_;
						_tmp384_ = g_ascii_strdown (_tmp383_, (gssize) -1);
						_tmp385_ = _tmp384_;
						_tmp386_ = g_strdup_printf ("%s_destroy_func", _tmp385_);
						_tmp387_ = _tmp386_;
						_tmp388_ = vala_ccode_identifier_new (_tmp387_);
						_tmp389_ = _tmp388_;
						vala_map_set ((ValaMap*) _tmp380_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp389_);
						_vala_ccode_node_unref0 (_tmp389_);
						_g_free0 (_tmp387_);
						_g_free0 (_tmp385_);
						_tmp390_ = type_param_index;
						type_param_index = _tmp390_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp391_;
			ValaClass* _tmp392_;
			ValaClass* _tmp393_;
			ValaClass* _tmp394_;
			ValaClass* _tmp395_;
			_tmp391_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp392_ = _tmp391_;
			_tmp393_ = vala_class_get_base_class (_tmp392_);
			_tmp394_ = _tmp393_;
			_tmp395_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp394_ == _tmp395_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp396_;
				ValaClass* _tmp397_;
				gchar* _tmp398_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp399_;
				ValaCCodeDeclaration* _tmp400_;
				ValaCCodeDeclaration* _tmp401_;
				const gchar* _tmp402_;
				const gchar* _tmp403_;
				const gchar* _tmp404_;
				const gchar* _tmp405_;
				gchar* _tmp406_;
				gchar* _tmp407_;
				ValaCCodeConstant* _tmp408_;
				ValaCCodeConstant* _tmp409_;
				ValaCCodeVariableDeclarator* _tmp410_;
				ValaCCodeVariableDeclarator* _tmp411_;
				ValaCCodeFunction* _tmp412_;
				ValaCCodeFunction* _tmp413_;
				ValaCCodeDeclaration* _tmp414_;
				ValaCCodeFunctionCall* _tmp415_;
				ValaCCodeIdentifier* _tmp416_;
				ValaCCodeIdentifier* _tmp417_;
				ValaCCodeUnaryExpression* _tmp418_;
				ValaCCodeUnaryExpression* _tmp419_;
				ValaCCodeCastExpression* _tmp420_;
				ValaCCodeCastExpression* _tmp421_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp422_;
				ValaCCodeIdentifier* _tmp423_;
				ValaCCodeFunctionCall* _tmp424_;
				ValaCCodeFunctionCall* _tmp425_;
				ValaCCodeFunctionCall* _tmp426_;
				ValaClass* _tmp427_;
				ValaClass* _tmp428_;
				gchar* _tmp429_;
				gchar* _tmp430_;
				ValaCCodeIdentifier* _tmp431_;
				ValaCCodeIdentifier* _tmp432_;
				ValaCCodeFunctionCall* _tmp433_;
				ValaCCodeFunctionCall* _tmp434_;
				_tmp396_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp397_ = _tmp396_;
				_tmp398_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp397_, NULL);
				class_prefix = _tmp398_;
				_tmp399_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp399_;
				_tmp400_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp400_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp401_ = funcs;
				_tmp402_ = class_prefix;
				_tmp403_ = class_prefix;
				_tmp404_ = class_prefix;
				_tmp405_ = class_prefix;
				_tmp406_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp402_, _tmp403_, _tmp404_, _tmp405_);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_ccode_constant_new (_tmp407_);
				_tmp409_ = _tmp408_;
				_tmp410_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp409_, NULL);
				_tmp411_ = _tmp410_;
				vala_ccode_declaration_add_declarator (_tmp401_, (ValaCCodeDeclarator*) _tmp411_);
				_vala_ccode_node_unref0 (_tmp411_);
				_vala_ccode_node_unref0 (_tmp409_);
				_g_free0 (_tmp407_);
				_tmp412_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp413_ = _tmp412_;
				_tmp414_ = funcs;
				vala_ccode_function_add_statement (_tmp413_, (ValaCCodeNode*) _tmp414_);
				_tmp415_ = ccall;
				_tmp416_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp417_ = _tmp416_;
				_tmp418_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp417_);
				_tmp419_ = _tmp418_;
				_tmp420_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp419_, "GSourceFuncs *");
				_tmp421_ = _tmp420_;
				vala_ccode_function_call_add_argument (_tmp415_, (ValaCCodeExpression*) _tmp421_);
				_vala_ccode_node_unref0 (_tmp421_);
				_vala_ccode_node_unref0 (_tmp419_);
				_vala_ccode_node_unref0 (_tmp417_);
				_tmp422_ = vala_ccode_identifier_new ("sizeof");
				_tmp423_ = _tmp422_;
				_tmp424_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp423_);
				_tmp425_ = _tmp424_;
				_vala_ccode_node_unref0 (_tmp423_);
				csizeof = _tmp425_;
				_tmp426_ = csizeof;
				_tmp427_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp428_ = _tmp427_;
				_tmp429_ = vala_get_ccode_name ((ValaCodeNode*) _tmp428_);
				_tmp430_ = _tmp429_;
				_tmp431_ = vala_ccode_identifier_new (_tmp430_);
				_tmp432_ = _tmp431_;
				vala_ccode_function_call_add_argument (_tmp426_, (ValaCCodeExpression*) _tmp432_);
				_vala_ccode_node_unref0 (_tmp432_);
				_g_free0 (_tmp430_);
				_tmp433_ = ccall;
				_tmp434_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp433_, (ValaCCodeExpression*) _tmp434_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp435_ = FALSE;
		ValaMethod* _tmp436_;
		_tmp436_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp436_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp437_;
			ValaSymbol* _tmp438_;
			ValaSymbol* _tmp439_;
			_tmp437_ = m;
			_tmp438_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp437_);
			_tmp439_ = _tmp438_;
			_tmp435_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp439_, VALA_TYPE_STRUCT);
		} else {
			_tmp435_ = FALSE;
		}
		if (_tmp435_) {
			ValaCCodeFunctionCall* _tmp440_;
			ValaCCodeExpression* _tmp441_;
			ValaCCodeExpression* _tmp442_;
			_tmp440_ = ccall;
			_tmp441_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp442_ = _tmp441_;
			vala_ccode_function_call_add_argument (_tmp440_, _tmp442_);
			_vala_ccode_node_unref0 (_tmp442_);
		} else {
			gboolean _tmp443_ = FALSE;
			gboolean _tmp444_ = FALSE;
			gboolean _tmp445_ = FALSE;
			gboolean _tmp446_ = FALSE;
			ValaMethod* _tmp447_;
			_tmp447_ = m;
			if (_tmp447_ != NULL) {
				ValaMethod* _tmp448_;
				_tmp448_ = m;
				_tmp446_ = vala_method_has_type_parameters (_tmp448_);
			} else {
				_tmp446_ = FALSE;
			}
			if (_tmp446_) {
				ValaMethod* _tmp449_;
				_tmp449_ = m;
				_tmp445_ = !vala_get_ccode_has_generic_type_parameter (_tmp449_);
			} else {
				_tmp445_ = FALSE;
			}
			if (_tmp445_) {
				ValaMethod* _tmp450_;
				_tmp450_ = m;
				_tmp444_ = !vala_get_ccode_simple_generics (_tmp450_);
			} else {
				_tmp444_ = FALSE;
			}
			if (_tmp444_) {
				gboolean _tmp451_ = FALSE;
				ValaCCodeFunctionCall* _tmp452_;
				ValaCCodeFunctionCall* _tmp453_;
				_tmp452_ = ccall;
				_tmp453_ = finish_call;
				if (_tmp452_ != _tmp453_) {
					_tmp451_ = TRUE;
				} else {
					gboolean _tmp454_;
					gboolean _tmp455_;
					_tmp454_ = vala_method_call_get_is_yield_expression (expr);
					_tmp455_ = _tmp454_;
					_tmp451_ = _tmp455_;
				}
				_tmp443_ = _tmp451_;
			} else {
				_tmp443_ = FALSE;
			}
			if (_tmp443_) {
				ValaHashMap* _tmp456_;
				ValaMemberAccess* _tmp457_;
				ValaList* _tmp458_;
				_tmp456_ = in_arg_map;
				_tmp457_ = ma;
				_tmp458_ = vala_member_access_get_type_arguments (_tmp457_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp456_, _tmp458_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp459_ = ccall;
	_tmp460_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp459_);
	ccall_expr = _tmp460_;
	_tmp462_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp462_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp463_;
		ValaCodeContext* _tmp464_;
		ValaProfile _tmp465_;
		ValaProfile _tmp466_;
		_tmp463_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp464_ = _tmp463_;
		_tmp465_ = vala_code_context_get_profile (_tmp464_);
		_tmp466_ = _tmp465_;
		_tmp461_ = _tmp466_ != VALA_PROFILE_POSIX;
	} else {
		_tmp461_ = FALSE;
	}
	if (_tmp461_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp467_;
		ValaExpression* _tmp468_;
		ValaExpression* _tmp469_;
		ValaDataType* _tmp470_;
		ValaDataType* _tmp471_;
		ValaArrayType* _tmp472_;
		ValaHashMap* _tmp473_;
		ValaArrayType* _tmp474_;
		ValaDataType* _tmp475_;
		ValaDataType* _tmp476_;
		gchar* _tmp477_;
		gchar* _tmp478_;
		ValaCCodeIdentifier* _tmp479_;
		ValaCCodeIdentifier* _tmp480_;
		_tmp467_ = ma;
		_tmp468_ = vala_member_access_get_inner (_tmp467_);
		_tmp469_ = _tmp468_;
		_tmp470_ = vala_expression_get_value_type (_tmp469_);
		_tmp471_ = _tmp470_;
		_tmp472_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp471_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp472_;
		_tmp473_ = in_arg_map;
		_tmp474_ = array_type;
		_tmp475_ = vala_array_type_get_element_type (_tmp474_);
		_tmp476_ = _tmp475_;
		_tmp477_ = vala_get_ccode_name ((ValaCodeNode*) _tmp476_);
		_tmp478_ = _tmp477_;
		_tmp479_ = vala_ccode_identifier_new (_tmp478_);
		_tmp480_ = _tmp479_;
		vala_map_set ((ValaMap*) _tmp473_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp480_);
		_vala_ccode_node_unref0 (_tmp480_);
		_g_free0 (_tmp478_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp481_;
		_tmp481_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp481_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp482_;
			_tmp482_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp482_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp483_;
				ValaExpression* _tmp484_;
				ValaExpression* _tmp485_;
				ValaTargetValue* _tmp486_;
				ValaTargetValue* _tmp487_;
				ValaTargetValue* _tmp488_;
				ValaTargetValue* _tmp489_;
				_tmp483_ = ma;
				_tmp484_ = vala_member_access_get_inner (_tmp483_);
				_tmp485_ = _tmp484_;
				_tmp486_ = vala_expression_get_target_value (_tmp485_);
				_tmp487_ = _tmp486_;
				_tmp488_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp487_, (ValaCodeNode*) expr);
				_tmp489_ = _tmp488_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp489_);
				_vala_target_value_unref0 (_tmp489_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp491_ = m;
	if (_tmp491_ != NULL) {
		ValaMethod* _tmp492_;
		gboolean _tmp493_;
		gboolean _tmp494_;
		_tmp492_ = m;
		_tmp493_ = vala_method_get_is_async_callback (_tmp492_);
		_tmp494_ = _tmp493_;
		_tmp490_ = _tmp494_;
	} else {
		_tmp490_ = FALSE;
	}
	if (_tmp490_) {
		ValaMethod* _tmp495_;
		ValaMethod* _tmp496_;
		gboolean _tmp497_;
		gboolean _tmp498_;
		ValaHashMap* _tmp512_;
		ValaMethod* _tmp513_;
		ValaCCodeExpression* _tmp514_;
		ValaHashMap* _tmp515_;
		ValaMethod* _tmp516_;
		ValaCCodeExpression* _tmp517_;
		_tmp495_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp496_ = _tmp495_;
		_tmp497_ = vala_method_get_closure (_tmp496_);
		_tmp498_ = _tmp497_;
		if (_tmp498_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp499_;
			ValaSymbol* _tmp500_;
			ValaSymbol* _tmp501_;
			ValaBlock* _tmp502_;
			ValaBlock* _tmp503_;
			ValaBlock* _tmp504_;
			ValaBlock* _tmp505_;
			gchar* _tmp506_;
			gchar* _tmp507_;
			ValaCCodeExpression* _tmp508_;
			ValaCCodeExpression* _tmp509_;
			ValaCCodeMemberAccess* _tmp510_;
			_tmp499_ = m;
			_tmp500_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp499_);
			_tmp501_ = _tmp500_;
			_tmp502_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp501_, VALA_TYPE_METHOD, ValaMethod));
			_tmp503_ = _tmp502_;
			_tmp504_ = _vala_code_node_ref0 (_tmp503_);
			block = _tmp504_;
			_tmp505_ = block;
			_tmp506_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp505_));
			_tmp507_ = _tmp506_;
			_tmp508_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp507_);
			_tmp509_ = _tmp508_;
			_tmp510_ = vala_ccode_member_access_new_pointer (_tmp509_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp510_;
			_vala_ccode_node_unref0 (_tmp509_);
			_g_free0 (_tmp507_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp511_;
			_tmp511_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp511_;
		}
		_tmp512_ = in_arg_map;
		_tmp513_ = m;
		_tmp514_ = instance;
		vala_map_set ((ValaMap*) _tmp512_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp513_), FALSE)), _tmp514_);
		_tmp515_ = out_arg_map;
		_tmp516_ = m;
		_tmp517_ = instance;
		vala_map_set ((ValaMap*) _tmp515_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp516_), FALSE)), _tmp517_);
	} else {
		gboolean _tmp518_ = FALSE;
		gboolean _tmp519_ = FALSE;
		ValaMethod* _tmp520_;
		_tmp520_ = m;
		if (_tmp520_ != NULL) {
			ValaMethod* _tmp521_;
			ValaMemberBinding _tmp522_;
			ValaMemberBinding _tmp523_;
			_tmp521_ = m;
			_tmp522_ = vala_method_get_binding (_tmp521_);
			_tmp523_ = _tmp522_;
			_tmp519_ = _tmp523_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp519_ = FALSE;
		}
		if (_tmp519_) {
			ValaMethod* _tmp524_;
			_tmp524_ = m;
			_tmp518_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp524_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp518_ = FALSE;
		}
		if (_tmp518_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp525_;
			ValaExpression* _tmp526_;
			ValaExpression* _tmp527_;
			ValaTargetValue* _tmp528_;
			ValaTargetValue* _tmp529_;
			ValaTargetValue* _tmp530_;
			gboolean _tmp531_ = FALSE;
			gboolean _tmp532_ = FALSE;
			ValaMemberAccess* _tmp533_;
			const gchar* _tmp534_;
			const gchar* _tmp535_;
			ValaTargetValue* _tmp557_;
			ValaCCodeExpression* _tmp558_;
			ValaCCodeExpression* _tmp559_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp560_;
			ValaSymbol* _tmp561_;
			ValaSymbol* _tmp562_;
			ValaStruct* _tmp563_;
			gboolean _tmp564_ = FALSE;
			ValaStruct* _tmp565_;
			ValaMethod* _tmp573_;
			gboolean _tmp574_;
			gboolean _tmp575_;
			_tmp525_ = ma;
			_tmp526_ = vala_member_access_get_inner (_tmp525_);
			_tmp527_ = _tmp526_;
			_tmp528_ = vala_expression_get_target_value (_tmp527_);
			_tmp529_ = _tmp528_;
			_tmp530_ = _vala_target_value_ref0 (_tmp529_);
			instance_value = _tmp530_;
			_tmp533_ = ma;
			_tmp534_ = vala_member_access_get_member_name (_tmp533_);
			_tmp535_ = _tmp534_;
			if (g_strcmp0 (_tmp535_, "begin") == 0) {
				_tmp532_ = TRUE;
			} else {
				ValaMemberAccess* _tmp536_;
				const gchar* _tmp537_;
				const gchar* _tmp538_;
				_tmp536_ = ma;
				_tmp537_ = vala_member_access_get_member_name (_tmp536_);
				_tmp538_ = _tmp537_;
				_tmp532_ = g_strcmp0 (_tmp538_, "end") == 0;
			}
			if (_tmp532_) {
				ValaMemberAccess* _tmp539_;
				ValaExpression* _tmp540_;
				ValaExpression* _tmp541_;
				ValaSymbol* _tmp542_;
				ValaSymbol* _tmp543_;
				ValaMemberAccess* _tmp544_;
				ValaSymbol* _tmp545_;
				ValaSymbol* _tmp546_;
				_tmp539_ = ma;
				_tmp540_ = vala_member_access_get_inner (_tmp539_);
				_tmp541_ = _tmp540_;
				_tmp542_ = vala_expression_get_symbol_reference (_tmp541_);
				_tmp543_ = _tmp542_;
				_tmp544_ = ma;
				_tmp545_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp544_);
				_tmp546_ = _tmp545_;
				_tmp531_ = _tmp543_ == _tmp546_;
			} else {
				_tmp531_ = FALSE;
			}
			if (_tmp531_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp547_;
				ValaExpression* _tmp548_;
				ValaExpression* _tmp549_;
				ValaMemberAccess* _tmp550_;
				ValaMemberAccess* _tmp551_;
				ValaExpression* _tmp552_;
				ValaExpression* _tmp553_;
				ValaTargetValue* _tmp554_;
				ValaTargetValue* _tmp555_;
				ValaTargetValue* _tmp556_;
				_tmp547_ = ma;
				_tmp548_ = vala_member_access_get_inner (_tmp547_);
				_tmp549_ = _tmp548_;
				_tmp550_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp549_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp550_;
				_tmp551_ = inner_ma;
				_tmp552_ = vala_member_access_get_inner (_tmp551_);
				_tmp553_ = _tmp552_;
				_tmp554_ = vala_expression_get_target_value (_tmp553_);
				_tmp555_ = _tmp554_;
				_tmp556_ = _vala_target_value_ref0 (_tmp555_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp556_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp557_ = instance_value;
			_tmp558_ = vala_get_cvalue_ (_tmp557_);
			_tmp559_ = _vala_ccode_node_ref0 (_tmp558_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp559_;
			_tmp560_ = m;
			_tmp561_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp560_);
			_tmp562_ = _tmp561_;
			_tmp563_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp562_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp562_) : NULL);
			st = _tmp563_;
			_tmp565_ = st;
			if (_tmp565_ != NULL) {
				ValaStruct* _tmp566_;
				_tmp566_ = st;
				_tmp564_ = !vala_struct_is_simple_type (_tmp566_);
			} else {
				_tmp564_ = FALSE;
			}
			if (_tmp564_) {
				ValaTargetValue* _tmp567_;
				ValaTargetValue* _tmp570_;
				ValaCCodeExpression* _tmp571_;
				ValaCCodeUnaryExpression* _tmp572_;
				_tmp567_ = instance_value;
				if (!vala_get_lvalue (_tmp567_)) {
					ValaTargetValue* _tmp568_;
					ValaTargetValue* _tmp569_;
					_tmp568_ = instance_value;
					_tmp569_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp568_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp569_;
				}
				_tmp570_ = instance_value;
				_tmp571_ = vala_get_cvalue_ (_tmp570_);
				_tmp572_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp571_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp572_;
			}
			_tmp573_ = m;
			_tmp574_ = vala_method_get_coroutine (_tmp573_);
			_tmp575_ = _tmp574_;
			if (!_tmp575_) {
				ValaHashMap* _tmp576_;
				ValaMethod* _tmp577_;
				ValaCCodeExpression* _tmp578_;
				_tmp576_ = in_arg_map;
				_tmp577_ = m;
				_tmp578_ = instance;
				vala_map_set ((ValaMap*) _tmp576_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp577_), FALSE)), _tmp578_);
			} else {
				gboolean _tmp579_;
				gboolean _tmp580_;
				_tmp579_ = vala_method_call_get_is_yield_expression (expr);
				_tmp580_ = _tmp579_;
				if (_tmp580_) {
					ValaHashMap* _tmp581_;
					ValaMethod* _tmp582_;
					ValaCCodeExpression* _tmp583_;
					ValaMethod* _tmp584_;
					_tmp581_ = in_arg_map;
					_tmp582_ = m;
					_tmp583_ = instance;
					vala_map_set ((ValaMap*) _tmp581_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp582_), FALSE)), _tmp583_);
					_tmp584_ = m;
					if (vala_get_ccode_finish_instance (_tmp584_)) {
						ValaHashMap* _tmp585_;
						ValaMethod* _tmp586_;
						ValaCCodeExpression* _tmp587_;
						_tmp585_ = out_arg_map;
						_tmp586_ = m;
						_tmp587_ = instance;
						vala_map_set ((ValaMap*) _tmp585_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp586_), FALSE)), _tmp587_);
					}
				} else {
					gboolean _tmp588_ = FALSE;
					ValaMemberAccess* _tmp589_;
					const gchar* _tmp590_;
					const gchar* _tmp591_;
					_tmp589_ = ma;
					_tmp590_ = vala_member_access_get_member_name (_tmp589_);
					_tmp591_ = _tmp590_;
					if (g_strcmp0 (_tmp591_, "end") != 0) {
						_tmp588_ = TRUE;
					} else {
						ValaMethod* _tmp592_;
						_tmp592_ = m;
						_tmp588_ = vala_get_ccode_finish_instance (_tmp592_);
					}
					if (_tmp588_) {
						ValaHashMap* _tmp593_;
						ValaMethod* _tmp594_;
						ValaCCodeExpression* _tmp595_;
						ValaHashMap* _tmp596_;
						ValaMethod* _tmp597_;
						ValaCCodeExpression* _tmp598_;
						_tmp593_ = out_arg_map;
						_tmp594_ = m;
						_tmp595_ = instance;
						vala_map_set ((ValaMap*) _tmp593_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp594_), FALSE)), _tmp595_);
						_tmp596_ = in_arg_map;
						_tmp597_ = m;
						_tmp598_ = instance;
						vala_map_set ((ValaMap*) _tmp596_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp597_), FALSE)), _tmp598_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp599_ = FALSE;
			ValaMethod* _tmp600_;
			_tmp600_ = m;
			if (_tmp600_ != NULL) {
				ValaMethod* _tmp601_;
				ValaMemberBinding _tmp602_;
				ValaMemberBinding _tmp603_;
				_tmp601_ = m;
				_tmp602_ = vala_method_get_binding (_tmp601_);
				_tmp603_ = _tmp602_;
				_tmp599_ = _tmp603_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp599_ = FALSE;
			}
			if (_tmp599_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp604_;
				ValaSymbol* _tmp605_;
				ValaSymbol* _tmp606_;
				ValaClass* _tmp607_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp608_;
				gchar* _tmp609_;
				gchar* _tmp610_;
				ValaCCodeIdentifier* _tmp611_;
				ValaCCodeIdentifier* _tmp612_;
				ValaCCodeFunctionCall* _tmp613_;
				ValaCCodeFunctionCall* _tmp614_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp615_;
				ValaExpression* _tmp616_;
				ValaExpression* _tmp617_;
				ValaCCodeFunctionCall* _tmp640_;
				ValaCCodeExpression* _tmp641_;
				ValaHashMap* _tmp642_;
				ValaMethod* _tmp643_;
				ValaCCodeFunctionCall* _tmp644_;
				ValaHashMap* _tmp645_;
				ValaMethod* _tmp646_;
				ValaCCodeFunctionCall* _tmp647_;
				_tmp604_ = m;
				_tmp605_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp604_);
				_tmp606_ = _tmp605_;
				_tmp607_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp606_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp607_;
				_tmp608_ = cl;
				_tmp609_ = vala_get_ccode_class_type_function (_tmp608_);
				_tmp610_ = _tmp609_;
				_tmp611_ = vala_ccode_identifier_new (_tmp610_);
				_tmp612_ = _tmp611_;
				_tmp613_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp612_);
				_tmp614_ = _tmp613_;
				_vala_ccode_node_unref0 (_tmp612_);
				_g_free0 (_tmp610_);
				cast = _tmp614_;
				_tmp615_ = ma;
				_tmp616_ = vala_member_access_get_inner (_tmp615_);
				_tmp617_ = _tmp616_;
				if (_tmp617_ == NULL) {
					ValaDataType* _tmp618_;
					_tmp618_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp618_ == NULL) {
						ValaCCodeIdentifier* _tmp619_;
						_tmp619_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp619_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp620_;
						ValaCCodeIdentifier* _tmp621_;
						ValaCCodeFunctionCall* _tmp622_;
						ValaCCodeFunctionCall* _tmp623_;
						ValaCCodeFunctionCall* _tmp624_;
						ValaCCodeExpression* _tmp625_;
						ValaCCodeExpression* _tmp626_;
						ValaCCodeFunctionCall* _tmp627_;
						ValaCCodeExpression* _tmp628_;
						_tmp620_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp621_ = _tmp620_;
						_tmp622_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp621_);
						_tmp623_ = _tmp622_;
						_vala_ccode_node_unref0 (_tmp621_);
						k = _tmp623_;
						_tmp624_ = k;
						_tmp625_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp626_ = _tmp625_;
						vala_ccode_function_call_add_argument (_tmp624_, _tmp626_);
						_vala_ccode_node_unref0 (_tmp626_);
						_tmp627_ = k;
						_tmp628_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp627_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp628_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp629_;
					ValaCCodeIdentifier* _tmp630_;
					ValaCCodeFunctionCall* _tmp631_;
					ValaCCodeFunctionCall* _tmp632_;
					ValaCCodeFunctionCall* _tmp633_;
					ValaMemberAccess* _tmp634_;
					ValaExpression* _tmp635_;
					ValaExpression* _tmp636_;
					ValaCCodeExpression* _tmp637_;
					ValaCCodeFunctionCall* _tmp638_;
					ValaCCodeExpression* _tmp639_;
					_tmp629_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp630_ = _tmp629_;
					_tmp631_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp630_);
					_tmp632_ = _tmp631_;
					_vala_ccode_node_unref0 (_tmp630_);
					k = _tmp632_;
					_tmp633_ = k;
					_tmp634_ = ma;
					_tmp635_ = vala_member_access_get_inner (_tmp634_);
					_tmp636_ = _tmp635_;
					_tmp637_ = vala_get_cvalue (_tmp636_);
					vala_ccode_function_call_add_argument (_tmp633_, _tmp637_);
					_tmp638_ = k;
					_tmp639_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp638_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp639_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp640_ = cast;
				_tmp641_ = klass;
				vala_ccode_function_call_add_argument (_tmp640_, _tmp641_);
				_tmp642_ = in_arg_map;
				_tmp643_ = m;
				_tmp644_ = cast;
				vala_map_set ((ValaMap*) _tmp642_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp643_), FALSE)), (ValaCCodeExpression*) _tmp644_);
				_tmp645_ = out_arg_map;
				_tmp646_ = m;
				_tmp647_ = cast;
				vala_map_set ((ValaMap*) _tmp645_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp646_), FALSE)), (ValaCCodeExpression*) _tmp647_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp649_ = m;
	if (_tmp649_ != NULL) {
		ValaMethod* _tmp650_;
		_tmp650_ = m;
		_tmp648_ = vala_get_ccode_has_generic_type_parameter (_tmp650_);
	} else {
		_tmp648_ = FALSE;
	}
	if (_tmp648_) {
		ValaMethod* _tmp651_;
		_tmp651_ = m;
		if (vala_method_has_type_parameters (_tmp651_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp652_;
				ValaList* _tmp653_;
				ValaList* _tmp654_;
				gint _type_arg_size = 0;
				ValaList* _tmp655_;
				gint _tmp656_;
				gint _tmp657_;
				gint _type_arg_index = 0;
				_tmp652_ = ma;
				_tmp653_ = vala_member_access_get_type_arguments (_tmp652_);
				_tmp654_ = _vala_iterable_ref0 (_tmp653_);
				_type_arg_list = _tmp654_;
				_tmp655_ = _type_arg_list;
				_tmp656_ = vala_collection_get_size ((ValaCollection*) _tmp655_);
				_tmp657_ = _tmp656_;
				_type_arg_size = _tmp657_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp658_;
					gint _tmp659_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp660_;
					gpointer _tmp661_;
					gboolean _tmp662_ = FALSE;
					gboolean _tmp663_ = FALSE;
					gboolean _tmp664_ = FALSE;
					ValaMethod* _tmp665_;
					ValaHashMap* _tmp673_;
					ValaMethod* _tmp674_;
					ValaDataType* _tmp675_;
					gchar* _tmp676_;
					gchar* _tmp677_;
					ValaCCodeIdentifier* _tmp678_;
					ValaCCodeIdentifier* _tmp679_;
					gint _tmp680_;
					_type_arg_index = _type_arg_index + 1;
					_tmp658_ = _type_arg_index;
					_tmp659_ = _type_arg_size;
					if (!(_tmp658_ < _tmp659_)) {
						break;
					}
					_tmp660_ = _type_arg_list;
					_tmp661_ = vala_list_get (_tmp660_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp661_;
					_tmp665_ = m;
					if (vala_get_ccode_simple_generics (_tmp665_)) {
						ValaDataType* _tmp666_;
						_tmp666_ = type_arg;
						_tmp664_ = vala_data_type_is_real_struct_type (_tmp666_);
					} else {
						_tmp664_ = FALSE;
					}
					if (_tmp664_) {
						ValaDataType* _tmp667_;
						gboolean _tmp668_;
						gboolean _tmp669_;
						_tmp667_ = type_arg;
						_tmp668_ = vala_data_type_get_nullable (_tmp667_);
						_tmp669_ = _tmp668_;
						_tmp663_ = !_tmp669_;
					} else {
						_tmp663_ = FALSE;
					}
					if (_tmp663_) {
						ValaDataType* _tmp670_;
						_tmp670_ = type_arg;
						_tmp662_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp670_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp662_ = FALSE;
					}
					if (_tmp662_) {
						ValaDataType* _tmp671_;
						ValaPointerType* _tmp672_;
						_tmp671_ = type_arg;
						_tmp672_ = vala_pointer_type_new (_tmp671_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp672_;
					}
					_tmp673_ = in_arg_map;
					_tmp674_ = m;
					_tmp675_ = type_arg;
					_tmp676_ = vala_get_ccode_name ((ValaCodeNode*) _tmp675_);
					_tmp677_ = _tmp676_;
					_tmp678_ = vala_ccode_identifier_new (_tmp677_);
					_tmp679_ = _tmp678_;
					vala_map_set ((ValaMap*) _tmp673_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp674_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp679_);
					_vala_ccode_node_unref0 (_tmp679_);
					_g_free0 (_tmp677_);
					_tmp680_ = type_param_index;
					type_param_index = _tmp680_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp681_;
				ValaExpression* _tmp682_;
				ValaExpression* _tmp683_;
				ValaDataType* _tmp684_;
				ValaDataType* _tmp685_;
				ValaList* _tmp686_;
				ValaList* _tmp687_;
				gint _type_arg_size = 0;
				ValaList* _tmp688_;
				gint _tmp689_;
				gint _tmp690_;
				gint _type_arg_index = 0;
				_tmp681_ = ma;
				_tmp682_ = vala_member_access_get_inner (_tmp681_);
				_tmp683_ = _tmp682_;
				_tmp684_ = vala_expression_get_value_type (_tmp683_);
				_tmp685_ = _tmp684_;
				_tmp686_ = vala_data_type_get_type_arguments (_tmp685_);
				_tmp687_ = _vala_iterable_ref0 (_tmp686_);
				_type_arg_list = _tmp687_;
				_tmp688_ = _type_arg_list;
				_tmp689_ = vala_collection_get_size ((ValaCollection*) _tmp688_);
				_tmp690_ = _tmp689_;
				_type_arg_size = _tmp690_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp691_;
					gint _tmp692_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp693_;
					gpointer _tmp694_;
					ValaHashMap* _tmp695_;
					ValaMethod* _tmp696_;
					ValaDataType* _tmp697_;
					gchar* _tmp698_;
					gchar* _tmp699_;
					ValaCCodeIdentifier* _tmp700_;
					ValaCCodeIdentifier* _tmp701_;
					gint _tmp702_;
					_type_arg_index = _type_arg_index + 1;
					_tmp691_ = _type_arg_index;
					_tmp692_ = _type_arg_size;
					if (!(_tmp691_ < _tmp692_)) {
						break;
					}
					_tmp693_ = _type_arg_list;
					_tmp694_ = vala_list_get (_tmp693_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp694_;
					_tmp695_ = in_arg_map;
					_tmp696_ = m;
					_tmp697_ = type_arg;
					_tmp698_ = vala_get_ccode_name ((ValaCodeNode*) _tmp697_);
					_tmp699_ = _tmp698_;
					_tmp700_ = vala_ccode_identifier_new (_tmp699_);
					_tmp701_ = _tmp700_;
					vala_map_set ((ValaMap*) _tmp695_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp696_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp701_);
					_vala_ccode_node_unref0 (_tmp701_);
					_g_free0 (_tmp699_);
					_tmp702_ = type_param_index;
					type_param_index = _tmp702_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp703_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp703_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp704_;
		ValaExpression* _tmp705_;
		ValaExpression* _tmp706_;
		ValaDataType* _tmp707_;
		ValaDataType* _tmp708_;
		ValaArrayType* _tmp709_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp710_;
		ValaCCodeIdentifier* _tmp711_;
		ValaCCodeFunctionCall* _tmp712_;
		ValaCCodeFunctionCall* _tmp713_;
		ValaCCodeFunctionCall* _tmp714_;
		ValaArrayType* _tmp715_;
		ValaDataType* _tmp716_;
		ValaDataType* _tmp717_;
		gchar* _tmp718_;
		gchar* _tmp719_;
		ValaCCodeIdentifier* _tmp720_;
		ValaCCodeIdentifier* _tmp721_;
		ValaHashMap* _tmp722_;
		ValaCCodeFunctionCall* _tmp723_;
		_tmp704_ = ma;
		_tmp705_ = vala_member_access_get_inner (_tmp704_);
		_tmp706_ = _tmp705_;
		_tmp707_ = vala_expression_get_value_type (_tmp706_);
		_tmp708_ = _tmp707_;
		_tmp709_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp708_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp709_;
		_tmp710_ = vala_ccode_identifier_new ("sizeof");
		_tmp711_ = _tmp710_;
		_tmp712_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp711_);
		_tmp713_ = _tmp712_;
		_vala_ccode_node_unref0 (_tmp711_);
		csizeof = _tmp713_;
		_tmp714_ = csizeof;
		_tmp715_ = array_type;
		_tmp716_ = vala_array_type_get_element_type (_tmp715_);
		_tmp717_ = _tmp716_;
		_tmp718_ = vala_get_ccode_name ((ValaCodeNode*) _tmp717_);
		_tmp719_ = _tmp718_;
		_tmp720_ = vala_ccode_identifier_new (_tmp719_);
		_tmp721_ = _tmp720_;
		vala_ccode_function_call_add_argument (_tmp714_, (ValaCCodeExpression*) _tmp721_);
		_vala_ccode_node_unref0 (_tmp721_);
		_g_free0 (_tmp719_);
		_tmp722_ = in_arg_map;
		_tmp723_ = csizeof;
		vala_map_set ((ValaMap*) _tmp722_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp723_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp724_;
		_tmp724_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp724_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp725_;
			ValaMethod* _tmp726_;
			ValaMethod* _tmp727_;
			gint param_nr = 0;
			ValaMethod* _tmp793_;
			ValaCCodeBaseModuleEmitContext* _tmp794_;
			_tmp725_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp726_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp725_, (ValaSymbol*) _tmp726_);
			_tmp727_ = m;
			vala_method_clear_parameters (_tmp727_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp728_;
				ValaList* _tmp729_;
				gint _arg_size = 0;
				ValaList* _tmp730_;
				gint _tmp731_;
				gint _tmp732_;
				gint _arg_index = 0;
				_tmp728_ = vala_method_call_get_argument_list (expr);
				_tmp729_ = _vala_iterable_ref0 (_tmp728_);
				_arg_list = _tmp729_;
				_tmp730_ = _arg_list;
				_tmp731_ = vala_collection_get_size ((ValaCollection*) _tmp730_);
				_tmp732_ = _tmp731_;
				_arg_size = _tmp732_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp733_;
					gint _tmp734_;
					ValaExpression* arg = NULL;
					ValaList* _tmp735_;
					gpointer _tmp736_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp737_;
					ValaUnaryExpression* _tmp738_;
					gboolean _tmp739_ = FALSE;
					ValaUnaryExpression* _tmp740_;
					gint _tmp781_;
					_arg_index = _arg_index + 1;
					_tmp733_ = _arg_index;
					_tmp734_ = _arg_size;
					if (!(_tmp733_ < _tmp734_)) {
						break;
					}
					_tmp735_ = _arg_list;
					_tmp736_ = vala_list_get (_tmp735_, _arg_index);
					arg = (ValaExpression*) _tmp736_;
					_tmp737_ = arg;
					_tmp738_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp737_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp737_) : NULL);
					unary = _tmp738_;
					_tmp740_ = unary;
					if (_tmp740_ != NULL) {
						ValaUnaryExpression* _tmp741_;
						ValaUnaryOperator _tmp742_;
						ValaUnaryOperator _tmp743_;
						_tmp741_ = unary;
						_tmp742_ = vala_unary_expression_get_operator (_tmp741_);
						_tmp743_ = _tmp742_;
						_tmp739_ = _tmp743_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp739_ = FALSE;
					}
					if (_tmp739_) {
						ValaParameter* param = NULL;
						gchar* _tmp744_;
						gchar* _tmp745_;
						ValaUnaryExpression* _tmp746_;
						ValaExpression* _tmp747_;
						ValaExpression* _tmp748_;
						ValaDataType* _tmp749_;
						ValaDataType* _tmp750_;
						ValaParameter* _tmp751_;
						ValaParameter* _tmp752_;
						ValaParameter* _tmp753_;
						ValaMethod* _tmp754_;
						ValaParameter* _tmp755_;
						_tmp744_ = g_strdup_printf ("param%d", param_nr);
						_tmp745_ = _tmp744_;
						_tmp746_ = unary;
						_tmp747_ = vala_unary_expression_get_inner (_tmp746_);
						_tmp748_ = _tmp747_;
						_tmp749_ = vala_expression_get_value_type (_tmp748_);
						_tmp750_ = _tmp749_;
						_tmp751_ = vala_parameter_new (_tmp745_, _tmp750_, NULL);
						_tmp752_ = _tmp751_;
						_g_free0 (_tmp745_);
						param = _tmp752_;
						_tmp753_ = param;
						vala_parameter_set_direction (_tmp753_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp754_ = m;
						_tmp755_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp754_, _tmp755_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp756_ = FALSE;
						ValaUnaryExpression* _tmp757_;
						_tmp757_ = unary;
						if (_tmp757_ != NULL) {
							ValaUnaryExpression* _tmp758_;
							ValaUnaryOperator _tmp759_;
							ValaUnaryOperator _tmp760_;
							_tmp758_ = unary;
							_tmp759_ = vala_unary_expression_get_operator (_tmp758_);
							_tmp760_ = _tmp759_;
							_tmp756_ = _tmp760_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp756_ = FALSE;
						}
						if (_tmp756_) {
							ValaParameter* param = NULL;
							gchar* _tmp761_;
							gchar* _tmp762_;
							ValaUnaryExpression* _tmp763_;
							ValaExpression* _tmp764_;
							ValaExpression* _tmp765_;
							ValaDataType* _tmp766_;
							ValaDataType* _tmp767_;
							ValaParameter* _tmp768_;
							ValaParameter* _tmp769_;
							ValaParameter* _tmp770_;
							ValaMethod* _tmp771_;
							ValaParameter* _tmp772_;
							_tmp761_ = g_strdup_printf ("param%d", param_nr);
							_tmp762_ = _tmp761_;
							_tmp763_ = unary;
							_tmp764_ = vala_unary_expression_get_inner (_tmp763_);
							_tmp765_ = _tmp764_;
							_tmp766_ = vala_expression_get_value_type (_tmp765_);
							_tmp767_ = _tmp766_;
							_tmp768_ = vala_parameter_new (_tmp762_, _tmp767_, NULL);
							_tmp769_ = _tmp768_;
							_g_free0 (_tmp762_);
							param = _tmp769_;
							_tmp770_ = param;
							vala_parameter_set_direction (_tmp770_, VALA_PARAMETER_DIRECTION_REF);
							_tmp771_ = m;
							_tmp772_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp771_, _tmp772_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp773_;
							gchar* _tmp774_;
							gchar* _tmp775_;
							ValaExpression* _tmp776_;
							ValaDataType* _tmp777_;
							ValaDataType* _tmp778_;
							ValaParameter* _tmp779_;
							ValaParameter* _tmp780_;
							_tmp773_ = m;
							_tmp774_ = g_strdup_printf ("param%d", param_nr);
							_tmp775_ = _tmp774_;
							_tmp776_ = arg;
							_tmp777_ = vala_expression_get_value_type (_tmp776_);
							_tmp778_ = _tmp777_;
							_tmp779_ = vala_parameter_new (_tmp775_, _tmp778_, NULL);
							_tmp780_ = _tmp779_;
							vala_callable_add_parameter ((ValaCallable*) _tmp773_, _tmp780_);
							_vala_code_node_unref0 (_tmp780_);
							_g_free0 (_tmp775_);
						}
					}
					_tmp781_ = param_nr;
					param_nr = _tmp781_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp782_;
				ValaList* _tmp783_;
				ValaList* _tmp784_;
				gint _param_size = 0;
				ValaList* _tmp785_;
				gint _tmp786_;
				gint _tmp787_;
				gint _param_index = 0;
				_tmp782_ = m;
				_tmp783_ = vala_callable_get_parameters ((ValaCallable*) _tmp782_);
				_tmp784_ = _vala_iterable_ref0 (_tmp783_);
				_param_list = _tmp784_;
				_tmp785_ = _param_list;
				_tmp786_ = vala_collection_get_size ((ValaCollection*) _tmp785_);
				_tmp787_ = _tmp786_;
				_param_size = _tmp787_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp788_;
					gint _tmp789_;
					ValaParameter* param = NULL;
					ValaList* _tmp790_;
					gpointer _tmp791_;
					ValaParameter* _tmp792_;
					_param_index = _param_index + 1;
					_tmp788_ = _param_index;
					_tmp789_ = _param_size;
					if (!(_tmp788_ < _tmp789_)) {
						break;
					}
					_tmp790_ = _param_list;
					_tmp791_ = vala_list_get (_tmp790_, _param_index);
					param = (ValaParameter*) _tmp791_;
					_tmp792_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp792_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp793_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp793_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp794_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp794_);
		} else {
			gboolean _tmp795_ = FALSE;
			gboolean _tmp796_ = FALSE;
			ValaMethod* _tmp797_;
			_tmp797_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp797_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp798_;
				ValaCodeContext* _tmp799_;
				ValaProfile _tmp800_;
				ValaProfile _tmp801_;
				_tmp798_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp799_ = _tmp798_;
				_tmp800_ = vala_code_context_get_profile (_tmp799_);
				_tmp801_ = _tmp800_;
				_tmp796_ = _tmp801_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp796_ = FALSE;
			}
			if (_tmp796_) {
				ValaMethod* _tmp802_;
				ValaSymbol* _tmp803_;
				ValaSymbol* _tmp804_;
				_tmp802_ = m;
				_tmp803_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp802_);
				_tmp804_ = _tmp803_;
				_tmp795_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp804_, VALA_TYPE_CLASS);
			} else {
				_tmp795_ = FALSE;
			}
			if (_tmp795_) {
				ValaCCodeFunction* _tmp805_;
				ValaCCodeFunction* _tmp806_;
				ValaCCodeExpression* _tmp807_;
				ValaCCodeExpression* _tmp808_;
				ValaCCodeFunctionCall* _tmp809_;
				ValaClass* _tmp810_;
				ValaClass* _tmp811_;
				gchar* _tmp812_;
				gchar* _tmp813_;
				gchar* _tmp814_;
				gchar* _tmp815_;
				ValaCCodeCastExpression* _tmp816_;
				ValaCCodeCastExpression* _tmp817_;
				ValaMethod* _tmp818_;
				ValaMethod* _tmp819_;
				ValaBlock* _tmp820_;
				ValaBlock* _tmp821_;
				gboolean _tmp822_;
				gboolean _tmp823_;
				gboolean _tmp850_ = FALSE;
				ValaClass* _tmp851_;
				ValaClass* _tmp852_;
				gboolean _tmp853_;
				gboolean _tmp854_;
				_tmp805_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp806_ = _tmp805_;
				_tmp807_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp808_ = _tmp807_;
				_tmp809_ = ccall;
				_tmp810_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp811_ = _tmp810_;
				_tmp812_ = vala_get_ccode_name ((ValaCodeNode*) _tmp811_);
				_tmp813_ = _tmp812_;
				_tmp814_ = g_strconcat (_tmp813_, "*", NULL);
				_tmp815_ = _tmp814_;
				_tmp816_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp809_, _tmp815_);
				_tmp817_ = _tmp816_;
				vala_ccode_function_add_assignment (_tmp806_, _tmp808_, (ValaCCodeExpression*) _tmp817_);
				_vala_ccode_node_unref0 (_tmp817_);
				_g_free0 (_tmp815_);
				_g_free0 (_tmp813_);
				_vala_ccode_node_unref0 (_tmp808_);
				_tmp818_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp819_ = _tmp818_;
				_tmp820_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp819_);
				_tmp821_ = _tmp820_;
				_tmp822_ = vala_block_get_captured (_tmp821_);
				_tmp823_ = _tmp822_;
				if (_tmp823_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp824_;
					ValaClass* _tmp825_;
					ValaObjectType* _tmp826_;
					ValaObjectType* _tmp827_;
					ValaSourceReference* _tmp828_;
					ValaSourceReference* _tmp829_;
					ValaCCodeExpression* _tmp830_;
					ValaCCodeExpression* _tmp831_;
					ValaCCodeFunctionCall* _tmp832_;
					ValaCCodeFunctionCall* _tmp833_;
					ValaCCodeFunctionCall* _tmp834_;
					ValaCCodeExpression* _tmp835_;
					ValaCCodeExpression* _tmp836_;
					ValaCCodeFunction* _tmp837_;
					ValaCCodeFunction* _tmp838_;
					ValaMethod* _tmp839_;
					ValaMethod* _tmp840_;
					ValaBlock* _tmp841_;
					ValaBlock* _tmp842_;
					gchar* _tmp843_;
					gchar* _tmp844_;
					ValaCCodeExpression* _tmp845_;
					ValaCCodeExpression* _tmp846_;
					ValaCCodeMemberAccess* _tmp847_;
					ValaCCodeMemberAccess* _tmp848_;
					ValaCCodeFunctionCall* _tmp849_;
					_tmp824_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp825_ = _tmp824_;
					_tmp826_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp825_);
					_tmp827_ = _tmp826_;
					_tmp828_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp829_ = _tmp828_;
					_tmp830_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp827_, _tmp829_, FALSE);
					_tmp831_ = _tmp830_;
					_tmp832_ = vala_ccode_function_call_new (_tmp831_);
					_tmp833_ = _tmp832_;
					_vala_ccode_node_unref0 (_tmp831_);
					_vala_code_node_unref0 (_tmp827_);
					ref_call = _tmp833_;
					_tmp834_ = ref_call;
					_tmp835_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp836_ = _tmp835_;
					vala_ccode_function_call_add_argument (_tmp834_, _tmp836_);
					_vala_ccode_node_unref0 (_tmp836_);
					_tmp837_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp838_ = _tmp837_;
					_tmp839_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp840_ = _tmp839_;
					_tmp841_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp840_);
					_tmp842_ = _tmp841_;
					_tmp843_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp842_));
					_tmp844_ = _tmp843_;
					_tmp845_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp844_);
					_tmp846_ = _tmp845_;
					_tmp847_ = vala_ccode_member_access_new_pointer (_tmp846_, "self");
					_tmp848_ = _tmp847_;
					_tmp849_ = ref_call;
					vala_ccode_function_add_assignment (_tmp838_, (ValaCCodeExpression*) _tmp848_, (ValaCCodeExpression*) _tmp849_);
					_vala_ccode_node_unref0 (_tmp848_);
					_vala_ccode_node_unref0 (_tmp846_);
					_g_free0 (_tmp844_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp851_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp852_ = _tmp851_;
				_tmp853_ = vala_class_get_is_compact (_tmp852_);
				_tmp854_ = _tmp853_;
				if (!_tmp854_) {
					ValaClass* _tmp855_;
					ValaClass* _tmp856_;
					_tmp855_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp856_ = _tmp855_;
					_tmp850_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp856_);
				} else {
					_tmp850_ = FALSE;
				}
				if (_tmp850_) {
					gchar** suffices = NULL;
					gchar* _tmp857_;
					gchar* _tmp858_;
					gchar* _tmp859_;
					gchar** _tmp860_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp857_ = g_strdup ("type");
					_tmp858_ = g_strdup ("dup_func");
					_tmp859_ = g_strdup ("destroy_func");
					_tmp860_ = g_new0 (gchar*, 3 + 1);
					_tmp860_[0] = _tmp857_;
					_tmp860_[1] = _tmp858_;
					_tmp860_[2] = _tmp859_;
					suffices = _tmp860_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp861_;
						ValaClass* _tmp862_;
						ValaList* _tmp863_;
						ValaList* _tmp864_;
						gint _type_param_size = 0;
						ValaList* _tmp865_;
						gint _tmp866_;
						gint _tmp867_;
						gint _type_param_index = 0;
						_tmp861_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp862_ = _tmp861_;
						_tmp863_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp862_);
						_tmp864_ = _vala_iterable_ref0 (_tmp863_);
						_type_param_list = _tmp864_;
						_tmp865_ = _type_param_list;
						_tmp866_ = vala_collection_get_size ((ValaCollection*) _tmp865_);
						_tmp867_ = _tmp866_;
						_type_param_size = _tmp867_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp868_;
							gint _tmp869_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp870_;
							gpointer _tmp871_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp872_;
							ValaCCodeIdentifier* _tmp873_;
							ValaCCodeMemberAccess* _tmp874_;
							ValaCCodeMemberAccess* _tmp875_;
							gchar** _tmp876_;
							gint _tmp876__length1;
							_type_param_index = _type_param_index + 1;
							_tmp868_ = _type_param_index;
							_tmp869_ = _type_param_size;
							if (!(_tmp868_ < _tmp869_)) {
								break;
							}
							_tmp870_ = _type_param_list;
							_tmp871_ = vala_list_get (_tmp870_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp871_;
							_tmp872_ = vala_ccode_identifier_new ("self");
							_tmp873_ = _tmp872_;
							_tmp874_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp873_, "priv");
							_tmp875_ = _tmp874_;
							_vala_ccode_node_unref0 (_tmp873_);
							priv_access = _tmp875_;
							_tmp876_ = suffices;
							_tmp876__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp876_;
								suffix_collection_length1 = _tmp876__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp877_;
									gchar* suffix = NULL;
									_tmp877_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp877_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp878_;
										const gchar* _tmp879_;
										const gchar* _tmp880_;
										gchar* _tmp881_;
										gchar* _tmp882_;
										const gchar* _tmp883_;
										gchar* _tmp884_;
										gchar* _tmp885_;
										ValaCCodeIdentifier* _tmp886_;
										ValaCCodeIdentifier* _tmp887_;
										ValaCCodeFunction* _tmp888_;
										ValaCCodeFunction* _tmp889_;
										ValaCCodeMemberAccess* _tmp890_;
										ValaCCodeIdentifier* _tmp891_;
										const gchar* _tmp892_;
										const gchar* _tmp893_;
										ValaCCodeMemberAccess* _tmp894_;
										ValaCCodeMemberAccess* _tmp895_;
										ValaCCodeIdentifier* _tmp896_;
										_tmp878_ = type_param;
										_tmp879_ = vala_symbol_get_name ((ValaSymbol*) _tmp878_);
										_tmp880_ = _tmp879_;
										_tmp881_ = g_ascii_strdown (_tmp880_, (gssize) -1);
										_tmp882_ = _tmp881_;
										_tmp883_ = suffix;
										_tmp884_ = g_strdup_printf ("%s_%s", _tmp882_, _tmp883_);
										_tmp885_ = _tmp884_;
										_tmp886_ = vala_ccode_identifier_new (_tmp885_);
										_tmp887_ = _tmp886_;
										_g_free0 (_tmp885_);
										_g_free0 (_tmp882_);
										param_name = _tmp887_;
										_tmp888_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp889_ = _tmp888_;
										_tmp890_ = priv_access;
										_tmp891_ = param_name;
										_tmp892_ = vala_ccode_identifier_get_name (_tmp891_);
										_tmp893_ = _tmp892_;
										_tmp894_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp890_, _tmp893_);
										_tmp895_ = _tmp894_;
										_tmp896_ = param_name;
										vala_ccode_function_add_assignment (_tmp889_, (ValaCCodeExpression*) _tmp895_, (ValaCCodeExpression*) _tmp896_);
										_vala_ccode_node_unref0 (_tmp895_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp897_ = params;
	_tmp898_ = vala_iterable_iterator ((ValaIterable*) _tmp897_);
	params_it = _tmp898_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp899_;
		ValaList* _tmp900_;
		gint _arg_size = 0;
		ValaList* _tmp901_;
		gint _tmp902_;
		gint _tmp903_;
		gint _arg_index = 0;
		_tmp899_ = vala_method_call_get_argument_list (expr);
		_tmp900_ = _vala_iterable_ref0 (_tmp899_);
		_arg_list = _tmp900_;
		_tmp901_ = _arg_list;
		_tmp902_ = vala_collection_get_size ((ValaCollection*) _tmp901_);
		_tmp903_ = _tmp902_;
		_arg_size = _tmp903_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp904_;
			gint _tmp905_;
			ValaExpression* arg = NULL;
			ValaList* _tmp906_;
			gpointer _tmp907_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp908_;
			ValaCCodeExpression* _tmp909_;
			ValaCCodeExpression* _tmp910_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp911_;
			ValaHashMap* _tmp912_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp913_;
			gboolean _tmp923_ = FALSE;
			ValaParameter* _tmp924_;
			gdouble _tmp1261_ = 0.0;
			gboolean _tmp1262_ = FALSE;
			ValaParameter* _tmp1263_;
			ValaHashMap* _tmp1265_;
			ValaCCodeExpression* _tmp1266_;
			gboolean _tmp1267_ = FALSE;
			ValaMethod* _tmp1268_;
			gboolean _tmp1293_ = FALSE;
			ValaExpression* _tmp1294_;
			gint _tmp1311_;
			_arg_index = _arg_index + 1;
			_tmp904_ = _arg_index;
			_tmp905_ = _arg_size;
			if (!(_tmp904_ < _tmp905_)) {
				break;
			}
			_tmp906_ = _arg_list;
			_tmp907_ = vala_list_get (_tmp906_, _arg_index);
			arg = (ValaExpression*) _tmp907_;
			_tmp908_ = arg;
			_tmp909_ = vala_get_cvalue (_tmp908_);
			_tmp910_ = _vala_ccode_node_ref0 (_tmp909_);
			cexpr = _tmp910_;
			_tmp911_ = in_arg_map;
			_tmp912_ = _vala_map_ref0 (_tmp911_);
			carg_map = _tmp912_;
			param = NULL;
			_tmp913_ = params_it;
			if (vala_iterator_next (_tmp913_)) {
				ValaIterator* _tmp914_;
				gpointer _tmp915_;
				gboolean _tmp916_ = FALSE;
				ValaParameter* _tmp917_;
				gboolean _tmp918_;
				gboolean _tmp919_;
				_tmp914_ = params_it;
				_tmp915_ = vala_iterator_get (_tmp914_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp915_;
				_tmp917_ = param;
				_tmp918_ = vala_parameter_get_params_array (_tmp917_);
				_tmp919_ = _tmp918_;
				if (_tmp919_) {
					_tmp916_ = TRUE;
				} else {
					ValaParameter* _tmp920_;
					gboolean _tmp921_;
					gboolean _tmp922_;
					_tmp920_ = param;
					_tmp921_ = vala_parameter_get_ellipsis (_tmp920_);
					_tmp922_ = _tmp921_;
					_tmp916_ = _tmp922_;
				}
				ellipsis = _tmp916_;
			}
			_tmp924_ = param;
			if (_tmp924_ != NULL) {
				_tmp923_ = !ellipsis;
			} else {
				_tmp923_ = FALSE;
			}
			if (_tmp923_) {
				ValaParameter* _tmp925_;
				ValaParameterDirection _tmp926_;
				ValaParameterDirection _tmp927_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp930_;
				ValaUnaryExpression* _tmp931_;
				gboolean _tmp932_ = FALSE;
				ValaUnaryExpression* _tmp933_;
				ValaParameter* _tmp1191_;
				gchar* _tmp1192_;
				gchar* _tmp1193_;
				gboolean _tmp1194_;
				_tmp925_ = param;
				_tmp926_ = vala_parameter_get_direction (_tmp925_);
				_tmp927_ = _tmp926_;
				if (_tmp927_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp928_;
					ValaHashMap* _tmp929_;
					_tmp928_ = out_arg_map;
					_tmp929_ = _vala_map_ref0 (_tmp928_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp929_;
				}
				_tmp930_ = arg;
				_tmp931_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp930_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp930_) : NULL);
				unary = _tmp931_;
				_tmp933_ = unary;
				if (_tmp933_ == NULL) {
					_tmp932_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp934_;
					ValaUnaryOperator _tmp935_;
					ValaUnaryOperator _tmp936_;
					_tmp934_ = unary;
					_tmp935_ = vala_unary_expression_get_operator (_tmp934_);
					_tmp936_ = _tmp935_;
					_tmp932_ = _tmp936_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp932_) {
					gboolean _tmp937_ = FALSE;
					gboolean _tmp938_ = FALSE;
					ValaParameter* _tmp939_;
					ValaParameter* _tmp1071_;
					ValaExpression* _tmp1072_;
					ValaCCodeExpression* _tmp1073_;
					ValaCCodeExpression* _tmp1074_;
					_tmp939_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp939_)) {
						ValaParameter* _tmp940_;
						ValaDataType* _tmp941_;
						ValaDataType* _tmp942_;
						_tmp940_ = param;
						_tmp941_ = vala_variable_get_variable_type ((ValaVariable*) _tmp940_);
						_tmp942_ = _tmp941_;
						_tmp938_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp942_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp938_ = FALSE;
					}
					if (_tmp938_) {
						ValaParameter* _tmp943_;
						ValaDataType* _tmp944_;
						ValaDataType* _tmp945_;
						gboolean _tmp946_;
						gboolean _tmp947_;
						_tmp943_ = param;
						_tmp944_ = vala_variable_get_variable_type ((ValaVariable*) _tmp943_);
						_tmp945_ = _tmp944_;
						_tmp946_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp945_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp947_ = _tmp946_;
						_tmp937_ = !_tmp947_;
					} else {
						_tmp937_ = FALSE;
					}
					if (_tmp937_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp948_;
						ValaDataType* _tmp949_;
						ValaDataType* _tmp950_;
						ValaArrayType* _tmp951_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp952_;
						gchar* _tmp953_;
						gboolean _tmp954_ = FALSE;
						ValaUnaryExpression* _tmp955_;
						_tmp948_ = param;
						_tmp949_ = vala_variable_get_variable_type ((ValaVariable*) _tmp948_);
						_tmp950_ = _tmp949_;
						_tmp951_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp950_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp951_;
						_tmp952_ = param;
						_tmp953_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp952_);
						length_ctype = _tmp953_;
						_tmp955_ = unary;
						if (_tmp955_ != NULL) {
							ValaUnaryExpression* _tmp956_;
							ValaUnaryOperator _tmp957_;
							ValaUnaryOperator _tmp958_;
							_tmp956_ = unary;
							_tmp957_ = vala_unary_expression_get_operator (_tmp956_);
							_tmp958_ = _tmp957_;
							_tmp954_ = _tmp958_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp954_ = FALSE;
						}
						if (_tmp954_) {
							const gchar* _tmp959_;
							gchar* _tmp960_;
							_tmp959_ = length_ctype;
							_tmp960_ = g_strdup_printf ("%s*", _tmp959_);
							_g_free0 (length_ctype);
							length_ctype = _tmp960_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp961_ = FALSE;
								_tmp961_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp963_;
									gint _tmp964_;
									gint _tmp965_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp966_;
									ValaCCodeExpression* _tmp967_;
									ValaCCodeExpression* _tmp968_;
									const gchar* _tmp969_;
									ValaCCodeCastExpression* _tmp970_;
									ValaCCodeCastExpression* _tmp971_;
									ValaHashMap* _tmp972_;
									ValaParameter* _tmp973_;
									ValaCCodeCastExpression* _tmp974_;
									if (!_tmp961_) {
										gint _tmp962_;
										_tmp962_ = dim;
										dim = _tmp962_ + 1;
									}
									_tmp961_ = FALSE;
									_tmp963_ = array_type;
									_tmp964_ = vala_array_type_get_rank (_tmp963_);
									_tmp965_ = _tmp964_;
									if (!(dim <= _tmp965_)) {
										break;
									}
									_tmp966_ = arg;
									_tmp967_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp966_, dim);
									_tmp968_ = _tmp967_;
									_tmp969_ = length_ctype;
									_tmp970_ = vala_ccode_cast_expression_new (_tmp968_, _tmp969_);
									_tmp971_ = _tmp970_;
									_vala_ccode_node_unref0 (_tmp968_);
									array_length_expr = _tmp971_;
									_tmp972_ = carg_map;
									_tmp973_ = param;
									_tmp974_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp972_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp973_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp974_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp975_ = FALSE;
						ValaParameter* _tmp976_;
						_tmp976_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp976_)) {
							ValaParameter* _tmp977_;
							ValaDataType* _tmp978_;
							ValaDataType* _tmp979_;
							_tmp977_ = param;
							_tmp978_ = vala_variable_get_variable_type ((ValaVariable*) _tmp977_);
							_tmp979_ = _tmp978_;
							_tmp975_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp979_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp975_ = FALSE;
						}
						if (_tmp975_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp980_;
							ValaDataType* _tmp981_;
							ValaDataType* _tmp982_;
							ValaDelegateType* _tmp983_;
							ValaDelegateType* _tmp984_;
							ValaDelegate* _tmp985_;
							ValaDelegate* _tmp986_;
							gboolean _tmp987_;
							gboolean _tmp988_;
							_tmp980_ = param;
							_tmp981_ = vala_variable_get_variable_type ((ValaVariable*) _tmp980_);
							_tmp982_ = _tmp981_;
							_tmp983_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp982_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp983_;
							_tmp984_ = deleg_type;
							_tmp985_ = vala_delegate_type_get_delegate_symbol (_tmp984_);
							_tmp986_ = _tmp985_;
							_tmp987_ = vala_delegate_get_has_target (_tmp986_);
							_tmp988_ = _tmp987_;
							if (_tmp988_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp989_;
								ValaCCodeExpression* _tmp990_ = NULL;
								ValaCCodeExpression* _tmp991_;
								ValaCCodeExpression* _tmp992_;
								ValaParameter* _tmp993_;
								gchar* _tmp994_;
								gchar* _tmp995_;
								gboolean _tmp996_;
								_tmp989_ = arg;
								_tmp991_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp989_, &_tmp990_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp990_;
								delegate_target = _tmp991_;
								_tmp992_ = delegate_target;
								_vala_assert (_tmp992_ != NULL, "delegate_target != null");
								_tmp993_ = param;
								_tmp994_ = vala_get_ccode_type ((ValaCodeNode*) _tmp993_);
								_tmp995_ = _tmp994_;
								_tmp996_ = g_strcmp0 (_tmp995_, "GClosure*") == 0;
								_g_free0 (_tmp995_);
								if (_tmp996_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp997_;
									ValaCCodeIdentifier* _tmp998_;
									ValaCCodeFunctionCall* _tmp999_;
									ValaCCodeFunctionCall* _tmp1000_;
									ValaCCodeFunctionCall* _tmp1001_;
									ValaCCodeExpression* _tmp1002_;
									ValaCCodeCastExpression* _tmp1003_;
									ValaCCodeCastExpression* _tmp1004_;
									ValaCCodeFunctionCall* _tmp1005_;
									ValaCCodeExpression* _tmp1006_;
									ValaCCodeFunctionCall* _tmp1007_;
									ValaCCodeExpression* _tmp1008_;
									ValaCCodeCastExpression* _tmp1009_;
									ValaCCodeCastExpression* _tmp1010_;
									ValaCCodeExpression* _tmp1011_;
									ValaCCodeIdentifier* _tmp1012_;
									ValaCCodeIdentifier* _tmp1013_;
									ValaCCodeBinaryExpression* _tmp1014_;
									ValaCCodeBinaryExpression* _tmp1015_;
									ValaCCodeIdentifier* _tmp1016_;
									ValaCCodeIdentifier* _tmp1017_;
									ValaCCodeFunctionCall* _tmp1018_;
									ValaCCodeConditionalExpression* _tmp1019_;
									_tmp997_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp998_ = _tmp997_;
									_tmp999_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp998_);
									_tmp1000_ = _tmp999_;
									_vala_ccode_node_unref0 (_tmp998_);
									closure_new = _tmp1000_;
									_tmp1001_ = closure_new;
									_tmp1002_ = cexpr;
									_tmp1003_ = vala_ccode_cast_expression_new (_tmp1002_, "GCallback");
									_tmp1004_ = _tmp1003_;
									vala_ccode_function_call_add_argument (_tmp1001_, (ValaCCodeExpression*) _tmp1004_);
									_vala_ccode_node_unref0 (_tmp1004_);
									_tmp1005_ = closure_new;
									_tmp1006_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1005_, _tmp1006_);
									_tmp1007_ = closure_new;
									_tmp1008_ = delegate_target_destroy_notify;
									_tmp1009_ = vala_ccode_cast_expression_new (_tmp1008_, "GClosureNotify");
									_tmp1010_ = _tmp1009_;
									vala_ccode_function_call_add_argument (_tmp1007_, (ValaCCodeExpression*) _tmp1010_);
									_vala_ccode_node_unref0 (_tmp1010_);
									_tmp1011_ = cexpr;
									_tmp1012_ = vala_ccode_identifier_new ("NULL");
									_tmp1013_ = _tmp1012_;
									_tmp1014_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1011_, (ValaCCodeExpression*) _tmp1013_);
									_tmp1015_ = _tmp1014_;
									_tmp1016_ = vala_ccode_identifier_new ("NULL");
									_tmp1017_ = _tmp1016_;
									_tmp1018_ = closure_new;
									_tmp1019_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1015_, (ValaCCodeExpression*) _tmp1017_, (ValaCCodeExpression*) _tmp1018_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1019_;
									_vala_ccode_node_unref0 (_tmp1017_);
									_vala_ccode_node_unref0 (_tmp1015_);
									_vala_ccode_node_unref0 (_tmp1013_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1020_;
									ValaParameter* _tmp1021_;
									ValaCCodeExpression* _tmp1022_;
									ValaDelegateType* _tmp1023_;
									_tmp1020_ = carg_map;
									_tmp1021_ = param;
									_tmp1022_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1020_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1021_), FALSE)), _tmp1022_);
									_tmp1023_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1023_)) {
										ValaCCodeExpression* _tmp1024_;
										ValaHashMap* _tmp1025_;
										ValaParameter* _tmp1026_;
										ValaCCodeExpression* _tmp1027_;
										_tmp1024_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1024_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1025_ = carg_map;
										_tmp1026_ = param;
										_tmp1027_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1025_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1026_) + 0.01, FALSE)), _tmp1027_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1028_;
							ValaDataType* _tmp1029_;
							ValaDataType* _tmp1030_;
							_tmp1028_ = param;
							_tmp1029_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1028_);
							_tmp1030_ = _tmp1029_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1030_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1031_;
								ValaParameter* _tmp1032_;
								ValaExpression* _tmp1033_;
								ValaCCodeExpression* _tmp1034_ = NULL;
								ValaCCodeExpression* _tmp1035_;
								ValaCCodeExpression* _tmp1036_;
								_tmp1031_ = carg_map;
								_tmp1032_ = param;
								_tmp1033_ = arg;
								_tmp1035_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1033_, &_tmp1034_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1034_;
								_tmp1036_ = _tmp1035_;
								vala_map_set ((ValaMap*) _tmp1031_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1032_), FALSE)), _tmp1036_);
								_vala_ccode_node_unref0 (_tmp1036_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1037_;
								ValaDataType* _tmp1038_;
								ValaDataType* _tmp1039_;
								_tmp1037_ = param;
								_tmp1038_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1037_);
								_tmp1039_ = _tmp1038_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1039_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1040_ = FALSE;
									ValaMethod* _tmp1041_;
									_tmp1041_ = m;
									if (_tmp1041_ != NULL) {
										ValaMethod* _tmp1042_;
										_tmp1042_ = m;
										_tmp1040_ = vala_get_ccode_simple_generics (_tmp1042_);
									} else {
										_tmp1040_ = FALSE;
									}
									if (_tmp1040_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1043_;
										ValaDataType* _tmp1044_;
										ValaDataType* _tmp1045_;
										ValaGenericType* _tmp1046_;
										gint type_param_index = 0;
										ValaMethod* _tmp1047_;
										ValaGenericType* _tmp1048_;
										ValaTypeParameter* _tmp1049_;
										ValaTypeParameter* _tmp1050_;
										const gchar* _tmp1051_;
										const gchar* _tmp1052_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1053_;
										ValaList* _tmp1054_;
										gpointer _tmp1055_;
										ValaParameter* _tmp1056_;
										ValaDataType* _tmp1057_;
										ValaDataType* _tmp1058_;
										gboolean _tmp1059_;
										gboolean _tmp1060_;
										_tmp1043_ = param;
										_tmp1044_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1043_);
										_tmp1045_ = _tmp1044_;
										_tmp1046_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1045_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1046_;
										_tmp1047_ = m;
										_tmp1048_ = generic_type;
										_tmp1049_ = vala_generic_type_get_type_parameter (_tmp1048_);
										_tmp1050_ = _tmp1049_;
										_tmp1051_ = vala_symbol_get_name ((ValaSymbol*) _tmp1050_);
										_tmp1052_ = _tmp1051_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1047_, _tmp1052_);
										_tmp1053_ = ma;
										_tmp1054_ = vala_member_access_get_type_arguments (_tmp1053_);
										_tmp1055_ = vala_list_get (_tmp1054_, type_param_index);
										type_arg = (ValaDataType*) _tmp1055_;
										_tmp1056_ = param;
										_tmp1057_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1056_);
										_tmp1058_ = _tmp1057_;
										_tmp1059_ = vala_data_type_get_value_owned (_tmp1058_);
										_tmp1060_ = _tmp1059_;
										if (_tmp1060_) {
											ValaDataType* _tmp1061_;
											_tmp1061_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1061_)) {
												ValaHashMap* _tmp1062_;
												ValaParameter* _tmp1063_;
												ValaDataType* _tmp1064_;
												ValaCCodeExpression* _tmp1065_;
												ValaCCodeExpression* _tmp1066_;
												_tmp1062_ = carg_map;
												_tmp1063_ = param;
												_tmp1064_ = type_arg;
												_tmp1065_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1064_, FALSE);
												_tmp1066_ = _tmp1065_;
												vala_map_set ((ValaMap*) _tmp1062_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1063_), FALSE)), _tmp1066_);
												_vala_ccode_node_unref0 (_tmp1066_);
											} else {
												ValaHashMap* _tmp1067_;
												ValaParameter* _tmp1068_;
												ValaCCodeConstant* _tmp1069_;
												ValaCCodeConstant* _tmp1070_;
												_tmp1067_ = carg_map;
												_tmp1068_ = param;
												_tmp1069_ = vala_ccode_constant_new ("NULL");
												_tmp1070_ = _tmp1069_;
												vala_map_set ((ValaMap*) _tmp1067_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1068_), FALSE)), (ValaCCodeExpression*) _tmp1070_);
												_vala_ccode_node_unref0 (_tmp1070_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1071_ = param;
					_tmp1072_ = arg;
					_tmp1073_ = cexpr;
					_tmp1074_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1071_, _tmp1072_, _tmp1073_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1074_;
				} else {
					ValaExpression* _tmp1075_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1076_;
					ValaDataType* _tmp1077_;
					ValaDataType* _tmp1078_;
					ValaParameter* _tmp1079_;
					ValaDataType* _tmp1080_;
					ValaDataType* _tmp1081_;
					gboolean _tmp1082_;
					gboolean _tmp1083_;
					ValaLocalVariable* _tmp1084_;
					ValaLocalVariable* _tmp1085_;
					ValaExpression* _tmp1086_;
					ValaLocalVariable* _tmp1087_;
					const gchar* _tmp1088_;
					const gchar* _tmp1089_;
					ValaCCodeExpression* _tmp1090_;
					ValaCCodeExpression* _tmp1091_;
					ValaExpression* _tmp1092_;
					ValaTargetValue* _tmp1093_;
					ValaTargetValue* _tmp1094_;
					ValaExpression* _tmp1095_;
					ValaDataType* _tmp1096_;
					ValaDataType* _tmp1097_;
					ValaExpression* _tmp1098_;
					ValaCCodeExpression* _tmp1099_;
					ValaCCodeUnaryExpression* _tmp1100_;
					gboolean _tmp1101_ = FALSE;
					gboolean _tmp1102_ = FALSE;
					ValaParameter* _tmp1103_;
					_tmp1075_ = arg;
					vala_expression_set_target_value (_tmp1075_, NULL);
					_tmp1076_ = param;
					_tmp1077_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1076_);
					_tmp1078_ = _tmp1077_;
					_tmp1079_ = param;
					_tmp1080_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1079_);
					_tmp1081_ = _tmp1080_;
					_tmp1082_ = vala_data_type_get_value_owned (_tmp1081_);
					_tmp1083_ = _tmp1082_;
					_tmp1084_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1078_, _tmp1083_, NULL, TRUE);
					temp_var = _tmp1084_;
					_tmp1085_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1085_, FALSE);
					_tmp1086_ = arg;
					_tmp1087_ = temp_var;
					_tmp1088_ = vala_symbol_get_name ((ValaSymbol*) _tmp1087_);
					_tmp1089_ = _tmp1088_;
					_tmp1090_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1089_);
					_tmp1091_ = _tmp1090_;
					vala_set_cvalue (_tmp1086_, _tmp1091_);
					_vala_ccode_node_unref0 (_tmp1091_);
					_tmp1092_ = arg;
					_tmp1093_ = vala_expression_get_target_value (_tmp1092_);
					_tmp1094_ = _tmp1093_;
					_tmp1095_ = arg;
					_tmp1096_ = vala_expression_get_target_type (_tmp1095_);
					_tmp1097_ = _tmp1096_;
					vala_target_value_set_value_type (_tmp1094_, _tmp1097_);
					_tmp1098_ = arg;
					_tmp1099_ = vala_get_cvalue (_tmp1098_);
					_tmp1100_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1099_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1100_;
					_tmp1103_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1103_)) {
						ValaParameter* _tmp1104_;
						ValaDataType* _tmp1105_;
						ValaDataType* _tmp1106_;
						_tmp1104_ = param;
						_tmp1105_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1104_);
						_tmp1106_ = _tmp1105_;
						_tmp1102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1106_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1102_ = FALSE;
					}
					if (_tmp1102_) {
						ValaParameter* _tmp1107_;
						ValaDataType* _tmp1108_;
						ValaDataType* _tmp1109_;
						gboolean _tmp1110_;
						gboolean _tmp1111_;
						_tmp1107_ = param;
						_tmp1108_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1107_);
						_tmp1109_ = _tmp1108_;
						_tmp1110_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1109_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1111_ = _tmp1110_;
						_tmp1101_ = !_tmp1111_;
					} else {
						_tmp1101_ = FALSE;
					}
					if (_tmp1101_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1112_;
						ValaDataType* _tmp1113_;
						ValaDataType* _tmp1114_;
						ValaArrayType* _tmp1115_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1116_;
						gchar* _tmp1117_;
						_tmp1112_ = param;
						_tmp1113_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1112_);
						_tmp1114_ = _tmp1113_;
						_tmp1115_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1114_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1115_;
						_tmp1116_ = param;
						_tmp1117_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1116_);
						length_ctype = _tmp1117_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1118_ = FALSE;
								_tmp1118_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1120_;
									gint _tmp1121_;
									gint _tmp1122_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1123_;
									ValaCType* _tmp1124_;
									ValaCType* _tmp1125_;
									ValaLocalVariable* _tmp1126_;
									ValaLocalVariable* _tmp1127_;
									ValaLocalVariable* _tmp1128_;
									ValaExpression* _tmp1129_;
									ValaLocalVariable* _tmp1130_;
									const gchar* _tmp1131_;
									const gchar* _tmp1132_;
									ValaCCodeExpression* _tmp1133_;
									ValaCCodeExpression* _tmp1134_;
									ValaHashMap* _tmp1135_;
									ValaParameter* _tmp1136_;
									ValaExpression* _tmp1137_;
									ValaList* _tmp1138_;
									gpointer _tmp1139_;
									ValaCCodeExpression* _tmp1140_;
									ValaCCodeUnaryExpression* _tmp1141_;
									ValaCCodeUnaryExpression* _tmp1142_;
									if (!_tmp1118_) {
										gint _tmp1119_;
										_tmp1119_ = dim;
										dim = _tmp1119_ + 1;
									}
									_tmp1118_ = FALSE;
									_tmp1120_ = array_type;
									_tmp1121_ = vala_array_type_get_rank (_tmp1120_);
									_tmp1122_ = _tmp1121_;
									if (!(dim <= _tmp1122_)) {
										break;
									}
									_tmp1123_ = length_ctype;
									_tmp1124_ = vala_ctype_new (_tmp1123_, "0");
									_tmp1125_ = _tmp1124_;
									_tmp1126_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1125_, TRUE, NULL, TRUE);
									_tmp1127_ = _tmp1126_;
									_vala_code_node_unref0 (_tmp1125_);
									temp_array_length = _tmp1127_;
									_tmp1128_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1128_, FALSE);
									_tmp1129_ = arg;
									_tmp1130_ = temp_array_length;
									_tmp1131_ = vala_symbol_get_name ((ValaSymbol*) _tmp1130_);
									_tmp1132_ = _tmp1131_;
									_tmp1133_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1132_);
									_tmp1134_ = _tmp1133_;
									vala_append_array_length (_tmp1129_, _tmp1134_);
									_vala_ccode_node_unref0 (_tmp1134_);
									_tmp1135_ = carg_map;
									_tmp1136_ = param;
									_tmp1137_ = arg;
									_tmp1138_ = vala_get_array_lengths (_tmp1137_);
									_tmp1139_ = vala_list_get (_tmp1138_, dim - 1);
									_tmp1140_ = (ValaCCodeExpression*) _tmp1139_;
									_tmp1141_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1140_);
									_tmp1142_ = _tmp1141_;
									vala_map_set ((ValaMap*) _tmp1135_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1136_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1142_);
									_vala_ccode_node_unref0 (_tmp1142_);
									_vala_ccode_node_unref0 (_tmp1140_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1143_ = FALSE;
						ValaParameter* _tmp1144_;
						_tmp1144_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1144_)) {
							ValaParameter* _tmp1145_;
							ValaDataType* _tmp1146_;
							ValaDataType* _tmp1147_;
							_tmp1145_ = param;
							_tmp1146_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1145_);
							_tmp1147_ = _tmp1146_;
							_tmp1143_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1147_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1143_ = FALSE;
						}
						if (_tmp1143_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1148_;
							ValaDataType* _tmp1149_;
							ValaDataType* _tmp1150_;
							ValaDelegateType* _tmp1151_;
							ValaDelegateType* _tmp1152_;
							ValaDelegate* _tmp1153_;
							ValaDelegate* _tmp1154_;
							gboolean _tmp1155_;
							gboolean _tmp1156_;
							_tmp1148_ = param;
							_tmp1149_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1148_);
							_tmp1150_ = _tmp1149_;
							_tmp1151_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1150_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1151_;
							_tmp1152_ = deleg_type;
							_tmp1153_ = vala_delegate_type_get_delegate_symbol (_tmp1152_);
							_tmp1154_ = _tmp1153_;
							_tmp1155_ = vala_delegate_get_has_target (_tmp1154_);
							_tmp1156_ = _tmp1155_;
							if (_tmp1156_) {
								ValaVoidType* _tmp1157_;
								ValaVoidType* _tmp1158_;
								ValaPointerType* _tmp1159_;
								ValaPointerType* _tmp1160_;
								ValaLocalVariable* _tmp1161_;
								ValaLocalVariable* _tmp1162_;
								ValaExpression* _tmp1163_;
								ValaLocalVariable* _tmp1164_;
								const gchar* _tmp1165_;
								const gchar* _tmp1166_;
								ValaCCodeExpression* _tmp1167_;
								ValaCCodeExpression* _tmp1168_;
								ValaHashMap* _tmp1169_;
								ValaParameter* _tmp1170_;
								ValaExpression* _tmp1171_;
								ValaCCodeExpression* _tmp1172_;
								ValaCCodeUnaryExpression* _tmp1173_;
								ValaCCodeUnaryExpression* _tmp1174_;
								ValaDelegateType* _tmp1175_;
								_tmp1157_ = vala_void_type_new (NULL);
								_tmp1158_ = _tmp1157_;
								_tmp1159_ = vala_pointer_type_new ((ValaDataType*) _tmp1158_, NULL);
								_tmp1160_ = _tmp1159_;
								_tmp1161_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1160_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1161_;
								_vala_code_node_unref0 (_tmp1160_);
								_vala_code_node_unref0 (_tmp1158_);
								_tmp1162_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1162_, FALSE);
								_tmp1163_ = arg;
								_tmp1164_ = temp_var;
								_tmp1165_ = vala_symbol_get_name ((ValaSymbol*) _tmp1164_);
								_tmp1166_ = _tmp1165_;
								_tmp1167_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1166_);
								_tmp1168_ = _tmp1167_;
								vala_set_delegate_target (_tmp1163_, _tmp1168_);
								_vala_ccode_node_unref0 (_tmp1168_);
								_tmp1169_ = carg_map;
								_tmp1170_ = param;
								_tmp1171_ = arg;
								_tmp1172_ = vala_get_delegate_target (_tmp1171_);
								_tmp1173_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1172_);
								_tmp1174_ = _tmp1173_;
								vala_map_set ((ValaMap*) _tmp1169_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1170_), FALSE)), (ValaCCodeExpression*) _tmp1174_);
								_vala_ccode_node_unref0 (_tmp1174_);
								_tmp1175_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1175_)) {
									ValaDataType* _tmp1176_;
									ValaLocalVariable* _tmp1177_;
									ValaLocalVariable* _tmp1178_;
									ValaExpression* _tmp1179_;
									ValaLocalVariable* _tmp1180_;
									const gchar* _tmp1181_;
									const gchar* _tmp1182_;
									ValaCCodeExpression* _tmp1183_;
									ValaCCodeExpression* _tmp1184_;
									ValaHashMap* _tmp1185_;
									ValaParameter* _tmp1186_;
									ValaExpression* _tmp1187_;
									ValaCCodeExpression* _tmp1188_;
									ValaCCodeUnaryExpression* _tmp1189_;
									ValaCCodeUnaryExpression* _tmp1190_;
									_tmp1176_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1177_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1176_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1177_;
									_tmp1178_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1178_, FALSE);
									_tmp1179_ = arg;
									_tmp1180_ = temp_var;
									_tmp1181_ = vala_symbol_get_name ((ValaSymbol*) _tmp1180_);
									_tmp1182_ = _tmp1181_;
									_tmp1183_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1182_);
									_tmp1184_ = _tmp1183_;
									vala_set_delegate_target_destroy_notify (_tmp1179_, _tmp1184_);
									_vala_ccode_node_unref0 (_tmp1184_);
									_tmp1185_ = carg_map;
									_tmp1186_ = param;
									_tmp1187_ = arg;
									_tmp1188_ = vala_get_delegate_target_destroy_notify (_tmp1187_);
									_tmp1189_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1188_);
									_tmp1190_ = _tmp1189_;
									vala_map_set ((ValaMap*) _tmp1185_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1186_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1190_);
									_vala_ccode_node_unref0 (_tmp1190_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1191_ = param;
				_tmp1192_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1191_);
				_tmp1193_ = _tmp1192_;
				_tmp1194_ = _tmp1193_ != NULL;
				_g_free0 (_tmp1193_);
				if (_tmp1194_) {
					ValaCCodeExpression* _tmp1195_;
					ValaParameter* _tmp1196_;
					gchar* _tmp1197_;
					gchar* _tmp1198_;
					ValaCCodeCastExpression* _tmp1199_;
					_tmp1195_ = cexpr;
					_tmp1196_ = param;
					_tmp1197_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1196_);
					_tmp1198_ = _tmp1197_;
					_tmp1199_ = vala_ccode_cast_expression_new (_tmp1195_, _tmp1198_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1199_;
					_g_free0 (_tmp1198_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1200_;
				ValaUnaryExpression* _tmp1201_;
				gboolean _tmp1202_ = FALSE;
				gboolean _tmp1203_ = FALSE;
				_tmp1200_ = arg;
				_tmp1201_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1200_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1200_) : NULL);
				unary = _tmp1201_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1204_;
					_tmp1204_ = unary;
					_tmp1203_ = _tmp1204_ != NULL;
				} else {
					_tmp1203_ = FALSE;
				}
				if (_tmp1203_) {
					ValaUnaryExpression* _tmp1205_;
					ValaUnaryOperator _tmp1206_;
					ValaUnaryOperator _tmp1207_;
					_tmp1205_ = unary;
					_tmp1206_ = vala_unary_expression_get_operator (_tmp1205_);
					_tmp1207_ = _tmp1206_;
					_tmp1202_ = _tmp1207_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1202_ = FALSE;
				}
				if (_tmp1202_) {
					ValaHashMap* _tmp1208_;
					ValaHashMap* _tmp1209_;
					ValaExpression* _tmp1210_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1211_;
					ValaDataType* _tmp1212_;
					ValaDataType* _tmp1213_;
					ValaExpression* _tmp1214_;
					ValaDataType* _tmp1215_;
					ValaDataType* _tmp1216_;
					gboolean _tmp1217_;
					gboolean _tmp1218_;
					ValaLocalVariable* _tmp1219_;
					ValaLocalVariable* _tmp1220_;
					ValaExpression* _tmp1221_;
					ValaLocalVariable* _tmp1222_;
					const gchar* _tmp1223_;
					const gchar* _tmp1224_;
					ValaCCodeExpression* _tmp1225_;
					ValaCCodeExpression* _tmp1226_;
					ValaExpression* _tmp1227_;
					ValaTargetValue* _tmp1228_;
					ValaTargetValue* _tmp1229_;
					ValaExpression* _tmp1230_;
					ValaDataType* _tmp1231_;
					ValaDataType* _tmp1232_;
					gboolean _tmp1233_ = FALSE;
					ValaExpression* _tmp1234_;
					ValaDataType* _tmp1235_;
					ValaDataType* _tmp1236_;
					ValaExpression* _tmp1255_;
					ValaCCodeExpression* _tmp1256_;
					ValaCCodeUnaryExpression* _tmp1257_;
					_tmp1208_ = out_arg_map;
					_tmp1209_ = _vala_map_ref0 (_tmp1208_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1209_;
					_tmp1210_ = arg;
					vala_expression_set_target_value (_tmp1210_, NULL);
					_tmp1211_ = arg;
					_tmp1212_ = vala_expression_get_value_type (_tmp1211_);
					_tmp1213_ = _tmp1212_;
					_tmp1214_ = arg;
					_tmp1215_ = vala_expression_get_value_type (_tmp1214_);
					_tmp1216_ = _tmp1215_;
					_tmp1217_ = vala_data_type_get_value_owned (_tmp1216_);
					_tmp1218_ = _tmp1217_;
					_tmp1219_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1213_, _tmp1218_, NULL, TRUE);
					temp_var = _tmp1219_;
					_tmp1220_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1220_, FALSE);
					_tmp1221_ = arg;
					_tmp1222_ = temp_var;
					_tmp1223_ = vala_symbol_get_name ((ValaSymbol*) _tmp1222_);
					_tmp1224_ = _tmp1223_;
					_tmp1225_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1224_);
					_tmp1226_ = _tmp1225_;
					vala_set_cvalue (_tmp1221_, _tmp1226_);
					_vala_ccode_node_unref0 (_tmp1226_);
					_tmp1227_ = arg;
					_tmp1228_ = vala_expression_get_target_value (_tmp1227_);
					_tmp1229_ = _tmp1228_;
					_tmp1230_ = arg;
					_tmp1231_ = vala_expression_get_value_type (_tmp1230_);
					_tmp1232_ = _tmp1231_;
					vala_target_value_set_value_type (_tmp1229_, _tmp1232_);
					_tmp1234_ = arg;
					_tmp1235_ = vala_expression_get_value_type (_tmp1234_);
					_tmp1236_ = _tmp1235_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1236_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1237_;
						ValaDataType* _tmp1238_;
						ValaDataType* _tmp1239_;
						ValaDelegate* _tmp1240_;
						ValaDelegate* _tmp1241_;
						gboolean _tmp1242_;
						gboolean _tmp1243_;
						_tmp1237_ = arg;
						_tmp1238_ = vala_expression_get_value_type (_tmp1237_);
						_tmp1239_ = _tmp1238_;
						_tmp1240_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1239_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1241_ = _tmp1240_;
						_tmp1242_ = vala_delegate_get_has_target (_tmp1241_);
						_tmp1243_ = _tmp1242_;
						_tmp1233_ = _tmp1243_;
					} else {
						_tmp1233_ = FALSE;
					}
					if (_tmp1233_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1244_;
						ValaTargetValue* _tmp1245_;
						ValaTargetValue* _tmp1246_;
						ValaGLibValue* _tmp1247_;
						ValaCCodeExpression* _tmp1248_;
						ValaGLibValue* _tmp1251_;
						ValaCCodeExpression* _tmp1252_;
						_tmp1244_ = arg;
						_tmp1245_ = vala_expression_get_target_value (_tmp1244_);
						_tmp1246_ = _tmp1245_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1246_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1247_ = arg_value;
						_tmp1248_ = _tmp1247_->delegate_target_cvalue;
						if (_tmp1248_ == NULL) {
							ValaGLibValue* _tmp1249_;
							ValaCCodeConstant* _tmp1250_;
							_tmp1249_ = arg_value;
							_tmp1250_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1249_->delegate_target_cvalue);
							_tmp1249_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1250_;
						}
						_tmp1251_ = arg_value;
						_tmp1252_ = _tmp1251_->delegate_target_destroy_notify_cvalue;
						if (_tmp1252_ == NULL) {
							ValaGLibValue* _tmp1253_;
							ValaCCodeConstant* _tmp1254_;
							_tmp1253_ = arg_value;
							_tmp1254_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1253_->delegate_target_destroy_notify_cvalue);
							_tmp1253_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1254_;
						}
					}
					_tmp1255_ = arg;
					_tmp1256_ = vala_get_cvalue (_tmp1255_);
					_tmp1257_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1256_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1257_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1258_;
					ValaCCodeExpression* _tmp1259_;
					ValaCCodeExpression* _tmp1260_;
					_tmp1258_ = arg;
					_tmp1259_ = cexpr;
					_tmp1260_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1258_, _tmp1259_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1260_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1263_ = param;
			if (_tmp1263_ != NULL) {
				_tmp1262_ = !ellipsis;
			} else {
				_tmp1262_ = FALSE;
			}
			if (_tmp1262_) {
				ValaParameter* _tmp1264_;
				_tmp1264_ = param;
				_tmp1261_ = vala_get_ccode_pos (_tmp1264_);
			} else {
				_tmp1261_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1261_, ellipsis);
			_tmp1265_ = carg_map;
			_tmp1266_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1265_, (gpointer) ((gintptr) arg_pos), _tmp1266_);
			_tmp1268_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1268_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1269_;
				ValaCodeContext* _tmp1270_;
				ValaProfile _tmp1271_;
				ValaProfile _tmp1272_;
				_tmp1269_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1270_ = _tmp1269_;
				_tmp1271_ = vala_code_context_get_profile (_tmp1270_);
				_tmp1272_ = _tmp1271_;
				_tmp1267_ = _tmp1272_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1267_ = FALSE;
			}
			if (_tmp1267_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1273_;
				ValaExpression* _tmp1274_;
				ValaExpression* _tmp1275_;
				ValaDataType* _tmp1276_;
				ValaDataType* _tmp1277_;
				ValaDataType* _tmp1278_;
				ValaDataType* _tmp1279_;
				gchar* _tmp1280_;
				gchar* _tmp1281_;
				gchar* _tmp1282_;
				gchar* _tmp1283_;
				ValaCCodeIdentifier* _tmp1284_;
				ValaCCodeIdentifier* _tmp1285_;
				ValaHashMap* _tmp1286_;
				ValaCCodeIdentifier* _tmp1287_;
				ValaCCodeExpression* _tmp1288_;
				ValaCCodeBinaryExpression* _tmp1289_;
				ValaCCodeBinaryExpression* _tmp1290_;
				_tmp1273_ = ma;
				_tmp1274_ = vala_member_access_get_inner (_tmp1273_);
				_tmp1275_ = _tmp1274_;
				_tmp1276_ = vala_expression_get_value_type (_tmp1275_);
				_tmp1277_ = _tmp1276_;
				_tmp1278_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1277_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1279_ = _tmp1278_;
				_tmp1280_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1279_);
				_tmp1281_ = _tmp1280_;
				_tmp1282_ = g_strdup_printf ("sizeof (%s)", _tmp1281_);
				_tmp1283_ = _tmp1282_;
				_tmp1284_ = vala_ccode_identifier_new (_tmp1283_);
				_tmp1285_ = _tmp1284_;
				_g_free0 (_tmp1283_);
				_g_free0 (_tmp1281_);
				csizeof = _tmp1285_;
				_tmp1286_ = carg_map;
				_tmp1287_ = csizeof;
				_tmp1288_ = cexpr;
				_tmp1289_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1287_, _tmp1288_);
				_tmp1290_ = _tmp1289_;
				vala_map_set ((ValaMap*) _tmp1286_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1290_);
				_vala_ccode_node_unref0 (_tmp1290_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1291_;
				ValaCCodeExpression* _tmp1292_;
				_tmp1291_ = carg_map;
				_tmp1292_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1291_, (gpointer) ((gintptr) arg_pos), _tmp1292_);
			}
			_tmp1294_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1294_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1293_ = ellipsis;
			} else {
				_tmp1293_ = FALSE;
			}
			if (_tmp1293_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1295_;
				ValaNamedArgument* _tmp1296_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1297_;
				const gchar* _tmp1298_;
				const gchar* _tmp1299_;
				gchar** _tmp1300_;
				gchar** _tmp1301_;
				gchar** _tmp1302_;
				gint _tmp1302__length1;
				gchar* _tmp1303_;
				gchar* _tmp1304_;
				ValaHashMap* _tmp1305_;
				const gchar* _tmp1306_;
				gchar* _tmp1307_;
				gchar* _tmp1308_;
				ValaCCodeConstant* _tmp1309_;
				ValaCCodeConstant* _tmp1310_;
				_tmp1295_ = arg;
				_tmp1296_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1295_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1296_;
				_tmp1297_ = named_arg;
				_tmp1298_ = vala_named_argument_get_name (_tmp1297_);
				_tmp1299_ = _tmp1298_;
				_tmp1301_ = _tmp1300_ = g_strsplit (_tmp1299_, "_", 0);
				_tmp1302_ = _tmp1301_;
				_tmp1302__length1 = _vala_array_length (_tmp1300_);
				_tmp1303_ = _vala_g_strjoinv ("-", _tmp1302_, (gint) _vala_array_length (_tmp1300_));
				_tmp1304_ = _tmp1303_;
				_tmp1302_ = (_vala_array_free (_tmp1302_, _tmp1302__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1304_;
				_tmp1305_ = carg_map;
				_tmp1306_ = name;
				_tmp1307_ = g_strdup_printf ("\"%s\"", _tmp1306_);
				_tmp1308_ = _tmp1307_;
				_tmp1309_ = vala_ccode_constant_new (_tmp1308_);
				_tmp1310_ = _tmp1309_;
				vala_map_set ((ValaMap*) _tmp1305_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1310_);
				_vala_ccode_node_unref0 (_tmp1310_);
				_g_free0 (_tmp1308_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1311_ = i;
			i = _tmp1311_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1312_ = params_it;
	if (vala_iterator_next (_tmp1312_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1313_;
		gpointer _tmp1314_;
		gboolean _tmp1315_ = FALSE;
		ValaParameter* _tmp1316_;
		gboolean _tmp1317_;
		gboolean _tmp1318_;
		_tmp1313_ = params_it;
		_tmp1314_ = vala_iterator_get (_tmp1313_);
		param = (ValaParameter*) _tmp1314_;
		_tmp1316_ = param;
		_tmp1317_ = vala_parameter_get_params_array (_tmp1316_);
		_tmp1318_ = _tmp1317_;
		if (_tmp1318_) {
			_tmp1315_ = TRUE;
		} else {
			ValaParameter* _tmp1319_;
			gboolean _tmp1320_;
			gboolean _tmp1321_;
			_tmp1319_ = param;
			_tmp1320_ = vala_parameter_get_ellipsis (_tmp1319_);
			_tmp1321_ = _tmp1320_;
			_tmp1315_ = _tmp1321_;
		}
		_vala_assert (_tmp1315_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1324_ = m;
	if (_tmp1324_ != NULL) {
		ValaMethod* _tmp1325_;
		ValaDataType* _tmp1326_;
		ValaDataType* _tmp1327_;
		_tmp1325_ = m;
		_tmp1326_ = vala_callable_get_return_type ((ValaCallable*) _tmp1325_);
		_tmp1327_ = _tmp1326_;
		_tmp1323_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1327_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1323_ = FALSE;
	}
	if (_tmp1323_) {
		ValaCCodeFunctionCall* _tmp1328_;
		ValaCCodeFunctionCall* _tmp1329_;
		_tmp1328_ = async_call;
		_tmp1329_ = ccall;
		_tmp1322_ = _tmp1328_ != _tmp1329_;
	} else {
		_tmp1322_ = FALSE;
	}
	if (_tmp1322_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1330_;
		ValaDataType* _tmp1331_;
		ValaDataType* _tmp1332_;
		ValaArrayType* _tmp1333_;
		_tmp1330_ = m;
		_tmp1331_ = vala_callable_get_return_type ((ValaCallable*) _tmp1330_);
		_tmp1332_ = _tmp1331_;
		_tmp1333_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1332_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1333_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1334_ = FALSE;
				_tmp1334_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1336_;
					gint _tmp1337_;
					gint _tmp1338_;
					ValaMethod* _tmp1339_;
					if (!_tmp1334_) {
						gint _tmp1335_;
						_tmp1335_ = dim;
						dim = _tmp1335_ + 1;
					}
					_tmp1334_ = FALSE;
					_tmp1336_ = array_type;
					_tmp1337_ = vala_array_type_get_rank (_tmp1336_);
					_tmp1338_ = _tmp1337_;
					if (!(dim <= _tmp1338_)) {
						break;
					}
					_tmp1339_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1339_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1340_;
						ValaDataType* _tmp1341_;
						ValaLocalVariable* _tmp1342_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1343_;
						const gchar* _tmp1344_;
						const gchar* _tmp1345_;
						ValaCCodeExpression* _tmp1346_;
						ValaLocalVariable* _tmp1347_;
						ValaCCodeExpression* _tmp1348_;
						ValaCCodeExpression* _tmp1349_;
						ValaCCodeAssignment* _tmp1350_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1351_;
						ValaCCodeIdentifier* _tmp1352_;
						ValaCCodeFunctionCall* _tmp1353_;
						ValaCCodeFunctionCall* _tmp1354_;
						ValaCCodeFunctionCall* _tmp1355_;
						ValaCCodeExpression* _tmp1356_;
						ValaCCodeFunctionCall* _tmp1357_;
						_tmp1340_ = itype;
						_tmp1341_ = vala_data_type_get_return_type (_tmp1340_);
						_tmp1342_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1341_, TRUE, NULL, FALSE);
						temp_var = _tmp1342_;
						_tmp1343_ = temp_var;
						_tmp1344_ = vala_symbol_get_name ((ValaSymbol*) _tmp1343_);
						_tmp1345_ = _tmp1344_;
						_tmp1346_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1345_);
						temp_ref = _tmp1346_;
						_tmp1347_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1347_, FALSE);
						_tmp1348_ = temp_ref;
						_tmp1349_ = ccall_expr;
						_tmp1350_ = vala_ccode_assignment_new (_tmp1348_, _tmp1349_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1350_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1351_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1352_ = _tmp1351_;
						_tmp1353_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1352_);
						_tmp1354_ = _tmp1353_;
						_vala_ccode_node_unref0 (_tmp1352_);
						len_call = _tmp1354_;
						_tmp1355_ = len_call;
						_tmp1356_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1355_, _tmp1356_);
						_tmp1357_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1357_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1358_;
						_tmp1358_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1358_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1359_;
							gchar* _tmp1360_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1361_;
							ValaCType* _tmp1362_;
							ValaCType* _tmp1363_;
							ValaLocalVariable* _tmp1364_;
							ValaLocalVariable* _tmp1365_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1366_;
							const gchar* _tmp1367_;
							const gchar* _tmp1368_;
							ValaCCodeExpression* _tmp1369_;
							ValaLocalVariable* _tmp1370_;
							ValaHashMap* _tmp1371_;
							ValaMethod* _tmp1372_;
							ValaCCodeExpression* _tmp1373_;
							ValaCCodeUnaryExpression* _tmp1374_;
							ValaCCodeUnaryExpression* _tmp1375_;
							ValaCCodeExpression* _tmp1376_;
							_tmp1359_ = m;
							_tmp1360_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1359_);
							length_ctype = _tmp1360_;
							_tmp1361_ = length_ctype;
							_tmp1362_ = vala_ctype_new (_tmp1361_, "0");
							_tmp1363_ = _tmp1362_;
							_tmp1364_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1363_, TRUE, NULL, TRUE);
							_tmp1365_ = _tmp1364_;
							_vala_code_node_unref0 (_tmp1363_);
							temp_var = _tmp1365_;
							_tmp1366_ = temp_var;
							_tmp1367_ = vala_symbol_get_name ((ValaSymbol*) _tmp1366_);
							_tmp1368_ = _tmp1367_;
							_tmp1369_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1368_);
							temp_ref = _tmp1369_;
							_tmp1370_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1370_, FALSE);
							_tmp1371_ = out_arg_map;
							_tmp1372_ = m;
							_tmp1373_ = temp_ref;
							_tmp1374_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1373_);
							_tmp1375_ = _tmp1374_;
							vala_map_set ((ValaMap*) _tmp1371_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1372_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1375_);
							_vala_ccode_node_unref0 (_tmp1375_);
							_tmp1376_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1376_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1377_;
							gchar* _tmp1378_;
							gchar* _tmp1379_;
							gboolean _tmp1380_;
							_tmp1377_ = m;
							_tmp1378_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1377_);
							_tmp1379_ = _tmp1378_;
							_tmp1380_ = _tmp1379_ != NULL;
							_g_free0 (_tmp1379_);
							if (_tmp1380_) {
								ValaMethod* _tmp1381_;
								gchar* _tmp1382_;
								gchar* _tmp1383_;
								ValaCCodeConstant* _tmp1384_;
								ValaCCodeConstant* _tmp1385_;
								_tmp1381_ = m;
								_tmp1382_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1381_);
								_tmp1383_ = _tmp1382_;
								_tmp1384_ = vala_ccode_constant_new (_tmp1383_);
								_tmp1385_ = _tmp1384_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1385_);
								_vala_ccode_node_unref0 (_tmp1385_);
								_g_free0 (_tmp1383_);
							} else {
								ValaCCodeConstant* _tmp1386_;
								ValaCCodeConstant* _tmp1387_;
								_tmp1386_ = vala_ccode_constant_new ("-1");
								_tmp1387_ = _tmp1386_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1387_);
								_vala_ccode_node_unref0 (_tmp1387_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1388_ = FALSE;
		gboolean _tmp1389_ = FALSE;
		ValaMethod* _tmp1390_;
		_tmp1390_ = m;
		if (_tmp1390_ != NULL) {
			ValaMethod* _tmp1391_;
			ValaDataType* _tmp1392_;
			ValaDataType* _tmp1393_;
			_tmp1391_ = m;
			_tmp1392_ = vala_callable_get_return_type ((ValaCallable*) _tmp1391_);
			_tmp1393_ = _tmp1392_;
			_tmp1389_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1393_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1389_ = FALSE;
		}
		if (_tmp1389_) {
			ValaCCodeFunctionCall* _tmp1394_;
			ValaCCodeFunctionCall* _tmp1395_;
			_tmp1394_ = async_call;
			_tmp1395_ = ccall;
			_tmp1388_ = _tmp1394_ != _tmp1395_;
		} else {
			_tmp1388_ = FALSE;
		}
		if (_tmp1388_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1396_;
			ValaDataType* _tmp1397_;
			ValaDataType* _tmp1398_;
			ValaDelegateType* _tmp1399_;
			gboolean _tmp1400_ = FALSE;
			ValaMethod* _tmp1401_;
			_tmp1396_ = m;
			_tmp1397_ = vala_callable_get_return_type ((ValaCallable*) _tmp1396_);
			_tmp1398_ = _tmp1397_;
			_tmp1399_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1398_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1399_;
			_tmp1401_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1401_)) {
				ValaDelegateType* _tmp1402_;
				ValaDelegate* _tmp1403_;
				ValaDelegate* _tmp1404_;
				gboolean _tmp1405_;
				gboolean _tmp1406_;
				_tmp1402_ = deleg_type;
				_tmp1403_ = vala_delegate_type_get_delegate_symbol (_tmp1402_);
				_tmp1404_ = _tmp1403_;
				_tmp1405_ = vala_delegate_get_has_target (_tmp1404_);
				_tmp1406_ = _tmp1405_;
				_tmp1400_ = _tmp1406_;
			} else {
				_tmp1400_ = FALSE;
			}
			if (_tmp1400_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1407_;
				ValaVoidType* _tmp1408_;
				ValaPointerType* _tmp1409_;
				ValaPointerType* _tmp1410_;
				ValaLocalVariable* _tmp1411_;
				ValaLocalVariable* _tmp1412_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1413_;
				const gchar* _tmp1414_;
				const gchar* _tmp1415_;
				ValaCCodeExpression* _tmp1416_;
				ValaLocalVariable* _tmp1417_;
				ValaHashMap* _tmp1418_;
				ValaMethod* _tmp1419_;
				ValaCCodeExpression* _tmp1420_;
				ValaCCodeUnaryExpression* _tmp1421_;
				ValaCCodeUnaryExpression* _tmp1422_;
				ValaCCodeExpression* _tmp1423_;
				ValaDelegateType* _tmp1424_;
				_tmp1407_ = vala_void_type_new (NULL);
				_tmp1408_ = _tmp1407_;
				_tmp1409_ = vala_pointer_type_new ((ValaDataType*) _tmp1408_, NULL);
				_tmp1410_ = _tmp1409_;
				_tmp1411_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1410_, TRUE, NULL, TRUE);
				_tmp1412_ = _tmp1411_;
				_vala_code_node_unref0 (_tmp1410_);
				_vala_code_node_unref0 (_tmp1408_);
				temp_var = _tmp1412_;
				_tmp1413_ = temp_var;
				_tmp1414_ = vala_symbol_get_name ((ValaSymbol*) _tmp1413_);
				_tmp1415_ = _tmp1414_;
				_tmp1416_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1415_);
				temp_ref = _tmp1416_;
				_tmp1417_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1417_, FALSE);
				_tmp1418_ = out_arg_map;
				_tmp1419_ = m;
				_tmp1420_ = temp_ref;
				_tmp1421_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1420_);
				_tmp1422_ = _tmp1421_;
				vala_map_set ((ValaMap*) _tmp1418_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1419_), FALSE)), (ValaCCodeExpression*) _tmp1422_);
				_vala_ccode_node_unref0 (_tmp1422_);
				_tmp1423_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1423_);
				_tmp1424_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1424_)) {
					ValaDataType* _tmp1425_;
					ValaLocalVariable* _tmp1426_;
					ValaLocalVariable* _tmp1427_;
					const gchar* _tmp1428_;
					const gchar* _tmp1429_;
					ValaCCodeExpression* _tmp1430_;
					ValaLocalVariable* _tmp1431_;
					ValaHashMap* _tmp1432_;
					ValaMethod* _tmp1433_;
					ValaCCodeExpression* _tmp1434_;
					ValaCCodeUnaryExpression* _tmp1435_;
					ValaCCodeUnaryExpression* _tmp1436_;
					ValaCCodeExpression* _tmp1437_;
					_tmp1425_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1426_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1425_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1426_;
					_tmp1427_ = temp_var;
					_tmp1428_ = vala_symbol_get_name ((ValaSymbol*) _tmp1427_);
					_tmp1429_ = _tmp1428_;
					_tmp1430_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1429_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1430_;
					_tmp1431_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1431_, FALSE);
					_tmp1432_ = out_arg_map;
					_tmp1433_ = m;
					_tmp1434_ = temp_ref;
					_tmp1435_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1434_);
					_tmp1436_ = _tmp1435_;
					vala_map_set ((ValaMap*) _tmp1432_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1433_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1436_);
					_vala_ccode_node_unref0 (_tmp1436_);
					_tmp1437_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1437_);
				} else {
					ValaCCodeConstant* _tmp1438_;
					ValaCCodeConstant* _tmp1439_;
					_tmp1438_ = vala_ccode_constant_new ("NULL");
					_tmp1439_ = _tmp1438_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1439_);
					_vala_ccode_node_unref0 (_tmp1439_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1440_;
				ValaCCodeConstant* _tmp1441_;
				ValaDelegateType* _tmp1442_;
				ValaDelegate* _tmp1443_;
				ValaDelegate* _tmp1444_;
				gboolean _tmp1445_;
				gboolean _tmp1446_;
				_tmp1440_ = vala_ccode_constant_new ("NULL");
				_tmp1441_ = _tmp1440_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1441_);
				_vala_ccode_node_unref0 (_tmp1441_);
				_tmp1442_ = deleg_type;
				_tmp1443_ = vala_delegate_type_get_delegate_symbol (_tmp1442_);
				_tmp1444_ = _tmp1443_;
				_tmp1445_ = vala_delegate_get_has_target (_tmp1444_);
				_tmp1446_ = _tmp1445_;
				if (_tmp1446_) {
					ValaCCodeConstant* _tmp1447_;
					ValaCCodeConstant* _tmp1448_;
					_tmp1447_ = vala_ccode_constant_new ("NULL");
					_tmp1448_ = _tmp1447_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1448_);
					_vala_ccode_node_unref0 (_tmp1448_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1450_ = deleg;
	if (_tmp1450_ != NULL) {
		ValaDelegate* _tmp1451_;
		ValaDataType* _tmp1452_;
		ValaDataType* _tmp1453_;
		_tmp1451_ = deleg;
		_tmp1452_ = vala_callable_get_return_type ((ValaCallable*) _tmp1451_);
		_tmp1453_ = _tmp1452_;
		_tmp1449_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1453_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1449_ = FALSE;
	}
	if (_tmp1449_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1454_;
		ValaDataType* _tmp1455_;
		ValaDataType* _tmp1456_;
		ValaArrayType* _tmp1457_;
		_tmp1454_ = deleg;
		_tmp1455_ = vala_callable_get_return_type ((ValaCallable*) _tmp1454_);
		_tmp1456_ = _tmp1455_;
		_tmp1457_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1456_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1457_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1458_ = FALSE;
				_tmp1458_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1460_;
					gint _tmp1461_;
					gint _tmp1462_;
					ValaDelegate* _tmp1463_;
					if (!_tmp1458_) {
						gint _tmp1459_;
						_tmp1459_ = dim;
						dim = _tmp1459_ + 1;
					}
					_tmp1458_ = FALSE;
					_tmp1460_ = array_type;
					_tmp1461_ = vala_array_type_get_rank (_tmp1460_);
					_tmp1462_ = _tmp1461_;
					if (!(dim <= _tmp1462_)) {
						break;
					}
					_tmp1463_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1463_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1464_;
						ValaDataType* _tmp1465_;
						ValaLocalVariable* _tmp1466_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1467_;
						const gchar* _tmp1468_;
						const gchar* _tmp1469_;
						ValaCCodeExpression* _tmp1470_;
						ValaLocalVariable* _tmp1471_;
						ValaCCodeExpression* _tmp1472_;
						ValaCCodeExpression* _tmp1473_;
						ValaCCodeAssignment* _tmp1474_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1475_;
						ValaCCodeIdentifier* _tmp1476_;
						ValaCCodeFunctionCall* _tmp1477_;
						ValaCCodeFunctionCall* _tmp1478_;
						ValaCCodeFunctionCall* _tmp1479_;
						ValaCCodeExpression* _tmp1480_;
						ValaCCodeFunctionCall* _tmp1481_;
						_tmp1464_ = itype;
						_tmp1465_ = vala_data_type_get_return_type (_tmp1464_);
						_tmp1466_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1465_, TRUE, NULL, FALSE);
						temp_var = _tmp1466_;
						_tmp1467_ = temp_var;
						_tmp1468_ = vala_symbol_get_name ((ValaSymbol*) _tmp1467_);
						_tmp1469_ = _tmp1468_;
						_tmp1470_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1469_);
						temp_ref = _tmp1470_;
						_tmp1471_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1471_, FALSE);
						_tmp1472_ = temp_ref;
						_tmp1473_ = ccall_expr;
						_tmp1474_ = vala_ccode_assignment_new (_tmp1472_, _tmp1473_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1474_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1475_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1476_ = _tmp1475_;
						_tmp1477_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1476_);
						_tmp1478_ = _tmp1477_;
						_vala_ccode_node_unref0 (_tmp1476_);
						len_call = _tmp1478_;
						_tmp1479_ = len_call;
						_tmp1480_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1479_, _tmp1480_);
						_tmp1481_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1481_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1482_;
						_tmp1482_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1482_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1483_;
							gchar* _tmp1484_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1485_;
							ValaCType* _tmp1486_;
							ValaCType* _tmp1487_;
							ValaLocalVariable* _tmp1488_;
							ValaLocalVariable* _tmp1489_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1490_;
							const gchar* _tmp1491_;
							const gchar* _tmp1492_;
							ValaCCodeExpression* _tmp1493_;
							ValaLocalVariable* _tmp1494_;
							ValaHashMap* _tmp1495_;
							ValaDelegate* _tmp1496_;
							ValaCCodeExpression* _tmp1497_;
							ValaCCodeUnaryExpression* _tmp1498_;
							ValaCCodeUnaryExpression* _tmp1499_;
							ValaCCodeExpression* _tmp1500_;
							_tmp1483_ = deleg;
							_tmp1484_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1483_);
							length_ctype = _tmp1484_;
							_tmp1485_ = length_ctype;
							_tmp1486_ = vala_ctype_new (_tmp1485_, "0");
							_tmp1487_ = _tmp1486_;
							_tmp1488_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1487_, TRUE, NULL, TRUE);
							_tmp1489_ = _tmp1488_;
							_vala_code_node_unref0 (_tmp1487_);
							temp_var = _tmp1489_;
							_tmp1490_ = temp_var;
							_tmp1491_ = vala_symbol_get_name ((ValaSymbol*) _tmp1490_);
							_tmp1492_ = _tmp1491_;
							_tmp1493_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1492_);
							temp_ref = _tmp1493_;
							_tmp1494_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1494_, FALSE);
							_tmp1495_ = out_arg_map;
							_tmp1496_ = deleg;
							_tmp1497_ = temp_ref;
							_tmp1498_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1497_);
							_tmp1499_ = _tmp1498_;
							vala_map_set ((ValaMap*) _tmp1495_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1496_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1499_);
							_vala_ccode_node_unref0 (_tmp1499_);
							_tmp1500_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1500_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1501_;
							ValaCCodeConstant* _tmp1502_;
							_tmp1501_ = vala_ccode_constant_new ("-1");
							_tmp1502_ = _tmp1501_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1502_);
							_vala_ccode_node_unref0 (_tmp1502_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1503_ = FALSE;
		gboolean _tmp1504_ = FALSE;
		ValaDelegate* _tmp1505_;
		_tmp1505_ = deleg;
		if (_tmp1505_ != NULL) {
			ValaDelegate* _tmp1506_;
			ValaDataType* _tmp1507_;
			ValaDataType* _tmp1508_;
			_tmp1506_ = deleg;
			_tmp1507_ = vala_callable_get_return_type ((ValaCallable*) _tmp1506_);
			_tmp1508_ = _tmp1507_;
			_tmp1504_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1508_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1504_ = FALSE;
		}
		if (_tmp1504_) {
			ValaDelegate* _tmp1509_;
			_tmp1509_ = deleg;
			_tmp1503_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1509_);
		} else {
			_tmp1503_ = FALSE;
		}
		if (_tmp1503_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1510_;
			ValaDataType* _tmp1511_;
			ValaDataType* _tmp1512_;
			ValaDelegateType* _tmp1513_;
			ValaDelegateType* _tmp1514_;
			ValaDelegate* _tmp1515_;
			ValaDelegate* _tmp1516_;
			gboolean _tmp1517_;
			gboolean _tmp1518_;
			_tmp1510_ = deleg;
			_tmp1511_ = vala_callable_get_return_type ((ValaCallable*) _tmp1510_);
			_tmp1512_ = _tmp1511_;
			_tmp1513_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1512_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1513_;
			_tmp1514_ = deleg_type;
			_tmp1515_ = vala_delegate_type_get_delegate_symbol (_tmp1514_);
			_tmp1516_ = _tmp1515_;
			_tmp1517_ = vala_delegate_get_has_target (_tmp1516_);
			_tmp1518_ = _tmp1517_;
			if (_tmp1518_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1519_;
				ValaVoidType* _tmp1520_;
				ValaPointerType* _tmp1521_;
				ValaPointerType* _tmp1522_;
				ValaLocalVariable* _tmp1523_;
				ValaLocalVariable* _tmp1524_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1525_;
				const gchar* _tmp1526_;
				const gchar* _tmp1527_;
				ValaCCodeExpression* _tmp1528_;
				ValaLocalVariable* _tmp1529_;
				ValaHashMap* _tmp1530_;
				ValaDelegate* _tmp1531_;
				ValaCCodeExpression* _tmp1532_;
				ValaCCodeUnaryExpression* _tmp1533_;
				ValaCCodeUnaryExpression* _tmp1534_;
				ValaCCodeExpression* _tmp1535_;
				ValaDelegateType* _tmp1536_;
				_tmp1519_ = vala_void_type_new (NULL);
				_tmp1520_ = _tmp1519_;
				_tmp1521_ = vala_pointer_type_new ((ValaDataType*) _tmp1520_, NULL);
				_tmp1522_ = _tmp1521_;
				_tmp1523_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1522_, TRUE, NULL, TRUE);
				_tmp1524_ = _tmp1523_;
				_vala_code_node_unref0 (_tmp1522_);
				_vala_code_node_unref0 (_tmp1520_);
				temp_var = _tmp1524_;
				_tmp1525_ = temp_var;
				_tmp1526_ = vala_symbol_get_name ((ValaSymbol*) _tmp1525_);
				_tmp1527_ = _tmp1526_;
				_tmp1528_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1527_);
				temp_ref = _tmp1528_;
				_tmp1529_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1529_, FALSE);
				_tmp1530_ = out_arg_map;
				_tmp1531_ = deleg;
				_tmp1532_ = temp_ref;
				_tmp1533_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1532_);
				_tmp1534_ = _tmp1533_;
				vala_map_set ((ValaMap*) _tmp1530_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1531_), FALSE)), (ValaCCodeExpression*) _tmp1534_);
				_vala_ccode_node_unref0 (_tmp1534_);
				_tmp1535_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1535_);
				_tmp1536_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1536_)) {
					ValaDataType* _tmp1537_;
					ValaLocalVariable* _tmp1538_;
					ValaLocalVariable* _tmp1539_;
					const gchar* _tmp1540_;
					const gchar* _tmp1541_;
					ValaCCodeExpression* _tmp1542_;
					ValaLocalVariable* _tmp1543_;
					ValaHashMap* _tmp1544_;
					ValaDelegate* _tmp1545_;
					ValaCCodeExpression* _tmp1546_;
					ValaCCodeUnaryExpression* _tmp1547_;
					ValaCCodeUnaryExpression* _tmp1548_;
					ValaCCodeExpression* _tmp1549_;
					_tmp1537_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1538_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1537_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1538_;
					_tmp1539_ = temp_var;
					_tmp1540_ = vala_symbol_get_name ((ValaSymbol*) _tmp1539_);
					_tmp1541_ = _tmp1540_;
					_tmp1542_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1541_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1542_;
					_tmp1543_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1543_, FALSE);
					_tmp1544_ = out_arg_map;
					_tmp1545_ = deleg;
					_tmp1546_ = temp_ref;
					_tmp1547_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1546_);
					_tmp1548_ = _tmp1547_;
					vala_map_set ((ValaMap*) _tmp1544_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1545_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1548_);
					_vala_ccode_node_unref0 (_tmp1548_);
					_tmp1549_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1549_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1551_ = m;
	if (_tmp1551_ != NULL) {
		ValaMethod* _tmp1552_;
		gboolean _tmp1553_;
		gboolean _tmp1554_;
		_tmp1552_ = m;
		_tmp1553_ = vala_method_get_coroutine (_tmp1552_);
		_tmp1554_ = _tmp1553_;
		_tmp1550_ = _tmp1554_;
	} else {
		_tmp1550_ = FALSE;
	}
	if (_tmp1550_) {
		gboolean _tmp1555_;
		gboolean _tmp1556_;
		_tmp1555_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1556_ = _tmp1555_;
		if (_tmp1556_) {
			ValaHashMap* _tmp1557_;
			ValaMethod* _tmp1558_;
			ValaMethod* _tmp1559_;
			gchar* _tmp1560_;
			gchar* _tmp1561_;
			ValaCCodeIdentifier* _tmp1562_;
			ValaCCodeIdentifier* _tmp1563_;
			ValaHashMap* _tmp1564_;
			ValaCCodeIdentifier* _tmp1565_;
			ValaCCodeIdentifier* _tmp1566_;
			_tmp1557_ = in_arg_map;
			_tmp1558_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1559_ = _tmp1558_;
			_tmp1560_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1559_);
			_tmp1561_ = _tmp1560_;
			_tmp1562_ = vala_ccode_identifier_new (_tmp1561_);
			_tmp1563_ = _tmp1562_;
			vala_map_set ((ValaMap*) _tmp1557_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1563_);
			_vala_ccode_node_unref0 (_tmp1563_);
			_g_free0 (_tmp1561_);
			_tmp1564_ = in_arg_map;
			_tmp1565_ = vala_ccode_identifier_new ("_data_");
			_tmp1566_ = _tmp1565_;
			vala_map_set ((ValaMap*) _tmp1564_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1566_);
			_vala_ccode_node_unref0 (_tmp1566_);
		}
	}
	_tmp1567_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1568_ = _tmp1567_;
	if (_tmp1568_) {
		ValaCallable* _tmp1569_ = NULL;
		ValaMethod* _tmp1570_;
		ValaHashMap* _tmp1572_;
		ValaCCodeExpression* _tmp1573_;
		ValaCCodeExpression* _tmp1574_;
		ValaCCodeUnaryExpression* _tmp1575_;
		ValaCCodeUnaryExpression* _tmp1576_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1570_ = m;
		_tmp1569_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1570_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1569_ == NULL) {
			ValaDelegate* _tmp1571_;
			_tmp1571_ = deleg;
			_tmp1569_ = (ValaCallable*) _tmp1571_;
		}
		_tmp1572_ = out_arg_map;
		_tmp1573_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1574_ = _tmp1573_;
		_tmp1575_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1574_);
		_tmp1576_ = _tmp1575_;
		vala_map_set ((ValaMap*) _tmp1572_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1569_), FALSE)), (ValaCCodeExpression*) _tmp1576_);
		_vala_ccode_node_unref0 (_tmp1576_);
		_vala_ccode_node_unref0 (_tmp1574_);
	} else {
		gboolean _tmp1577_ = FALSE;
		gboolean _tmp1578_ = FALSE;
		ValaMethod* _tmp1579_;
		_tmp1579_ = m;
		if (_tmp1579_ != NULL) {
			ValaMethod* _tmp1580_;
			_tmp1580_ = m;
			_tmp1578_ = vala_method_has_error_type_parameter (_tmp1580_);
		} else {
			_tmp1578_ = FALSE;
		}
		if (_tmp1578_) {
			ValaCCodeFunctionCall* _tmp1581_;
			ValaCCodeFunctionCall* _tmp1582_;
			_tmp1581_ = async_call;
			_tmp1582_ = ccall;
			_tmp1577_ = _tmp1581_ != _tmp1582_;
		} else {
			_tmp1577_ = FALSE;
		}
		if (_tmp1577_) {
			ValaHashMap* _tmp1583_;
			ValaMethod* _tmp1584_;
			ValaCCodeConstant* _tmp1585_;
			ValaCCodeConstant* _tmp1586_;
			_tmp1583_ = out_arg_map;
			_tmp1584_ = m;
			_tmp1585_ = vala_ccode_constant_new ("NULL");
			_tmp1586_ = _tmp1585_;
			vala_map_set ((ValaMap*) _tmp1583_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1584_), FALSE)), (ValaCCodeExpression*) _tmp1586_);
			_vala_ccode_node_unref0 (_tmp1586_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1587_;
		_tmp1587_ = m;
		if (_tmp1587_ == NULL) {
			ValaHashMap* _tmp1588_;
			ValaCCodeConstant* _tmp1589_;
			ValaCCodeConstant* _tmp1590_;
			_tmp1588_ = in_arg_map;
			_tmp1589_ = vala_ccode_constant_new ("NULL");
			_tmp1590_ = _tmp1589_;
			vala_map_set ((ValaMap*) _tmp1588_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1590_);
			_vala_ccode_node_unref0 (_tmp1590_);
		} else {
			gboolean _tmp1591_ = FALSE;
			gboolean _tmp1592_ = FALSE;
			gboolean _tmp1593_ = FALSE;
			ValaMethod* _tmp1594_;
			gboolean _tmp1595_;
			gboolean _tmp1596_;
			_tmp1594_ = m;
			_tmp1595_ = vala_method_get_printf_format (_tmp1594_);
			_tmp1596_ = _tmp1595_;
			if (!_tmp1596_) {
				ValaMethod* _tmp1597_;
				gboolean _tmp1598_;
				gboolean _tmp1599_;
				_tmp1597_ = m;
				_tmp1598_ = vala_method_get_scanf_format (_tmp1597_);
				_tmp1599_ = _tmp1598_;
				_tmp1593_ = !_tmp1599_;
			} else {
				_tmp1593_ = FALSE;
			}
			if (_tmp1593_) {
				ValaMethod* _tmp1600_;
				gchar* _tmp1601_;
				gchar* _tmp1602_;
				_tmp1600_ = m;
				_tmp1601_ = vala_get_ccode_sentinel (_tmp1600_);
				_tmp1602_ = _tmp1601_;
				_tmp1592_ = g_strcmp0 (_tmp1602_, "") != 0;
				_g_free0 (_tmp1602_);
			} else {
				_tmp1592_ = FALSE;
			}
			if (_tmp1592_) {
				gboolean _tmp1603_;
				gboolean _tmp1604_;
				_tmp1603_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1604_ = _tmp1603_;
				_tmp1591_ = !_tmp1604_;
			} else {
				_tmp1591_ = FALSE;
			}
			if (_tmp1591_) {
				ValaHashMap* _tmp1605_;
				ValaMethod* _tmp1606_;
				gchar* _tmp1607_;
				gchar* _tmp1608_;
				ValaCCodeConstant* _tmp1609_;
				ValaCCodeConstant* _tmp1610_;
				_tmp1605_ = in_arg_map;
				_tmp1606_ = m;
				_tmp1607_ = vala_get_ccode_sentinel (_tmp1606_);
				_tmp1608_ = _tmp1607_;
				_tmp1609_ = vala_ccode_constant_new (_tmp1608_);
				_tmp1610_ = _tmp1609_;
				vala_map_set ((ValaMap*) _tmp1605_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1610_);
				_vala_ccode_node_unref0 (_tmp1610_);
				_g_free0 (_tmp1608_);
			}
		}
	}
	_tmp1612_ = deleg;
	if (_tmp1612_ != NULL) {
		ValaDelegate* _tmp1613_;
		gboolean _tmp1614_;
		gboolean _tmp1615_;
		_tmp1613_ = deleg;
		_tmp1614_ = vala_delegate_get_has_target (_tmp1613_);
		_tmp1615_ = _tmp1614_;
		_tmp1611_ = _tmp1615_;
	} else {
		_tmp1611_ = FALSE;
	}
	if (_tmp1611_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1616_;
		ValaDelegate* _tmp1617_;
		ValaExpression* _tmp1618_;
		ValaExpression* _tmp1619_;
		ValaCCodeExpression* _tmp1620_ = NULL;
		ValaCCodeExpression* _tmp1621_;
		ValaCCodeExpression* _tmp1622_;
		ValaHashMap* _tmp1623_;
		ValaDelegate* _tmp1624_;
		ValaExpression* _tmp1625_;
		ValaExpression* _tmp1626_;
		ValaCCodeExpression* _tmp1627_ = NULL;
		ValaCCodeExpression* _tmp1628_;
		ValaCCodeExpression* _tmp1629_;
		_tmp1616_ = in_arg_map;
		_tmp1617_ = deleg;
		_tmp1618_ = vala_method_call_get_call (expr);
		_tmp1619_ = _tmp1618_;
		_tmp1621_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1619_, &_tmp1620_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1620_;
		_tmp1622_ = _tmp1621_;
		vala_map_set ((ValaMap*) _tmp1616_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1617_), FALSE)), _tmp1622_);
		_vala_ccode_node_unref0 (_tmp1622_);
		_tmp1623_ = out_arg_map;
		_tmp1624_ = deleg;
		_tmp1625_ = vala_method_call_get_call (expr);
		_tmp1626_ = _tmp1625_;
		_tmp1628_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1626_, &_tmp1627_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1627_;
		_tmp1629_ = _tmp1628_;
		vala_map_set ((ValaMap*) _tmp1623_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1624_), FALSE)), _tmp1629_);
		_vala_ccode_node_unref0 (_tmp1629_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1630_ = itype;
	_tmp1631_ = vala_data_type_get_return_type (_tmp1630_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1631_);
	_tmp1633_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1633_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1634_;
		ValaDataType* _tmp1635_;
		_tmp1634_ = itype;
		_tmp1635_ = vala_data_type_get_return_type (_tmp1634_);
		_tmp1632_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1635_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1632_ = FALSE;
	}
	if (_tmp1632_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1636_;
		ValaSignal* _tmp1637_;
		ValaSignal* _tmp1638_;
		ValaSignal* _tmp1639_;
		gboolean _tmp1640_ = FALSE;
		gboolean _tmp1641_ = FALSE;
		ValaMemberAccess* _tmp1642_;
		_tmp1636_ = itype;
		_tmp1637_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1636_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1638_ = _tmp1637_;
		_tmp1639_ = _vala_code_node_ref0 (_tmp1638_);
		sig = _tmp1639_;
		_tmp1642_ = ma;
		if (_tmp1642_ != NULL) {
			ValaMemberAccess* _tmp1643_;
			ValaExpression* _tmp1644_;
			ValaExpression* _tmp1645_;
			_tmp1643_ = ma;
			_tmp1644_ = vala_member_access_get_inner (_tmp1643_);
			_tmp1645_ = _tmp1644_;
			_tmp1641_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1645_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1641_ = FALSE;
		}
		if (_tmp1641_) {
			ValaSignal* _tmp1646_;
			gboolean _tmp1647_;
			gboolean _tmp1648_;
			_tmp1646_ = sig;
			_tmp1647_ = vala_signal_get_is_virtual (_tmp1646_);
			_tmp1648_ = _tmp1647_;
			_tmp1640_ = _tmp1648_;
		} else {
			_tmp1640_ = FALSE;
		}
		if (_tmp1640_) {
		} else {
			gboolean _tmp1649_ = FALSE;
			ValaSignal* _tmp1650_;
			_tmp1650_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1650_)) {
				_tmp1649_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1651_;
				ValaSourceReference* _tmp1652_;
				ValaSourceReference* _tmp1653_;
				ValaSourceFile* _tmp1654_;
				ValaSourceFile* _tmp1655_;
				ValaSignal* _tmp1656_;
				ValaSourceReference* _tmp1657_;
				ValaSourceReference* _tmp1658_;
				ValaSourceFile* _tmp1659_;
				ValaSourceFile* _tmp1660_;
				_tmp1651_ = ma;
				_tmp1652_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1651_);
				_tmp1653_ = _tmp1652_;
				_tmp1654_ = vala_source_reference_get_file (_tmp1653_);
				_tmp1655_ = _tmp1654_;
				_tmp1656_ = sig;
				_tmp1657_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1656_);
				_tmp1658_ = _tmp1657_;
				_tmp1659_ = vala_source_reference_get_file (_tmp1658_);
				_tmp1660_ = _tmp1659_;
				_tmp1649_ = _tmp1655_ == _tmp1660_;
			}
			if (_tmp1649_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1661_ = async_call;
	_tmp1662_ = ccall;
	if (_tmp1661_ == _tmp1662_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1663_;
		ValaDataType* _tmp1664_;
		ValaLocalVariable* _tmp1665_;
		ValaLocalVariable* _tmp1666_;
		const gchar* _tmp1667_;
		const gchar* _tmp1668_;
		ValaCCodeExpression* _tmp1669_;
		ValaLocalVariable* _tmp1670_;
		ValaHashMap* _tmp1671_;
		ValaCCodeExpression* _tmp1672_;
		ValaCCodeUnaryExpression* _tmp1673_;
		ValaCCodeUnaryExpression* _tmp1674_;
		_tmp1663_ = itype;
		_tmp1664_ = vala_data_type_get_return_type (_tmp1663_);
		_tmp1665_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1664_, TRUE, NULL, TRUE);
		out_param_var = _tmp1665_;
		_tmp1666_ = out_param_var;
		_tmp1667_ = vala_symbol_get_name ((ValaSymbol*) _tmp1666_);
		_tmp1668_ = _tmp1667_;
		_tmp1669_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1668_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1669_;
		_tmp1670_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1670_, FALSE);
		_tmp1671_ = out_arg_map;
		_tmp1672_ = out_param_ref;
		_tmp1673_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1672_);
		_tmp1674_ = _tmp1673_;
		vala_map_set ((ValaMap*) _tmp1671_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1674_);
		_vala_ccode_node_unref0 (_tmp1674_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1675_ = async_call;
	_tmp1676_ = ccall;
	if (_tmp1675_ != _tmp1676_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1687_;
			ValaHashMap* _tmp1688_;
			gpointer _tmp1689_;
			ValaCCodeExpression* _tmp1690_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1677_;
				ValaSet* _tmp1678_;
				ValaSet* _tmp1679_;
				ValaIterator* _tmp1680_;
				ValaIterator* _tmp1681_;
				_tmp1677_ = out_arg_map;
				_tmp1678_ = vala_map_get_keys ((ValaMap*) _tmp1677_);
				_tmp1679_ = _tmp1678_;
				_tmp1680_ = vala_iterable_iterator ((ValaIterable*) _tmp1679_);
				_tmp1681_ = _tmp1680_;
				_vala_iterable_unref0 (_tmp1679_);
				_pos_it = _tmp1681_;
				while (TRUE) {
					ValaIterator* _tmp1682_;
					gint pos = 0;
					ValaIterator* _tmp1683_;
					gpointer _tmp1684_;
					gboolean _tmp1685_ = FALSE;
					_tmp1682_ = _pos_it;
					if (!vala_iterator_next (_tmp1682_)) {
						break;
					}
					_tmp1683_ = _pos_it;
					_tmp1684_ = vala_iterator_get (_tmp1683_);
					pos = (gint) ((gintptr) _tmp1684_);
					if (pos > last_pos) {
						gboolean _tmp1686_ = FALSE;
						if (min_pos == -1) {
							_tmp1686_ = TRUE;
						} else {
							_tmp1686_ = pos < min_pos;
						}
						_tmp1685_ = _tmp1686_;
					} else {
						_tmp1685_ = FALSE;
					}
					if (_tmp1685_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1687_ = ccall;
			_tmp1688_ = out_arg_map;
			_tmp1689_ = vala_map_get ((ValaMap*) _tmp1688_, (gpointer) ((gintptr) min_pos));
			_tmp1690_ = (ValaCCodeExpression*) _tmp1689_;
			vala_ccode_function_call_add_argument (_tmp1687_, _tmp1690_);
			_vala_ccode_node_unref0 (_tmp1690_);
			last_pos = min_pos;
		}
	}
	_tmp1691_ = async_call;
	if (_tmp1691_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1702_;
			ValaHashMap* _tmp1703_;
			gpointer _tmp1704_;
			ValaCCodeExpression* _tmp1705_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1692_;
				ValaSet* _tmp1693_;
				ValaSet* _tmp1694_;
				ValaIterator* _tmp1695_;
				ValaIterator* _tmp1696_;
				_tmp1692_ = in_arg_map;
				_tmp1693_ = vala_map_get_keys ((ValaMap*) _tmp1692_);
				_tmp1694_ = _tmp1693_;
				_tmp1695_ = vala_iterable_iterator ((ValaIterable*) _tmp1694_);
				_tmp1696_ = _tmp1695_;
				_vala_iterable_unref0 (_tmp1694_);
				_pos_it = _tmp1696_;
				while (TRUE) {
					ValaIterator* _tmp1697_;
					gint pos = 0;
					ValaIterator* _tmp1698_;
					gpointer _tmp1699_;
					gboolean _tmp1700_ = FALSE;
					_tmp1697_ = _pos_it;
					if (!vala_iterator_next (_tmp1697_)) {
						break;
					}
					_tmp1698_ = _pos_it;
					_tmp1699_ = vala_iterator_get (_tmp1698_);
					pos = (gint) ((gintptr) _tmp1699_);
					if (pos > last_pos) {
						gboolean _tmp1701_ = FALSE;
						if (min_pos == -1) {
							_tmp1701_ = TRUE;
						} else {
							_tmp1701_ = pos < min_pos;
						}
						_tmp1700_ = _tmp1701_;
					} else {
						_tmp1700_ = FALSE;
					}
					if (_tmp1700_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1702_ = async_call;
			_tmp1703_ = in_arg_map;
			_tmp1704_ = vala_map_get ((ValaMap*) _tmp1703_, (gpointer) ((gintptr) min_pos));
			_tmp1705_ = (ValaCCodeExpression*) _tmp1704_;
			vala_ccode_function_call_add_argument (_tmp1702_, _tmp1705_);
			_vala_ccode_node_unref0 (_tmp1705_);
			last_pos = min_pos;
		}
	}
	_tmp1706_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1707_ = _tmp1706_;
	if (_tmp1707_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1708_;
		gint _tmp1709_;
		ValaCCodeFunction* _tmp1710_;
		ValaCCodeFunction* _tmp1711_;
		ValaCCodeIdentifier* _tmp1712_;
		ValaCCodeIdentifier* _tmp1713_;
		ValaCCodeMemberAccess* _tmp1714_;
		ValaCCodeMemberAccess* _tmp1715_;
		gchar* _tmp1716_;
		gchar* _tmp1717_;
		ValaCCodeConstant* _tmp1718_;
		ValaCCodeConstant* _tmp1719_;
		ValaCCodeFunction* _tmp1720_;
		ValaCCodeFunction* _tmp1721_;
		ValaCCodeFunctionCall* _tmp1722_;
		ValaCCodeFunction* _tmp1723_;
		ValaCCodeFunction* _tmp1724_;
		ValaCCodeConstant* _tmp1725_;
		ValaCCodeConstant* _tmp1726_;
		ValaCCodeFunction* _tmp1727_;
		ValaCCodeFunction* _tmp1728_;
		gchar* _tmp1729_;
		gchar* _tmp1730_;
		_tmp1708_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1709_ = _tmp1708_->next_coroutine_state;
		_tmp1708_->next_coroutine_state = _tmp1709_ + 1;
		state = _tmp1709_;
		_tmp1710_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1711_ = _tmp1710_;
		_tmp1712_ = vala_ccode_identifier_new ("_data_");
		_tmp1713_ = _tmp1712_;
		_tmp1714_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1713_, "_state_");
		_tmp1715_ = _tmp1714_;
		_tmp1716_ = g_strdup_printf ("%i", state);
		_tmp1717_ = _tmp1716_;
		_tmp1718_ = vala_ccode_constant_new (_tmp1717_);
		_tmp1719_ = _tmp1718_;
		vala_ccode_function_add_assignment (_tmp1711_, (ValaCCodeExpression*) _tmp1715_, (ValaCCodeExpression*) _tmp1719_);
		_vala_ccode_node_unref0 (_tmp1719_);
		_g_free0 (_tmp1717_);
		_vala_ccode_node_unref0 (_tmp1715_);
		_vala_ccode_node_unref0 (_tmp1713_);
		_tmp1720_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1721_ = _tmp1720_;
		_tmp1722_ = async_call;
		vala_ccode_function_add_expression (_tmp1721_, (ValaCCodeExpression*) _tmp1722_);
		_tmp1723_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1724_ = _tmp1723_;
		_tmp1725_ = vala_ccode_constant_new ("FALSE");
		_tmp1726_ = _tmp1725_;
		vala_ccode_function_add_return (_tmp1724_, (ValaCCodeExpression*) _tmp1726_);
		_vala_ccode_node_unref0 (_tmp1726_);
		_tmp1727_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1728_ = _tmp1727_;
		_tmp1729_ = g_strdup_printf ("_state_%d", state);
		_tmp1730_ = _tmp1729_;
		vala_ccode_function_add_label (_tmp1728_, _tmp1730_);
		_g_free0 (_tmp1730_);
	}
	_tmp1731_ = vala_method_call_get_is_assert (expr);
	_tmp1732_ = _tmp1731_;
	if (_tmp1732_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1733_;
		ValaSourceReference* _tmp1734_;
		ValaSourceLocation _tmp1735_ = {0};
		ValaSourceLocation _tmp1736_;
		gchar* _tmp1737_;
		ValaSourceReference* _tmp1738_;
		ValaSourceReference* _tmp1739_;
		ValaSourceLocation _tmp1740_ = {0};
		ValaSourceLocation _tmp1741_;
		gchar* _tmp1742_;
		ValaSourceReference* _tmp1743_;
		ValaSourceReference* _tmp1744_;
		ValaSourceLocation _tmp1745_ = {0};
		ValaSourceLocation _tmp1746_;
		gchar* _tmp1747_;
		gchar* _tmp1748_;
		ValaCCodeFunctionCall* _tmp1749_;
		ValaCCodeIdentifier* _tmp1750_;
		ValaCCodeIdentifier* _tmp1751_;
		ValaCCodeFunctionCall* _tmp1752_;
		const gchar* _tmp1753_;
		gchar* _tmp1754_;
		gchar* _tmp1755_;
		gchar* _tmp1756_;
		gchar* _tmp1757_;
		gchar* _tmp1758_;
		gchar* _tmp1759_;
		ValaCCodeConstant* _tmp1760_;
		ValaCCodeConstant* _tmp1761_;
		_tmp1733_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1734_ = _tmp1733_;
		vala_source_reference_get_begin (_tmp1734_, &_tmp1735_);
		_tmp1736_ = _tmp1735_;
		_tmp1737_ = _tmp1736_.pos;
		_tmp1738_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1739_ = _tmp1738_;
		vala_source_reference_get_end (_tmp1739_, &_tmp1740_);
		_tmp1741_ = _tmp1740_;
		_tmp1742_ = _tmp1741_.pos;
		_tmp1743_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1744_ = _tmp1743_;
		vala_source_reference_get_begin (_tmp1744_, &_tmp1745_);
		_tmp1746_ = _tmp1745_;
		_tmp1747_ = _tmp1746_.pos;
		_tmp1748_ = string_substring ((const gchar*) _tmp1737_, (glong) 0, (glong) ((gint) (_tmp1742_ - _tmp1747_)));
		message = _tmp1748_;
		_tmp1749_ = ccall;
		_tmp1750_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1751_ = _tmp1750_;
		vala_ccode_function_call_set_call (_tmp1749_, (ValaCCodeExpression*) _tmp1751_);
		_vala_ccode_node_unref0 (_tmp1751_);
		_tmp1752_ = ccall;
		_tmp1753_ = message;
		_tmp1754_ = string_replace (_tmp1753_, "\n", " ");
		_tmp1755_ = _tmp1754_;
		_tmp1756_ = g_strescape (_tmp1755_, "");
		_tmp1757_ = _tmp1756_;
		_tmp1758_ = g_strdup_printf ("\"%s\"", _tmp1757_);
		_tmp1759_ = _tmp1758_;
		_tmp1760_ = vala_ccode_constant_new (_tmp1759_);
		_tmp1761_ = _tmp1760_;
		vala_ccode_function_call_add_argument (_tmp1752_, (ValaCCodeExpression*) _tmp1761_);
		_vala_ccode_node_unref0 (_tmp1761_);
		_g_free0 (_tmp1759_);
		_g_free0 (_tmp1757_);
		_g_free0 (_tmp1755_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1762_;
		ValaCCodeFunction* _tmp1763_;
		ValaCCodeExpression* _tmp1764_;
		ValaCCodeExpression* _tmp1765_;
		ValaCCodeExpression* _tmp1766_;
		_tmp1762_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1763_ = _tmp1762_;
		_tmp1764_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1763_, _tmp1764_);
		_tmp1765_ = out_param_ref;
		_tmp1766_ = _vala_ccode_node_ref0 (_tmp1765_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1766_;
	}
	_tmp1769_ = m;
	if (_tmp1769_ != NULL) {
		ValaMethod* _tmp1770_;
		ValaMemberBinding _tmp1771_;
		ValaMemberBinding _tmp1772_;
		_tmp1770_ = m;
		_tmp1771_ = vala_method_get_binding (_tmp1770_);
		_tmp1772_ = _tmp1771_;
		_tmp1768_ = _tmp1772_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1768_ = FALSE;
	}
	if (_tmp1768_) {
		ValaMethod* _tmp1773_;
		gboolean _tmp1774_;
		gboolean _tmp1775_;
		_tmp1773_ = m;
		_tmp1774_ = vala_method_get_returns_modified_pointer (_tmp1773_);
		_tmp1775_ = _tmp1774_;
		_tmp1767_ = _tmp1775_;
	} else {
		_tmp1767_ = FALSE;
	}
	if (_tmp1767_) {
		gboolean _tmp1776_ = FALSE;
		gboolean _tmp1777_ = FALSE;
		ValaMemberAccess* _tmp1778_;
		_tmp1778_ = ma;
		if (_tmp1778_ != NULL) {
			ValaMemberAccess* _tmp1779_;
			ValaExpression* _tmp1780_;
			ValaExpression* _tmp1781_;
			ValaSymbol* _tmp1782_;
			ValaSymbol* _tmp1783_;
			_tmp1779_ = ma;
			_tmp1780_ = vala_member_access_get_inner (_tmp1779_);
			_tmp1781_ = _tmp1780_;
			_tmp1782_ = vala_expression_get_symbol_reference (_tmp1781_);
			_tmp1783_ = _tmp1782_;
			_tmp1777_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1783_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1777_ = FALSE;
		}
		if (_tmp1777_) {
			ValaMemberAccess* _tmp1784_;
			ValaExpression* _tmp1785_;
			ValaExpression* _tmp1786_;
			_tmp1784_ = ma;
			_tmp1785_ = vala_member_access_get_inner (_tmp1784_);
			_tmp1786_ = _tmp1785_;
			_tmp1776_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1786_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1776_ = FALSE;
		}
		if (_tmp1776_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1787_;
			ValaExpression* _tmp1788_;
			ValaExpression* _tmp1789_;
			ValaSymbol* _tmp1790_;
			ValaSymbol* _tmp1791_;
			ValaProperty* _tmp1792_;
			ValaProperty* _tmp1793_;
			ValaMemberAccess* _tmp1794_;
			ValaExpression* _tmp1795_;
			ValaExpression* _tmp1796_;
			ValaExpression* _tmp1797_;
			ValaExpression* _tmp1798_;
			ValaDataType* _tmp1799_;
			ValaDataType* _tmp1800_;
			ValaCCodeExpression* _tmp1801_;
			ValaGLibValue* _tmp1802_;
			ValaGLibValue* _tmp1803_;
			_tmp1787_ = ma;
			_tmp1788_ = vala_member_access_get_inner (_tmp1787_);
			_tmp1789_ = _tmp1788_;
			_tmp1790_ = vala_expression_get_symbol_reference (_tmp1789_);
			_tmp1791_ = _tmp1790_;
			_tmp1792_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1791_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1792_;
			_tmp1793_ = prop;
			_tmp1794_ = ma;
			_tmp1795_ = vala_member_access_get_inner (_tmp1794_);
			_tmp1796_ = _tmp1795_;
			_tmp1797_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1796_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1798_ = _tmp1797_;
			_tmp1799_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1800_ = _tmp1799_;
			_tmp1801_ = ccall_expr;
			_tmp1802_ = vala_glib_value_new (_tmp1800_, _tmp1801_, FALSE);
			_tmp1803_ = _tmp1802_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1793_, _tmp1798_, (ValaTargetValue*) _tmp1803_);
			_vala_target_value_unref0 (_tmp1803_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1804_;
			ValaCCodeExpression* _tmp1805_;
			ValaCCodeAssignment* _tmp1806_;
			_tmp1804_ = instance;
			_tmp1805_ = ccall_expr;
			_tmp1806_ = vala_ccode_assignment_new (_tmp1804_, _tmp1805_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1806_;
		}
	}
	_tmp1812_ = m;
	if (_tmp1812_ != NULL) {
		ValaMethod* _tmp1813_;
		_tmp1813_ = m;
		_tmp1811_ = vala_get_ccode_simple_generics (_tmp1813_);
	} else {
		_tmp1811_ = FALSE;
	}
	if (_tmp1811_) {
		ValaMethod* _tmp1814_;
		ValaDataType* _tmp1815_;
		ValaDataType* _tmp1816_;
		_tmp1814_ = m;
		_tmp1815_ = vala_callable_get_return_type ((ValaCallable*) _tmp1814_);
		_tmp1816_ = _tmp1815_;
		_tmp1810_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1816_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1810_ = FALSE;
	}
	if (_tmp1810_) {
		ValaDataType* _tmp1817_;
		ValaDataType* _tmp1818_;
		_tmp1817_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1818_ = _tmp1817_;
		_tmp1809_ = vala_data_type_is_real_struct_type (_tmp1818_);
	} else {
		_tmp1809_ = FALSE;
	}
	if (_tmp1809_) {
		ValaDataType* _tmp1819_;
		ValaDataType* _tmp1820_;
		gboolean _tmp1821_;
		gboolean _tmp1822_;
		_tmp1819_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1820_ = _tmp1819_;
		_tmp1821_ = vala_data_type_get_nullable (_tmp1820_);
		_tmp1822_ = _tmp1821_;
		_tmp1808_ = !_tmp1822_;
	} else {
		_tmp1808_ = FALSE;
	}
	if (_tmp1808_) {
		ValaDataType* _tmp1823_;
		ValaDataType* _tmp1824_;
		_tmp1823_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1824_ = _tmp1823_;
		_tmp1807_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1824_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1807_ = FALSE;
	}
	if (_tmp1807_) {
		ValaCCodeExpression* _tmp1825_;
		ValaCCodeParenthesizedExpression* _tmp1826_;
		ValaCCodeParenthesizedExpression* _tmp1827_;
		ValaCCodeUnaryExpression* _tmp1828_;
		_tmp1825_ = ccall_expr;
		_tmp1826_ = vala_ccode_parenthesized_expression_new (_tmp1825_);
		_tmp1827_ = _tmp1826_;
		_tmp1828_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1827_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1828_;
		_vala_ccode_node_unref0 (_tmp1827_);
	}
	_tmp1831_ = m;
	if (_tmp1831_ != NULL) {
		ValaMethod* _tmp1832_;
		gchar* _tmp1833_;
		gchar* _tmp1834_;
		_tmp1832_ = m;
		_tmp1833_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1832_);
		_tmp1834_ = _tmp1833_;
		_tmp1830_ = _tmp1834_ != NULL;
		_g_free0 (_tmp1834_);
	} else {
		_tmp1830_ = FALSE;
	}
	if (_tmp1830_) {
		ValaMethod* _tmp1835_;
		gchar* _tmp1836_;
		gchar* _tmp1837_;
		ValaMethod* _tmp1838_;
		ValaDataType* _tmp1839_;
		ValaDataType* _tmp1840_;
		gchar* _tmp1841_;
		gchar* _tmp1842_;
		_tmp1835_ = m;
		_tmp1836_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1835_);
		_tmp1837_ = _tmp1836_;
		_tmp1838_ = m;
		_tmp1839_ = vala_callable_get_return_type ((ValaCallable*) _tmp1838_);
		_tmp1840_ = _tmp1839_;
		_tmp1841_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1840_);
		_tmp1842_ = _tmp1841_;
		_tmp1829_ = g_strcmp0 (_tmp1837_, _tmp1842_) != 0;
		_g_free0 (_tmp1842_);
		_g_free0 (_tmp1837_);
	} else {
		_tmp1829_ = FALSE;
	}
	if (_tmp1829_) {
		ValaCCodeExpression* _tmp1843_;
		ValaMethod* _tmp1844_;
		ValaDataType* _tmp1845_;
		ValaDataType* _tmp1846_;
		gchar* _tmp1847_;
		gchar* _tmp1848_;
		ValaCCodeCastExpression* _tmp1849_;
		_tmp1843_ = ccall_expr;
		_tmp1844_ = m;
		_tmp1845_ = vala_callable_get_return_type ((ValaCallable*) _tmp1844_);
		_tmp1846_ = _tmp1845_;
		_tmp1847_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1846_);
		_tmp1848_ = _tmp1847_;
		_tmp1849_ = vala_ccode_cast_expression_new (_tmp1843_, _tmp1848_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1849_;
		_g_free0 (_tmp1848_);
	}
	_tmp1850_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1850_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1851_;
		ValaIterator* _tmp1852_;
		ValaIterator* _tmp1853_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1854_;
		gpointer _tmp1855_;
		ValaExpression* _tmp1856_;
		ValaCCodeExpression* _tmp1857_;
		ValaCCodeExpression* _tmp1858_;
		ValaCCodeExpression* _tmp1859_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1860_;
		ValaLocalVariable* _tmp1861_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1862_;
		const gchar* _tmp1863_;
		const gchar* _tmp1864_;
		ValaCCodeExpression* _tmp1865_;
		ValaLocalVariable* _tmp1866_;
		ValaCCodeFile* _tmp1867_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1868_;
		ValaExpression* _tmp1869_;
		ValaExpression* _tmp1870_;
		ValaCCodeExpression* _tmp1871_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1872_;
		ValaExpression* _tmp1873_;
		ValaExpression* _tmp1874_;
		ValaCCodeExpression* _tmp1875_;
		ValaCCodeExpression* _tmp1876_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1877_;
		ValaExpression* _tmp1878_;
		ValaExpression* _tmp1879_;
		ValaDataType* _tmp1880_;
		ValaDataType* _tmp1881_;
		ValaArrayType* _tmp1882_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1883_;
		ValaDataType* _tmp1884_;
		ValaDataType* _tmp1885_;
		gchar* _tmp1886_;
		gchar* _tmp1887_;
		gchar* _tmp1888_;
		gchar* _tmp1889_;
		ValaCCodeIdentifier* _tmp1890_;
		ValaCCodeIdentifier* _tmp1891_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1892_;
		ValaCCodeExpression* _tmp1893_;
		ValaCCodeBinaryExpression* _tmp1894_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1895_;
		ValaCCodeExpression* _tmp1896_;
		ValaCCodeBinaryExpression* _tmp1897_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1898_;
		ValaCCodeIdentifier* _tmp1899_;
		ValaCCodeFunctionCall* _tmp1900_;
		ValaCCodeFunctionCall* _tmp1901_;
		ValaCCodeFunctionCall* _tmp1902_;
		ValaCCodeExpression* _tmp1903_;
		ValaCCodeExpression* _tmp1904_;
		ValaCCodeBinaryExpression* _tmp1905_;
		ValaCCodeBinaryExpression* _tmp1906_;
		ValaCCodeFunctionCall* _tmp1907_;
		ValaCCodeConstant* _tmp1908_;
		ValaCCodeConstant* _tmp1909_;
		ValaCCodeFunctionCall* _tmp1910_;
		ValaCCodeIdentifier* _tmp1911_;
		ValaCCodeBinaryExpression* _tmp1912_;
		ValaCCodeBinaryExpression* _tmp1913_;
		ValaCCodeBinaryExpression* _tmp1914_;
		ValaCCodeFunction* _tmp1915_;
		ValaCCodeFunction* _tmp1916_;
		ValaCCodeExpression* _tmp1917_;
		ValaCCodeExpression* _tmp1918_;
		ValaCCodeFunction* _tmp1919_;
		ValaCCodeFunction* _tmp1920_;
		ValaCCodeExpression* _tmp1921_;
		ValaCCodeFunction* _tmp1922_;
		ValaCCodeFunction* _tmp1923_;
		ValaCCodeBinaryExpression* _tmp1924_;
		ValaCCodeFunctionCall* _tmp1925_;
		ValaCCodeConstant* _tmp1926_;
		ValaCCodeConstant* _tmp1927_;
		ValaCCodeConditionalExpression* _tmp1928_;
		ValaCCodeConditionalExpression* _tmp1929_;
		ValaCCodeFunction* _tmp1930_;
		ValaCCodeFunction* _tmp1931_;
		ValaMemberAccess* _tmp1932_;
		ValaExpression* _tmp1933_;
		ValaExpression* _tmp1934_;
		ValaCCodeExpression* _tmp1935_;
		ValaCCodeExpression* _tmp1936_;
		ValaCCodeExpression* _tmp1937_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1938_;
		ValaExpression* _tmp1939_;
		ValaExpression* _tmp1940_;
		ValaSymbol* _tmp1941_;
		ValaSymbol* _tmp1942_;
		ValaSymbol* _tmp1943_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1944_;
		ValaLocalVariable* _tmp1945_;
		gboolean _tmp1946_ = FALSE;
		gboolean _tmp1947_ = FALSE;
		ValaSymbol* _tmp1948_;
		_tmp1851_ = vala_method_call_get_argument_list (expr);
		_tmp1852_ = vala_iterable_iterator ((ValaIterable*) _tmp1851_);
		arg_it = _tmp1852_;
		_tmp1853_ = arg_it;
		vala_iterator_next (_tmp1853_);
		_tmp1854_ = arg_it;
		_tmp1855_ = vala_iterator_get (_tmp1854_);
		_tmp1856_ = (ValaExpression*) _tmp1855_;
		_tmp1857_ = vala_get_cvalue (_tmp1856_);
		_tmp1858_ = _vala_ccode_node_ref0 (_tmp1857_);
		_tmp1859_ = _tmp1858_;
		_vala_code_node_unref0 (_tmp1856_);
		new_size = _tmp1859_;
		_tmp1860_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1861_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1860_, TRUE, NULL, FALSE);
		temp_decl = _tmp1861_;
		_tmp1862_ = temp_decl;
		_tmp1863_ = vala_symbol_get_name ((ValaSymbol*) _tmp1862_);
		_tmp1864_ = _tmp1863_;
		_tmp1865_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1864_);
		temp_ref = _tmp1865_;
		_tmp1866_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1866_, FALSE);
		_tmp1867_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1867_, "string.h", FALSE);
		_tmp1868_ = ma;
		_tmp1869_ = vala_member_access_get_inner (_tmp1868_);
		_tmp1870_ = _tmp1869_;
		_tmp1871_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1870_, 1);
		clen = _tmp1871_;
		_tmp1872_ = ma;
		_tmp1873_ = vala_member_access_get_inner (_tmp1872_);
		_tmp1874_ = _tmp1873_;
		_tmp1875_ = vala_get_cvalue (_tmp1874_);
		_tmp1876_ = _vala_ccode_node_ref0 (_tmp1875_);
		celems = _tmp1876_;
		_tmp1877_ = ma;
		_tmp1878_ = vala_member_access_get_inner (_tmp1877_);
		_tmp1879_ = _tmp1878_;
		_tmp1880_ = vala_expression_get_value_type (_tmp1879_);
		_tmp1881_ = _tmp1880_;
		_tmp1882_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1881_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1882_;
		_tmp1883_ = array_type;
		_tmp1884_ = vala_array_type_get_element_type (_tmp1883_);
		_tmp1885_ = _tmp1884_;
		_tmp1886_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1885_);
		_tmp1887_ = _tmp1886_;
		_tmp1888_ = g_strdup_printf ("sizeof (%s)", _tmp1887_);
		_tmp1889_ = _tmp1888_;
		_tmp1890_ = vala_ccode_identifier_new (_tmp1889_);
		_tmp1891_ = _tmp1890_;
		_g_free0 (_tmp1889_);
		_g_free0 (_tmp1887_);
		csizeof = _tmp1891_;
		_tmp1892_ = temp_ref;
		_tmp1893_ = clen;
		_tmp1894_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1892_, _tmp1893_);
		cdelta = _tmp1894_;
		_tmp1895_ = temp_ref;
		_tmp1896_ = clen;
		_tmp1897_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1895_, _tmp1896_);
		ccheck = _tmp1897_;
		_tmp1898_ = vala_ccode_identifier_new ("memset");
		_tmp1899_ = _tmp1898_;
		_tmp1900_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1899_);
		_tmp1901_ = _tmp1900_;
		_vala_ccode_node_unref0 (_tmp1899_);
		czero = _tmp1901_;
		_tmp1902_ = czero;
		_tmp1903_ = celems;
		_tmp1904_ = clen;
		_tmp1905_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1903_, _tmp1904_);
		_tmp1906_ = _tmp1905_;
		vala_ccode_function_call_add_argument (_tmp1902_, (ValaCCodeExpression*) _tmp1906_);
		_vala_ccode_node_unref0 (_tmp1906_);
		_tmp1907_ = czero;
		_tmp1908_ = vala_ccode_constant_new ("0");
		_tmp1909_ = _tmp1908_;
		vala_ccode_function_call_add_argument (_tmp1907_, (ValaCCodeExpression*) _tmp1909_);
		_vala_ccode_node_unref0 (_tmp1909_);
		_tmp1910_ = czero;
		_tmp1911_ = csizeof;
		_tmp1912_ = cdelta;
		_tmp1913_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1911_, (ValaCCodeExpression*) _tmp1912_);
		_tmp1914_ = _tmp1913_;
		vala_ccode_function_call_add_argument (_tmp1910_, (ValaCCodeExpression*) _tmp1914_);
		_vala_ccode_node_unref0 (_tmp1914_);
		_tmp1915_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1916_ = _tmp1915_;
		_tmp1917_ = temp_ref;
		_tmp1918_ = new_size;
		vala_ccode_function_add_assignment (_tmp1916_, _tmp1917_, _tmp1918_);
		_tmp1919_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1920_ = _tmp1919_;
		_tmp1921_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1920_, _tmp1921_);
		_tmp1922_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1923_ = _tmp1922_;
		_tmp1924_ = ccheck;
		_tmp1925_ = czero;
		_tmp1926_ = vala_ccode_constant_new ("NULL");
		_tmp1927_ = _tmp1926_;
		_tmp1928_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1924_, (ValaCCodeExpression*) _tmp1925_, (ValaCCodeExpression*) _tmp1927_);
		_tmp1929_ = _tmp1928_;
		vala_ccode_function_add_expression (_tmp1923_, (ValaCCodeExpression*) _tmp1929_);
		_vala_ccode_node_unref0 (_tmp1929_);
		_vala_ccode_node_unref0 (_tmp1927_);
		_tmp1930_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1931_ = _tmp1930_;
		_tmp1932_ = ma;
		_tmp1933_ = vala_member_access_get_inner (_tmp1932_);
		_tmp1934_ = _tmp1933_;
		_tmp1935_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1934_, 1);
		_tmp1936_ = _tmp1935_;
		_tmp1937_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1931_, _tmp1936_, _tmp1937_);
		_vala_ccode_node_unref0 (_tmp1936_);
		_tmp1938_ = ma;
		_tmp1939_ = vala_member_access_get_inner (_tmp1938_);
		_tmp1940_ = _tmp1939_;
		_tmp1941_ = vala_expression_get_symbol_reference (_tmp1940_);
		_tmp1942_ = _tmp1941_;
		_tmp1943_ = _vala_code_node_ref0 (_tmp1942_);
		array_var = _tmp1943_;
		_tmp1944_ = array_var;
		_tmp1945_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1944_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1944_) : NULL);
		array_local = _tmp1945_;
		_tmp1948_ = array_var;
		if (_tmp1948_ != NULL) {
			ValaSymbol* _tmp1949_;
			_tmp1949_ = array_var;
			_tmp1947_ = vala_symbol_is_internal_symbol (_tmp1949_);
		} else {
			_tmp1947_ = FALSE;
		}
		if (_tmp1947_) {
			gboolean _tmp1950_ = FALSE;
			gboolean _tmp1951_ = FALSE;
			ValaSymbol* _tmp1952_;
			_tmp1952_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1952_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1953_;
				gboolean _tmp1954_;
				gboolean _tmp1955_;
				_tmp1953_ = array_local;
				_tmp1954_ = vala_local_variable_get_captured (_tmp1953_);
				_tmp1955_ = _tmp1954_;
				_tmp1951_ = !_tmp1955_;
			} else {
				_tmp1951_ = FALSE;
			}
			if (_tmp1951_) {
				_tmp1950_ = TRUE;
			} else {
				ValaSymbol* _tmp1956_;
				_tmp1956_ = array_var;
				_tmp1950_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1956_, VALA_TYPE_FIELD);
			}
			_tmp1946_ = _tmp1950_;
		} else {
			_tmp1946_ = FALSE;
		}
		if (_tmp1946_) {
			ValaCCodeFunction* _tmp1957_;
			ValaCCodeFunction* _tmp1958_;
			ValaMemberAccess* _tmp1959_;
			ValaExpression* _tmp1960_;
			ValaExpression* _tmp1961_;
			ValaTargetValue* _tmp1962_;
			ValaTargetValue* _tmp1963_;
			ValaCCodeExpression* _tmp1964_;
			ValaCCodeExpression* _tmp1965_;
			_tmp1957_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1958_ = _tmp1957_;
			_tmp1959_ = ma;
			_tmp1960_ = vala_member_access_get_inner (_tmp1959_);
			_tmp1961_ = _tmp1960_;
			_tmp1962_ = vala_expression_get_target_value (_tmp1961_);
			_tmp1963_ = _tmp1962_;
			_tmp1964_ = vala_get_array_size_cvalue (_tmp1963_);
			_tmp1965_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1958_, _tmp1964_, _tmp1965_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1967_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1968_ = _tmp1967_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1968_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1969_;
		ValaDataType* _tmp1970_;
		_tmp1969_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1970_ = _tmp1969_;
		_tmp1966_ = !vala_data_type_is_disposable (_tmp1970_);
	} else {
		_tmp1966_ = FALSE;
	}
	if (_tmp1966_) {
		gboolean _tmp1971_ = FALSE;
		ValaCCodeExpression* _tmp1972_;
		_tmp1972_ = ccall_expr;
		if (_tmp1972_ != NULL) {
			_tmp1971_ = !return_result_via_out_param;
		} else {
			_tmp1971_ = FALSE;
		}
		if (_tmp1971_) {
			ValaCCodeFunction* _tmp1973_;
			ValaCCodeFunction* _tmp1974_;
			ValaCCodeExpression* _tmp1975_;
			_tmp1973_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1974_ = _tmp1973_;
			_tmp1975_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1974_, _tmp1975_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1976_;
		ValaDataType* _tmp1977_;
		ValaDataType* _tmp1978_;
		gboolean _tmp1979_ = FALSE;
		ValaDataType* _tmp1980_;
		ValaDataType* _tmp1981_;
		gboolean _tmp2034_ = FALSE;
		ValaMethod* _tmp2035_;
		_tmp1976_ = itype;
		_tmp1977_ = vala_data_type_get_return_type (_tmp1976_);
		_tmp1978_ = _vala_code_node_ref0 (_tmp1977_);
		result_type = _tmp1978_;
		_tmp1980_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1981_ = _tmp1980_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1981_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1982_;
			ValaDataType* _tmp1983_;
			_tmp1982_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1983_ = _tmp1982_;
			_tmp1979_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1983_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1979_ = FALSE;
		}
		if (_tmp1979_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1984_;
			ValaDataType* _tmp1985_;
			ValaTypeParameter* _tmp1986_;
			ValaTypeParameter* _tmp1987_;
			ValaTypeParameter* _tmp1988_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1989_;
			ValaSymbol* _tmp1990_;
			ValaSymbol* _tmp1991_;
			ValaSymbol* _tmp1992_;
			ValaSymbol* _tmp1993_;
			ValaStruct* _tmp1994_;
			gboolean _tmp1995_ = FALSE;
			ValaTypeParameter* _tmp1996_;
			ValaSymbol* _tmp1997_;
			ValaSymbol* _tmp1998_;
			ValaTypeSymbol* _tmp1999_;
			gboolean _tmp2008_ = FALSE;
			gboolean _tmp2009_ = FALSE;
			ValaStruct* _tmp2010_;
			_tmp1984_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1985_ = _tmp1984_;
			_tmp1986_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1985_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1987_ = _tmp1986_;
			_tmp1988_ = _vala_code_node_ref0 (_tmp1987_);
			type_parameter = _tmp1988_;
			_tmp1989_ = type_parameter;
			_tmp1990_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1989_);
			_tmp1991_ = _tmp1990_;
			_tmp1992_ = vala_symbol_get_parent_symbol (_tmp1991_);
			_tmp1993_ = _tmp1992_;
			_tmp1994_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1993_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1993_) : NULL);
			st = _tmp1994_;
			_tmp1996_ = type_parameter;
			_tmp1997_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1996_);
			_tmp1998_ = _tmp1997_;
			_tmp1999_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1998_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1999_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1995_ = TRUE;
			} else {
				gboolean _tmp2000_ = FALSE;
				ValaStruct* _tmp2001_;
				_tmp2001_ = st;
				if (_tmp2001_ != NULL) {
					ValaStruct* _tmp2002_;
					gchar* _tmp2003_;
					gchar* _tmp2004_;
					_tmp2002_ = st;
					_tmp2003_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2002_);
					_tmp2004_ = _tmp2003_;
					_tmp2000_ = g_strcmp0 (_tmp2004_, "va_list") == 0;
					_g_free0 (_tmp2004_);
				} else {
					_tmp2000_ = FALSE;
				}
				_tmp1995_ = _tmp2000_;
			}
			if (_tmp1995_) {
				ValaDataType* _tmp2005_;
				ValaDataType* _tmp2006_;
				ValaDataType* _tmp2007_;
				_tmp2005_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2006_ = _tmp2005_;
				_tmp2007_ = _vala_code_node_ref0 (_tmp2006_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2007_;
			}
			_tmp2010_ = st;
			if (_tmp2010_ != NULL) {
				ValaStruct* _tmp2011_;
				gchar* _tmp2012_;
				gchar* _tmp2013_;
				_tmp2011_ = st;
				_tmp2012_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2011_);
				_tmp2013_ = _tmp2012_;
				_tmp2009_ = g_strcmp0 (_tmp2013_, "va_list") == 0;
				_g_free0 (_tmp2013_);
			} else {
				_tmp2009_ = FALSE;
			}
			if (_tmp2009_) {
				ValaMemberAccess* _tmp2014_;
				const gchar* _tmp2015_;
				const gchar* _tmp2016_;
				_tmp2014_ = ma;
				_tmp2015_ = vala_member_access_get_member_name (_tmp2014_);
				_tmp2016_ = _tmp2015_;
				_tmp2008_ = g_strcmp0 (_tmp2016_, "arg") == 0;
			} else {
				_tmp2008_ = FALSE;
			}
			if (_tmp2008_) {
				gboolean _tmp2017_ = FALSE;
				ValaDataType* _tmp2018_;
				_tmp2018_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2018_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2019_;
					ValaDelegate* _tmp2020_;
					ValaDelegate* _tmp2021_;
					gboolean _tmp2022_;
					gboolean _tmp2023_;
					_tmp2019_ = result_type;
					_tmp2020_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2019_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2021_ = _tmp2020_;
					_tmp2022_ = vala_delegate_get_has_target (_tmp2021_);
					_tmp2023_ = _tmp2022_;
					_tmp2017_ = _tmp2023_;
				} else {
					_tmp2017_ = FALSE;
				}
				if (_tmp2017_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2024_;
					ValaTargetValue* _tmp2025_;
					ValaGLibValue* _tmp2026_;
					ValaCCodeExpression* _tmp2027_;
					ValaGLibValue* _tmp2030_;
					ValaCCodeExpression* _tmp2031_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2024_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2025_ = _tmp2024_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2025_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2026_ = arg_value;
					_tmp2027_ = _tmp2026_->delegate_target_cvalue;
					if (_tmp2027_ == NULL) {
						ValaGLibValue* _tmp2028_;
						ValaCCodeConstant* _tmp2029_;
						_tmp2028_ = arg_value;
						_tmp2029_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2028_->delegate_target_cvalue);
						_tmp2028_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2029_;
					}
					_tmp2030_ = arg_value;
					_tmp2031_ = _tmp2030_->delegate_target_destroy_notify_cvalue;
					if (_tmp2031_ == NULL) {
						ValaGLibValue* _tmp2032_;
						ValaCCodeConstant* _tmp2033_;
						_tmp2032_ = arg_value;
						_tmp2033_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2032_->delegate_target_destroy_notify_cvalue);
						_tmp2032_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2033_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2035_ = m;
		if (_tmp2035_ != NULL) {
			ValaMethod* _tmp2036_;
			_tmp2036_ = m;
			_tmp2034_ = vala_method_get_format_arg_index (_tmp2036_) >= 0;
		} else {
			_tmp2034_ = FALSE;
		}
		if (_tmp2034_) {
			ValaCCodeExpression* _tmp2037_;
			_tmp2037_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2037_);
		} else {
			gboolean _tmp2038_ = FALSE;
			ValaMethod* _tmp2039_;
			_tmp2039_ = m;
			if (_tmp2039_ != NULL) {
				ValaMethod* _tmp2040_;
				_tmp2040_ = m;
				_tmp2038_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2040_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2038_ = FALSE;
			}
			if (_tmp2038_) {
				ValaCCodeExpression* _tmp2041_;
				_tmp2041_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2041_);
			} else {
				gboolean _tmp2042_ = FALSE;
				gboolean _tmp2043_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2043_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2043_ = FALSE;
				}
				if (_tmp2043_) {
					gboolean _tmp2044_ = FALSE;
					ValaDataType* _tmp2045_;
					_tmp2045_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2045_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2046_;
						_tmp2046_ = result_type;
						_tmp2044_ = !vala_data_type_is_disposable (_tmp2046_);
					} else {
						_tmp2044_ = FALSE;
					}
					_tmp2042_ = _tmp2044_;
				} else {
					_tmp2042_ = FALSE;
				}
				if (_tmp2042_) {
					ValaCCodeExpression* _tmp2047_;
					_tmp2047_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2047_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2048_;
						ValaDataType* _tmp2049_;
						gboolean _tmp2050_;
						gboolean _tmp2051_;
						ValaLocalVariable* _tmp2052_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2053_;
						const gchar* _tmp2054_;
						const gchar* _tmp2055_;
						ValaCCodeExpression* _tmp2056_;
						ValaLocalVariable* _tmp2057_;
						ValaCCodeFunction* _tmp2058_;
						ValaCCodeFunction* _tmp2059_;
						ValaCCodeExpression* _tmp2060_;
						ValaCCodeExpression* _tmp2061_;
						ValaCCodeExpression* _tmp2062_;
						ValaTargetValue* _tmp2063_;
						ValaTargetValue* _tmp2064_;
						_tmp2048_ = result_type;
						_tmp2049_ = result_type;
						_tmp2050_ = vala_data_type_get_value_owned (_tmp2049_);
						_tmp2051_ = _tmp2050_;
						_tmp2052_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2048_, _tmp2051_, NULL, FALSE);
						temp_var = _tmp2052_;
						_tmp2053_ = temp_var;
						_tmp2054_ = vala_symbol_get_name ((ValaSymbol*) _tmp2053_);
						_tmp2055_ = _tmp2054_;
						_tmp2056_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2055_);
						temp_ref = _tmp2056_;
						_tmp2057_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2057_, FALSE);
						_tmp2058_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2059_ = _tmp2058_;
						_tmp2060_ = temp_ref;
						_tmp2061_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2059_, _tmp2060_, _tmp2061_);
						_tmp2062_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2062_);
						_tmp2063_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2064_ = _tmp2063_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2064_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2065_;
						ValaTargetValue* _tmp2066_;
						ValaTargetValue* _tmp2067_;
						_tmp2065_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2065_);
						_tmp2066_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2067_ = _tmp2066_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2067_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2068_ = params;
	_tmp2069_ = vala_iterable_iterator ((ValaIterable*) _tmp2068_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2069_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2070_;
		ValaList* _tmp2071_;
		gint _arg_size = 0;
		ValaList* _tmp2072_;
		gint _tmp2073_;
		gint _tmp2074_;
		gint _arg_index = 0;
		_tmp2070_ = vala_method_call_get_argument_list (expr);
		_tmp2071_ = _vala_iterable_ref0 (_tmp2070_);
		_arg_list = _tmp2071_;
		_tmp2072_ = _arg_list;
		_tmp2073_ = vala_collection_get_size ((ValaCollection*) _tmp2072_);
		_tmp2074_ = _tmp2073_;
		_arg_size = _tmp2074_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2075_;
			gint _tmp2076_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2077_;
			gpointer _tmp2078_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2079_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2082_;
			ValaUnaryExpression* _tmp2083_;
			gboolean _tmp2084_ = FALSE;
			ValaUnaryExpression* _tmp2085_;
			gboolean _tmp2140_ = FALSE;
			ValaUnaryExpression* _tmp2141_;
			ValaUnaryExpression* _tmp2145_;
			ValaExpression* _tmp2146_;
			ValaExpression* _tmp2147_;
			ValaDataType* _tmp2148_;
			ValaDataType* _tmp2149_;
			gboolean _tmp2159_ = FALSE;
			ValaMemberAccess* _tmp2160_;
			ValaSymbol* _tmp2161_;
			ValaSymbol* _tmp2162_;
			ValaUnaryExpression* _tmp2178_;
			ValaExpression* _tmp2179_;
			ValaExpression* _tmp2180_;
			ValaTargetValue* _tmp2181_;
			ValaTargetValue* _tmp2182_;
			ValaUnaryExpression* _tmp2183_;
			ValaTargetValue* _tmp2184_;
			ValaTargetValue* _tmp2185_;
			ValaUnaryExpression* _tmp2186_;
			ValaExpression* _tmp2187_;
			ValaExpression* _tmp2188_;
			ValaDataType* _tmp2189_;
			ValaDataType* _tmp2190_;
			ValaExpression* _tmp2191_;
			ValaTargetValue* _tmp2192_;
			ValaTargetValue* _tmp2193_;
			ValaSourceReference* _tmp2194_;
			ValaSourceReference* _tmp2195_;
			gboolean _tmp2196_ = FALSE;
			ValaParameter* _tmp2197_;
			_arg_index = _arg_index + 1;
			_tmp2075_ = _arg_index;
			_tmp2076_ = _arg_size;
			if (!(_tmp2075_ < _tmp2076_)) {
				break;
			}
			_tmp2077_ = _arg_list;
			_tmp2078_ = vala_list_get (_tmp2077_, _arg_index);
			arg = (ValaExpression*) _tmp2078_;
			param = NULL;
			_tmp2079_ = params_it;
			if (vala_iterator_next (_tmp2079_)) {
				ValaIterator* _tmp2080_;
				gpointer _tmp2081_;
				_tmp2080_ = params_it;
				_tmp2081_ = vala_iterator_get (_tmp2080_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2081_;
			}
			_tmp2082_ = arg;
			_tmp2083_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2082_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2082_) : NULL);
			unary = _tmp2083_;
			_tmp2085_ = unary;
			if (_tmp2085_ != NULL) {
				ValaUnaryExpression* _tmp2086_;
				ValaUnaryOperator _tmp2087_;
				ValaUnaryOperator _tmp2088_;
				_tmp2086_ = unary;
				_tmp2087_ = vala_unary_expression_get_operator (_tmp2086_);
				_tmp2088_ = _tmp2087_;
				_tmp2084_ = _tmp2088_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2084_ = FALSE;
			}
			if (_tmp2084_) {
				gboolean _tmp2089_ = FALSE;
				gboolean _tmp2090_ = FALSE;
				gboolean _tmp2091_ = FALSE;
				gboolean _tmp2092_ = FALSE;
				ValaParameter* _tmp2093_;
				_tmp2093_ = param;
				if (_tmp2093_ != NULL) {
					ValaParameter* _tmp2094_;
					_tmp2094_ = param;
					_tmp2092_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2094_);
				} else {
					_tmp2092_ = FALSE;
				}
				if (_tmp2092_) {
					ValaParameter* _tmp2095_;
					ValaDataType* _tmp2096_;
					ValaDataType* _tmp2097_;
					_tmp2095_ = param;
					_tmp2096_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2095_);
					_tmp2097_ = _tmp2096_;
					_tmp2091_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2097_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2091_ = FALSE;
				}
				if (_tmp2091_) {
					ValaParameter* _tmp2098_;
					ValaDataType* _tmp2099_;
					ValaDataType* _tmp2100_;
					gboolean _tmp2101_;
					gboolean _tmp2102_;
					_tmp2098_ = param;
					_tmp2099_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2098_);
					_tmp2100_ = _tmp2099_;
					_tmp2101_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2100_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2102_ = _tmp2101_;
					_tmp2090_ = !_tmp2102_;
				} else {
					_tmp2090_ = FALSE;
				}
				if (_tmp2090_) {
					ValaParameter* _tmp2103_;
					ValaDataType* _tmp2104_;
					ValaDataType* _tmp2105_;
					gint _tmp2106_;
					gint _tmp2107_;
					_tmp2103_ = param;
					_tmp2104_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2103_);
					_tmp2105_ = _tmp2104_;
					_tmp2106_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2105_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2107_ = _tmp2106_;
					_tmp2089_ = _tmp2107_ == 1;
				} else {
					_tmp2089_ = FALSE;
				}
				if (_tmp2089_) {
					ValaSymbol* array_var = NULL;
					ValaUnaryExpression* _tmp2108_;
					ValaExpression* _tmp2109_;
					ValaExpression* _tmp2110_;
					ValaSymbol* _tmp2111_;
					ValaSymbol* _tmp2112_;
					ValaLocalVariable* array_local = NULL;
					ValaSymbol* _tmp2113_;
					gboolean _tmp2114_ = FALSE;
					gboolean _tmp2115_ = FALSE;
					ValaSymbol* _tmp2116_;
					_tmp2108_ = unary;
					_tmp2109_ = vala_unary_expression_get_inner (_tmp2108_);
					_tmp2110_ = _tmp2109_;
					_tmp2111_ = vala_expression_get_symbol_reference (_tmp2110_);
					_tmp2112_ = _tmp2111_;
					array_var = _tmp2112_;
					_tmp2113_ = array_var;
					array_local = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2113_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp2113_) : NULL;
					_tmp2116_ = array_var;
					if (_tmp2116_ != NULL) {
						ValaSymbol* _tmp2117_;
						_tmp2117_ = array_var;
						_tmp2115_ = vala_symbol_is_internal_symbol (_tmp2117_);
					} else {
						_tmp2115_ = FALSE;
					}
					if (_tmp2115_) {
						gboolean _tmp2118_ = FALSE;
						gboolean _tmp2119_ = FALSE;
						ValaLocalVariable* _tmp2120_;
						_tmp2120_ = array_local;
						if (_tmp2120_ != NULL) {
							ValaLocalVariable* _tmp2121_;
							gboolean _tmp2122_;
							gboolean _tmp2123_;
							_tmp2121_ = array_local;
							_tmp2122_ = vala_local_variable_get_captured (_tmp2121_);
							_tmp2123_ = _tmp2122_;
							_tmp2119_ = !_tmp2123_;
						} else {
							_tmp2119_ = FALSE;
						}
						if (_tmp2119_) {
							_tmp2118_ = TRUE;
						} else {
							ValaSymbol* _tmp2124_;
							_tmp2124_ = array_var;
							_tmp2118_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2124_, VALA_TYPE_FIELD);
						}
						_tmp2114_ = _tmp2118_;
					} else {
						_tmp2114_ = FALSE;
					}
					if (_tmp2114_) {
						ValaCCodeFunction* _tmp2125_;
						ValaCCodeFunction* _tmp2126_;
						ValaUnaryExpression* _tmp2127_;
						ValaExpression* _tmp2128_;
						ValaExpression* _tmp2129_;
						ValaTargetValue* _tmp2130_;
						ValaTargetValue* _tmp2131_;
						ValaCCodeExpression* _tmp2132_;
						ValaUnaryExpression* _tmp2133_;
						ValaExpression* _tmp2134_;
						ValaExpression* _tmp2135_;
						ValaTargetValue* _tmp2136_;
						ValaTargetValue* _tmp2137_;
						ValaCCodeExpression* _tmp2138_;
						ValaCCodeExpression* _tmp2139_;
						_tmp2125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2126_ = _tmp2125_;
						_tmp2127_ = unary;
						_tmp2128_ = vala_unary_expression_get_inner (_tmp2127_);
						_tmp2129_ = _tmp2128_;
						_tmp2130_ = vala_expression_get_target_value (_tmp2129_);
						_tmp2131_ = _tmp2130_;
						_tmp2132_ = vala_get_array_size_cvalue (_tmp2131_);
						_tmp2133_ = unary;
						_tmp2134_ = vala_unary_expression_get_inner (_tmp2133_);
						_tmp2135_ = _tmp2134_;
						_tmp2136_ = vala_expression_get_target_value (_tmp2135_);
						_tmp2137_ = _tmp2136_;
						_tmp2138_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2137_, 1);
						_tmp2139_ = _tmp2138_;
						vala_ccode_function_add_assignment (_tmp2126_, _tmp2132_, _tmp2139_);
						_vala_ccode_node_unref0 (_tmp2139_);
					}
				}
			}
			_tmp2141_ = unary;
			if (_tmp2141_ == NULL) {
				_tmp2140_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2142_;
				ValaUnaryOperator _tmp2143_;
				ValaUnaryOperator _tmp2144_;
				_tmp2142_ = unary;
				_tmp2143_ = vala_unary_expression_get_operator (_tmp2142_);
				_tmp2144_ = _tmp2143_;
				_tmp2140_ = _tmp2144_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2140_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2145_ = unary;
			_tmp2146_ = vala_unary_expression_get_inner (_tmp2145_);
			_tmp2147_ = _tmp2146_;
			_tmp2148_ = vala_expression_get_value_type (_tmp2147_);
			_tmp2149_ = _tmp2148_;
			if (vala_ccode_base_module_requires_destroy (_tmp2149_)) {
				ValaCCodeFunction* _tmp2150_;
				ValaCCodeFunction* _tmp2151_;
				ValaUnaryExpression* _tmp2152_;
				ValaExpression* _tmp2153_;
				ValaExpression* _tmp2154_;
				ValaTargetValue* _tmp2155_;
				ValaTargetValue* _tmp2156_;
				ValaCCodeExpression* _tmp2157_;
				ValaCCodeExpression* _tmp2158_;
				_tmp2150_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2151_ = _tmp2150_;
				_tmp2152_ = unary;
				_tmp2153_ = vala_unary_expression_get_inner (_tmp2152_);
				_tmp2154_ = _tmp2153_;
				_tmp2155_ = vala_expression_get_target_value (_tmp2154_);
				_tmp2156_ = _tmp2155_;
				_tmp2157_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2156_, FALSE);
				_tmp2158_ = _tmp2157_;
				vala_ccode_function_add_expression (_tmp2151_, _tmp2158_);
				_vala_ccode_node_unref0 (_tmp2158_);
			}
			_tmp2160_ = ma;
			_tmp2161_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2160_);
			_tmp2162_ = _tmp2161_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2162_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2163_;
				ValaTargetValue* _tmp2164_;
				ValaTargetValue* _tmp2165_;
				ValaDataType* _tmp2166_;
				ValaDataType* _tmp2167_;
				_tmp2163_ = unary;
				_tmp2164_ = vala_expression_get_target_value ((ValaExpression*) _tmp2163_);
				_tmp2165_ = _tmp2164_;
				_tmp2166_ = vala_target_value_get_value_type (_tmp2165_);
				_tmp2167_ = _tmp2166_;
				_tmp2159_ = _tmp2167_ == NULL;
			} else {
				_tmp2159_ = FALSE;
			}
			if (_tmp2159_) {
				ValaUnaryExpression* _tmp2168_;
				ValaTargetValue* _tmp2169_;
				ValaTargetValue* _tmp2170_;
				ValaUnaryExpression* _tmp2171_;
				ValaExpression* _tmp2172_;
				ValaExpression* _tmp2173_;
				ValaDataType* _tmp2174_;
				ValaDataType* _tmp2175_;
				ValaDataType* _tmp2176_;
				ValaDataType* _tmp2177_;
				_tmp2168_ = unary;
				_tmp2169_ = vala_expression_get_target_value ((ValaExpression*) _tmp2168_);
				_tmp2170_ = _tmp2169_;
				_tmp2171_ = unary;
				_tmp2172_ = vala_unary_expression_get_inner (_tmp2171_);
				_tmp2173_ = _tmp2172_;
				_tmp2174_ = vala_expression_get_value_type (_tmp2173_);
				_tmp2175_ = _tmp2174_;
				_tmp2176_ = vala_data_type_copy (_tmp2175_);
				_tmp2177_ = _tmp2176_;
				vala_target_value_set_value_type (_tmp2170_, _tmp2177_);
				_vala_code_node_unref0 (_tmp2177_);
			}
			_tmp2178_ = unary;
			_tmp2179_ = vala_unary_expression_get_inner (_tmp2178_);
			_tmp2180_ = _tmp2179_;
			_tmp2181_ = vala_expression_get_target_value (_tmp2180_);
			_tmp2182_ = _tmp2181_;
			_tmp2183_ = unary;
			_tmp2184_ = vala_expression_get_target_value ((ValaExpression*) _tmp2183_);
			_tmp2185_ = _tmp2184_;
			_tmp2186_ = unary;
			_tmp2187_ = vala_unary_expression_get_inner (_tmp2186_);
			_tmp2188_ = _tmp2187_;
			_tmp2189_ = vala_expression_get_value_type (_tmp2188_);
			_tmp2190_ = _tmp2189_;
			_tmp2191_ = arg;
			_tmp2192_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2185_, _tmp2190_, (ValaCodeNode*) _tmp2191_);
			_tmp2193_ = _tmp2192_;
			_tmp2194_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2195_ = _tmp2194_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2182_, _tmp2193_, _tmp2195_);
			_vala_target_value_unref0 (_tmp2193_);
			_tmp2197_ = param;
			if (_tmp2197_ != NULL) {
				ValaParameter* _tmp2198_;
				_tmp2198_ = param;
				_tmp2196_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2198_);
			} else {
				_tmp2196_ = FALSE;
			}
			if (_tmp2196_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2199_;
				ValaCCodeIdentifier* _tmp2200_;
				ValaCCodeFunctionCall* _tmp2201_;
				ValaCCodeFunctionCall* _tmp2202_;
				ValaCCodeFunctionCall* _tmp2203_;
				ValaUnaryExpression* _tmp2204_;
				ValaExpression* _tmp2205_;
				ValaExpression* _tmp2206_;
				ValaTargetValue* _tmp2207_;
				ValaTargetValue* _tmp2208_;
				ValaCCodeExpression* _tmp2209_;
				ValaCCodeFunction* _tmp2210_;
				ValaCCodeFunction* _tmp2211_;
				ValaUnaryExpression* _tmp2212_;
				ValaExpression* _tmp2213_;
				ValaExpression* _tmp2214_;
				ValaTargetValue* _tmp2215_;
				ValaTargetValue* _tmp2216_;
				ValaCCodeExpression* _tmp2217_;
				ValaCCodeExpression* _tmp2218_;
				ValaCCodeFunctionCall* _tmp2219_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2199_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2200_ = _tmp2199_;
				_tmp2201_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2200_);
				_tmp2202_ = _tmp2201_;
				_vala_ccode_node_unref0 (_tmp2200_);
				len_call = _tmp2202_;
				_tmp2203_ = len_call;
				_tmp2204_ = unary;
				_tmp2205_ = vala_unary_expression_get_inner (_tmp2204_);
				_tmp2206_ = _tmp2205_;
				_tmp2207_ = vala_expression_get_target_value (_tmp2206_);
				_tmp2208_ = _tmp2207_;
				_tmp2209_ = vala_get_cvalue_ (_tmp2208_);
				vala_ccode_function_call_add_argument (_tmp2203_, _tmp2209_);
				_tmp2210_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2211_ = _tmp2210_;
				_tmp2212_ = unary;
				_tmp2213_ = vala_unary_expression_get_inner (_tmp2212_);
				_tmp2214_ = _tmp2213_;
				_tmp2215_ = vala_expression_get_target_value (_tmp2214_);
				_tmp2216_ = _tmp2215_;
				_tmp2217_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2216_, 1);
				_tmp2218_ = _tmp2217_;
				_tmp2219_ = len_call;
				vala_ccode_function_add_assignment (_tmp2211_, _tmp2218_, (ValaCCodeExpression*) _tmp2219_);
				_vala_ccode_node_unref0 (_tmp2218_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2222_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2222_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2223_;
		ValaSymbol* _tmp2224_;
		ValaSymbol* _tmp2225_;
		_tmp2223_ = m;
		_tmp2224_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2223_);
		_tmp2225_ = _tmp2224_;
		_tmp2221_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2225_, VALA_TYPE_CLASS);
	} else {
		_tmp2221_ = FALSE;
	}
	if (_tmp2221_) {
		gboolean _tmp2226_ = FALSE;
		gboolean _tmp2227_ = FALSE;
		ValaClass* _tmp2228_;
		ValaClass* _tmp2229_;
		gboolean _tmp2230_;
		gboolean _tmp2231_;
		_tmp2228_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2229_ = _tmp2228_;
		_tmp2230_ = vala_class_get_is_compact (_tmp2229_);
		_tmp2231_ = _tmp2230_;
		if (_tmp2231_) {
			ValaClass* _tmp2232_;
			ValaClass* _tmp2233_;
			ValaClass* _tmp2234_;
			ValaClass* _tmp2235_;
			_tmp2232_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2233_ = _tmp2232_;
			_tmp2234_ = vala_class_get_base_class (_tmp2233_);
			_tmp2235_ = _tmp2234_;
			_tmp2227_ = _tmp2235_ != NULL;
		} else {
			_tmp2227_ = FALSE;
		}
		if (_tmp2227_) {
			_tmp2226_ = TRUE;
		} else {
			ValaClass* _tmp2236_;
			ValaClass* _tmp2237_;
			ValaClass* _tmp2238_;
			ValaClass* _tmp2239_;
			ValaClass* _tmp2240_;
			_tmp2236_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2237_ = _tmp2236_;
			_tmp2238_ = vala_class_get_base_class (_tmp2237_);
			_tmp2239_ = _tmp2238_;
			_tmp2240_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2226_ = _tmp2239_ == _tmp2240_;
		}
		_tmp2220_ = _tmp2226_;
	} else {
		_tmp2220_ = FALSE;
	}
	if (_tmp2220_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2241_;
		ValaClass* _tmp2242_;
		gchar* _tmp2243_;
		gchar* _tmp2244_;
		gchar* _tmp2245_;
		gchar* _tmp2246_;
		ValaCCodeIdentifier* _tmp2247_;
		ValaCCodeIdentifier* _tmp2248_;
		ValaCCodeFunctionCall* _tmp2249_;
		ValaCCodeFunctionCall* _tmp2250_;
		ValaCCodeFunctionCall* _tmp2251_;
		ValaCCodeExpression* _tmp2252_;
		ValaCCodeExpression* _tmp2253_;
		ValaClass* _tmp2254_;
		ValaClass* _tmp2255_;
		gboolean _tmp2256_;
		gboolean _tmp2257_;
		ValaCCodeFunction* _tmp2261_;
		ValaCCodeFunction* _tmp2262_;
		ValaCCodeFunctionCall* _tmp2263_;
		_tmp2241_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2242_ = _tmp2241_;
		_tmp2243_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2242_, NULL);
		_tmp2244_ = _tmp2243_;
		_tmp2245_ = g_strdup_printf ("%s_instance_init", _tmp2244_);
		_tmp2246_ = _tmp2245_;
		_tmp2247_ = vala_ccode_identifier_new (_tmp2246_);
		_tmp2248_ = _tmp2247_;
		_tmp2249_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2248_);
		_tmp2250_ = _tmp2249_;
		_vala_ccode_node_unref0 (_tmp2248_);
		_g_free0 (_tmp2246_);
		_g_free0 (_tmp2244_);
		cinitcall = _tmp2250_;
		_tmp2251_ = cinitcall;
		_tmp2252_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2253_ = _tmp2252_;
		vala_ccode_function_call_add_argument (_tmp2251_, _tmp2253_);
		_vala_ccode_node_unref0 (_tmp2253_);
		_tmp2254_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2255_ = _tmp2254_;
		_tmp2256_ = vala_class_get_is_compact (_tmp2255_);
		_tmp2257_ = _tmp2256_;
		if (!_tmp2257_) {
			ValaCCodeFunctionCall* _tmp2258_;
			ValaCCodeConstant* _tmp2259_;
			ValaCCodeConstant* _tmp2260_;
			_tmp2258_ = cinitcall;
			_tmp2259_ = vala_ccode_constant_new ("NULL");
			_tmp2260_ = _tmp2259_;
			vala_ccode_function_call_add_argument (_tmp2258_, (ValaCCodeExpression*) _tmp2260_);
			_vala_ccode_node_unref0 (_tmp2260_);
		}
		_tmp2261_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2262_ = _tmp2261_;
		_tmp2263_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2262_, (ValaCCodeExpression*) _tmp2263_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _enum_value_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_enum_value_list = _tmp21_;
		_tmp22_ = _enum_value_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_enum_value_size = _tmp24_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaEnumValue* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaEnumValue* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			_enum_value_index = _enum_value_index + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = vala_list_get (_tmp27_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp28_;
			_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp30_ = _tmp29_;
			_tmp31_ = enum_value;
			_tmp32_ = vala_get_ccode_name ((ValaCodeNode*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_ccode_identifier_new (_tmp33_);
			_tmp35_ = _tmp34_;
			vala_ccode_function_add_case (_tmp30_, (ValaCCodeExpression*) _tmp35_);
			_vala_ccode_node_unref0 (_tmp35_);
			_g_free0 (_tmp33_);
			_tmp36_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = enum_value;
			_tmp39_ = vala_get_ccode_name ((ValaCodeNode*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat ("\"", _tmp40_, NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, "\"", NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_ccode_constant_new (_tmp44_);
			_tmp46_ = _tmp45_;
			vala_ccode_function_add_return (_tmp37_, (ValaCCodeExpression*) _tmp46_);
			_vala_ccode_node_unref0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	vala_ccode_function_close (_tmp48_);
	_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_constant_new ("NULL");
	_tmp52_ = _tmp51_;
	vala_ccode_function_add_return (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function_declaration (_tmp53_, _tmp54_);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = function;
	vala_ccode_file_add_function (_tmp55_, _tmp56_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaUnaryExpression* _tmp11_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp9_) : NULL;
			_tmp11_ = unary;
			if (_tmp11_ != NULL) {
				gboolean _tmp12_ = FALSE;
				ValaUnaryExpression* _tmp13_;
				ValaUnaryOperator _tmp14_;
				ValaUnaryOperator _tmp15_;
				_tmp13_ = unary;
				_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp12_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp16_;
					ValaUnaryOperator _tmp17_;
					ValaUnaryOperator _tmp18_;
					_tmp16_ = unary;
					_tmp17_ = vala_unary_expression_get_operator (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp10_ = _tmp12_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

