/* completionengine.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from completionengine.vala, do not modify */

/* sourcereference.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <vala.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define AFRODITE_TYPE_COMPLETION_ENGINE (afrodite_completion_engine_get_type ())
#define AFRODITE_COMPLETION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEngine))
#define AFRODITE_COMPLETION_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEngineClass))
#define AFRODITE_IS_COMPLETION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_COMPLETION_ENGINE))
#define AFRODITE_IS_COMPLETION_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_COMPLETION_ENGINE))
#define AFRODITE_COMPLETION_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEngineClass))

typedef struct _AfroditeCompletionEngine AfroditeCompletionEngine;
typedef struct _AfroditeCompletionEngineClass AfroditeCompletionEngineClass;
typedef struct _AfroditeCompletionEnginePrivate AfroditeCompletionEnginePrivate;

#define AFRODITE_TYPE_SOURCE_ITEM (afrodite_source_item_get_type ())
#define AFRODITE_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_ITEM, AfroditeSourceItem))
#define AFRODITE_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_ITEM, AfroditeSourceItemClass))
#define AFRODITE_IS_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_ITEM))
#define AFRODITE_IS_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_ITEM))
#define AFRODITE_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_ITEM, AfroditeSourceItemClass))

typedef struct _AfroditeSourceItem AfroditeSourceItem;
typedef struct _AfroditeSourceItemClass AfroditeSourceItemClass;

#define AFRODITE_TYPE_CODE_DOM (afrodite_code_dom_get_type ())
#define AFRODITE_CODE_DOM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_CODE_DOM, AfroditeCodeDom))
#define AFRODITE_CODE_DOM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_CODE_DOM, AfroditeCodeDomClass))
#define AFRODITE_IS_CODE_DOM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_CODE_DOM))
#define AFRODITE_IS_CODE_DOM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_CODE_DOM))
#define AFRODITE_CODE_DOM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_CODE_DOM, AfroditeCodeDomClass))

typedef struct _AfroditeCodeDom AfroditeCodeDom;
typedef struct _AfroditeCodeDomClass AfroditeCodeDomClass;

#define AFRODITE_TYPE_PARSE_RESULT (afrodite_parse_result_get_type ())
#define AFRODITE_PARSE_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_PARSE_RESULT, AfroditeParseResult))
#define AFRODITE_PARSE_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_PARSE_RESULT, AfroditeParseResultClass))
#define AFRODITE_IS_PARSE_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_PARSE_RESULT))
#define AFRODITE_IS_PARSE_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_PARSE_RESULT))
#define AFRODITE_PARSE_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_PARSE_RESULT, AfroditeParseResultClass))

typedef struct _AfroditeParseResult AfroditeParseResult;
typedef struct _AfroditeParseResultClass AfroditeParseResultClass;
#define _afrodite_code_dom_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_code_dom_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_mutex_free0(var) ((var == NULL) ? NULL : (var = (g_mutex_free (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _afrodite_source_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_item_unref (var), NULL)))

#define AFRODITE_TYPE_SOURCE_TYPE (afrodite_source_type_get_type ())
typedef struct _AfroditeSourceItemPrivate AfroditeSourceItemPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define AFRODITE_TYPE_SOURCE_FILE (afrodite_source_file_get_type ())
#define AFRODITE_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFile))
#define AFRODITE_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))
#define AFRODITE_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))

typedef struct _AfroditeSourceFile AfroditeSourceFile;
typedef struct _AfroditeSourceFileClass AfroditeSourceFileClass;
#define _afrodite_source_file_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_file_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define AFRODITE_TYPE_PARSER (afrodite_parser_get_type ())
#define AFRODITE_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_PARSER, AfroditeParser))
#define AFRODITE_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_PARSER, AfroditeParserClass))
#define AFRODITE_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_PARSER))
#define AFRODITE_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_PARSER))
#define AFRODITE_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_PARSER, AfroditeParserClass))

typedef struct _AfroditeParser AfroditeParser;
typedef struct _AfroditeParserClass AfroditeParserClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AfroditeParseResultPrivate AfroditeParseResultPrivate;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
typedef struct _AfroditeCompletionEngineMergeAndResolveData AfroditeCompletionEngineMergeAndResolveData;
typedef struct _AfroditeCompletionEnginePerformMergeAndResolveData AfroditeCompletionEnginePerformMergeAndResolveData;

#define AFRODITE_TYPE_AST_MERGER (afrodite_ast_merger_get_type ())
#define AFRODITE_AST_MERGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST_MERGER, AfroditeAstMerger))
#define AFRODITE_AST_MERGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST_MERGER, AfroditeAstMergerClass))
#define AFRODITE_IS_AST_MERGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST_MERGER))
#define AFRODITE_IS_AST_MERGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST_MERGER))
#define AFRODITE_AST_MERGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST_MERGER, AfroditeAstMergerClass))

typedef struct _AfroditeAstMerger AfroditeAstMerger;
typedef struct _AfroditeAstMergerClass AfroditeAstMergerClass;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
typedef struct _AfroditeCompletionEngineMergeValaSourceData AfroditeCompletionEngineMergeValaSourceData;

#define AFRODITE_TYPE_SYMBOL_RESOLVER (afrodite_symbol_resolver_get_type ())
#define AFRODITE_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolver))
#define AFRODITE_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolverClass))
#define AFRODITE_IS_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER))
#define AFRODITE_IS_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL_RESOLVER))
#define AFRODITE_SYMBOL_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolverClass))

typedef struct _AfroditeSymbolResolver AfroditeSymbolResolver;
typedef struct _AfroditeSymbolResolverClass AfroditeSymbolResolverClass;
#define _afrodite_symbol_resolver_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_symbol_resolver_unref (var), NULL)))
typedef struct _AfroditeCompletionEngineResolveCodedomData AfroditeCompletionEngineResolveCodedomData;

struct _AfroditeCompletionEngine {
	GObject parent_instance;
	AfroditeCompletionEnginePrivate * priv;
	gchar* id;
};

struct _AfroditeCompletionEngineClass {
	GObjectClass parent_class;
};

struct _AfroditeCompletionEnginePrivate {
	ValaList* _vapidirs;
	ValaList* _source_queue;
	GMutex* _source_queue_mutex;
	gboolean _begin_parse_event_fired;
	GThread* _parser_thread;
	gint _parser_stamp;
	gint _parser_remaining_files;
	gint _current_parsing_total_file_count;
	gboolean _glib_init;
	gboolean _is_parsing;
	AfroditeCodeDom* _codedom;
	GAsyncQueue* _parse_result_list;
	guint _idle_id;
};

typedef enum  {
	AFRODITE_SOURCE_TYPE_AUTO,
	AFRODITE_SOURCE_TYPE_VALA,
	AFRODITE_SOURCE_TYPE_GENIE,
	AFRODITE_SOURCE_TYPE_VAPI,
	AFRODITE_SOURCE_TYPE_UNKNOWN
} AfroditeSourceType;

struct _AfroditeSourceItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeSourceItemPrivate * priv;
	gchar* content;
	AfroditeSourceType source_type;
	gboolean is_glib;
	ValaCodeContext* context;
};

struct _AfroditeSourceItemClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeSourceItem *self);
};

struct _AfroditeParseResult {
	ValaReport parent_instance;
	AfroditeParseResultPrivate * priv;
	ValaList* warnings;
	ValaList* errors;
	ValaList* notes;
	gchar* source_path;
	gboolean is_glib;
	ValaCodeContext* context;
	gboolean is_edited;
};

struct _AfroditeParseResultClass {
	ValaReportClass parent_class;
};

struct _AfroditeCompletionEngineMergeAndResolveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AfroditeCompletionEngine* self;
	AfroditeParseResult* _result_;
	ValaList* _tmp0_;
	ValaList* _s_list;
	gint _tmp1_;
	gint _s_size;
	gint _s_index;
	gpointer _tmp2_;
	ValaSourceFile* s;
	const gchar* _tmp3_;
	AfroditeSourceFile* _tmp4_;
	AfroditeSourceFile* ast_source;
	gboolean source_exists;
	gboolean need_update;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
};

struct _AfroditeCompletionEnginePerformMergeAndResolveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AfroditeCompletionEngine* self;
	ValaSourceFile* s;
	AfroditeParseResult* _result_;
	gboolean source_exists;
};

struct _AfroditeCompletionEngineMergeValaSourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AfroditeCompletionEngine* self;
	ValaSourceFile* s;
	AfroditeParseResult* _result_;
	gboolean source_exists;
	GTimer* _tmp0_;
	GTimer* timer;
	gdouble start_time;
	gdouble elapsed;
	AfroditeAstMerger* _tmp1_;
	AfroditeAstMerger* merger;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	const gchar* _tmp6_;
};

struct _AfroditeCompletionEngineResolveCodedomData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AfroditeCompletionEngine* self;
	GTimer* _tmp0_;
	GTimer* timer;
	gdouble start_time;
	gdouble _tmp1_;
	AfroditeSymbolResolver* _tmp2_;
	AfroditeSymbolResolver* resolver;
	gdouble _tmp3_;
};


static gpointer afrodite_completion_engine_parent_class = NULL;

GType afrodite_completion_engine_get_type (void) G_GNUC_CONST;
gpointer afrodite_source_item_ref (gpointer instance);
void afrodite_source_item_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_item (GValue* value, gpointer v_object);
void afrodite_value_take_source_item (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_item (const GValue* value);
GType afrodite_source_item_get_type (void) G_GNUC_CONST;
gpointer afrodite_code_dom_ref (gpointer instance);
void afrodite_code_dom_unref (gpointer instance);
GParamSpec* afrodite_param_spec_code_dom (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_code_dom (GValue* value, gpointer v_object);
void afrodite_value_take_code_dom (GValue* value, gpointer v_object);
gpointer afrodite_value_get_code_dom (const GValue* value);
GType afrodite_code_dom_get_type (void) G_GNUC_CONST;
GType afrodite_parse_result_get_type (void) G_GNUC_CONST;
#define AFRODITE_COMPLETION_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEnginePrivate))
enum  {
	AFRODITE_COMPLETION_ENGINE_DUMMY_PROPERTY,
	AFRODITE_COMPLETION_ENGINE_IS_PARSING,
	AFRODITE_COMPLETION_ENGINE_CODEDOM
};
void afrodite_utils_trace (const gchar* format, ...);
AfroditeCompletionEngine* afrodite_completion_engine_new (const gchar* id);
AfroditeCompletionEngine* afrodite_completion_engine_construct (GType object_type, const gchar* id);
AfroditeCodeDom* afrodite_code_dom_new (void);
AfroditeCodeDom* afrodite_code_dom_construct (GType object_type);
void afrodite_completion_engine_add_vapi_dir (AfroditeCompletionEngine* self, const gchar* path);
void afrodite_completion_engine_remove_vapi_dir (AfroditeCompletionEngine* self, const gchar* path);
void afrodite_completion_engine_queue_source (AfroditeCompletionEngine* self, AfroditeSourceItem* item);
AfroditeSourceItem* afrodite_source_item_copy (AfroditeSourceItem* self);
gboolean afrodite_completion_engine_queue_sources (AfroditeCompletionEngine* self, ValaList* sources, gboolean no_update_check);
static AfroditeSourceItem* afrodite_completion_engine_source_queue_contains (AfroditeCompletionEngine* self, AfroditeSourceItem* value);
const gchar* afrodite_source_item_get_path (AfroditeSourceItem* self);
ValaList* afrodite_utils_get_package_paths (const gchar* pkg, ValaCodeContext* context, gchar** vapi_dirs, int vapi_dirs_length1);
GType afrodite_source_type_get_type (void) G_GNUC_CONST;
AfroditeSourceItem* afrodite_source_item_new (const gchar* path, AfroditeSourceType source_type);
AfroditeSourceItem* afrodite_source_item_construct (GType object_type, const gchar* path, AfroditeSourceType source_type);
gpointer afrodite_source_file_ref (gpointer instance);
void afrodite_source_file_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_file (GValue* value, gpointer v_object);
void afrodite_value_take_source_file (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_file (const GValue* value);
GType afrodite_source_file_get_type (void) G_GNUC_CONST;
AfroditeSourceFile* afrodite_code_dom_lookup_source_file (AfroditeCodeDom* self, const gchar* filename);
gboolean afrodite_source_file_update_last_modification_time (AfroditeSourceFile* self);
static void afrodite_completion_engine_create_parser_thread (AfroditeCompletionEngine* self);
void afrodite_completion_engine_queue_sourcefile (AfroditeCompletionEngine* self, const gchar* path, const gchar* content, gboolean is_vapi, gboolean is_glib);
void afrodite_completion_engine_queue_sourcefiles (AfroditeCompletionEngine* self, ValaList* paths, const gchar* content, gboolean is_vapi, gboolean is_glib);
void afrodite_completion_engine_remove_source_filename (AfroditeCompletionEngine* self, const gchar* source_path);
void afrodite_code_dom_remove_source (AfroditeCodeDom* self, AfroditeSourceFile* source);
static gint afrodite_completion_engine_parse_sources (AfroditeCompletionEngine* self);
static gpointer _afrodite_completion_engine_parse_sources_gthread_func (gpointer self);
AfroditeParser* afrodite_parser_new_with_source (AfroditeSourceItem* source_item);
AfroditeParser* afrodite_parser_construct_with_source (GType object_type, AfroditeSourceItem* source_item);
GType afrodite_parser_get_type (void) G_GNUC_CONST;
AfroditeParseResult* afrodite_parser_parse (AfroditeParser* self);
static gboolean afrodite_completion_engine_on_parse_results (AfroditeCompletionEngine* self);
static gboolean _afrodite_completion_engine_on_parse_results_gsource_func (gpointer self);
static void afrodite_completion_engine_on_begin_parsing (AfroditeCompletionEngine* self);
static void afrodite_completion_engine_on_end_parsing (AfroditeCompletionEngine* self);
static void afrodite_completion_engine_merge_and_resolve (AfroditeCompletionEngine* self, AfroditeParseResult* _result_, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void afrodite_completion_engine_merge_and_resolve_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_);
static void afrodite_completion_engine_on_merge_and_resolve_ended (AfroditeCompletionEngine* self, GObject* source, GAsyncResult* r);
static void _afrodite_completion_engine_on_merge_and_resolve_ended_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void afrodite_completion_engine_merge_and_resolve_data_free (gpointer _data);
static gboolean afrodite_completion_engine_merge_and_resolve_co (AfroditeCompletionEngineMergeAndResolveData* data);
static void afrodite_completion_engine_perform_merge_and_resolve (AfroditeCompletionEngine* self, ValaSourceFile* s, AfroditeParseResult* _result_, gboolean source_exists, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void afrodite_completion_engine_perform_merge_and_resolve_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_);
static void afrodite_completion_engine_merge_and_resolve_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void afrodite_completion_engine_perform_merge_and_resolve_data_free (gpointer _data);
static gboolean afrodite_completion_engine_perform_merge_and_resolve_co (AfroditeCompletionEnginePerformMergeAndResolveData* data);
static void afrodite_completion_engine_merge_vala_source (AfroditeCompletionEngine* self, ValaSourceFile* s, AfroditeParseResult* _result_, gboolean source_exists, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void afrodite_completion_engine_merge_vala_source_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_);
static void afrodite_completion_engine_perform_merge_and_resolve_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void afrodite_completion_engine_resolve_codedom (AfroditeCompletionEngine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void afrodite_completion_engine_resolve_codedom_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_);
static void afrodite_completion_engine_merge_vala_source_data_free (gpointer _data);
static gboolean afrodite_completion_engine_merge_vala_source_co (AfroditeCompletionEngineMergeValaSourceData* data);
AfroditeAstMerger* afrodite_ast_merger_new (AfroditeCodeDom* codedom);
AfroditeAstMerger* afrodite_ast_merger_construct (GType object_type, AfroditeCodeDom* codedom);
GType afrodite_ast_merger_get_type (void) G_GNUC_CONST;
void afrodite_ast_merger_merge_vala_context (AfroditeAstMerger* self, ValaSourceFile* source, ValaCodeContext* context, gboolean merge_glib, gboolean merge_edited_file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void afrodite_ast_merger_merge_vala_context_finish (AfroditeAstMerger* self, GAsyncResult* _res_);
static void afrodite_completion_engine_merge_vala_source_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void afrodite_completion_engine_resolve_codedom_data_free (gpointer _data);
static gboolean afrodite_completion_engine_resolve_codedom_co (AfroditeCompletionEngineResolveCodedomData* data);
AfroditeSymbolResolver* afrodite_symbol_resolver_new (void);
AfroditeSymbolResolver* afrodite_symbol_resolver_construct (GType object_type);
gpointer afrodite_symbol_resolver_ref (gpointer instance);
void afrodite_symbol_resolver_unref (gpointer instance);
GParamSpec* afrodite_param_spec_symbol_resolver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_symbol_resolver (GValue* value, gpointer v_object);
void afrodite_value_take_symbol_resolver (GValue* value, gpointer v_object);
gpointer afrodite_value_get_symbol_resolver (const GValue* value);
GType afrodite_symbol_resolver_get_type (void) G_GNUC_CONST;
void afrodite_symbol_resolver_resolve (AfroditeSymbolResolver* self, AfroditeCodeDom* codedom);
gboolean afrodite_completion_engine_get_is_parsing (AfroditeCompletionEngine* self);
AfroditeCodeDom* afrodite_completion_engine_get_codedom (AfroditeCompletionEngine* self);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void afrodite_completion_engine_finalize (GObject* obj);
static void _vala_afrodite_completion_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


AfroditeCompletionEngine* afrodite_completion_engine_construct (GType object_type, const gchar* id) {
	AfroditeCompletionEngine * self = NULL;
	gchar* _tmp0_;
	ValaArrayList* _tmp1_ = NULL;
	ValaArrayList* _tmp2_ = NULL;
	GMutex* _tmp3_ = NULL;
	AfroditeCodeDom* _tmp4_ = NULL;
	self = (AfroditeCompletionEngine*) g_object_new (object_type, NULL);
	if (id == NULL) {
		id = "";
	}
	_tmp0_ = g_strdup (id);
	_g_free0 (self->id);
	self->id = _tmp0_;
	_tmp1_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	_vala_iterable_unref0 (self->priv->_vapidirs);
	self->priv->_vapidirs = (ValaList*) _tmp1_;
	_tmp2_ = vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal);
	_vala_iterable_unref0 (self->priv->_source_queue);
	self->priv->_source_queue = (ValaList*) _tmp2_;
	_tmp3_ = g_mutex_new ();
	_g_mutex_free0 (self->priv->_source_queue_mutex);
	self->priv->_source_queue_mutex = _tmp3_;
	_tmp4_ = afrodite_code_dom_new ();
	_afrodite_code_dom_unref0 (self->priv->_codedom);
	self->priv->_codedom = _tmp4_;
	return self;
}


AfroditeCompletionEngine* afrodite_completion_engine_new (const gchar* id) {
	return afrodite_completion_engine_construct (AFRODITE_TYPE_COMPLETION_ENGINE, id);
}


void afrodite_completion_engine_add_vapi_dir (AfroditeCompletionEngine* self, const gchar* path) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	vala_collection_add ((ValaCollection*) self->priv->_vapidirs, path);
}


void afrodite_completion_engine_remove_vapi_dir (AfroditeCompletionEngine* self, const gchar* path) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = vala_collection_remove ((ValaCollection*) self->priv->_vapidirs, path);
	if (!_tmp0_) {
		g_warning ("completionengine.vala:99: remove_vapi_dir: vapidir %s not found", path);
	}
}


void afrodite_completion_engine_queue_source (AfroditeCompletionEngine* self, AfroditeSourceItem* item) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* sources;
	AfroditeSourceItem* _tmp1_ = NULL;
	AfroditeSourceItem* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal);
	sources = _tmp0_;
	_tmp1_ = afrodite_source_item_copy (item);
	_tmp2_ = _tmp1_;
	vala_collection_add ((ValaCollection*) sources, _tmp2_);
	_afrodite_source_item_unref0 (_tmp2_);
	afrodite_completion_engine_queue_sources (self, (ValaList*) sources, FALSE);
	_vala_iterable_unref0 (sources);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static AfroditeSourceItem* afrodite_completion_engine_source_queue_contains (AfroditeCompletionEngine* self, AfroditeSourceItem* value) {
	AfroditeSourceItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	{
		ValaList* _tmp0_;
		ValaList* _source_list;
		gint _tmp1_;
		gint _source_size;
		gint _source_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_source_queue);
		_source_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _source_list);
		_source_size = _tmp1_;
		_source_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			AfroditeSourceItem* source;
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			_source_index = _source_index + 1;
			if (!(_source_index < _source_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_source_list, _source_index);
			source = (AfroditeSourceItem*) _tmp2_;
			_tmp3_ = afrodite_source_item_get_path (source);
			_tmp4_ = afrodite_source_item_get_path (value);
			if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
				result = source;
				_vala_iterable_unref0 (_source_list);
				return result;
			}
			_afrodite_source_item_unref0 (source);
		}
		_vala_iterable_unref0 (_source_list);
	}
	result = NULL;
	return result;
}


gboolean afrodite_completion_engine_queue_sources (AfroditeCompletionEngine* self, ValaList* sources, gboolean no_update_check) {
	gboolean result = FALSE;
	gboolean _result_;
	gboolean _tmp26_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sources != NULL, FALSE);
	_result_ = FALSE;
	g_mutex_lock (self->priv->_source_queue_mutex);
	if (!self->priv->_glib_init) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar** _tmp2_ = NULL;
		gchar** packages;
		gint packages_length1;
		gint _packages_size_;
		ValaCodeContext* _tmp3_ = NULL;
		ValaCodeContext* context;
		self->priv->_glib_init = TRUE;
		_tmp0_ = g_strdup ("glib-2.0");
		_tmp1_ = g_strdup ("gobject-2.0");
		_tmp2_ = g_new0 (gchar*, 2 + 1);
		_tmp2_[0] = _tmp0_;
		_tmp2_[1] = _tmp1_;
		packages = _tmp2_;
		packages_length1 = 2;
		_packages_size_ = 2;
		_tmp3_ = vala_code_context_new ();
		context = _tmp3_;
		{
			gchar** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = packages;
			package_collection_length1 = packages_length1;
			for (package_it = 0; package_it < packages_length1; package_it = package_it + 1) {
				gchar* _tmp4_;
				gchar* package;
				_tmp4_ = g_strdup (package_collection[package_it]);
				package = _tmp4_;
				{
					ValaList* _tmp5_ = NULL;
					ValaList* paths;
					_tmp5_ = afrodite_utils_get_package_paths (package, context, NULL, 0);
					paths = _tmp5_;
					if (paths != NULL) {
						{
							ValaList* _tmp6_;
							ValaList* _path_list;
							gint _tmp7_;
							gint _path_size;
							gint _path_index;
							_tmp6_ = _vala_iterable_ref0 (paths);
							_path_list = _tmp6_;
							_tmp7_ = vala_collection_get_size ((ValaCollection*) _path_list);
							_path_size = _tmp7_;
							_path_index = -1;
							while (TRUE) {
								gpointer _tmp8_ = NULL;
								gchar* path;
								AfroditeSourceItem* _tmp9_ = NULL;
								AfroditeSourceItem* item;
								_path_index = _path_index + 1;
								if (!(_path_index < _path_size)) {
									break;
								}
								_tmp8_ = vala_list_get (_path_list, _path_index);
								path = (gchar*) _tmp8_;
								_tmp9_ = afrodite_source_item_new (path, AFRODITE_SOURCE_TYPE_AUTO);
								item = _tmp9_;
								_g_free0 (item->content);
								item->content = NULL;
								item->is_glib = TRUE;
								vala_list_insert (sources, 0, item);
								_afrodite_source_item_unref0 (item);
								_g_free0 (path);
							}
							_vala_iterable_unref0 (_path_list);
						}
					}
					_vala_iterable_unref0 (paths);
					_g_free0 (package);
				}
			}
		}
		_vala_code_context_unref0 (context);
		packages = (_vala_array_free (packages, packages_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		ValaList* _tmp10_;
		ValaList* _source_list;
		gint _tmp11_;
		gint _source_size;
		gint _source_index;
		_tmp10_ = _vala_iterable_ref0 (sources);
		_source_list = _tmp10_;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _source_list);
		_source_size = _tmp11_;
		_source_index = -1;
		while (TRUE) {
			gpointer _tmp12_ = NULL;
			AfroditeSourceItem* source;
			gboolean skip_unchanged_file;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			_source_index = _source_index + 1;
			if (!(_source_index < _source_size)) {
				break;
			}
			_tmp12_ = vala_list_get (_source_list, _source_index);
			source = (AfroditeSourceItem*) _tmp12_;
			skip_unchanged_file = FALSE;
			if (no_update_check == FALSE) {
				_tmp14_ = source->content == NULL;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				_tmp13_ = self->priv->_codedom != NULL;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				const gchar* _tmp15_ = NULL;
				AfroditeSourceFile* _tmp16_ = NULL;
				AfroditeSourceFile* sf;
				gboolean _tmp17_ = FALSE;
				_tmp15_ = afrodite_source_item_get_path (source);
				_tmp16_ = afrodite_code_dom_lookup_source_file (self->priv->_codedom, _tmp15_);
				sf = _tmp16_;
				if (sf != NULL) {
					gboolean _tmp18_;
					_tmp18_ = afrodite_source_file_update_last_modification_time (sf);
					_tmp17_ = _tmp18_;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					const gchar* _tmp19_ = NULL;
					_tmp19_ = afrodite_source_item_get_path (source);
					afrodite_utils_trace ("completionengine.vala:150: engine %s: skip unchanged source %s", self->id, _tmp19_);
					skip_unchanged_file = TRUE;
				}
				_afrodite_source_file_unref0 (sf);
			}
			if (!skip_unchanged_file) {
				AfroditeSourceItem* _tmp20_ = NULL;
				AfroditeSourceItem* item;
				gboolean _tmp21_ = FALSE;
				_tmp20_ = afrodite_completion_engine_source_queue_contains (self, source);
				item = _tmp20_;
				if (item == NULL) {
					_tmp21_ = TRUE;
				} else {
					_tmp21_ = g_strcmp0 (item->content, source->content) != 0;
				}
				if (_tmp21_) {
					AfroditeSourceItem* _tmp22_ = NULL;
					AfroditeSourceItem* _tmp23_;
					if (item != NULL) {
						vala_collection_remove ((ValaCollection*) self->priv->_source_queue, item);
					}
					_tmp22_ = afrodite_source_item_copy (source);
					_tmp23_ = _tmp22_;
					vala_collection_add ((ValaCollection*) self->priv->_source_queue, _tmp23_);
					_afrodite_source_item_unref0 (_tmp23_);
				} else {
					gboolean _tmp24_ = FALSE;
					if (item->content == NULL) {
						_tmp24_ = source->content != NULL;
					} else {
						_tmp24_ = FALSE;
					}
					if (_tmp24_) {
						gchar* _tmp25_;
						_tmp25_ = g_strdup (source->content);
						_g_free0 (item->content);
						item->content = _tmp25_;
					}
				}
				_afrodite_source_item_unref0 (item);
			}
			_afrodite_source_item_unref0 (source);
		}
		_vala_iterable_unref0 (_source_list);
	}
	g_mutex_unlock (self->priv->_source_queue_mutex);
	_tmp26_ = g_atomic_int_compare_and_exchange (&self->priv->_parser_stamp, 0, 1);
	if (_tmp26_) {
		afrodite_completion_engine_create_parser_thread (self);
	} else {
		g_atomic_int_inc (&self->priv->_parser_stamp);
	}
	result = _result_;
	return result;
}


void afrodite_completion_engine_queue_sourcefile (AfroditeCompletionEngine* self, const gchar* path, const gchar* content, gboolean is_vapi, gboolean is_glib) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* sources;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	sources = _tmp0_;
	vala_collection_add ((ValaCollection*) sources, path);
	afrodite_completion_engine_queue_sourcefiles (self, (ValaList*) sources, content, is_vapi, FALSE);
	_vala_iterable_unref0 (sources);
}


void afrodite_completion_engine_queue_sourcefiles (AfroditeCompletionEngine* self, ValaList* paths, const gchar* content, gboolean is_vapi, gboolean is_glib) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* sources;
	g_return_if_fail (self != NULL);
	g_return_if_fail (paths != NULL);
	_tmp0_ = vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal);
	sources = _tmp0_;
	{
		ValaList* _tmp1_;
		ValaList* _path_list;
		gint _tmp2_;
		gint _path_size;
		gint _path_index;
		_tmp1_ = _vala_iterable_ref0 (paths);
		_path_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _path_list);
		_path_size = _tmp2_;
		_path_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			gchar* path;
			AfroditeSourceItem* _tmp4_ = NULL;
			AfroditeSourceItem* item;
			gchar* _tmp5_;
			_path_index = _path_index + 1;
			if (!(_path_index < _path_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_path_list, _path_index);
			path = (gchar*) _tmp3_;
			_tmp4_ = afrodite_source_item_new (path, AFRODITE_SOURCE_TYPE_AUTO);
			item = _tmp4_;
			_tmp5_ = g_strdup (content);
			_g_free0 (item->content);
			item->content = _tmp5_;
			item->is_glib = is_glib;
			vala_collection_add ((ValaCollection*) sources, item);
			_afrodite_source_item_unref0 (item);
			_g_free0 (path);
		}
		_vala_iterable_unref0 (_path_list);
	}
	afrodite_completion_engine_queue_sources (self, (ValaList*) sources, FALSE);
	_vala_iterable_unref0 (sources);
}


void afrodite_completion_engine_remove_source_filename (AfroditeCompletionEngine* self, const gchar* source_path) {
	GTimer* _tmp0_ = NULL;
	GTimer* timer;
	gdouble start_time;
	gdouble _tmp1_;
	AfroditeSourceFile* _tmp2_ = NULL;
	AfroditeSourceFile* source;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_path != NULL);
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	start_time = (gdouble) 0;
	g_timer_start (timer);
	afrodite_utils_trace ("completionengine.vala:216: engine %s: removing source %s", self->id, source_path);
	_tmp1_ = g_timer_elapsed (timer, NULL);
	start_time = _tmp1_;
	_tmp2_ = afrodite_code_dom_lookup_source_file (self->priv->_codedom, source_path);
	source = _tmp2_;
	g_assert (source != NULL);
	afrodite_code_dom_remove_source (self->priv->_codedom, source);
	g_signal_emit_by_name (self, "file-removed", self, source_path);
	_tmp3_ = g_timer_elapsed (timer, NULL);
	afrodite_utils_trace ("completionengine.vala:226: engine %s: removing source %s done %g", self->id, source_path, _tmp3_ - start_time);
	_afrodite_source_file_unref0 (source);
	_g_timer_destroy0 (timer);
}


static gpointer _afrodite_completion_engine_parse_sources_gthread_func (gpointer self) {
	gpointer result;
	result = afrodite_completion_engine_parse_sources (self);
	return result;
}


static void afrodite_completion_engine_create_parser_thread (AfroditeCompletionEngine* self) {
	GThread* _tmp0_ = NULL;
	GThread* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->_parser_thread != NULL) {
		g_thread_join (self->priv->_parser_thread);
	}
	_tmp0_ = g_thread_create_full (_afrodite_completion_engine_parse_sources_gthread_func, self, (gulong) 0, TRUE, FALSE, G_THREAD_PRIORITY_LOW, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_THREAD_ERROR) {
			goto __catch3_g_thread_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->_parser_thread = _tmp1_;
	goto __finally3;
	__catch3_g_thread_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_error ("completionengine.vala:245: %s: can't create parser thread: %s", self->id, err->message);
		_g_error_free0 (err);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _afrodite_completion_engine_on_parse_results_gsource_func (gpointer self) {
	gboolean result;
	result = afrodite_completion_engine_on_parse_results (self);
	return result;
}


static gint afrodite_completion_engine_parse_sources (AfroditeCompletionEngine* self) {
	gint result = 0;
	GTimer* _tmp0_ = NULL;
	GTimer* timer;
	gdouble start_time;
	ValaArrayList* _tmp1_ = NULL;
	ValaList* sources;
	gdouble _tmp24_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	start_time = (gdouble) 0;
	g_timer_start (timer);
	afrodite_utils_trace ("completionengine.vala:256: engine %s: parser thread *** starting ***.." \
".", self->id);
	_tmp1_ = vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal);
	sources = (ValaList*) _tmp1_;
	while (TRUE) {
		gint _tmp2_;
		gint stamp;
		gint _tmp3_;
		gint _tmp9_;
		gint _tmp10_;
		gboolean _tmp22_ = FALSE;
		_tmp2_ = g_atomic_int_get (&self->priv->_parser_stamp);
		stamp = _tmp2_;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) self->priv->_source_queue);
		g_atomic_int_set (&self->priv->_parser_remaining_files, _tmp3_);
		g_mutex_lock (self->priv->_source_queue_mutex);
		{
			ValaList* _tmp4_;
			ValaList* _item_list;
			gint _tmp5_;
			gint _item_size;
			gint _item_index;
			_tmp4_ = _vala_iterable_ref0 (self->priv->_source_queue);
			_item_list = _tmp4_;
			_tmp5_ = vala_collection_get_size ((ValaCollection*) _item_list);
			_item_size = _tmp5_;
			_item_index = -1;
			while (TRUE) {
				gpointer _tmp6_ = NULL;
				AfroditeSourceItem* item;
				AfroditeSourceItem* _tmp7_ = NULL;
				AfroditeSourceItem* _tmp8_;
				_item_index = _item_index + 1;
				if (!(_item_index < _item_size)) {
					break;
				}
				_tmp6_ = vala_list_get (_item_list, _item_index);
				item = (AfroditeSourceItem*) _tmp6_;
				_tmp7_ = afrodite_source_item_copy (item);
				_tmp8_ = _tmp7_;
				vala_collection_add ((ValaCollection*) sources, _tmp8_);
				_afrodite_source_item_unref0 (_tmp8_);
				_afrodite_source_item_unref0 (item);
			}
			_vala_iterable_unref0 (_item_list);
		}
		_tmp9_ = vala_collection_get_size ((ValaCollection*) sources);
		afrodite_utils_trace ("completionengine.vala:270: engine %s: queued %d", self->id, _tmp9_);
		_tmp10_ = vala_collection_get_size ((ValaCollection*) sources);
		g_atomic_int_set (&self->priv->_current_parsing_total_file_count, _tmp10_);
		vala_collection_clear ((ValaCollection*) self->priv->_source_queue);
		g_mutex_unlock (self->priv->_source_queue_mutex);
		{
			ValaList* _tmp11_;
			ValaList* _source_list;
			gint _tmp12_;
			gint _source_size;
			gint _source_index;
			_tmp11_ = _vala_iterable_ref0 (sources);
			_source_list = _tmp11_;
			_tmp12_ = vala_collection_get_size ((ValaCollection*) _source_list);
			_source_size = _tmp12_;
			_source_index = -1;
			while (TRUE) {
				gpointer _tmp13_ = NULL;
				AfroditeSourceItem* source;
				const gchar* _tmp14_ = NULL;
				gdouble _tmp15_;
				AfroditeParser* _tmp16_ = NULL;
				AfroditeParser* p;
				AfroditeParseResult* _tmp17_ = NULL;
				AfroditeParseResult* parse_results;
				AfroditeParseResult* _tmp18_;
				const gchar* _tmp20_ = NULL;
				gdouble _tmp21_;
				_source_index = _source_index + 1;
				if (!(_source_index < _source_size)) {
					break;
				}
				_tmp13_ = vala_list_get (_source_list, _source_index);
				source = (AfroditeSourceItem*) _tmp13_;
				_tmp14_ = afrodite_source_item_get_path (source);
				afrodite_utils_trace ("completionengine.vala:278: engine %s: parsing source: %s", self->id, _tmp14_);
				_tmp15_ = g_timer_elapsed (timer, NULL);
				start_time = _tmp15_;
				_tmp16_ = afrodite_parser_new_with_source (source);
				p = _tmp16_;
				_tmp17_ = afrodite_parser_parse (p);
				parse_results = _tmp17_;
				g_async_queue_lock (self->priv->_parse_result_list);
				_tmp18_ = _g_object_ref0 (parse_results);
				g_async_queue_push_unlocked (self->priv->_parse_result_list, _tmp18_);
				if (self->priv->_idle_id == 0) {
					guint _tmp19_;
					_tmp19_ = g_timeout_add_full (G_PRIORITY_LOW, (guint) 250, _afrodite_completion_engine_on_parse_results_gsource_func, g_object_ref (self), g_object_unref);
					self->priv->_idle_id = _tmp19_;
				}
				g_async_queue_unlock (self->priv->_parse_result_list);
				_tmp20_ = afrodite_source_item_get_path (source);
				_tmp21_ = g_timer_elapsed (timer, NULL);
				afrodite_utils_trace ("completionengine.vala:292: engine %s: parsing source: %s done %g", self->id, _tmp20_, _tmp21_ - start_time);
				g_atomic_int_add (&self->priv->_parser_remaining_files, -1);
				_g_object_unref0 (parse_results);
				_g_object_unref0 (p);
				_afrodite_source_item_unref0 (source);
			}
			_vala_iterable_unref0 (_source_list);
		}
		vala_collection_clear ((ValaCollection*) sources);
		if (self->priv->_codedom == NULL) {
			_tmp22_ = TRUE;
		} else {
			gboolean _tmp23_;
			_tmp23_ = g_atomic_int_compare_and_exchange (&self->priv->_parser_stamp, stamp, 0);
			_tmp22_ = _tmp23_;
		}
		if (_tmp22_) {
			break;
		}
	}
	g_atomic_int_set (&self->priv->_current_parsing_total_file_count, 0);
	_vala_iterable_unref0 (sources);
	sources = NULL;
	g_timer_stop (timer);
	_tmp24_ = g_timer_elapsed (timer, NULL);
	afrodite_utils_trace ("completionengine.vala:311: engine %s: parser thread *** exiting *** (e" \
"lapsed time parsing %g)...", self->id, _tmp24_);
	result = 0;
	_vala_iterable_unref0 (sources);
	_g_timer_destroy0 (timer);
	return result;
}


static void afrodite_completion_engine_on_begin_parsing (AfroditeCompletionEngine* self) {
	g_return_if_fail (self != NULL);
	if (!self->priv->_is_parsing) {
		self->priv->_is_parsing = TRUE;
		g_signal_emit_by_name (self, "begin-parsing", self);
	}
}


static void afrodite_completion_engine_on_end_parsing (AfroditeCompletionEngine* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_atomic_int_get (&self->priv->_current_parsing_total_file_count);
	if (_tmp0_ == 0) {
		self->priv->_is_parsing = FALSE;
		g_signal_emit_by_name (self, "end-parsing", self);
	}
}


static void _afrodite_completion_engine_on_merge_and_resolve_ended_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	afrodite_completion_engine_on_merge_and_resolve_ended (self, source_object, res);
	g_object_unref (self);
}


static gboolean afrodite_completion_engine_on_parse_results (AfroditeCompletionEngine* self) {
	gboolean result = FALSE;
	AfroditeParseResult* parse_result;
	gpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	parse_result = NULL;
	g_async_queue_lock (self->priv->_parse_result_list);
	_tmp0_ = g_async_queue_try_pop_unlocked (self->priv->_parse_result_list);
	_g_object_unref0 (parse_result);
	parse_result = (AfroditeParseResult*) _tmp0_;
	if (parse_result == NULL) {
		self->priv->_idle_id = (guint) 0;
	}
	g_async_queue_unlock (self->priv->_parse_result_list);
	if (parse_result != NULL) {
		if (!self->priv->_begin_parse_event_fired) {
			self->priv->_begin_parse_event_fired = TRUE;
			afrodite_completion_engine_on_begin_parsing (self);
		}
		afrodite_completion_engine_merge_and_resolve (self, parse_result, _afrodite_completion_engine_on_merge_and_resolve_ended_gasync_ready_callback, g_object_ref (self));
	} else {
		afrodite_completion_engine_on_end_parsing (self);
		self->priv->_begin_parse_event_fired = FALSE;
	}
	result = FALSE;
	_g_object_unref0 (parse_result);
	return result;
}


static void afrodite_completion_engine_on_merge_and_resolve_ended (AfroditeCompletionEngine* self, GObject* source, GAsyncResult* r) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	afrodite_completion_engine_merge_and_resolve_finish (self, r);
	_tmp0_ = g_idle_add_full (G_PRIORITY_LOW, _afrodite_completion_engine_on_parse_results_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->_idle_id = _tmp0_;
}


static void afrodite_completion_engine_merge_and_resolve_data_free (gpointer _data) {
	AfroditeCompletionEngineMergeAndResolveData* data;
	data = _data;
	_g_object_unref0 (data->_result_);
	_g_object_unref0 (data->self);
	g_slice_free (AfroditeCompletionEngineMergeAndResolveData, data);
}


static void afrodite_completion_engine_merge_and_resolve (AfroditeCompletionEngine* self, AfroditeParseResult* _result_, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AfroditeCompletionEngineMergeAndResolveData* _data_;
	_data_ = g_slice_new0 (AfroditeCompletionEngineMergeAndResolveData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, afrodite_completion_engine_merge_and_resolve);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, afrodite_completion_engine_merge_and_resolve_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->_result_ = _g_object_ref0 (_result_);
	afrodite_completion_engine_merge_and_resolve_co (_data_);
}


static void afrodite_completion_engine_merge_and_resolve_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_) {
	AfroditeCompletionEngineMergeAndResolveData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void afrodite_completion_engine_merge_and_resolve_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AfroditeCompletionEngineMergeAndResolveData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	afrodite_completion_engine_merge_and_resolve_co (data);
}


static gboolean afrodite_completion_engine_merge_and_resolve_co (AfroditeCompletionEngineMergeAndResolveData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	afrodite_utils_trace ("completionengine.vala:370: engine %s: async merge and resolve: %s", data->self->id, data->_result_->source_path);
	{
		data->_tmp0_ = NULL;
		data->_tmp0_ = vala_code_context_get_source_files (data->_result_->context);
		data->_s_list = data->_tmp0_;
		data->_tmp1_ = vala_collection_get_size ((ValaCollection*) data->_s_list);
		data->_s_size = data->_tmp1_;
		data->_s_index = -1;
		while (TRUE) {
			data->_s_index = data->_s_index + 1;
			if (!(data->_s_index < data->_s_size)) {
				break;
			}
			data->_tmp2_ = NULL;
			data->_tmp2_ = vala_list_get (data->_s_list, data->_s_index);
			data->s = (ValaSourceFile*) data->_tmp2_;
			data->_tmp3_ = NULL;
			data->_tmp3_ = vala_source_file_get_filename (data->s);
			if (g_strcmp0 (data->_tmp3_, data->_result_->source_path) == 0) {
				data->_tmp4_ = NULL;
				data->_tmp4_ = afrodite_code_dom_lookup_source_file (data->self->priv->_codedom, data->_result_->source_path);
				data->ast_source = data->_tmp4_;
				data->source_exists = data->ast_source != NULL;
				data->need_update = TRUE;
				if (data->source_exists) {
					data->_tmp6_ = data->_result_->is_edited;
				} else {
					data->_tmp6_ = FALSE;
				}
				if (data->_tmp6_) {
					data->_tmp7_ = vala_collection_get_size ((ValaCollection*) data->_result_->errors);
					data->_tmp5_ = data->_tmp7_ > 0;
				} else {
					data->_tmp5_ = FALSE;
				}
				if (!data->_tmp5_) {
					if (data->source_exists) {
						data->_tmp8_ = !data->_result_->is_edited;
					} else {
						data->_tmp8_ = FALSE;
					}
					if (data->_tmp8_) {
						data->_tmp9_ = afrodite_source_file_update_last_modification_time (data->ast_source);
						data->need_update = data->_tmp9_;
					}
					_afrodite_source_file_unref0 (data->ast_source);
					data->ast_source = NULL;
					if (data->need_update) {
						data->_state_ = 1;
						afrodite_completion_engine_perform_merge_and_resolve (data->self, data->s, data->_result_, data->source_exists, afrodite_completion_engine_merge_and_resolve_ready, data);
						return FALSE;
						_state_1:
						afrodite_completion_engine_perform_merge_and_resolve_finish (data->self, data->_res_);
					}
				} else {
					afrodite_utils_trace ("completionengine.vala:392: engine %s: source (live buffer) with errors" \
" mantaining the previous parsing: %s", data->self->id, data->_result_->source_path);
				}
				g_signal_emit_by_name (data->self, "file-parsed", data->self, data->_result_->source_path, data->_result_);
				_afrodite_source_file_unref0 (data->ast_source);
				_vala_source_file_unref0 (data->s);
				break;
			}
			_vala_source_file_unref0 (data->s);
		}
		_vala_iterable_unref0 (data->_s_list);
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void afrodite_completion_engine_perform_merge_and_resolve_data_free (gpointer _data) {
	AfroditeCompletionEnginePerformMergeAndResolveData* data;
	data = _data;
	_vala_source_file_unref0 (data->s);
	_g_object_unref0 (data->_result_);
	_g_object_unref0 (data->self);
	g_slice_free (AfroditeCompletionEnginePerformMergeAndResolveData, data);
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void afrodite_completion_engine_perform_merge_and_resolve (AfroditeCompletionEngine* self, ValaSourceFile* s, AfroditeParseResult* _result_, gboolean source_exists, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AfroditeCompletionEnginePerformMergeAndResolveData* _data_;
	_data_ = g_slice_new0 (AfroditeCompletionEnginePerformMergeAndResolveData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, afrodite_completion_engine_perform_merge_and_resolve);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, afrodite_completion_engine_perform_merge_and_resolve_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->s = _vala_source_file_ref0 (s);
	_data_->_result_ = _g_object_ref0 (_result_);
	_data_->source_exists = source_exists;
	afrodite_completion_engine_perform_merge_and_resolve_co (_data_);
}


static void afrodite_completion_engine_perform_merge_and_resolve_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_) {
	AfroditeCompletionEnginePerformMergeAndResolveData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void afrodite_completion_engine_perform_merge_and_resolve_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AfroditeCompletionEnginePerformMergeAndResolveData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	afrodite_completion_engine_perform_merge_and_resolve_co (data);
}


static gboolean afrodite_completion_engine_perform_merge_and_resolve_co (AfroditeCompletionEnginePerformMergeAndResolveData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	afrodite_completion_engine_merge_vala_source (data->self, data->s, data->_result_, data->source_exists, afrodite_completion_engine_perform_merge_and_resolve_ready, data);
	return FALSE;
	_state_1:
	afrodite_completion_engine_merge_vala_source_finish (data->self, data->_res_);
	data->_state_ = 2;
	afrodite_completion_engine_resolve_codedom (data->self, afrodite_completion_engine_perform_merge_and_resolve_ready, data);
	return FALSE;
	_state_2:
	afrodite_completion_engine_resolve_codedom_finish (data->self, data->_res_);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void afrodite_completion_engine_merge_vala_source_data_free (gpointer _data) {
	AfroditeCompletionEngineMergeValaSourceData* data;
	data = _data;
	_vala_source_file_unref0 (data->s);
	_g_object_unref0 (data->_result_);
	_g_object_unref0 (data->self);
	g_slice_free (AfroditeCompletionEngineMergeValaSourceData, data);
}


static void afrodite_completion_engine_merge_vala_source (AfroditeCompletionEngine* self, ValaSourceFile* s, AfroditeParseResult* _result_, gboolean source_exists, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AfroditeCompletionEngineMergeValaSourceData* _data_;
	_data_ = g_slice_new0 (AfroditeCompletionEngineMergeValaSourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, afrodite_completion_engine_merge_vala_source);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, afrodite_completion_engine_merge_vala_source_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->s = _vala_source_file_ref0 (s);
	_data_->_result_ = _g_object_ref0 (_result_);
	_data_->source_exists = source_exists;
	afrodite_completion_engine_merge_vala_source_co (_data_);
}


static void afrodite_completion_engine_merge_vala_source_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_) {
	AfroditeCompletionEngineMergeValaSourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void afrodite_completion_engine_merge_vala_source_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AfroditeCompletionEngineMergeValaSourceData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	afrodite_completion_engine_merge_vala_source_co (data);
}


static gboolean afrodite_completion_engine_merge_vala_source_co (AfroditeCompletionEngineMergeValaSourceData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_timer_new ();
	data->timer = data->_tmp0_;
	data->start_time = (gdouble) 0;
	g_timer_start (data->timer);
	data->_tmp1_ = NULL;
	data->_tmp1_ = afrodite_ast_merger_new (data->self->priv->_codedom);
	data->merger = data->_tmp1_;
	if (data->source_exists) {
		afrodite_utils_trace ("completionengine.vala:418: engine %s: removing source (%p) %s", data->self->id, data->_result_, data->_result_->source_path);
		data->_tmp2_ = g_timer_elapsed (data->timer, NULL);
		data->start_time = data->_tmp2_;
		afrodite_completion_engine_remove_source_filename (data->self, data->_result_->source_path);
		data->_tmp3_ = g_timer_elapsed (data->timer, NULL);
		afrodite_utils_trace ("completionengine.vala:423: engine %s: removing source (%p) %s done %g", data->self->id, data->_result_, data->_result_->source_path, data->_tmp3_ - data->start_time);
	}
	afrodite_utils_trace ("completionengine.vala:427: engine %s: merging source %s", data->self->id, data->_result_->source_path);
	data->_tmp4_ = g_timer_elapsed (data->timer, NULL);
	data->start_time = data->_tmp4_;
	data->_state_ = 1;
	afrodite_ast_merger_merge_vala_context (data->merger, data->s, data->_result_->context, data->_result_->is_glib, data->_result_->is_edited, afrodite_completion_engine_merge_vala_source_ready, data);
	return FALSE;
	_state_1:
	afrodite_ast_merger_merge_vala_context_finish (data->merger, data->_res_);
	_vala_code_context_unref0 (data->_result_->context);
	data->_result_->context = NULL;
	_vala_code_visitor_unref0 (data->merger);
	data->merger = NULL;
	data->_tmp5_ = g_timer_elapsed (data->timer, NULL);
	data->elapsed = data->_tmp5_ - data->start_time;
	if (data->elapsed > 0.7) {
		data->_tmp6_ = " <== Warning";
	} else {
		data->_tmp6_ = "";
	}
	afrodite_utils_trace ("completionengine.vala:435: engine %s: merging source %s done %g %s", data->self->id, data->_result_->source_path, data->elapsed, data->_tmp6_);
	_vala_code_visitor_unref0 (data->merger);
	_g_timer_destroy0 (data->timer);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void afrodite_completion_engine_resolve_codedom_data_free (gpointer _data) {
	AfroditeCompletionEngineResolveCodedomData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (AfroditeCompletionEngineResolveCodedomData, data);
}


static void afrodite_completion_engine_resolve_codedom (AfroditeCompletionEngine* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AfroditeCompletionEngineResolveCodedomData* _data_;
	_data_ = g_slice_new0 (AfroditeCompletionEngineResolveCodedomData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, afrodite_completion_engine_resolve_codedom);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, afrodite_completion_engine_resolve_codedom_data_free);
	_data_->self = _g_object_ref0 (self);
	afrodite_completion_engine_resolve_codedom_co (_data_);
}


static void afrodite_completion_engine_resolve_codedom_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_) {
	AfroditeCompletionEngineResolveCodedomData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean afrodite_completion_engine_resolve_codedom_co (AfroditeCompletionEngineResolveCodedomData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_timer_new ();
	data->timer = data->_tmp0_;
	data->start_time = (gdouble) 0;
	g_timer_start (data->timer);
	afrodite_utils_trace ("completionengine.vala:446: engine %s: resolving ast", data->self->id);
	data->_tmp1_ = g_timer_elapsed (data->timer, NULL);
	data->start_time = data->_tmp1_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = afrodite_symbol_resolver_new ();
	data->resolver = data->_tmp2_;
	afrodite_symbol_resolver_resolve (data->resolver, data->self->priv->_codedom);
	data->_tmp3_ = g_timer_elapsed (data->timer, NULL);
	afrodite_utils_trace ("completionengine.vala:452: engine %s: resolving ast done %g", data->self->id, data->_tmp3_ - data->start_time);
	_afrodite_symbol_resolver_unref0 (data->resolver);
	_g_timer_destroy0 (data->timer);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


gboolean afrodite_completion_engine_get_is_parsing (AfroditeCompletionEngine* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_parsing;
	return result;
}


AfroditeCodeDom* afrodite_completion_engine_get_codedom (AfroditeCompletionEngine* self) {
	AfroditeCodeDom* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_codedom;
	return result;
}


static void g_cclosure_user_marshal_VOID__OBJECT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_STRING_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING_OBJECT) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), g_value_get_object (param_values + 3), data2);
}


static void afrodite_completion_engine_class_init (AfroditeCompletionEngineClass * klass) {
	afrodite_completion_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AfroditeCompletionEnginePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_afrodite_completion_engine_get_property;
	G_OBJECT_CLASS (klass)->finalize = afrodite_completion_engine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_COMPLETION_ENGINE_IS_PARSING, g_param_spec_boolean ("is-parsing", "is-parsing", "is-parsing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_COMPLETION_ENGINE_CODEDOM, afrodite_param_spec_code_dom ("codedom", "codedom", "codedom", AFRODITE_TYPE_CODE_DOM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("begin_parsing", AFRODITE_TYPE_COMPLETION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, AFRODITE_TYPE_COMPLETION_ENGINE);
	g_signal_new ("end_parsing", AFRODITE_TYPE_COMPLETION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, AFRODITE_TYPE_COMPLETION_ENGINE);
	g_signal_new ("file_removed", AFRODITE_TYPE_COMPLETION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING, G_TYPE_NONE, 2, AFRODITE_TYPE_COMPLETION_ENGINE, G_TYPE_STRING);
	g_signal_new ("file_parsed", AFRODITE_TYPE_COMPLETION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING_OBJECT, G_TYPE_NONE, 3, AFRODITE_TYPE_COMPLETION_ENGINE, G_TYPE_STRING, AFRODITE_TYPE_PARSE_RESULT);
}


static void afrodite_completion_engine_instance_init (AfroditeCompletionEngine * self) {
	GAsyncQueue* _tmp0_ = NULL;
	self->priv = AFRODITE_COMPLETION_ENGINE_GET_PRIVATE (self);
	self->priv->_begin_parse_event_fired = FALSE;
	self->priv->_parser_stamp = 0;
	self->priv->_parser_remaining_files = 0;
	self->priv->_current_parsing_total_file_count = 0;
	self->priv->_glib_init = FALSE;
	self->priv->_is_parsing = FALSE;
	_tmp0_ = g_async_queue_new ();
	self->priv->_parse_result_list = _tmp0_;
	self->priv->_idle_id = (guint) 0;
}


static void afrodite_completion_engine_finalize (GObject* obj) {
	AfroditeCompletionEngine * self;
	gint _tmp0_;
	self = AFRODITE_COMPLETION_ENGINE (obj);
	afrodite_utils_trace ("completionengine.vala:68: Completion %s destroy", self->id);
	_afrodite_code_dom_unref0 (self->priv->_codedom);
	self->priv->_codedom = NULL;
	_tmp0_ = g_atomic_int_get (&self->priv->_parser_stamp);
	if (_tmp0_ != 0) {
		afrodite_utils_trace ("completionengine.vala:73: join the parser thread before exit");
		g_thread_join (self->priv->_parser_thread);
	}
	self->priv->_parser_thread = NULL;
	if (self->priv->_idle_id != 0) {
		g_source_remove (self->priv->_idle_id);
		self->priv->_idle_id = (guint) 0;
	}
	afrodite_utils_trace ("completionengine.vala:81: Completion %s destroyed", self->id);
	_g_free0 (self->id);
	_vala_iterable_unref0 (self->priv->_vapidirs);
	_vala_iterable_unref0 (self->priv->_source_queue);
	_g_mutex_free0 (self->priv->_source_queue_mutex);
	_afrodite_code_dom_unref0 (self->priv->_codedom);
	_g_async_queue_unref0 (self->priv->_parse_result_list);
	G_OBJECT_CLASS (afrodite_completion_engine_parent_class)->finalize (obj);
}


GType afrodite_completion_engine_get_type (void) {
	static volatile gsize afrodite_completion_engine_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_completion_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeCompletionEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_completion_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeCompletionEngine), 0, (GInstanceInitFunc) afrodite_completion_engine_instance_init, NULL };
		GType afrodite_completion_engine_type_id;
		afrodite_completion_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "AfroditeCompletionEngine", &g_define_type_info, 0);
		g_once_init_leave (&afrodite_completion_engine_type_id__volatile, afrodite_completion_engine_type_id);
	}
	return afrodite_completion_engine_type_id__volatile;
}


static void _vala_afrodite_completion_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AfroditeCompletionEngine * self;
	self = AFRODITE_COMPLETION_ENGINE (object);
	switch (property_id) {
		case AFRODITE_COMPLETION_ENGINE_IS_PARSING:
		g_value_set_boolean (value, afrodite_completion_engine_get_is_parsing (self));
		break;
		case AFRODITE_COMPLETION_ENGINE_CODEDOM:
		afrodite_value_set_code_dom (value, afrodite_completion_engine_get_codedom (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



