#
# sql_to_c.awk
#
# $Id: res_to_c.awk,v 1.1.1.1.2.1 2011/09/08 15:28:27 source Exp $
#
# Embeds text into a C file
#  
#  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
#  project.
#  
#  Copyright (C) 1998-2006 OpenLink Software
#  
#  This project is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; only version 2 of the License, dated June 1991.
#  
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#  
#  You should have received a copy of the GNU General Public License along
#  with this program; if not, write to the Free Software Foundation, Inc.,
#  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#  
#  

BEGIN   {
	  print "{ /* The content of the resource */"
	}
	{
	  fun = $0
	  # was: gsub ( /\\/, "\\\\", fun)
	  q = "\\\\"
	  if (PROCINFO["version"] ~ /^4/)
	    gsub ( q, q q, fun)
	  else
	    gsub ( q, q, fun)

	  gsub ( /"/, "\\\"", fun)
	  gsub ( /\$/, "\\044", fun)
	  gsub ( /.*/, "\"&\\n\",", fun)
	  print fun
	  next
	}
END 	{
	   print "/* end of the content of the resource '" FILENAME "' */"
	   print "0 };"
        }
