/*
 * Copyright (C) 2015 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer
 *    in the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of Ericsson nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MockRealtimeMediaSource_h
#define MockRealtimeMediaSource_h

#if ENABLE(MEDIA_STREAM)

#include "RealtimeMediaSource.h"

#if USE(OPENWEBRTC)
#include "RealtimeMediaSourceOwr.h"
#endif

namespace WebCore {

class CaptureDevice;

#if USE(OPENWEBRTC)
using BaseRealtimeMediaSourceClass = RealtimeMediaSourceOwr;
#else
using BaseRealtimeMediaSourceClass = RealtimeMediaSource;
#endif

class MockRealtimeMediaSource : public BaseRealtimeMediaSourceClass {
public:
    virtual ~MockRealtimeMediaSource() { }

    static Vector<CaptureDevice>& audioDevices();
    static Vector<CaptureDevice>& videoDevices();

protected:
    MockRealtimeMediaSource(const String& id, Type, const String& name);

    virtual void updateSettings(RealtimeMediaSourceSettings&) = 0;
    virtual void initializeCapabilities(RealtimeMediaSourceCapabilities&) = 0;
#if !USE(OPENWEBRTC)
    virtual void initializeSupportedConstraints(RealtimeMediaSourceSupportedConstraints&) = 0;
#endif

    const RealtimeMediaSourceCapabilities& capabilities() const override;
    const RealtimeMediaSourceSettings& settings() const override;

    RealtimeMediaSourceSupportedConstraints& supportedConstraints();

    unsigned deviceIndex() { return m_deviceIndex; }

private:
    void initializeCapabilities();
#if USE(OPENWEBRTC)
    void initializeSettings() final;
#else
    void initializeSettings();
#endif

    RealtimeMediaSourceSettings m_currentSettings;
    RealtimeMediaSourceSupportedConstraints m_supportedConstraints;
    std::unique_ptr<RealtimeMediaSourceCapabilities> m_capabilities;
    unsigned m_deviceIndex { 0 };
};

} // namespace WebCore

#endif // ENABLE(MEDIA_STREAM)

#endif // MockRealtimeMediaSource_h
