/*
//
// Copyright 2002 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//

This file contains the Yacc grammar for GLSL ES.
Based on ANSI C Yacc grammar:
http://www.lysator.liu.se/c/ANSI-C-grammar-y.html

IF YOU MODIFY THIS FILE YOU ALSO NEED TO RUN scripts/run_code_generation.py
WHICH GENERATES THE GLSL ES PARSER (glslang_tab_autogen.cpp AND glslang_tab_autogen.h).
*/

%{
// GENERATED FILE - DO NOT EDIT.
// Generated by generate_parser.py from glslang.y
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// glslang.y:
//   Parser for the OpenGL shading language.

// Ignore errors in auto-generated code.
#if defined(__GNUC__)
#pragma GCC diagnostic ignored "-Wunused-function"
#pragma GCC diagnostic ignored "-Wunused-variable"
#pragma GCC diagnostic ignored "-Wswitch-enum"
#elif defined(_MSC_VER)
#pragma warning(disable: 4065)
#pragma warning(disable: 4189)
#pragma warning(disable: 4244)
#pragma warning(disable: 4505)
#pragma warning(disable: 4701)
#pragma warning(disable: 4702)
#endif
#if defined(__clang__)
#pragma clang diagnostic ignored "-Wunreachable-code"
#pragma clang diagnostic ignored "-Wunused-but-set-variable"
#endif

#include "angle_gl.h"
#include "compiler/translator/Declarator.h"
#include "compiler/translator/SymbolTable.h"
#include "compiler/translator/ParseContext.h"
#include "GLSLANG/ShaderLang.h"

#define YYENABLE_NLS 0

using namespace sh;

%}
%expect 1 /* One shift reduce conflict because of if | else */
%parse-param {TParseContext* context}
%param   {void *scanner}
%define api.pure full
%locations

%code requires {
#define YYLTYPE TSourceLoc
#define YYLTYPE_IS_DECLARED 1
#define YYLTYPE_IS_TRIVIAL 1
}

%union {
    struct {
        union {
            const char *string;  // pool allocated.
            float f;
            int i;
            unsigned int u;
            bool b;
        };
        const TSymbol* symbol;
    } lex;
    struct {
        TOperator op;
        union {
            TIntermNode *intermNode;
            TIntermNodePair nodePair;
            TIntermTyped *intermTypedNode;
            TIntermAggregate *intermAggregate;
            TIntermBlock *intermBlock;
            TIntermDeclaration *intermDeclaration;
            TIntermFunctionPrototype *intermFunctionPrototype;
            TIntermSwitch *intermSwitch;
            TIntermCase *intermCase;
        };
        union {
            TVector<unsigned int> *arraySizes;
            TTypeSpecifierNonArray typeSpecifierNonArray;
            TPublicType type;
            TPrecision precision;
            TLayoutQualifier layoutQualifier;
            TQualifier qualifier;
            TFunction *function;
            TFunctionLookup *functionLookup;
            TParameter param;
            TDeclarator *declarator;
            TDeclaratorList *declaratorList;
            TFieldList *fieldList;
            TQualifierWrapperBase *qualifierWrapper;
            TTypeQualifierBuilder *typeQualifierBuilder;
        };
    } interm;
}

%{
extern int yylex(YYSTYPE* yylval, YYLTYPE* yylloc, void* yyscanner);
extern void yyerror(YYLTYPE* yylloc, TParseContext* context, void *scanner, const char* reason);

#define YYLLOC_DEFAULT(Current, Rhs, N)                      \
  do {                                                       \
      if (N) {                                         \
        (Current).first_file = YYRHSLOC(Rhs, 1).first_file;  \
        (Current).first_line = YYRHSLOC(Rhs, 1).first_line;  \
        (Current).last_file = YYRHSLOC(Rhs, N).last_file;    \
        (Current).last_line = YYRHSLOC(Rhs, N).last_line;    \
      }                                                      \
      else {                                                 \
        (Current).first_file = YYRHSLOC(Rhs, 0).last_file;   \
        (Current).first_line = YYRHSLOC(Rhs, 0).last_line;   \
        (Current).last_file = YYRHSLOC(Rhs, 0).last_file;    \
        (Current).last_line = YYRHSLOC(Rhs, 0).last_line;    \
      }                                                      \
  } while (0)

#define VERTEX_ONLY(S, L) do {  \
    if (context->getShaderType() != GL_VERTEX_SHADER) {  \
        context->error(L, " supported in vertex shaders only", S);  \
    }  \
} while (0)

#define COMPUTE_ONLY(S, L) do {  \
    if (context->getShaderType() != GL_COMPUTE_SHADER) {  \
        context->error(L, " supported in compute shaders only", S);  \
    }  \
} while (0)

#define ES2_ONLY(S, L) do {  \
    if (context->getShaderVersion() != 100) {  \
        context->error(L, " supported in GLSL ES 1.00 only", S);  \
    }  \
} while (0)

#define ES3_OR_NEWER(TOKEN, LINE, REASON) do {  \
    if (context->getShaderVersion() < 300) {  \
        context->error(LINE, REASON " supported in GLSL ES 3.00 and above only", TOKEN);  \
    }  \
} while (0)

#define ES3_1_OR_NEWER(TOKEN, LINE, REASON) do {  \
    if (context->getShaderVersion() < 310) {  \
        context->error(LINE, REASON " supported in GLSL ES 3.10 and above only", TOKEN);  \
    }  \
} while (0)
%}

%token <lex> INVARIANT PRECISE HIGH_PRECISION MEDIUM_PRECISION LOW_PRECISION PRECISION
%token <lex> ATTRIBUTE CONST_QUAL BOOL_TYPE FLOAT_TYPE INT_TYPE UINT_TYPE
%token <lex> BREAK CONTINUE DO ELSE FOR IF DISCARD RETURN SWITCH CASE DEFAULT
%token <lex> BVEC2 BVEC3 BVEC4 IVEC2 IVEC3 IVEC4 VEC2 VEC3 VEC4 UVEC2 UVEC3 UVEC4
%token <lex> MATRIX2 MATRIX3 MATRIX4 IN_QUAL OUT_QUAL INOUT_QUAL UNIFORM BUFFER VARYING
%token <lex> MATRIX2x3 MATRIX3x2 MATRIX2x4 MATRIX4x2 MATRIX3x4 MATRIX4x3
%token <lex> SAMPLE CENTROID FLAT SMOOTH NOPERSPECTIVE PATCH
%token <lex> READONLY WRITEONLY COHERENT RESTRICT VOLATILE SHARED
%token <lex> STRUCT VOID_TYPE WHILE
%token <lex> SAMPLER2D SAMPLERCUBE SAMPLER_EXTERNAL_OES SAMPLER2DRECT SAMPLER2DARRAY
%token <lex> ISAMPLER2D ISAMPLER3D ISAMPLERCUBE ISAMPLER2DARRAY
%token <lex> USAMPLER2D USAMPLER3D USAMPLERCUBE USAMPLER2DARRAY
%token <lex> SAMPLER2DMS ISAMPLER2DMS USAMPLER2DMS
%token <lex> SAMPLER2DMSARRAY ISAMPLER2DMSARRAY USAMPLER2DMSARRAY
%token <lex> SAMPLER3D SAMPLER3DRECT SAMPLER2DSHADOW SAMPLERCUBESHADOW SAMPLER2DARRAYSHADOW SAMPLERVIDEOWEBGL
%token <lex> SAMPLERCUBEARRAYOES SAMPLERCUBEARRAYSHADOWOES ISAMPLERCUBEARRAYOES USAMPLERCUBEARRAYOES
%token <lex> SAMPLERCUBEARRAYEXT SAMPLERCUBEARRAYSHADOWEXT ISAMPLERCUBEARRAYEXT USAMPLERCUBEARRAYEXT
%token <lex> SAMPLERBUFFER ISAMPLERBUFFER USAMPLERBUFFER
%token <lex> SAMPLEREXTERNAL2DY2YEXT
%token <lex> IMAGE2D IIMAGE2D UIMAGE2D IMAGE3D IIMAGE3D UIMAGE3D IMAGE2DARRAY IIMAGE2DARRAY UIMAGE2DARRAY
%token <lex> IMAGECUBE IIMAGECUBE UIMAGECUBE
%token <lex> IMAGECUBEARRAYOES IIMAGECUBEARRAYOES UIMAGECUBEARRAYOES
%token <lex> IMAGECUBEARRAYEXT IIMAGECUBEARRAYEXT UIMAGECUBEARRAYEXT
%token <lex> IMAGEBUFFER IIMAGEBUFFER UIMAGEBUFFER
%token <lex> ATOMICUINT
%token <lex> PIXELLOCALANGLE IPIXELLOCALANGLE UPIXELLOCALANGLE
%token <lex> LAYOUT
%token <lex> YUVCSCSTANDARDEXT YUVCSCSTANDARDEXTCONSTANT

%token <lex> IDENTIFIER TYPE_NAME FLOATCONSTANT INTCONSTANT UINTCONSTANT BOOLCONSTANT
%token <lex> FIELD_SELECTION
%token <lex> LEFT_OP RIGHT_OP
%token <lex> INC_OP DEC_OP LE_OP GE_OP EQ_OP NE_OP
%token <lex> AND_OP OR_OP XOR_OP MUL_ASSIGN DIV_ASSIGN ADD_ASSIGN
%token <lex> MOD_ASSIGN LEFT_ASSIGN RIGHT_ASSIGN AND_ASSIGN XOR_ASSIGN OR_ASSIGN
%token <lex> SUB_ASSIGN

%token <lex> LEFT_PAREN RIGHT_PAREN LEFT_BRACKET RIGHT_BRACKET LEFT_BRACE RIGHT_BRACE DOT
%token <lex> COMMA COLON EQUAL SEMICOLON BANG DASH TILDE PLUS STAR SLASH PERCENT
%token <lex> LEFT_ANGLE RIGHT_ANGLE VERTICAL_BAR CARET AMPERSAND QUESTION

%type <lex> identifier
%type <interm.op> assignment_operator unary_operator
%type <interm.intermTypedNode> variable_identifier primary_expression postfix_expression
%type <interm.intermTypedNode> expression integer_expression assignment_expression
%type <interm.intermTypedNode> unary_expression multiplicative_expression additive_expression
%type <interm.intermTypedNode> relational_expression equality_expression
%type <interm.intermTypedNode> conditional_expression constant_expression
%type <interm.intermTypedNode> logical_or_expression logical_xor_expression logical_and_expression
%type <interm.intermTypedNode> shift_expression and_expression exclusive_or_expression inclusive_or_expression
%type <interm.intermTypedNode> function_call initializer

%type <interm.intermNode> condition conditionopt
%type <interm.intermBlock> translation_unit
%type <interm.intermNode> function_definition statement simple_statement
%type <interm.intermBlock> statement_list compound_statement_with_scope compound_statement_no_new_scope
%type <interm.intermNode> declaration_statement selection_statement expression_statement
%type <interm.intermNode> declaration external_declaration
%type <interm.intermNode> for_init_statement
%type <interm.nodePair> selection_rest_statement for_rest_statement
%type <interm.intermSwitch> switch_statement
%type <interm.intermCase> case_label
%type <interm.intermNode> iteration_statement jump_statement statement_no_new_scope statement_with_scope
%type <interm> single_declaration init_declarator_list

%type <interm.param> parameter_declaration parameter_declarator parameter_type_specifier
%type <interm.layoutQualifier> layout_qualifier_id_list layout_qualifier_id

// Note: array_specifier guaranteed to be non-null.
%type <interm.arraySizes> array_specifier

%type <interm.type> fully_specified_type type_specifier

%type <interm.precision> precision_qualifier
%type <interm.layoutQualifier> layout_qualifier
%type <interm.qualifier> interpolation_qualifier
%type <interm.qualifierWrapper> storage_qualifier single_type_qualifier invariant_qualifier precise_qualifier
%type <interm.typeQualifierBuilder> type_qualifier

%type <interm.typeSpecifierNonArray> type_specifier_nonarray struct_specifier
%type <interm.type> type_specifier_no_prec
%type <interm.declarator> struct_declarator
%type <interm.declaratorList> struct_declarator_list
%type <interm.fieldList> struct_declaration struct_declaration_list
%type <interm.function> function_header function_declarator
%type <interm.function> function_header_with_parameters
%type <interm.functionLookup> function_identifier function_call_header
%type <interm.functionLookup> function_call_header_with_parameters function_call_header_no_parameters
%type <interm.functionLookup> function_call_generic function_call_or_method
%type <interm> function_prototype

%type <lex> enter_struct

%start translation_unit
%%

identifier
    : IDENTIFIER
    | TYPE_NAME

variable_identifier
    : IDENTIFIER {
        // The symbol table search was done in the lexical phase
        $$ = context->parseVariableIdentifier(@1, ImmutableString($1.string), $1.symbol);
    }
    ;

primary_expression
    : variable_identifier {
        $$ = $1;
    }
    | INTCONSTANT {
        TConstantUnion *unionArray = new TConstantUnion[1];
        unionArray->setIConst($1.i);
        $$ = context->addScalarLiteral(unionArray, @1);
    }
    | UINTCONSTANT {
        TConstantUnion *unionArray = new TConstantUnion[1];
        unionArray->setUConst($1.u);
        $$ = context->addScalarLiteral(unionArray, @1);
    }
    | FLOATCONSTANT {
        TConstantUnion *unionArray = new TConstantUnion[1];
        unionArray->setFConst($1.f);
        $$ = context->addScalarLiteral(unionArray, @1);
    }
    | BOOLCONSTANT {
        TConstantUnion *unionArray = new TConstantUnion[1];
        unionArray->setBConst($1.b);
        $$ = context->addScalarLiteral(unionArray, @1);
    }
    | YUVCSCSTANDARDEXTCONSTANT {
        if (!context->checkCanUseExtension(@1, TExtension::EXT_YUV_target))
        {
           context->error(@1, "unsupported value", ImmutableString($1.string));
        }
        TConstantUnion *unionArray = new TConstantUnion[1];
        unionArray->setYuvCscStandardEXTConst(getYuvCscStandardEXT(ImmutableString($1.string)));
        $$ = context->addScalarLiteral(unionArray, @1);
    }
    | LEFT_PAREN expression RIGHT_PAREN {
        $$ = $2;
    }
    ;

postfix_expression
    : primary_expression {
        $$ = $1;
    }
    | postfix_expression LEFT_BRACKET integer_expression RIGHT_BRACKET {
        $$ = context->addIndexExpression($1, @2, $3);
    }
    | function_call {
        $$ = $1;
    }
    | postfix_expression DOT FIELD_SELECTION {
        $$ = context->addFieldSelectionExpression($1, @2, ImmutableString($3.string), @3);
    }
    | postfix_expression INC_OP {
        $$ = context->addUnaryMathLValue(EOpPostIncrement, $1, @2);
    }
    | postfix_expression DEC_OP {
        $$ = context->addUnaryMathLValue(EOpPostDecrement, $1, @2);
    }
    ;

integer_expression
    : expression {
        context->checkIsScalarInteger($1, "[]");
        $$ = $1;
    }
    ;

function_call
    : function_call_or_method {
        $$ = context->addFunctionCallOrMethod($1, @1);
    }
    ;

function_call_or_method
    : function_call_generic {
        $$ = $1;
    }
    | postfix_expression DOT function_call_generic {
        ES3_OR_NEWER("", @3, "methods");
        $$ = $3;
        $$->setThisNode($1);
    }
    ;

function_call_generic
    : function_call_header_with_parameters RIGHT_PAREN {
        $$ = $1;
    }
    | function_call_header_no_parameters RIGHT_PAREN {
        $$ = $1;
    }
    ;

function_call_header_no_parameters
    : function_call_header VOID_TYPE {
        $$ = $1;
    }
    | function_call_header {
        $$ = $1;
    }
    ;

function_call_header_with_parameters
    : function_call_header assignment_expression {
        $$ = $1;
        $$->addArgument($2);
    }
    | function_call_header_with_parameters COMMA assignment_expression {
        $$ = $1;
        $$->addArgument($3);
    }
    ;

function_call_header
    : function_identifier LEFT_PAREN {
        $$ = $1;
    }
    ;

// Grammar Note:  Constructors look like functions, but are recognized as types.

function_identifier
    : type_specifier_no_prec {
        $$ = context->addConstructorFunc($1);
    }
    | IDENTIFIER {
        $$ = context->addNonConstructorFunc(ImmutableString($1.string), $1.symbol);
    }
    | FIELD_SELECTION {
        $$ = context->addNonConstructorFunc(ImmutableString($1.string), $1.symbol);
    }
    ;

unary_expression
    : postfix_expression {
        $$ = $1;
    }
    | INC_OP unary_expression {
        $$ = context->addUnaryMathLValue(EOpPreIncrement, $2, @1);
    }
    | DEC_OP unary_expression {
        $$ = context->addUnaryMathLValue(EOpPreDecrement, $2, @1);
    }
    | unary_operator unary_expression {
        $$ = context->addUnaryMath($1, $2, @1);
    }
    ;
// Grammar Note:  No traditional style type casts.

unary_operator
    : PLUS  { $$ = EOpPositive; }
    | DASH  { $$ = EOpNegative; }
    | BANG  { $$ = EOpLogicalNot; }
    | TILDE {
        ES3_OR_NEWER("~", @$, "bit-wise operator");
        $$ = EOpBitwiseNot;
    }
    ;
// Grammar Note:  No '*' or '&' unary ops.  Pointers are not supported.

multiplicative_expression
    : unary_expression { $$ = $1; }
    | multiplicative_expression STAR unary_expression {
        $$ = context->addBinaryMath(EOpMul, $1, $3, @2);
    }
    | multiplicative_expression SLASH unary_expression {
        $$ = context->addBinaryMath(EOpDiv, $1, $3, @2);
    }
    | multiplicative_expression PERCENT unary_expression {
        ES3_OR_NEWER("%", @2, "integer modulus operator");
        $$ = context->addBinaryMath(EOpIMod, $1, $3, @2);
    }
    ;

additive_expression
    : multiplicative_expression { $$ = $1; }
    | additive_expression PLUS multiplicative_expression {
        $$ = context->addBinaryMath(EOpAdd, $1, $3, @2);
    }
    | additive_expression DASH multiplicative_expression {
        $$ = context->addBinaryMath(EOpSub, $1, $3, @2);
    }
    ;

shift_expression
    : additive_expression { $$ = $1; }
    | shift_expression LEFT_OP additive_expression {
        ES3_OR_NEWER("<<", @2, "bit-wise operator");
        $$ = context->addBinaryMath(EOpBitShiftLeft, $1, $3, @2);
    }
    | shift_expression RIGHT_OP additive_expression {
        ES3_OR_NEWER(">>", @2, "bit-wise operator");
        $$ = context->addBinaryMath(EOpBitShiftRight, $1, $3, @2);
    }
    ;

relational_expression
    : shift_expression { $$ = $1; }
    | relational_expression LEFT_ANGLE shift_expression {
        $$ = context->addBinaryMathBooleanResult(EOpLessThan, $1, $3, @2);
    }
    | relational_expression RIGHT_ANGLE shift_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpGreaterThan, $1, $3, @2);
    }
    | relational_expression LE_OP shift_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpLessThanEqual, $1, $3, @2);
    }
    | relational_expression GE_OP shift_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpGreaterThanEqual, $1, $3, @2);
    }
    ;

equality_expression
    : relational_expression { $$ = $1; }
    | equality_expression EQ_OP relational_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpEqual, $1, $3, @2);
    }
    | equality_expression NE_OP relational_expression {
        $$ = context->addBinaryMathBooleanResult(EOpNotEqual, $1, $3, @2);
    }
    ;

and_expression
    : equality_expression { $$ = $1; }
    | and_expression AMPERSAND equality_expression {
        ES3_OR_NEWER("&", @2, "bit-wise operator");
        $$ = context->addBinaryMath(EOpBitwiseAnd, $1, $3, @2);
    }
    ;

exclusive_or_expression
    : and_expression { $$ = $1; }
    | exclusive_or_expression CARET and_expression {
        ES3_OR_NEWER("^", @2, "bit-wise operator");
        $$ = context->addBinaryMath(EOpBitwiseXor, $1, $3, @2);
    }
    ;

inclusive_or_expression
    : exclusive_or_expression { $$ = $1; }
    | inclusive_or_expression VERTICAL_BAR exclusive_or_expression {
        ES3_OR_NEWER("|", @2, "bit-wise operator");
        $$ = context->addBinaryMath(EOpBitwiseOr, $1, $3, @2);
    }
    ;

logical_and_expression
    : inclusive_or_expression { $$ = $1; }
    | logical_and_expression AND_OP inclusive_or_expression {
        $$ = context->addBinaryMathBooleanResult(EOpLogicalAnd, $1, $3, @2);
    }
    ;

logical_xor_expression
    : logical_and_expression { $$ = $1; }
    | logical_xor_expression XOR_OP logical_and_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpLogicalXor, $1, $3, @2);
    }
    ;

logical_or_expression
    : logical_xor_expression { $$ = $1; }
    | logical_or_expression OR_OP logical_xor_expression  {
        $$ = context->addBinaryMathBooleanResult(EOpLogicalOr, $1, $3, @2);
    }
    ;

conditional_expression
    : logical_or_expression { $$ = $1; }
    | logical_or_expression QUESTION expression COLON assignment_expression {
        $$ = context->addTernarySelection($1, $3, $5, @2);
    }
    ;

assignment_expression
    : conditional_expression { $$ = $1; }
    | unary_expression assignment_operator assignment_expression {
        $$ = context->addAssign($2, $1, $3, @2);
    }
    ;

assignment_operator
    : EQUAL        { $$ = EOpAssign; }
    | MUL_ASSIGN   { $$ = EOpMulAssign; }
    | DIV_ASSIGN   { $$ = EOpDivAssign; }
    | MOD_ASSIGN   {
        ES3_OR_NEWER("%=", @$, "integer modulus operator");
        $$ = EOpIModAssign;
    }
    | ADD_ASSIGN   { $$ = EOpAddAssign; }
    | SUB_ASSIGN   { $$ = EOpSubAssign; }
    | LEFT_ASSIGN {
        ES3_OR_NEWER("<<=", @$, "bit-wise operator");
        $$ = EOpBitShiftLeftAssign;
    }
    | RIGHT_ASSIGN {
        ES3_OR_NEWER(">>=", @$, "bit-wise operator");
        $$ = EOpBitShiftRightAssign;
    }
    | AND_ASSIGN {
        ES3_OR_NEWER("&=", @$, "bit-wise operator");
        $$ = EOpBitwiseAndAssign;
    }
    | XOR_ASSIGN {
        ES3_OR_NEWER("^=", @$, "bit-wise operator");
        $$ = EOpBitwiseXorAssign;
    }
    | OR_ASSIGN {
        ES3_OR_NEWER("|=", @$, "bit-wise operator");
        $$ = EOpBitwiseOrAssign;
    }
    ;

expression
    : assignment_expression {
        $$ = $1;
    }
    | expression COMMA assignment_expression {
        $$ = context->addComma($1, $3, @2);
    }
    ;

constant_expression
    : conditional_expression {
        context->checkIsConst($1);
        $$ = $1;
    }
    ;

enter_struct
    : IDENTIFIER LEFT_BRACE {
        context->enterStructDeclaration(@1, ImmutableString($1.string));
        $$ = $1;
    }
    ;

declaration
    : function_prototype SEMICOLON {
        $$ = context->addFunctionPrototypeDeclaration(*($1.function), @1);
    }
    | init_declarator_list SEMICOLON {
        $$ = $1.intermDeclaration;
    }
    | PRECISION precision_qualifier type_specifier_no_prec SEMICOLON {
        context->parseDefaultPrecisionQualifier($2, $3, @1);
        $$ = nullptr;
    }
    | type_qualifier enter_struct struct_declaration_list RIGHT_BRACE SEMICOLON {
        ES3_OR_NEWER(ImmutableString($2.string), @1, "interface blocks");
        $$ = context->addInterfaceBlock(*$1, @2, ImmutableString($2.string), $3, kEmptyImmutableString, @$, NULL, @$);
    }
    | type_qualifier enter_struct struct_declaration_list RIGHT_BRACE IDENTIFIER SEMICOLON {
        ES3_OR_NEWER(ImmutableString($2.string), @1, "interface blocks");
        $$ = context->addInterfaceBlock(*$1, @2, ImmutableString($2.string), $3, ImmutableString($5.string), @5, NULL, @$);
    }
    | type_qualifier enter_struct struct_declaration_list RIGHT_BRACE IDENTIFIER array_specifier SEMICOLON {
        ES3_OR_NEWER(ImmutableString($2.string), @1, "interface blocks");
        $$ = context->addInterfaceBlock(*$1, @2, ImmutableString($2.string), $3, ImmutableString($5.string), @5, $6, @6);
    }
    | type_qualifier SEMICOLON {
        context->parseGlobalLayoutQualifier(*$1);
        $$ = nullptr;
    }
    | type_qualifier IDENTIFIER SEMICOLON // e.g. to qualify an existing variable as invariant or precise
    {
        $$ = context->parseGlobalQualifierDeclaration(*$1, @2, ImmutableString($2.string), $2.symbol);
    }
    ;

function_prototype
    : function_declarator RIGHT_PAREN  {
        $$.function = context->parseFunctionDeclarator(@2, $1);
        context->exitFunctionDeclaration();
    }
    ;

function_declarator
    : function_header {
        $$ = $1;
    }
    | function_header_with_parameters {
        $$ = $1;
    }
    ;


function_header_with_parameters
    : function_header parameter_declaration {
        // Add the parameter
        $$ = $1;
        if ($2.type->getBasicType() != EbtVoid)
        {
            $1->addParameter($2.createVariable(&context->symbolTable));
        }
        else
        {
            // Remember that void was seen, so error can be generated if another parameter is seen.
            $1->setHasVoidParameter();
        }
    }
    | function_header_with_parameters COMMA parameter_declaration {
        $$ = $1;
        // Only first parameter of one-parameter functions can be void
        // The check for named parameters not being void is done in parameter_declarator
        if ($3.type->getBasicType() == EbtVoid)
        {
            // This parameter > first is void
            context->error(@2, "cannot be a parameter type except for '(void)'", "void");
        }
        else
        {
            if ($1->hasVoidParameter())
            {
                // Only first parameter of one-parameter functions can be void.  This check prevents
                // (void, non_void) parameters.
                context->error(@2, "cannot be a parameter type except for '(void)'", "void");
            }
            $1->addParameter($3.createVariable(&context->symbolTable));
        }
    }
    ;

function_header
    : fully_specified_type IDENTIFIER LEFT_PAREN {
        $$ = context->parseFunctionHeader($1, ImmutableString($2.string), @2);

        context->symbolTable.push();
        context->enterFunctionDeclaration();
    }
    ;

parameter_declarator
    // Type + name
    : type_specifier identifier {
        $$ = context->parseParameterDeclarator($1, ImmutableString($2.string), @2);
    }
    | type_specifier identifier array_specifier {
        $$ = context->parseParameterArrayDeclarator(ImmutableString($2.string), @2, *($3), @3, &$1);
    }
    ;

parameter_declaration
    : type_qualifier parameter_declarator {
        $$ = $2;
        context->checkIsParameterQualifierValid(@2, *$1, $2.type);
    }
    | parameter_declarator {
        $$ = $1;
        $$.type->setQualifier(EvqParamIn);
    }
    | type_qualifier parameter_type_specifier {
        $$ = $2;
        context->checkIsParameterQualifierValid(@2, *$1, $2.type);
    }
    | parameter_type_specifier {
        $$ = $1;
        $$.type->setQualifier(EvqParamIn);
    }
    ;

parameter_type_specifier
    : type_specifier {
        TParameter param = { 0, new TType($1) };
        $$ = param;
    }
    ;

init_declarator_list
    : single_declaration {
        $$ = $1;
    }
    | init_declarator_list COMMA identifier {
        $$ = $1;
        context->parseDeclarator($$.type, @3, ImmutableString($3.string), $$.intermDeclaration);
    }
    | init_declarator_list COMMA identifier array_specifier {
        $$ = $1;
        context->parseArrayDeclarator($$.type, @3, ImmutableString($3.string), @4, *($4), $$.intermDeclaration);
    }
    | init_declarator_list COMMA identifier array_specifier EQUAL initializer {
        ES3_OR_NEWER("=", @5, "first-class arrays (array initializer)");
        $$ = $1;
        context->parseArrayInitDeclarator($$.type, @3, ImmutableString($3.string), @4, *($4), @5, $6, $$.intermDeclaration);
    }
    | init_declarator_list COMMA identifier EQUAL initializer {
        $$ = $1;
        context->parseInitDeclarator($$.type, @3, ImmutableString($3.string), @4, $5, $$.intermDeclaration);
    }
    ;

single_declaration
    : fully_specified_type {
        $$.type = $1;
        $$.intermDeclaration = context->parseSingleDeclaration($$.type, @1, kEmptyImmutableString);
    }
    | fully_specified_type identifier {
        $$.type = $1;
        $$.intermDeclaration = context->parseSingleDeclaration($$.type, @2, ImmutableString($2.string));
    }
    | fully_specified_type identifier array_specifier {
        $$.type = $1;
        $$.intermDeclaration = context->parseSingleArrayDeclaration($$.type, @2, ImmutableString($2.string), @3, *($3));
    }
    | fully_specified_type identifier array_specifier EQUAL initializer {
        ES3_OR_NEWER("[]", @3, "first-class arrays (array initializer)");
        $$.type = $1;
        $$.intermDeclaration = context->parseSingleArrayInitDeclaration($$.type, @2, ImmutableString($2.string), @3, *($3), @4, $5);
    }
    | fully_specified_type identifier EQUAL initializer {
        $$.type = $1;
        $$.intermDeclaration = context->parseSingleInitDeclaration($$.type, @2, ImmutableString($2.string), @3, $4);
    }
    ;

fully_specified_type
    : type_specifier {
        context->addFullySpecifiedType(&$1);
        $$ = $1;
    }
    | type_qualifier type_specifier {
        $$ = context->addFullySpecifiedType(*$1, $2);
    }
    ;

interpolation_qualifier
    : SMOOTH {
        $$ = EvqSmooth;
    }
    | FLAT {
        $$ = EvqFlat;
    }
    | NOPERSPECTIVE {
        if (!context->checkCanUseExtension(@1, TExtension::NV_shader_noperspective_interpolation))
        {
            context->error(@1, "unsupported interpolation qualifier", "noperspective");
        }
        $$ = EvqNoPerspective;
    }
    ;

type_qualifier
    : single_type_qualifier {
        $$ = context->createTypeQualifierBuilder(@1);
        $$->appendQualifier($1);
    }
    | type_qualifier single_type_qualifier {
        $$ = $1;
        $$->appendQualifier($2);
    }
    ;

invariant_qualifier
    : INVARIANT {
        // empty
    }
    ;

precise_qualifier
    : PRECISE {
        context->markShaderHasPrecise();
    }
    ;

single_type_qualifier
    : storage_qualifier {
        context->checkLocalVariableConstStorageQualifier(*$1);
        $$ = $1;
    }
    | layout_qualifier {
        context->checkIsAtGlobalLevel(@1, "layout");
        $$ = new TLayoutQualifierWrapper($1, @1);
    }
    | precision_qualifier {
        $$ = new TPrecisionQualifierWrapper($1, @1);
    }
    | interpolation_qualifier {
        $$ = new TInterpolationQualifierWrapper($1, @1);
    }
    | invariant_qualifier {
        context->checkIsAtGlobalLevel(@1, "invariant");
        $$ = new TInvariantQualifierWrapper(@1);
    }
    | precise_qualifier {
        $$ = new TPreciseQualifierWrapper(@1);
    }
    ;


storage_qualifier
    :
    ATTRIBUTE {
        VERTEX_ONLY("attribute", @1);
        ES2_ONLY("attribute", @1);
        $$ = context->parseGlobalStorageQualifier(EvqAttribute, @1);
    }
    | VARYING {
        ES2_ONLY("varying", @1);
        $$ = context->parseVaryingQualifier(@1);
    }
    | CONST_QUAL {
        $$ = new TStorageQualifierWrapper(EvqConst, @1);
    }
    | IN_QUAL {
        $$ = context->parseInQualifier(@1);
    }
    | OUT_QUAL {
        $$ = context->parseOutQualifier(@1);
    }
    | INOUT_QUAL {
        $$ = context->parseInOutQualifier(@1);
    }
    | CENTROID {
        ES3_OR_NEWER("centroid", @1, "storage qualifier");
        $$ = new TStorageQualifierWrapper(EvqCentroid, @1);
    }
    | PATCH {
        if (context->getShaderVersion() < 320 &&
            !context->checkCanUseExtension(@1, TExtension::EXT_tessellation_shader))
        {
            context->error(@1, "unsupported storage qualifier", "patch");
        }
        $$ = new TStorageQualifierWrapper(EvqPatch, @1);
    }
    | UNIFORM {
        $$ = context->parseGlobalStorageQualifier(EvqUniform, @1);
    }
    | BUFFER {
        ES3_1_OR_NEWER("buffer", @1, "storage qualifier");
        $$ = context->parseGlobalStorageQualifier(EvqBuffer, @1);
    }
    | READONLY {
        $$ = new TMemoryQualifierWrapper(EvqReadOnly, @1);
    }
    | WRITEONLY {
        $$ = new TMemoryQualifierWrapper(EvqWriteOnly, @1);
    }
    | COHERENT {
        $$ = new TMemoryQualifierWrapper(EvqCoherent, @1);
    }
    | RESTRICT {
        $$ = new TMemoryQualifierWrapper(EvqRestrict, @1);
    }
    | VOLATILE {
        $$ = new TMemoryQualifierWrapper(EvqVolatile, @1);
    }
    | SHARED {
        COMPUTE_ONLY("shared", @1);
        $$ = context->parseGlobalStorageQualifier(EvqShared, @1);
    }
    | SAMPLE {
        ES3_OR_NEWER("sample", @1, "storage qualifier");
        $$ = new TStorageQualifierWrapper(EvqSample, @1);
    }
    ;

type_specifier
    : type_specifier_no_prec {
        $$ = $1;
        $$.precision = context->symbolTable.getDefaultPrecision($1.getBasicType());
    }
    ;

precision_qualifier
    : HIGH_PRECISION {
        $$ = EbpHigh;
    }
    | MEDIUM_PRECISION {
        $$ = EbpMedium;
    }
    | LOW_PRECISION  {
        $$ = EbpLow;
    }
    ;

layout_qualifier
    : LAYOUT LEFT_PAREN layout_qualifier_id_list RIGHT_PAREN {
        context->checkCanUseLayoutQualifier(@1);
        $$ = $3;
    }
    ;

layout_qualifier_id_list
    : layout_qualifier_id {
        $$ = $1;
    }
    | layout_qualifier_id_list COMMA layout_qualifier_id {
        $$ = context->joinLayoutQualifiers($1, $3, @3);
    }
    ;

layout_qualifier_id
    : IDENTIFIER {
        $$ = context->parseLayoutQualifier(ImmutableString($1.string), @1);
    }
    | IDENTIFIER EQUAL INTCONSTANT {
        $$ = context->parseLayoutQualifier(ImmutableString($1.string), @1, $3.i, @3);
    }
    | IDENTIFIER EQUAL UINTCONSTANT {
        $$ = context->parseLayoutQualifier(ImmutableString($1.string), @1, $3.i, @3);
    }
    | SHARED {
        $$ = context->parseLayoutQualifier(ImmutableString("shared"), @1);
    }
    ;

type_specifier_no_prec
    : type_specifier_nonarray {
        $$.initialize($1, (context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary));
    }
    | type_specifier_nonarray array_specifier {
        $$.initialize($1, (context->symbolTable.atGlobalLevel() ? EvqGlobal : EvqTemporary));
        $$.setArraySizes($2);
    }
    ;

array_specifier
    : LEFT_BRACKET RIGHT_BRACKET {
        ES3_OR_NEWER("[]", @1, "implicitly sized array");
        $$ = new TVector<unsigned int>();
        $$->push_back(0u);
    }
    | LEFT_BRACKET constant_expression RIGHT_BRACKET {
        $$ = new TVector<unsigned int>();
        unsigned int size = context->checkIsValidArraySize(@1, $2);
        // Make the type an array even if size check failed.
        // This ensures useless error messages regarding a variable's non-arrayness won't follow.
        $$->push_back(size);
    }
    | array_specifier LEFT_BRACKET RIGHT_BRACKET {
        ES3_1_OR_NEWER("[]", @2, "arrays of arrays");
        $$ = $1;
        $$->insert($$->begin(), 0u);
    }
    | array_specifier LEFT_BRACKET constant_expression RIGHT_BRACKET {
        ES3_1_OR_NEWER("[]", @2, "arrays of arrays");
        $$ = $1;
        unsigned int size = context->checkIsValidArraySize(@2, $3);
        // Make the type an array even if size check failed.
        // This ensures useless error messages regarding a variable's non-arrayness won't follow.
        $$->insert($$->begin(), size);
    }
    ;

type_specifier_nonarray
    : VOID_TYPE {
        $$.initialize(EbtVoid, @1);
    }
    | FLOAT_TYPE {
        $$.initialize(EbtFloat, @1);
    }
    | INT_TYPE {
        $$.initialize(EbtInt, @1);
    }
    | UINT_TYPE {
        $$.initialize(EbtUInt, @1);
    }
    | BOOL_TYPE {
        $$.initialize(EbtBool, @1);
    }
    | VEC2 {
        $$.initialize(EbtFloat, @1);
        $$.setAggregate(2);
    }
    | VEC3 {
        $$.initialize(EbtFloat, @1);
        $$.setAggregate(3);
    }
    | VEC4 {
        $$.initialize(EbtFloat, @1);
        $$.setAggregate(4);
    }
    | BVEC2 {
        $$.initialize(EbtBool, @1);
        $$.setAggregate(2);
    }
    | BVEC3 {
        $$.initialize(EbtBool, @1);
        $$.setAggregate(3);
    }
    | BVEC4 {
        $$.initialize(EbtBool, @1);
        $$.setAggregate(4);
    }
    | IVEC2 {
        $$.initialize(EbtInt, @1);
        $$.setAggregate(2);
    }
    | IVEC3 {
        $$.initialize(EbtInt, @1);
        $$.setAggregate(3);
    }
    | IVEC4 {
        $$.initialize(EbtInt, @1);
        $$.setAggregate(4);
    }
    | UVEC2 {
        $$.initialize(EbtUInt, @1);
        $$.setAggregate(2);
    }
    | UVEC3 {
        $$.initialize(EbtUInt, @1);
        $$.setAggregate(3);
    }
    | UVEC4 {
        $$.initialize(EbtUInt, @1);
        $$.setAggregate(4);
    }
    | MATRIX2 {
        $$.initialize(EbtFloat, @1);
        $$.setMatrix(2, 2);
    }
    | MATRIX3 {
        $$.initialize(EbtFloat, @1);
        $$.setMatrix(3, 3);
    }
    | MATRIX4 {
        $$.initialize(EbtFloat, @1);
        $$.setMatrix(4, 4);
    }
    | MATRIX2x3 {
        $$.initialize(EbtFloat, @1);
        $$.setMatrix(2, 3);
    }
    | MATRIX3x2 {
        $$.initialize(EbtFloat, @1);
        $$.setMatrix(3, 2);
    }
    | MATRIX2x4 {
        $$.initialize(EbtFloat, @1);
        $$.setMatrix(2, 4);
    }
    | MATRIX4x2 {
        $$.initialize(EbtFloat, @1);
        $$.setMatrix(4, 2);
    }
    | MATRIX3x4 {
        $$.initialize(EbtFloat, @1);
        $$.setMatrix(3, 4);
    }
    | MATRIX4x3 {
        $$.initialize(EbtFloat, @1);
        $$.setMatrix(4, 3);
    }
    | YUVCSCSTANDARDEXT {
        if (!context->checkCanUseExtension(@1, TExtension::EXT_YUV_target))
        {
            context->error(@1, "unsupported type", "yuvCscStandardEXT");
        }
        $$.initialize(EbtYuvCscStandardEXT, @1);
    }
    | SAMPLER2D {
        $$.initialize(EbtSampler2D, @1);
    }
    | SAMPLER3D {
        $$.initialize(EbtSampler3D, @1);
    }
    | SAMPLERCUBE {
        $$.initialize(EbtSamplerCube, @1);
    }
    | SAMPLER2DARRAY {
        $$.initialize(EbtSampler2DArray, @1);
    }
    | SAMPLER2DMS {
        $$.initialize(EbtSampler2DMS, @1);
    }
    | SAMPLER2DMSARRAY {
        $$.initialize(EbtSampler2DMSArray, @1);
    }
    | SAMPLERCUBEARRAYOES {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::OES_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__samplerCubeArray");
        }
        $$.initialize(EbtSamplerCubeArray, @1);
    }
    | SAMPLERCUBEARRAYEXT {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::EXT_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__samplerCubeArray");
        }
        $$.initialize(EbtSamplerCubeArray, @1);
    }
    | SAMPLERBUFFER {
        constexpr std::array<TExtension, 2u> extensions{ { TExtension::OES_texture_buffer,
                                                           TExtension::EXT_texture_buffer } };
        if (context->getShaderVersion() < 320
        && !context->checkCanUseOneOfExtensions(@1, extensions))
        {
            context->error(@1, "unsupported type", "__samplerBuffer");
        }
        $$.initialize(EbtSamplerBuffer, @1);
    }
    | ISAMPLER2D {
        $$.initialize(EbtISampler2D, @1);
    }
    | ISAMPLER3D {
        $$.initialize(EbtISampler3D, @1);
    }
    | ISAMPLERCUBE {
        $$.initialize(EbtISamplerCube, @1);
    }
    | ISAMPLER2DARRAY {
        $$.initialize(EbtISampler2DArray, @1);
    }
    | ISAMPLER2DMS {
        $$.initialize(EbtISampler2DMS, @1);
    }
    | ISAMPLER2DMSARRAY {
        $$.initialize(EbtISampler2DMSArray, @1);
    }
    | ISAMPLERCUBEARRAYOES {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::OES_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__isamplerCubeArray");
        }
        $$.initialize(EbtISamplerCubeArray, @1);
    }
    | ISAMPLERCUBEARRAYEXT {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::EXT_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__isamplerCubeArray");
        }
        $$.initialize(EbtISamplerCubeArray, @1);
    }
    | ISAMPLERBUFFER {
        constexpr std::array<TExtension, 2u> extensions{ { TExtension::OES_texture_buffer,
                                                           TExtension::EXT_texture_buffer } };
        if (context->getShaderVersion() < 320
        && !context->checkCanUseOneOfExtensions(@1, extensions))
        {
            context->error(@1, "unsupported type", "__isamplerBuffer");
        }
        $$.initialize(EbtISamplerBuffer, @1);
    }
    | USAMPLER2D {
        $$.initialize(EbtUSampler2D, @1);
    }
    | USAMPLER3D {
        $$.initialize(EbtUSampler3D, @1);
    }
    | USAMPLERCUBE {
        $$.initialize(EbtUSamplerCube, @1);
    }
    | USAMPLER2DARRAY {
        $$.initialize(EbtUSampler2DArray, @1);
    }
    | USAMPLER2DMS {
        $$.initialize(EbtUSampler2DMS, @1);
    }
    | USAMPLER2DMSARRAY {
        $$.initialize(EbtUSampler2DMSArray, @1);
    }
    | USAMPLERCUBEARRAYOES {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::OES_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__usamplerCubeArray");
        }
        $$.initialize(EbtUSamplerCubeArray, @1);
    }
    | USAMPLERCUBEARRAYEXT {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::EXT_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__usamplerCubeArray");
        }
        $$.initialize(EbtUSamplerCubeArray, @1);
    }
    | USAMPLERBUFFER {
        constexpr std::array<TExtension, 2u> extensions{ { TExtension::OES_texture_buffer,
                                                           TExtension::EXT_texture_buffer } };
        if (context->getShaderVersion() < 320
        && !context->checkCanUseOneOfExtensions(@1, extensions))
        {
            context->error(@1, "unsupported type", "__usamplerBuffer");
        }
        $$.initialize(EbtUSamplerBuffer, @1);
    }
    | SAMPLER2DSHADOW {
        $$.initialize(EbtSampler2DShadow, @1);
    }
    | SAMPLERCUBESHADOW {
        $$.initialize(EbtSamplerCubeShadow, @1);
    }
    | SAMPLER2DARRAYSHADOW {
        $$.initialize(EbtSampler2DArrayShadow, @1);
    }
    | SAMPLERCUBEARRAYSHADOWOES {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::OES_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__samplerCubeArrayShadow");
        }
        $$.initialize(EbtSamplerCubeArrayShadow, @1);
    }
    | SAMPLERCUBEARRAYSHADOWEXT {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::EXT_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__samplerCubeArrayShadow");
        }
        $$.initialize(EbtSamplerCubeArrayShadow, @1);
    }
    | SAMPLERVIDEOWEBGL {
        if (!context->checkCanUseExtension(@1, TExtension::WEBGL_video_texture))
        {
            context->error(@1, "unsupported type", "samplerVideoWEBGL");
        }
        $$.initialize(EbtSamplerVideoWEBGL, @1);
    }
    | SAMPLER_EXTERNAL_OES {
        constexpr std::array<TExtension, 3u> extensions{ { TExtension::NV_EGL_stream_consumer_external,
                                                           TExtension::OES_EGL_image_external_essl3,
                                                           TExtension::OES_EGL_image_external } };
        if (!context->checkCanUseOneOfExtensions(@1, extensions))
        {
            context->error(@1, "unsupported type", "samplerExternalOES");
        }
        $$.initialize(EbtSamplerExternalOES, @1);
    }
    | SAMPLEREXTERNAL2DY2YEXT {
        if (!context->checkCanUseExtension(@1, TExtension::EXT_YUV_target))
        {
            context->error(@1, "unsupported type", "__samplerExternal2DY2YEXT");
        }
        $$.initialize(EbtSamplerExternal2DY2YEXT, @1);
    }
    | SAMPLER2DRECT {
        if (!context->checkCanUseExtension(@1, TExtension::ARB_texture_rectangle))
        {
            context->error(@1, "unsupported type", "sampler2DRect");
        }
        $$.initialize(EbtSampler2DRect, @1);
    }
    | IMAGE2D {
        $$.initialize(EbtImage2D, @1);
    }
    | IIMAGE2D {
        $$.initialize(EbtIImage2D, @1);
    }
    | UIMAGE2D {
        $$.initialize(EbtUImage2D, @1);
    }
    | IMAGE3D {
        $$.initialize(EbtImage3D, @1);
    }
    | IIMAGE3D {
        $$.initialize(EbtIImage3D, @1);
    }
    | UIMAGE3D {
        $$.initialize(EbtUImage3D, @1);
    }
    | IMAGE2DARRAY {
        $$.initialize(EbtImage2DArray, @1);
    }
    | IIMAGE2DARRAY {
        $$.initialize(EbtIImage2DArray, @1);
    }
    | UIMAGE2DARRAY {
        $$.initialize(EbtUImage2DArray, @1);
    }
    | IMAGECUBE {
        $$.initialize(EbtImageCube, @1);
    }
    | IIMAGECUBE {
        $$.initialize(EbtIImageCube, @1);
    }
    | UIMAGECUBE {
        $$.initialize(EbtUImageCube, @1);
    }
    | IMAGECUBEARRAYOES {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::OES_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__imageCubeArray");
        }
        $$.initialize(EbtImageCubeArray, @1);
    }
    | IMAGECUBEARRAYEXT {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::EXT_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__imageCubeArray");
        }
        $$.initialize(EbtImageCubeArray, @1);
    }
    | IIMAGECUBEARRAYOES {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::OES_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__iimageCubeArray");
        }
        $$.initialize(EbtIImageCubeArray, @1);
    }
    | IIMAGECUBEARRAYEXT {
        if (context->getShaderVersion() < 320
        && !context->checkCanUseExtension(@1, TExtension::EXT_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__iimageCubeArray");
        }
        $$.initialize(EbtIImageCubeArray, @1);
    }
    | UIMAGECUBEARRAYOES {
       if (context->getShaderVersion() < 320
       && !context->checkCanUseExtension(@1, TExtension::OES_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__uimageCubeArray");
        }
        $$.initialize(EbtUImageCubeArray, @1);
    }
    | UIMAGECUBEARRAYEXT {
       if (context->getShaderVersion() < 320
       && !context->checkCanUseExtension(@1, TExtension::EXT_texture_cube_map_array))
        {
            context->error(@1, "unsupported type", "__uimageCubeArray");
        }
        $$.initialize(EbtUImageCubeArray, @1);
    }
    | IMAGEBUFFER {
        constexpr std::array<TExtension, 2u> extensions{ { TExtension::OES_texture_buffer,
                                                           TExtension::EXT_texture_buffer } };
        if (context->getShaderVersion() < 320
        && !context->checkCanUseOneOfExtensions(@1, extensions))
        {
            context->error(@1, "unsupported type", "__imageBuffer");
        }
        $$.initialize(EbtImageBuffer, @1);
    }
    | IIMAGEBUFFER {
        constexpr std::array<TExtension, 2u> extensions{ { TExtension::OES_texture_buffer,
                                                           TExtension::EXT_texture_buffer } };
        if (context->getShaderVersion() < 320
        && !context->checkCanUseOneOfExtensions(@1, extensions))
        {
            context->error(@1, "unsupported type", "__iimageBuffer");
        }
        $$.initialize(EbtIImageBuffer, @1);
    }
    | UIMAGEBUFFER {
        constexpr std::array<TExtension, 2u> extensions{ { TExtension::OES_texture_buffer,
                                                           TExtension::EXT_texture_buffer } };
        if (context->getShaderVersion() < 320
        && !context->checkCanUseOneOfExtensions(@1, extensions))
        {
            context->error(@1, "unsupported type", "__uimageBuffer");
        }
        $$.initialize(EbtUImageBuffer, @1);
    }
    | ATOMICUINT {
        $$.initialize(EbtAtomicCounter, @1);
    }
    | PIXELLOCALANGLE {
        if (!context->checkCanUseExtension(@1, TExtension::ANGLE_shader_pixel_local_storage))
        {
            context->error(@1, "unsupported type", "__pixelLocalANGLE");
        }
        $$.initialize(EbtPixelLocalANGLE, @1);
    }
    | IPIXELLOCALANGLE {
        if (!context->checkCanUseExtension(@1, TExtension::ANGLE_shader_pixel_local_storage))
        {
            context->error(@1, "unsupported type", "__ipixelLocalANGLE");
        }
        $$.initialize(EbtIPixelLocalANGLE, @1);
    }
    | UPIXELLOCALANGLE {
        if (!context->checkCanUseExtension(@1, TExtension::ANGLE_shader_pixel_local_storage))
        {
            context->error(@1, "unsupported type", "__upixelLocalANGLE");
        }
        $$.initialize(EbtUPixelLocalANGLE, @1);
    }
    | struct_specifier {
        $$ = $1;
    }
    | TYPE_NAME {
        // This is for user defined type names. The lexical phase looked up the type.
        const TStructure *structure = static_cast<const TStructure*>($1.symbol);
        $$.initializeStruct(structure, false, @1);
    }
    ;

struct_specifier
    : STRUCT identifier LEFT_BRACE { context->enterStructDeclaration(@2, ImmutableString($2.string)); } struct_declaration_list RIGHT_BRACE {
        $$ = context->addStructure(@1, @2, ImmutableString($2.string), $5);
    }
    | STRUCT LEFT_BRACE { context->enterStructDeclaration(@2, kEmptyImmutableString); } struct_declaration_list RIGHT_BRACE {
        $$ = context->addStructure(@1, @$, kEmptyImmutableString, $4);
    }
    ;

struct_declaration_list
    : struct_declaration {
        $$ = context->addStructFieldList($1, @1);
    }
    | struct_declaration_list struct_declaration {
        $$ = context->combineStructFieldLists($1, $2, @2);
    }
    ;

struct_declaration
    : type_specifier struct_declarator_list SEMICOLON {
        $$ = context->addStructDeclaratorList($1, $2);
    }
    | type_qualifier type_specifier struct_declarator_list SEMICOLON {
        // ES3 Only, but errors should be handled elsewhere
        $$ = context->addStructDeclaratorListWithQualifiers(*$1, &$2, $3);
    }
    ;

struct_declarator_list
    : struct_declarator {
        $$ = new TDeclaratorList();
        $$->push_back($1);
    }
    | struct_declarator_list COMMA struct_declarator {
        $$->push_back($3);
    }
    ;

struct_declarator
    : identifier {
        $$ = context->parseStructDeclarator(ImmutableString($1.string), @1);
    }
    | identifier array_specifier {
        $$ = context->parseStructArrayDeclarator(ImmutableString($1.string), @1, $2);
    }
    ;

initializer
    : assignment_expression { $$ = $1; }
    ;

declaration_statement
    : declaration { $$ = $1; }
    ;

statement
    : compound_statement_with_scope { $$ = $1; }
    | simple_statement              { $$ = $1; }
    ;

// Grammar Note:  Labeled statements for SWITCH only; 'goto' is not supported.

simple_statement
    : declaration_statement { $$ = $1; }
    | expression_statement  { $$ = $1; }
    | selection_statement   { $$ = $1; }
    | switch_statement      { $$ = $1; }
    | case_label            { $$ = $1; }
    | iteration_statement   { $$ = $1; }
    | jump_statement        { $$ = $1; }
    ;

compound_statement_with_scope
    : LEFT_BRACE RIGHT_BRACE {
        $$ = new TIntermBlock();
        $$->setLine(@$);
    }
    | LEFT_BRACE { context->symbolTable.push(); } statement_list { context->symbolTable.pop(); } RIGHT_BRACE {
        $3->setLine(@$);
        $$ = $3;
    }
    ;

statement_no_new_scope
    : compound_statement_no_new_scope { $$ = $1; }
    | simple_statement                { $$ = $1; }
    ;

statement_with_scope
    : { context->symbolTable.push(); } compound_statement_no_new_scope { context->symbolTable.pop(); $$ = $2; }
    | { context->symbolTable.push(); } simple_statement                { context->symbolTable.pop(); $$ = $2; }
    ;

compound_statement_no_new_scope
    // Statement that doesn't create a new scope for iteration_statement, function definition (scope is created for parameters)
    : LEFT_BRACE RIGHT_BRACE {
        $$ = new TIntermBlock();
        $$->setLine(@$);
    }
    | LEFT_BRACE statement_list RIGHT_BRACE {
        $2->setLine(@$);
        $$ = $2;
    }
    ;

statement_list
    : statement {
        $$ = new TIntermBlock();
        context->appendStatement($$, $1);
    }
    | statement_list statement {
        $$ = $1;
        context->appendStatement($$, $2);
    }
    ;

expression_statement
    : SEMICOLON  { $$ = context->addEmptyStatement(@$); }
    | expression SEMICOLON  { $$ = $1; }
    ;

selection_statement
    : IF LEFT_PAREN expression RIGHT_PAREN selection_rest_statement {
        $$ = context->addIfElse($3, $5, @1);
    }
    ;

selection_rest_statement
    : statement_with_scope ELSE statement_with_scope {
        $$.node1 = $1;
        $$.node2 = $3;
    }
    | statement_with_scope {
        $$.node1 = $1;
        $$.node2 = nullptr;
    }
    ;

// Note that we've diverged from the spec grammar here a bit for the sake of simplicity.
// We're reusing compound_statement_with_scope instead of having separate rules for switch.
switch_statement
    : SWITCH LEFT_PAREN expression RIGHT_PAREN { context->incrSwitchNestingLevel(); } compound_statement_with_scope {
        $$ = context->addSwitch($3, $6, @1);
        context->decrSwitchNestingLevel();
    }
    ;

case_label
    : CASE constant_expression COLON {
        $$ = context->addCase($2, @1);
    }
    | DEFAULT COLON {
        $$ = context->addDefault(@1);
    }
    ;

condition
    : expression {
        $$ = $1;
        context->checkIsScalarBool($1->getLine(), $1);
    }
    | fully_specified_type identifier EQUAL initializer {
        $$ = context->addConditionInitializer($1, ImmutableString($2.string), $4, @2);
    }
    ;

iteration_statement
    : WHILE LEFT_PAREN { context->symbolTable.push(); context->incrLoopNestingLevel(); } condition RIGHT_PAREN statement_no_new_scope {
        context->symbolTable.pop();
        $$ = context->addLoop(ELoopWhile, 0, $4, 0, $6, @1);
        context->decrLoopNestingLevel();
    }
    | DO { context->incrLoopNestingLevel(); } statement_with_scope WHILE LEFT_PAREN expression RIGHT_PAREN SEMICOLON {
        $$ = context->addLoop(ELoopDoWhile, 0, $6, 0, $3, @4);
        context->decrLoopNestingLevel();
    }
    | FOR LEFT_PAREN { context->symbolTable.push(); context->incrLoopNestingLevel(); } for_init_statement for_rest_statement RIGHT_PAREN statement_no_new_scope {
        context->symbolTable.pop();
        $$ = context->addLoop(ELoopFor, $4, $5.node1, reinterpret_cast<TIntermTyped*>($5.node2), $7, @1);
        context->decrLoopNestingLevel();
    }
    ;

for_init_statement
    : expression_statement {
        $$ = $1;
    }
    | declaration_statement {
        $$ = $1;
    }
    ;

conditionopt
    : condition {
        $$ = $1;
    }
    | /* May be null */ {
        $$ = nullptr;
    }
    ;

for_rest_statement
    : conditionopt SEMICOLON {
        $$.node1 = $1;
        $$.node2 = 0;
    }
    | conditionopt SEMICOLON expression  {
        $$.node1 = $1;
        $$.node2 = $3;
    }
    ;

jump_statement
    : CONTINUE SEMICOLON {
        $$ = context->addBranch(EOpContinue, @1);
    }
    | BREAK SEMICOLON {
        $$ = context->addBranch(EOpBreak, @1);
    }
    | RETURN SEMICOLON {
        $$ = context->addBranch(EOpReturn, @1);
    }
    | RETURN expression SEMICOLON {
        $$ = context->addBranch(EOpReturn, $2, @1);
    }
    | DISCARD SEMICOLON {
        $$ = context->addBranch(EOpKill, @1);
    }
    ;

// Grammar Note:  No 'goto'.  Gotos are not supported.

translation_unit
    : external_declaration {
        $$ = new TIntermBlock();
        $$->setLine(@$);
        $$->appendStatement($1);
        context->setTreeRoot($$);
    }
    | translation_unit external_declaration {
        $$->appendStatement($2);
    }
    ;

external_declaration
    : function_definition {
        $$ = $1;
    }
    | declaration {
        $$ = $1;
    }
    ;

function_definition
    : function_prototype {
        context->parseFunctionDefinitionHeader(@1, $1.function, &($1.intermFunctionPrototype));
    }
    compound_statement_no_new_scope {
        $$ = context->addFunctionDefinition($1.intermFunctionPrototype, $3, @1);
    }
    ;

%%

int glslang_parse(TParseContext* context) {
    return yyparse(context, context->getScanner());
}
