// // WideMargin. Simple fast bible software.
// // Copyright (C) 2011  Daniel Hughes
// //
// // This program is free software: you can redistribute it and/or modify
// // it under the terms of the GNU General Public License as published by
// // the Free Software Foundation, either version 3 of the License, or
// // (at your option) any later version.
// //
// // This program is distributed in the hope that it will be useful,
// // but WITHOUT ANY WARRANTY; without even the implied warranty of
// // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// // GNU General Public License for more details.
// //
// // You should have received a copy of the GNU General Public License
// // along with this program.  If not, see <http://www.gnu.org/licenses/>.
using System;
namespace WideMargin.GUI
{
	public class PageRanger
	{
		public PageRanger ()
		{
		}
		
		public void GetPageRange(int numberOfPages, int currentPage, out int firstPage, out int lastPage)
		{
			//figure out which end of the range we are closer to
			int distanceToEnd = numberOfPages - currentPage;
			int distanceToStart = currentPage;
			
			if(distanceToEnd <= distanceToStart)
			{
				if(distanceToEnd > 5)
				{
					lastPage = currentPage + 5;
					firstPage = lastPage - 10;
				}
				else
				{
					lastPage = numberOfPages - 1;
					firstPage = lastPage - 9;
				}
				if(firstPage < 0)
				{
					firstPage = 0;	
				}
				return;
			}

			if(distanceToStart > 5)
			{
				firstPage = currentPage - 5;
				lastPage = firstPage + 9;
			}
			else
			{
				firstPage = 0;
				lastPage = 9;
			}
			if(lastPage > numberOfPages - 1)
			{
				lastPage = numberOfPages - 1;	
			}
		}
	}
}

