/*    Copyright (C) 1998-2003 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* Interface octave to wims */

/* 'Permission denied' error generated by Octave: it is trying to
 * write to .octave.history even with the -H switch. */

/*************** Customization: change values hereafter ****************/
#include "common.h"

/* limit of input/output file sizes */
int fsizelim=131072;
/* This string tells octave to exit. */
char *quitstring="\nquit\n";
/* The way to print a string in the program. */
char *stringprinter="\"%s\"\n";
/* This is octave home page. To be kept up to date. */
#define homepage "http://www.gnu.org/software/octave/"
/* String to search for answers */
char ans_str[]="ans =";

char *nameofcmd="octave -Hf --no-line-editing";
int precision=9;
char header[]="split_long_rows(0)\n\
page_screen_output(0)\n\
function y=sh(x) y=sinh(x); endfunction\n\
function y=ch(x) y=cosh(x); endfunction\n\
function y=th(x) y=tanh(x); endfunction\n\
function y=ln(x) y=log(x); endfunction\n\
function y=lg(x) y=log10(x); endfunction\n\
function y=sgn(x) y=sign(x); endfunction\n\
function y=tg(x) y=tan(x); endfunction\n\
function y=cotan(x) y=cot(x); endfunction\n\
function y=ctg(x) y=cot(x); endfunction\n\
function y=arcsin(x) y=asin(x); endfunction\n\
function y=arccos(x) y=acos(x); endfunction\n\
function y=arctan(x) y=atan(x); endfunction\n\
function y=arctg(x) y=atan(x); endfunction\n\
function y=argsh(x) y=asinh(x); endfunction\n\
function y=argch(x) y=acosh(x); endfunction\n\
function y=argth(x) y=atanh(x); endfunction\n\
function y=Argsh(x) y=asinh(x); endfunction\n\
function y=Argch(x) y=acosh(x); endfunction\n\
function y=Argth(x) y=atanh(x); endfunction\n\
function y=rint(x) y=round(x); endfunction\n\
PI=pi\n\
Pi=pi\n\
";

struct {
    char *wname; char *defaultval; char *setname;
} setups[]={
      {"w_octave_precision", "9", "output_precision"}
};

/* names which are not allowed */
char *illegal[]={
      "system","fopen","fclose","readdir","popen","mkdir","rmdir",
      "dir","ls","cd","chdir","more","save","load","diary",
      "fork","putenv","graw","eval",
      "scanf","exec","unlink","umask","lstat","stat","rename",
      "glob","tilde_expand","pclose","popen2","waitpid",
};

int illegal_no=(sizeof(illegal)/sizeof(illegal[0]));

/* name parts which are not allowed */
char *illpart[]={
    "file", "debug", "plot"
};

int illpart_no=(sizeof(illpart)/sizeof(illpart[0]));

/***************** Nothing should need change hereafter *****************/

char *progname="octave";

/* check for security violations in command string */
void check_parm(char *p)
{
    char *pp, *s;

 /* Underscore replacement */
    for(pp=strchr(p,'_'); pp!=NULL; pp=strchr(pp+1,'_')) {
      if(pp==p || !isalnum(*(pp-1))) *pp='K';
    }
    for(s=p;*s;s++) *s=tolower(*s);
    find_illegal(p);
}

/* process and print octave output */
void output(char *p)
{
    int i,n;
    char *pp, *pe, *pt;

    pp=strchr(p,'\n');
    for(pp++; *pp; pp=pe) {
      pe=strchr(pp,'\n'); if(pe) *pe++=0; else pe=pp+strlen(pp);
      if(memcmp(pp,ans_str,strlen(ans_str))==0) pp+=strlen(ans_str);
      n=strlen(pp); if(n==0) {
          puts(""); continue;
      }
/* make every output one-line */
      for(i=0;i<n;i++) {
          if(*(pp+i)=='\n' || *(pp+i)=='\%') *(pp+i)=' ';
      }
/* strip leading and trailing spaces */
      while(isspace(*pp) && pp<pe) pp++;
      pt=pp+strlen(pp)-1;
      while(isspace(*pt) && pt>pp) *pt--=0;
      strip_zeros(pp);
      puts(pp);
    }
}

void about(void)
{
    char *p;

    prepabout(quitstring,outputfname,NULL);
    if(readabout()>0) {
      p=strchr(aboutbuf,'\n'); if(p!=NULL) *p=0;
      p=strchr(aboutbuf,'('); if(p!=NULL) *p=0;
      strip_trailing_spaces2(aboutbuf);
      printf("<a href=\"%s\">%s</a>",homepage,aboutbuf);
    }
}

char *dynsetup(char *ptr, char *end)
{
    int i;
    char *p, *pp;
    for(i=0;i<SETUP_NO;i++) {
      p=getenv(setups[i].wname);
      if(p!=NULL) for(pp=p;*pp;pp++) if(!isspace(*pp) && !isalnum(*pp)) p="";
      if(p==NULL || *p==0) p=setups[i].defaultval;
      snprintf(ptr,end-ptr,"%s(%s)\n",setups[i].setname,p);
      ptr+=strlen(ptr);
      if(strstr(setups[i].wname,"octave_precision")!=NULL)
        precision=atoi(p);
      if(precision<0) precision=-precision;
    }
    return ptr;
}

int main(int argc,char *argv[])
{
    prepare1();
    run();
    return 0;
}

