#!/usr/bin/perl -T
# 
# Simple Xtradius LDAP Authentication (klynn@santacruz.org) 
#
#set LDAP version

#set allow and deny access levels

$DENY_ACCESS = 255;
$ALLOW_ACCESS = 0;
#which host has the ldap directory?
$hostname = "localhost";

#set up variables for the dn and searchbase
#modify this to your liking. Some people need to use uid=
#instead of cn=
$dno = "Company";
$dnc = "US";
$dncn = "Manager";
$dn = "cn=$dncn,o=$dno,c=$dnc";
$searchbase = "o=$dno,c=$dnc";

#be careful of the password here. You really shouldn't put your password
#in a script that's world readable but for simplicity I've put it here.
#a better way would be to put it in a file readable only by root and the
#user you use to run the radius server.
$manpass = "SOMEPASSWORD";

use Net::LDAP;

#grab the login and password from the command line
$login = $ARGV[0];
#untaint $login
$login =~ s/[^\w\-\.\_\+]//g;
#password is hard to untaint because so many characters COULD be used in
#the password - I think this works but it's late and I definitely may be
#wrong (don't want to think about it to much right now)
$passwd = $ARGV[1];
$passwd =~ s/([\'\.\;\"\`])/\\$1/g;

#create a new OOP reference for the ldap.
$ldap = Net::LDAP->new("$hostname") or die "$@";
#bind to the ldap server with the DN
my $mesg = $ldap->bind(
        dn => "$dn",
        password => "$manpass",
        version => '3'
        );

#search through the ldap directory for the uid specified.
$mesg = $ldap->search (  # perform a search
 base=> $searchbase,
 filter => "(&(uid=$login))"
);

#if there's an error print it and die
$mesg->code && die $mesg->error;

#there really should only be one thing passed back from the uid
#but we do a foreach here just in case (we're lazy)
foreach $entry ($mesg->all_entries) {

#get the cn for the uid you queried
$cn = $entry->get_value('cn');
        
#creat a second OOP reference for the ldap
$ldap2 = Net::LDAP->new("$hostname") or die "$@";

#bind a second time - you could just modify the binding but
#I didn't want to go through the hassle.   
my $mesg2 = $ldap2->bind(
        dn => "cn=$cn,$searchbase",
        password => "$passwd",
        version => '3'
        );
  
  ###If there's any mesg code then it must have failed therefore
  ###exit with the DENY_ACCESS otherwise ALLOW_ACCESS
  if ( $mesg2->code() ) {
    $ret = $DENY_ACCESS;
  } else {
    $ret = $ALLOW_ACCESS;
  }
}       

#drop the bindings here - glad we're not skiing  
$ldap->unbind;# take down session
$ldap2->unbind;
#print the return code on the exit
exit $ret;
        
