/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "swidget/SBorder.h"

/**
 * Craet a border object.
 * the borderSize is the x and y dimension of the border.
 * The actual component size reduces by this twice for x and y directions too
 */
SBorder::SBorder (SStyle s)
{
  style = s;
  switch (style)
  {
  case IN:
  case OUT:
  case SOLID:
   borderSize = SDimension (1,1);
   break;
  default:
   borderSize = SDimension (2,2);
  }
}

SBorder::~SBorder ()
{
}

void
SBorder::setStyle (SStyle s)
{
  style = s;
}

const SDimension&
SBorder::getBorderSize() const
{
  return borderSize;
}

void
SBorder::redraw (SCanvas *canvas, int _x, int _y, unsigned int width, unsigned int height)
{
  SColor di = background.darker();
  SColor li = background.lighter();
  /* locations width ending points */
  int x[2] = { location.x, location.x + (int) size.width-1 };
  int y[2] = { location.y, location.y + (int) size.height-1 };
  switch (style)
  {
  case ETCHED:
      //  +----
      //  |
      //
      canvas->bitline (di, x[0], y[0], x[1]-1, y[0]);
      canvas->bitline (di, x[0], y[0]+1, x[0], y[1]-1);
      //    +----
      //    |
      canvas->bitline (li, x[0]+1, y[0]+1, x[1]-2, y[0]+1);
      canvas->bitline (li, x[0]+1, y[0]+2, x[0]+1, y[1]-2);
      //        |
      //     ---+
      canvas->bitline (di, x[1]-1, y[0]+2, x[1]-1, y[1]-2);
      canvas->bitline (di, x[1]-1, y[1]-1, x[0]+2, y[1]-1);
      //         |
      //      ---+
      canvas->bitline (li, x[1], y[0]+1, x[1], y[1]);
      canvas->bitline (li, x[1]-1, y[1], x[0]+1, y[1]);
      //         +
      //     +
      canvas->bitpoint (background, x[1]-1, y[0]+1);
      canvas->bitpoint (background, x[0]+1, y[1]-1);
      canvas->bitpoint (background, x[0], y[1]);
      canvas->bitpoint (background, x[1], y[0]);
      break;
  case IN:
      canvas->bitline (di, x[0], y[0], x[1]-1, y[0]); 
      canvas->bitline (di, x[0], y[0]+1, x[0], y[1]-1);
      canvas->bitpoint (background, x[1], y[0]); 
      canvas->bitline (li, x[1], y[0]+1, x[1], y[1]-1);
      canvas->bitline (li, x[0]+1, y[1],  x[1], y[1]);
      canvas->bitpoint (background, x[0], y[1]); 
      break;
  case OUT:
      break;
  case SOLID:
      canvas->bitline (background, x[0], y[0], x[1]-1, y[0]); 
      canvas->bitline (background, x[1], y[0], x[1], y[1]-1);
      canvas->bitline (background, x[0]+1, y[1],  x[1], y[1]);
      canvas->bitline (background, x[0], y[0]+1, x[0], y[1]);
      break;
  }
  return;
}

void
SBorder::resize (const SDimension& s)
{
  SComponent::resize(s);
}

void 
SBorder::move (const SLocation& l)
{
  SComponent::move(l);
}
