/** 
 *  Yudit Unicode Editor Source File
 *
 *  GNU Copyright (C) 2002  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2001  Gaspar Sinai <gsinai@yudit.org>  
 *  GNU Copyright (C) 2000  Gaspar Sinai <gsinai@yudit.org>  
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  dated June 1991. See file COPYYING for details.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include "stoolkit/SConfig.h"
#include <stdlib.h>
#include <stdio.h>

#ifdef USE_WINAPI
#define DEFAULT_CONFIG "/config/yuditrc"
#else
#define DEFAULT_CONFIG "/usr/share/yudit/config/yuditrc"
#endif

/**
 * @author: Gaspar Sinai <gsinai@yudit.org>
 * @version: 2000-04-23
 */
main (int argc, char* argv[])
{
  SString home(getenv("HOME"));
  if (home.size()==0) home = "/";
  SFile normrc("TESTFILE", home);
  SConfig conf (normrc);
  if (normrc.size()<0)
  {
    fprintf (stderr, "Main: %*.*s not found.\n", SSARGS(normrc.getName()));
    fprintf (stderr, "Main: Trying %s\n", DEFAULT_CONFIG);
    SFile def (DEFAULT_CONFIG);
    if (def.size()<0)
    {
      fprintf (stderr, "Main: %*.*s not found.\n", SSARGS(def.getName()));
      return 1;
    }
    conf.setFile (def);
    conf.read();
    fprintf (stderr, "Main: copying %*.*s to %*.*s\n", SSARGS(def.getName()),
          SSARGS(normrc.getName()));
    conf.setFile (normrc);
    if (!conf.write())
    {
      fprintf (stderr,"Main: failed to write %*.*s \n",SSARGS(normrc.getName()));
    }
  }
  else
  {
    conf.read();
  }
  return 0;
}
