package org.broad.tribble.index;

/**
 * Represents a contiguous block of bytes in a file, defined by a start position and size (in bytes)
*/
public class Block {

    private long startPosition;
    private int size;

    /**
     * Constructs ...
     *
     * @param startPosition
     * @param size
     */
    public Block(long startPosition, int size) {
        this.startPosition = startPosition;
        this.size = size;
    }

    /**
     * @return the startPosition
     */
    public long getStartPosition() {
        return startPosition;
    }

    public long getEndPosition() {
        return startPosition + size;
    }

    /**
     * This method is used to aid in consolidating blocks
     */
    public void setEndPosition(long endPosition) {
        assert(endPosition > startPosition);
        size = (int) (endPosition - startPosition);

    }

    /**
     * @return the # of bytes in this block
     */
    public int getSize() {
        return size;
    }
}
