/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import org.fest.swing.core.InputModifiers;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.TestTerminator;
import org.fest.util.VisibleForTesting;

public class EmergencyAbortListener
implements AWTEventListener {
    private static final long EVENT_MASK = 8L;
    private final Toolkit toolkit;
    private final TestTerminator testTerminator;
    private int keyCode = 65;
    private int modifiers = InputModifiers.unify(2, 1);

    public static EmergencyAbortListener registerInToolkit() {
        EmergencyAbortListener listener = new EmergencyAbortListener(Toolkit.getDefaultToolkit());
        listener.register();
        return listener;
    }

    @VisibleForTesting
    EmergencyAbortListener(Toolkit toolkit) {
        this(toolkit, new TestTerminator());
    }

    @VisibleForTesting
    EmergencyAbortListener(Toolkit toolkit, TestTerminator testTerminator) {
        this.testTerminator = testTerminator;
        this.toolkit = toolkit;
    }

    @VisibleForTesting
    void register() {
        this.removePrevious();
        this.toolkit.addAWTEventListener(this, 8L);
    }

    private void removePrevious() {
        AWTEventListener[] listeners;
        for (AWTEventListener listener : listeners = this.toolkit.getAWTEventListeners(8L)) {
            if (!(listener instanceof EmergencyAbortListener)) continue;
            this.toolkit.removeAWTEventListener(listener);
        }
    }

    public EmergencyAbortListener keyCombination(KeyPressInfo keyPressInfo) {
        if (keyPressInfo == null) {
            throw new NullPointerException("KeyPressInfo should not be null");
        }
        this.keyCode = keyPressInfo.keyCode();
        this.modifiers = InputModifiers.unify(keyPressInfo.modifiers());
        return this;
    }

    public void unregister() {
        this.toolkit.removeAWTEventListener(this);
    }

    public void eventDispatched(AWTEvent event) {
        if (event.getID() != 401) {
            return;
        }
        if (!(event instanceof KeyEvent)) {
            return;
        }
        KeyEvent e = (KeyEvent)event;
        if (e.getKeyCode() != this.keyCode) {
            return;
        }
        if (!InputModifiers.modifiersMatch(e, this.modifiers)) {
            return;
        }
        this.testTerminator.terminateTests();
    }

    @VisibleForTesting
    int keyCode() {
        return this.keyCode;
    }

    @VisibleForTesting
    int modifiers() {
        return this.modifiers;
    }
}

