/*  -*- c -*-  */
/* -------------------------------------------------------------------- *
**  copyright (c) 1995 ipvr stuttgart and thomas harrer
** -------------------------------------------------------------------- *
**
**  libhelp
**
**  a comprehensive hypertext help system for OSF/Motif(tm) applications. 
**  based on libhtmlw from NCSA Mosaic(tm) version 2.4
**
**  written by thomas harrer
**  e-mail: Thomas.Harrer@rus.uni-stuttgart.de
**
** -------------------------------------------------------------------- *
*h  $Id: language.h,v 1.23 1995/06/28 12:59:30 thomas Exp $
** -------------------------------------------------------------------- *
**
*h  module:		language.h
**
**  contents:		language dependent definitions
**
**  interface:		#include "language.h"
**
** -------------------------------------------------------------------- *
**  license and copying issues:
**
**  this software is free; you can redistribute it and/or modify it 
**  under terms similar to the gnu general public license (version 1 
**  or any later version published by the free software foundation). 
**  see the file Licence for more details.
**
**  this program is distributed in the hope that it will be useful,
**  but without any warranty; without even the implied warranty of
**  merchantability or fitness for a particular purpose.  
** -------------------------------------------------------------------- */
#ifndef _LANGUAGE_H_
#define _LANGUAGE_H_ 1

#if defined(english) && defined(deutsch)
# error "cannot have both defined, english and deutsch"
#endif

#if !defined(english) && !defined(deutsch)
# define english 1
#endif /* !english...  */

/* -------------------------------------------------------------------- *
*g  international defs
** -------------------------------------------------------------------- */
#define str_libhelp_icon \
"<img src=\"libhelp-icon.gif\" alt=\"Libhelp\">"
#define str_history_icon str_libhelp_icon
#define str_libhelp_bar \
"<img src=\"libhelp-bar.gif\" alt=\"----------------\">"
#define str_icon_index \
"<img align = top IMG SRC =\"icon-index.gif\" alt=\"+\">"

/* -------------------------------------------------------------------- *
*g  english strings for help
** -------------------------------------------------------------------- */
#ifdef english

#define str_error_text "<TITLE>Error text: no such file</TITLE> "	\
"<H1><img src=\"icon-warning.gif\" align=middle> "			\
"No help available.</H1>"						\
"<P> The following help file could not be accessed: <p><code>"

#define str_error_end "</code>. "                   \
"<P>Probably the libhelp path for this application is not set correctly" \
" or the help file is damaged (or this url is not local. try using "    \
"Mosaic or your favourite WWW browser for this url). "			\
"<P> To set the help path there are two possibilities: "		\
"<UL> "									\
"<LI> at compile time, specify the directories where help files are "	\
"to be installed in Makefile's HELP_PATH as a \":\" separated list."	\
"<LI> at run time, specify it in the environment variable MPSQL_HELP_PATH."	\
"</UL>\n"

#define str_history 	" History"
#define str_no_title 	"Plain text with no title"
#define str_directory	"Directory"
#define str_parent	"Parent Directory"
#define str_binary	"Binary File"
#define str_binary_cannot "Can't display contents of binary file"
#define str_image	"Image"
#endif /* english  */

/* -------------------------------------------------------------------- *
*g  german strings for libhelp
** -------------------------------------------------------------------- */
#ifdef deutsch

#define str_error_text "<TITLE>Hilfe-Fehler</TITLE> "			\
"<H1><img src=\"icon-warning.gif\" align=middle> "			\
"Hilfe ist nicht verfgbar.</H1>"					\
"<P> Ein Fehler im Hilfesystem trat auf: die von der Applikation"	\
" spezifizierte Hilfedatei<p><code>"

#define str_error_end "</code> <p>konnte nicht gefunden werden. "	\
"<P> Mgliche Fehlerursachen: die Hilfedatei ist nicht (korrekt)"	\
" installiert, der Hilfepfad ist nicht gesetzt oder die Hilfedatei "	\
"ist korrumpiert."                                                      \
"<P> Um den Hilfepfad zu setzen gibt es folgende Mglichkeiten:"	\
"<UL> "									\
"<LI> beim Kompilieren kann der Hilfepfad in der Makefile Variablen "	\
"HELP_PATH als durch \":\" getrennte Liste festgelegt werden."		\
"<LI> sonst kann der Hilfepfad in der Environment Variablen "		\
"MPSQL_HELP_PATH festgelegt werden."					\
"</UL>\n"

#define str_history 	"Hilfe Historie"
#define str_no_title 	"Text ohne Titel"
#define str_directory	"Verzeichnis"
#define str_parent	"&Uuml;bergeordnetes Verzeichnis"
#define str_binary	"Bin&auml;r Datei"
#define str_binary_cannot "Bin&auml;r Datei kann nicht angezeigt werden"
#define str_image	"Bild"
#endif /* deutsch  */

#endif /* !_LANGUAGE_H_ */
/* -------------------------------------------------------------------- *
*l  emacs:
**  local variables:
**  mode:		c
**  outline-regexp:	"\*[HGPLT]"
**  comment-column:	32
**  eval:		(outline-minor-mode t)
**  end:
** -------------------------------------------------------------------- */
