/* $Id: ll.h,v 1.2 1998/08/02 20:35:01 proff Exp $ */

#ifndef LL_H
#define LL_H

#include "ll.h"

struct group_cfg
{
	struct group_cfg *next;
	struct group_cfg *head;
	char *group_pat;
	struct server_cfg *server_cfg;
        int flags;
};

enum list_type
{
	l_active=0, l_active_times, l_newsgroups, l_overview_fmt, l_subscriptions, l_xgtitle, l_other, l_last
};

#define NUM_LISTS 4		/* only the first 4 are "real" lists */

struct list_cfg
{
    int bytes;
    int lines;
    int entries;		/* number of lines we accepted */
    time_t rebuild_good;
    time_t rebuild_fail;
    time_t rebuild_refused;	/* refused to provide the list type */
};

struct share_server_cfg
{
	struct strList *overview_fmt;
	struct strList *overview_fmt_xref;
	n_u32 overview_fmt_hash;
        bool overview_fmt_xref_full;
	time_t server_up;	/* time when server reported up */
	time_t server_down;	/* time when server reported down */
        time_t server_check;    /* time when server check was initiated */
	int server_down_time;	/* time down before last down */
	int server_up_time;	/* time up before last up */
        struct list_cfg list[NUM_LISTS];
        big_t connect_good;
	big_t connect_fail;
	big_t bytes_from;
	big_t bytes_to;
	big_t article_good;
        big_t article_fail;
	big_t head_good;
        big_t head_fail;
	big_t body_good;
        big_t body_fail;
	big_t stat_good;
        big_t stat_fail;
        big_t group_good;
        big_t group_fail;
	big_t xover_good;
	big_t xover_fail;
	big_t xhdr_good;
	big_t xhdr_fail;
	big_t listgroup_good;
	big_t listgroup_fail;
        big_t newnews_good;
        big_t newnews_fail;
	big_t post_good;
	big_t post_fail;
        big_t ihave_good;
        big_t ihave_fail;
        big_t xpath_good;
	big_t xpath_fail;
        big_t relay_good;
        big_t relay_fail;
};

struct server_cfg
{
	struct server_cfg *next;
	struct server_cfg *head;
        FILE *fh;               /* A FILE struct for the descriptor (fdreopen()ed) */
	char *group;		/* current group on server */
	char *group_actual;	/* actual (bound) group on server */
	int artno;		/* current article on server */
        char *host;    		/* Server name:port. Key field */
        char *us;               /* Our bind address. From nntpcache.servers */
	struct share_server_cfg *share;
        int fd;                 /* Socket fd. -1 means not connected */
	time_t last_active_time;	/* last communication with server */
        int active_timeout;     /* Active timeout. From nntpcache.servers */
        int active_times_timeout; /* Active.times timeout. From nntpcache.servers */
        int newsgroups_timeout; /* Newsgroups timeout. From nntpcache.servers */
        int xover_timeout;      /* Xover timeout. From nntpcache.servers */
	int group_timeout;	/* group timeout */
	int listgroup_timeout;	/* listgroup timeout */
	int overview_fmt_timeout;	/* timeout */
	int article_timeout;	/* timeout */
	bool post_ok;		/* posting ok on this server */
};

#endif /* LL_H */
