


#include "GetLocalIPAddressString.h"


 
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>

#include <sys/types.h>
//#include <sys/time.h>
//#include <sys/errno.h>
//#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>
//#include <sys/utsname.h>
#include <arpa/inet.h>
//#include <netdb.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>

short GetLocalIPAddressString(char *returnStr, short maxSize)
{
	short result = 0;
	char defaultAddress[] = "255.255.255.255";
	char* addr = defaultAddress;
	int err = -1;
	do 
	{
	
		//Most of this code is similar to the SIOCGIFCONF code presented in Stevens,
		//Unix Network Programming, section 16.6
		
		//Use the SIOCGIFCONF ioctl call to iterate through the network interfaces
		static const unsigned long kMaxAddrBufferSize = 2048;
		
		char* ifReqIter = NULL;
		struct ifconf ifc;
		struct ifreq* ifr;
		char buffer[kMaxAddrBufferSize];
		
		int tempSocket = socket(AF_INET, SOCK_DGRAM, 0);
		if (tempSocket == -1) break;
			
		ifc.ifc_len = kMaxAddrBufferSize;
		ifc.ifc_buf = buffer;
		
		err = ioctl(tempSocket, SIOCGIFCONF, (char*)&ifc);
		if (err == -1) break;
		
		close(tempSocket);
		tempSocket = -1;

//		int numIPAddrs = 0;
		
		for (ifReqIter = buffer; ifReqIter < (buffer + ifc.ifc_len);)
		{
			ifr = (struct ifreq*)ifReqIter;
#if __MacOSX__
			ifReqIter += sizeof(ifr->ifr_name) + ifr->ifr_addr.sa_len;
			if (ifr->ifr_addr.sa_len == 0)
			{
				switch (ifr->ifr_addr.sa_family)
				{
					case AF_INET:
						ifReqIter += sizeof(struct sockaddr_in);
						break;
					default:
						ifReqIter += sizeof(struct sockaddr);
				}
			}
#else
			ifReqIter += sizeof(ifr->ifr_name) + 0;
			switch (ifr->ifr_addr.sa_family)
			{
				case AF_INET:
					ifReqIter += sizeof(struct sockaddr_in);
					break;
				default:
					ifReqIter += sizeof(struct sockaddr);
			}
#endif
				
			//Only count interfaces in the AF_INET family.
			//And don't count localhost, loopback interfaces
			if ((ifr->ifr_addr.sa_family == AF_INET) && (strncmp(ifr->ifr_name, "lo", 2) != 0))
			{
				struct sockaddr_in* addrPtr = (struct sockaddr_in*)&ifr->ifr_addr;	
				addr = inet_ntoa(addrPtr->sin_addr);
				//printf("found local address: %s\n", addr);
				err = 0;
				break;
			}
		}
	
	} while (0);
		

	result = strlen(addr);
	
	if (maxSize < result)
	{	err = -1;
	}
	else
		strcpy(returnStr, addr);
	
	return err;
}
