/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		OSCond.cpp

	Contains:	Implementation of OSCond class
	
	$Log: OSCond.cpp,v $
	Revision 1.2  1999/02/19 23:05:31  ds
	Created
	

*/

#include "OSCond.h"
#include "OSMutex.h"
#include "OSThread.h"
#include "MyAssert.h"

#if __PTHREADS__
#include <sys/time.h>
#include <fcntl.h>
#endif


OSCond::OSCond()
{
#if !__PTHREADS__
	fCondition = mycondition_alloc();
	Assert(fCondition != NULL);
#else
	int ret = pthread_cond_init(&fCondition, NULL);
	Assert(ret == 0);
#endif
}

OSCond::~OSCond()
{
#if !__PTHREADS__
	Assert(fCondition != NULL);
	mycondition_free(fCondition);
#else
	pthread_cond_destroy(&fCondition);
#endif
}

#if __PTHREADS__
void OSCond::TimedWait(pthread_mutex_t* inMutex, SInt32 inTimeoutInMilSecs)
{
	struct timespec ts;
	struct timeval tv;
	struct timezone tz;
	int	sec, usec;
	
	if (inTimeoutInMilSecs == 0)
		pthread_cond_wait(&fCondition, inMutex);
	else
	{
		gettimeofday(&tv, &tz);
		sec = inTimeoutInMilSecs / 1000;
		inTimeoutInMilSecs = inTimeoutInMilSecs - sec * 1000;
		usec = inTimeoutInMilSecs * 1000;
		ts.tv_sec = tv.tv_sec + sec;
		ts.tv_nsec = (tv.tv_usec + usec) * 1000;
		pthread_cond_timedwait(&fCondition, inMutex, &ts);
	}
}
#endif
