/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import javax.swing.JTabbedPane;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.painter.ControlBackgroundComposite;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.painter.highlight.SubstanceHighlightPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.watermark.SubstanceWatermark;

/**
 * Abstract skin for <b>Substance</b> look and feel.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.1
 */
public abstract class SubstanceAbstractSkin implements SubstanceSkin {
	/**
	 * The theme of <code>this</code> skin. The result may be
	 * <code>null</code> if <code>this</code> skin doesn't define a custom
	 * theme.
	 */
	protected SubstanceTheme theme;

	/**
	 * The watermark of <code>this</code> skin. May be <code>null</code> if
	 * <code>this</code> skin doesn't define a custom watermark.
	 */
	protected SubstanceWatermark watermark;

	/**
	 * The button shaper of <code>this</code> skin. May be <code>null</code>
	 * if <code>this</code> skin doesn't define a custom button shaper.
	 */
	protected SubstanceButtonShaper buttonShaper;

	/**
	 * The gradient painter of <code>this</code> skin. May be
	 * <code>null</code> if <code>this</code> skin doesn't define a custom
	 * gradient painter.
	 */
	protected SubstanceGradientPainter gradientPainter;

	/**
	 * The border painter of <code>this</code> skin. May be <code>null</code>
	 * if <code>this</code> skin doesn't define a custom border painter.
	 */
	protected SubstanceBorderPainter borderPainter;

	protected SubstanceHighlightPainter highlightPainter;

	protected SubstanceDecorationPainter decorationPainter;

	/**
	 * The background composite for tabbed panes of <code>this</code> skin.
	 * May be <code>null</code> if <code>this</code> skin doesn't define a
	 * custom background composite for tabbed panes.
	 */
	protected ControlBackgroundComposite tabBackgroundComposite;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getTheme()
	 */
	public SubstanceTheme getTheme() {
		return this.theme;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getWatermark()
	 */
	public SubstanceWatermark getWatermark() {
		return this.watermark;
	}

	public SubstanceBorderPainter getBorderPainter() {
		return this.borderPainter;
	}

	public SubstanceButtonShaper getButtonShaper() {
		return this.buttonShaper;
	}

	public SubstanceGradientPainter getGradientPainter() {
		return this.gradientPainter;
	}

	public SubstanceHighlightPainter getHighlightPainter() {
		return this.highlightPainter;
	}

	public SubstanceDecorationPainter getDecorationPainter() {
		return this.decorationPainter;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#set()
	 */
	public boolean set() {
		// all settings must be non-null
		if (this.theme == null) {
			throw new IllegalStateException("Skin must define non-null theme");
		}
		if (this.watermark == null) {
			throw new IllegalStateException(
					"Skin must define non-null watermark");
		}
		if (this.buttonShaper == null) {
			throw new IllegalStateException(
					"Skin must define non-null button shaper");
		}
		if (this.gradientPainter == null) {
			throw new IllegalStateException(
					"Skin must define non-null gradient painter");
		}
		if (this.borderPainter == null) {
			throw new IllegalStateException(
					"Skin must define non-null border painter");
		}
		if (this.highlightPainter == null) {
			throw new IllegalStateException(
					"Skin must define non-null highlight painter");
		}
		if (this.decorationPainter == null) {
			throw new IllegalStateException(
					"Skin must define non-null decoration painter");
		}

		if (!SubstanceLookAndFeel
				.setCurrentGradientPainter(this.gradientPainter))
			return false;
		if (!SubstanceLookAndFeel
				.setCurrentDecorationPainter(this.decorationPainter))
			return false;
		if (!SubstanceLookAndFeel
				.setCurrentHighlightPainter(this.highlightPainter))
			return false;
		if (!SubstanceLookAndFeel.setCurrentBorderPainter(this.borderPainter))
			return false;
		if (!SubstanceLookAndFeel.setCurrentButtonShaper(this.buttonShaper))
			return false;
		if (!SubstanceLookAndFeel.setCurrentTheme(this.theme))
			return false;
		if (!SubstanceLookAndFeel.setCurrentWatermark(this.watermark))
			return false;
		SubstanceLookAndFeel.setBackgroundComposite(JTabbedPane.class,
				this.tabBackgroundComposite);
		return true;
	}
}
