package test.contrib;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;

public class TableTest extends JFrame {

	public TableTest() {
		super("FIFA WorldCup 2006");
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		} catch (Exception ignored) {
		}
		;
		SwingUtilities.updateComponentTreeUI(this);
		Object[][] data = { { "Italy", new Integer(1) },
				{ "France", new Integer(2) }, { "Portugal", new Integer(3) },
				{ "Germany", new Integer(4) } };

		String[] columnNames = { "Country", "Predicted Place" };

		final JTable table = new JTable(data, columnNames);
		table.setPreferredScrollableViewportSize(new Dimension(300, 50));

		table.getTableHeader().putClientProperty(
				SubstanceLookAndFeel.THEME_PROPERTY,
				"Sun Glare");
		table.getTableHeader().repaint();

		JScrollPane scrollPane = new JScrollPane(table);
		getContentPane().add(scrollPane, BorderLayout.CENTER);
	}

	public static void main(String[] args) {
		TableTest frame = new TableTest();
		frame.pack();
		frame.setVisible(true);
	}
}