package test.contrib.martin;

import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import java.util.ArrayList;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;

/*
 * InternalFrameDemo.java requires:
 *   MyInternalFrame.java
 */

public class InternalFrameDemo extends JFrame implements ActionListener {
	JDesktopPane desktop;

	// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	JComboBox comboBox;

	ArrayList<JInternalFrame> frames = new ArrayList<JInternalFrame>();

	// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	public InternalFrameDemo() {
		super("InternalFrameDemo");

		// Make the big window be indented 50 pixels from each edge
		// of the screen.
		int inset = 50;
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height
				- inset * 2);

		// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		setContentPane(panel);
		// Set up the GUI.
		desktop = new JDesktopPane(); // a specialized layered pane
		panel.add(createToolBar(), BorderLayout.NORTH);
		panel.add(desktop, BorderLayout.CENTER);
		for (int i = 0; i < 1; i++) {
			createFrame();
		}
		// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

		/*
		 * //Set up the GUI. desktop = new JDesktopPane(); //a specialized
		 * layered pane createFrame(); //create first "window"
		 * setContentPane(desktop);
		 */

		setJMenuBar(createMenuBar());

		// Make dragging a little faster but perhaps uglier.
		desktop.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
	}

	protected JMenuBar createMenuBar() {
		JMenuBar menuBar = new JMenuBar();

		// Set up the lone menu.
		JMenu menu = new JMenu("Document");
		menu.setMnemonic(KeyEvent.VK_D);
		menuBar.add(menu);

		// Set up the first menu item.
		JMenuItem menuItem = new JMenuItem("New");
		menuItem.setMnemonic(KeyEvent.VK_N);
		menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N,
				ActionEvent.ALT_MASK));
		menuItem.setActionCommand("new");
		menuItem.addActionListener(this);
		menu.add(menuItem);

		// Set up the second menu item.
		menuItem = new JMenuItem("Stop Animation");
		menuItem.setMnemonic(KeyEvent.VK_Q);
		menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q,
				ActionEvent.ALT_MASK));
		menuItem.setActionCommand("stop");
		menuItem.addActionListener(this);
		menu.add(menuItem);

		return menuBar;
	}

	// React to menu selections.
	public void actionPerformed(ActionEvent e) {
		if ("new".equals(e.getActionCommand())) { // new
			createFrame();
		} else { // quit
			stopAnimation();
		}
	}

	// Create a new internal frame.
	protected void createFrame() {
		MyInternalFrame frame = new MyInternalFrame();
		frame.setVisible(true); // necessary as of 1.3
		frame.setFrameIcon(animatedIcon());
		desktop.add(frame);
		try {
			frame.setSelected(true);
			frame.moveToFront();
		} catch (java.beans.PropertyVetoException e) {
		}
		// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
		frames.add(frame);
		comboBox.addItem(frame.getTitle());
		// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	}

	// Quit the application.
	protected void stopAnimation() {
		for (JInternalFrame frame : frames) {
			frame.setFrameIcon(staticIcon());
		}
	}

	/**
	 * Create the GUI and show it. For thread safety, this method should be
	 * invoked from the event-dispatching thread.
	 */
	private static void createAndShowGUI() {
		// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//		UIManager.put(SubstanceLookAndFeel.NO_EXTRA_ELEMENTS, Boolean.TRUE);
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
//			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			// Do nothing
		}
		JDialog.setDefaultLookAndFeelDecorated(true);
		// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

		// Make sure we have nice window decorations.
		JFrame.setDefaultLookAndFeelDecorated(true);

		// Create and set up the window.
		InternalFrameDemo frame = new InternalFrameDemo();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// Display the window.
		frame.setVisible(true);
	}

	// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	private JToolBar createToolBar() {
		JToolBar toolBar = new JToolBar();
		comboBox = new JComboBox();
		toolBar.add(comboBox);
		JButton button;
		button = new JButton("A");
		toolBar.add(button);
		button = new JButton("B");
		toolBar.add(button);
		button = new JButton("C");
		toolBar.add(button);
		button = new JButton("D");
		toolBar.add(button);
		button = new JButton("E");
		toolBar.add(button);
		button = new JButton("F");
		toolBar.add(button);

		toolBar.setName("Test ToolBar");
		toolBar.setFloatable(true);
		toolBar.setAlignmentX(Component.LEFT_ALIGNMENT);
		toolBar.setRollover(true);
		return toolBar;
	}

	public ImageIcon animatedIcon() {
		ImageIcon imageIcon;
		URL imgURL = InternalFrameDemo.class.getResource("aConnecting.gif");
		if (imgURL != null) {
			imageIcon = new ImageIcon(imgURL);
			return imageIcon;
		} else {
			return null;
		}
	}

	public ImageIcon staticIcon() {
		ImageIcon imageIcon;
		URL imgURL = InternalFrameDemo.class.getResource("Connecting.gif");
		if (imgURL != null) {
			imageIcon = new ImageIcon(imgURL);
			return imageIcon;
		} else {
			return null;
		}
	}

	// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

	public static void main(String[] args) {
		// Schedule a job for the event-dispatching thread:
		// creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}
}
