/*
	block.c - animate block

	Author:   Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

				All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

static int blockW, blockH, windowW, windowH;
static int maxsize,xsize,ysize,xof,yof;

static void blockIn()	/* Random block */
{
Pixmap pic;
XGCValues gcv;
GC gc;
int i,x,y,*tmp,tmpindex;

	gcv.function = GXcopy;
	gc = XCreateGC(theDisp,theWindow,GCFunction,&gcv );

	if( (pic = XCreatePixmap(	theDisp,theWindow,
								blockW,blockH,
								DefaultDepth(theDisp,theScreenNumber)	)) == (Pixmap)0 ){

		fprintf(stderr,"Can't create Pixmap. Abort.\n");
		goodbyekiss();

	}

	/* Draw the whole image on the pic */
	XPutImage(theDisp,pic,gc,theImage,0,0,0,0,blockW,blockH);


	/* Divide the image in to the small blocks which size is app_data.blockSteps */

	/* Calculate the center position */
	xof = (windowW - blockW) / 2;
	yof = (windowH - blockH) / 2;

	/* Calculate how many blocks will be generated                               */ 
	xsize = (blockW / app_data.blockSteps) + (blockW % app_data.blockSteps ? 1 : 0);
	ysize = (blockH / app_data.blockSteps) + (blockH % app_data.blockSteps ? 1 : 0);
	maxsize = xsize * ysize;

	if( (tmp = (int *)XtMalloc(sizeof(int) * maxsize)) == NULL ){
		fprintf(stderr,"xslideshow: memory allocation error\n");
		goodbyekiss();
	}

	/* Init random position table */
	for(i = 0; i < maxsize; i++)
		tmp[i] = -1;

	for(i = 0; i < maxsize; i++){

		/* Generate random position table */
		while(1){
			tmpindex = myrandom() % maxsize;
			if(tmp[tmpindex] == -1) {
				tmp[tmpindex] = i;
				break;
			}
		}

		/* Create a small block which position is selected randomly */
		x = (tmpindex % xsize) * app_data.blockSteps;
		y = (tmpindex / xsize) * app_data.blockSteps;

		/* If the block position is outside of the main window */
		if( ((x + xof) < 0 && (y + yof) < 0) 
			|| ((x + xof) >= windowW && (y + yof) >= windowH))
			continue;

		/* Draw the image (pic -> window) */
		XCopyArea(
				theDisp,
				pic,
				theWindow,
				gc,
				x, y,
				((x + app_data.blockSteps) < blockW ? app_data.blockSteps : blockW - x),
				((y + app_data.blockSteps) < blockH ? app_data.blockSteps : blockH - y),
				x + xof,
				y + yof );

		myusleep(0); /* Flush */
		if(gotSomeAction == True)
			break;
	}

	XtFree((char *)tmp);
	XFreeGC(theDisp,gc);
	XFreePixmap(theDisp,pic);
}

static void blockOut()	/* Random block */
{
int	i,x,y,*tmp,tmpindex;

	if( (tmp = (int *)XtMalloc(sizeof(int) * maxsize)) == NULL ){
		fprintf(stderr,"xslideshow: memory allocation error\n");
		goodbyekiss();
	}

	/* Init random position table */
	for(i = 0; i < maxsize; i++)
		tmp[i] = -1;

	for(i = 0; i < maxsize; i++){

		/* Generate random position table */
		while(1){
			tmpindex = myrandom() % maxsize;
			if(tmp[tmpindex] == -1) {
				tmp[tmpindex] = i;
				break;
			}
		}

		x = (tmpindex % xsize) * app_data.blockSteps;
		y = (tmpindex / xsize) * app_data.blockSteps;

		if(( (x + xof) < 0 && (y + yof) < 0) 
			|| ((x + xof) >= windowW && (y + yof) >= windowH) )
			continue;

		XClearArea(
				theDisp,
				theWindow,
				x + xof,
				y + yof,
				((x + app_data.blockSteps) < blockW ? app_data.blockSteps : blockW - x),
				((y + app_data.blockSteps) < blockH ? app_data.blockSteps : blockH - y),
				False);

		myusleep(0); /* Flush */
		if(gotSomeAction == True)
			break;
	}
	XtFree((char *)tmp);
}

#if defined(__STDC__) || defined(__cplusplus)
int xblockshow(char *fname)
#else
int xblockshow(fname)
char *fname;
#endif
{
	blockW = gim.subImageList->width;
	blockH = gim.subImageList->height;
	windowW = windowWidth;
	windowH = windowHeight;

	PreDisplay();
	StoreColors(xcolors,gim.subImageList->mapsize);

	if(app_data.showFileName)
		createFileNameWindow(fname);

	blockIn();

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxblockshow(char *fname)
#else
void postxblockshow(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();

	blockOut();
}

#if defined(__STDC__) || defined(__cplusplus)
int xblockshow24(char *fname)
#else
int xblockshow24(fname)
char *fname;
#endif
{
	blockW = gim.subImageList->width;
	blockH = gim.subImageList->height;
	windowW = windowWidth;
	windowH = windowHeight;

	PreDisplay2();
	StoreColors(xcolors,gim.subImageList->mapsize);

	if(app_data.showFileName)
		createFileNameWindow(fname);

	blockIn();

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxblockshow24(char *fname)
#else
void postxblockshow24(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();
}

