/********************************************************************************
* Copyright (c) Erik Kunze 1998 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if defined(sgi) && !defined(NAS_AUDIO) && !defined(OSS_AUDIO)
#ifndef lint
static char rcsid[] = "$Id: irix.c,v 1.13 1999/03/16 11:35:38 erik Rel $";
#endif
#include <sys/types.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <signal.h>
#include <dmedia/audio.h>
#include <errno.h>
#include "debug.h"
#include "resource.h"
#include "util.h"
#include "main.h"
#include "audio.h"
static ALport audioPort = (ALport)-1;
static ALconfig audioConfig;
static sigset_t blockingSet;
int
OsdOpenAudioDevice(char *device, int sample)
{
#if HAVE_al_FUNCS
ALpv pvs[4];
int alIsBusy = 0;
pvs[0].param = AL_MAX_PORTS;
pvs[1].param = AL_UNUSED_PORTS;
if (alGetParams(AL_SYSTEM, pvs, 2) < 0)
{
return -1;
}
if (pvs[1].value.i < 1)
{
Msg(M_WARN, "audio device in use");
return -1;
}
if (pvs[1].value.i < pvs[0].value.i)
{
pvs[0].param = AL_RATE;
if (alGetParams(AL_DEFAULT_OUTPUT,pvs,1) < 0)
{
return -1;
}
sample = pvs[0].value.i;
alIsBusy = 1;
}
if ((audioConfig = alNewConfig()) == (ALconfig)0)
{
return -1;
}
if (alSetChannels(audioConfig, AL_MONO) == -1
|| alSetQueueSize(audioConfig, 10000L) == -1
|| alSetSampFmt(audioConfig, AL_SAMPFMT_TWOSCOMP) == -1
|| alSetWidth(audioConfig,AL_SAMPLE_8) == -1)
{
Msg(M_ERR, "couldn't set channel-specific parameters");
(void)alFreeConfig(audioConfig);
return -1;
}
pvs[0].param = AL_MASTER_CLOCK;
pvs[0].value.i = AL_CRYSTAL_MCLK_TYPE;
pvs[1].param = AL_RATE;
pvs[1].value.i = sample;
if (!alIsBusy)
{
if (alSetParams( AL_DEFAULT_OUTPUT,pvs,2) < 0) {
Msg(M_ERR, "couldn't set audio-device parameters");
(void)alFreeConfig(audioConfig);
return -1;
}
}
if ((audioPort = alOpenPort(Version, "w", audioConfig)) == (ALport)0)
{
Msg(M_ERR, "couldn't open audio device for writing");
audioPort = (ALport)-1;
(void)alFreeConfig(audioConfig);
return -1;
}
#else
long param[10];
param[0] = AL_INPUT_COUNT;
param[2] = AL_OUTPUT_COUNT;
(void)ALgetparams(AL_DEFAULT_DEVICE, param, 4);
if (param[1] || param[3])
{
Msg(M_WARN, "audio device in use");
return -1;
}
if ((audioConfig = ALnewconfig()) == (ALconfig)0)
{
return -1;
}
if (ALsetchannels(audioConfig, AL_MONO) < 0
|| ALsetqueuesize(audioConfig, 10000L) < 0
|| ALsetsampfmt(audioConfig, AL_SAMPFMT_TWOSCOMP) < 0
|| ALsetwidth(audioConfig,AL_SAMPLE_8) < 0)
{
Msg(M_ERR, "couldn't set channel-specific parameters");
(void)ALfreeconfig(audioConfig);
return -1;
}
param[0] = AL_OUTPUT_RATE;
param[1] = (long)sample;
param[2] = AL_INPUT_RATE;
param[3] = (long)sample;
param[4] = AL_RIGHT_SPEAKER_GAIN;
param[5] = 64L;
param[6] = AL_LEFT_SPEAKER_GAIN;
param[7] = 64L;
param[8] = AL_SPEAKER_MUTE_CTL;
param[9] = AL_SPEAKER_MUTE_OFF;
if (ALsetparams(AL_DEFAULT_DEVICE, param, 10) < 0)
{
Msg(M_ERR, "couldn't set audio-device parameters");
(void)ALfreeconfig(audioConfig);
return -1;
}
if ((audioPort = ALopenport(Version, "w", audioConfig)) == (ALport)0)
{
Msg(M_ERR, "couldn't open audio device for writing");
audioPort = (ALport)-1;
(void)ALfreeconfig(audioConfig);
return -1;
}
#endif
sigemptyset(&blockingSet);
sigaddset(&blockingSet, SIGALRM);
return sample;
}
void
OsdCloseAudioDevice(void)
{
if (audioPort != (ALport)-1)
{
#if HAVE_al_FUNCS
(void)alClosePort(audioPort);
audioPort = (ALport)-1;
(void)alFreeConfig(audioConfig);
#else
(void)ALcloseport(audioPort);
audioPort = (ALport)-1;
(void)ALfreeconfig(audioConfig);
#endif
}
}
int
OsdDrainAudioDevice(void)
{
return 0;
}
size_t
OsdGetAudioFreespace(void)
{
#if HAVE_al_FUNCS
return ((size_t)alGetFillable(audioPort));
#else
return ((size_t)ALgetfillable(audioPort));
#endif
}
size_t
OsdPlayAudioBuffer(unsigned char *buf, size_t len)
{
sigset_t oldSet;
size_t written, i;
for (i = 0; i < len; i++)
{
buf[i] ^= 0x80;
}
(void)sigprocmask(SIG_BLOCK, &blockingSet, &oldSet);
#if HAVE_al_FUNCS
if ((written = alWriteFrames(audioPort, buf, (long)len)) < 0)
#else
if ((written = ALwritesamps(audioPort, buf, (long)len)) < 0)
#endif
{
Msg(M_PERR, "couldn't write to audio device");
}
else
{
written = len;
}
if (!sigismember(&oldSet, SIGALRM))
{
(void)sigprocmask(SIG_UNBLOCK, &blockingSet, NULL);
}
return written;
}
#endif
