// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package elb provides a client for Elastic Load Balancing.
package elb

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a request for the AddTags operation.
func (c *ELB) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsOutput{}
	req.Data = output
	return
}

// Adds the specified tags to the specified load balancer. Each load balancer
// can have a maximum of 10 tags.
//
// Each tag consists of a key and an optional value. If a tag with the same
// key is already associated with the load balancer, AddTags updates its value.
//
// For more information, see Tag Your Load Balancer (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/add-remove-tags.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	err := req.Send()
	return out, err
}

const opApplySecurityGroupsToLoadBalancer = "ApplySecurityGroupsToLoadBalancer"

// ApplySecurityGroupsToLoadBalancerRequest generates a request for the ApplySecurityGroupsToLoadBalancer operation.
func (c *ELB) ApplySecurityGroupsToLoadBalancerRequest(input *ApplySecurityGroupsToLoadBalancerInput) (req *request.Request, output *ApplySecurityGroupsToLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opApplySecurityGroupsToLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplySecurityGroupsToLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ApplySecurityGroupsToLoadBalancerOutput{}
	req.Data = output
	return
}

// Associates one or more security groups with your load balancer in a virtual
// private cloud (VPC). The specified security groups override the previously
// associated security groups.
//
// For more information, see Security Groups for Load Balancers in a VPC (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-security-groups.html#elb-vpc-security-groups)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) ApplySecurityGroupsToLoadBalancer(input *ApplySecurityGroupsToLoadBalancerInput) (*ApplySecurityGroupsToLoadBalancerOutput, error) {
	req, out := c.ApplySecurityGroupsToLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opAttachLoadBalancerToSubnets = "AttachLoadBalancerToSubnets"

// AttachLoadBalancerToSubnetsRequest generates a request for the AttachLoadBalancerToSubnets operation.
func (c *ELB) AttachLoadBalancerToSubnetsRequest(input *AttachLoadBalancerToSubnetsInput) (req *request.Request, output *AttachLoadBalancerToSubnetsOutput) {
	op := &request.Operation{
		Name:       opAttachLoadBalancerToSubnets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachLoadBalancerToSubnetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachLoadBalancerToSubnetsOutput{}
	req.Data = output
	return
}

// Adds one or more subnets to the set of configured subnets for the specified
// load balancer.
//
// The load balancer evenly distributes requests across all registered subnets.
// For more information, see Add or Remove Subnets for Your Load Balancer in
// a VPC (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-manage-subnets.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) AttachLoadBalancerToSubnets(input *AttachLoadBalancerToSubnetsInput) (*AttachLoadBalancerToSubnetsOutput, error) {
	req, out := c.AttachLoadBalancerToSubnetsRequest(input)
	err := req.Send()
	return out, err
}

const opConfigureHealthCheck = "ConfigureHealthCheck"

// ConfigureHealthCheckRequest generates a request for the ConfigureHealthCheck operation.
func (c *ELB) ConfigureHealthCheckRequest(input *ConfigureHealthCheckInput) (req *request.Request, output *ConfigureHealthCheckOutput) {
	op := &request.Operation{
		Name:       opConfigureHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfigureHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConfigureHealthCheckOutput{}
	req.Data = output
	return
}

// Specifies the health check settings to use when evaluating the health state
// of your back-end instances.
//
// For more information, see Configure Health Checks (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-healthchecks.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) ConfigureHealthCheck(input *ConfigureHealthCheckInput) (*ConfigureHealthCheckOutput, error) {
	req, out := c.ConfigureHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAppCookieStickinessPolicy = "CreateAppCookieStickinessPolicy"

// CreateAppCookieStickinessPolicyRequest generates a request for the CreateAppCookieStickinessPolicy operation.
func (c *ELB) CreateAppCookieStickinessPolicyRequest(input *CreateAppCookieStickinessPolicyInput) (req *request.Request, output *CreateAppCookieStickinessPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateAppCookieStickinessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAppCookieStickinessPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAppCookieStickinessPolicyOutput{}
	req.Data = output
	return
}

// Generates a stickiness policy with sticky session lifetimes that follow that
// of an application-generated cookie. This policy can be associated only with
// HTTP/HTTPS listeners.
//
// This policy is similar to the policy created by CreateLBCookieStickinessPolicy,
// except that the lifetime of the special Elastic Load Balancing cookie, AWSELB,
// follows the lifetime of the application-generated cookie specified in the
// policy configuration. The load balancer only inserts a new stickiness cookie
// when the application response includes a new application cookie.
//
// If the application cookie is explicitly removed or expires, the session
// stops being sticky until a new application cookie is issued.
//
// For more information, see Application-Controlled Session Stickiness (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-sticky-sessions.html#enable-sticky-sessions-application)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) CreateAppCookieStickinessPolicy(input *CreateAppCookieStickinessPolicyInput) (*CreateAppCookieStickinessPolicyOutput, error) {
	req, out := c.CreateAppCookieStickinessPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLBCookieStickinessPolicy = "CreateLBCookieStickinessPolicy"

// CreateLBCookieStickinessPolicyRequest generates a request for the CreateLBCookieStickinessPolicy operation.
func (c *ELB) CreateLBCookieStickinessPolicyRequest(input *CreateLBCookieStickinessPolicyInput) (req *request.Request, output *CreateLBCookieStickinessPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateLBCookieStickinessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLBCookieStickinessPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateLBCookieStickinessPolicyOutput{}
	req.Data = output
	return
}

// Generates a stickiness policy with sticky session lifetimes controlled by
// the lifetime of the browser (user-agent) or a specified expiration period.
// This policy can be associated only with HTTP/HTTPS listeners.
//
// When a load balancer implements this policy, the load balancer uses a special
// cookie to track the back-end server instance for each request. When the load
// balancer receives a request, it first checks to see if this cookie is present
// in the request. If so, the load balancer sends the request to the application
// server specified in the cookie. If not, the load balancer sends the request
// to a server that is chosen based on the existing load-balancing algorithm.
//
// A cookie is inserted into the response for binding subsequent requests from
// the same user to that server. The validity of the cookie is based on the
// cookie expiration time, which is specified in the policy configuration.
//
// For more information, see Duration-Based Session Stickiness (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-sticky-sessions.html#enable-sticky-sessions-duration)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) CreateLBCookieStickinessPolicy(input *CreateLBCookieStickinessPolicyInput) (*CreateLBCookieStickinessPolicyOutput, error) {
	req, out := c.CreateLBCookieStickinessPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLoadBalancer = "CreateLoadBalancer"

// CreateLoadBalancerRequest generates a request for the CreateLoadBalancer operation.
func (c *ELB) CreateLoadBalancerRequest(input *CreateLoadBalancerInput) (req *request.Request, output *CreateLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opCreateLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateLoadBalancerOutput{}
	req.Data = output
	return
}

// Creates a load balancer.
//
// If the call completes successfully, a new load balancer is created with
// a unique Domain Name Service (DNS) name. The load balancer receives incoming
// traffic and routes it to the registered instances. For more information,
// see How Elastic Load Balancing Works (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/how-elb-works.html)
// in the Elastic Load Balancing Developer Guide.
//
// You can create up to 20 load balancers per region per account. You can request
// an increase for the number of load balancers for your account. For more information,
// see Elastic Load Balancing Limits (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-limits.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) CreateLoadBalancer(input *CreateLoadBalancerInput) (*CreateLoadBalancerOutput, error) {
	req, out := c.CreateLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLoadBalancerListeners = "CreateLoadBalancerListeners"

// CreateLoadBalancerListenersRequest generates a request for the CreateLoadBalancerListeners operation.
func (c *ELB) CreateLoadBalancerListenersRequest(input *CreateLoadBalancerListenersInput) (req *request.Request, output *CreateLoadBalancerListenersOutput) {
	op := &request.Operation{
		Name:       opCreateLoadBalancerListeners,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerListenersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateLoadBalancerListenersOutput{}
	req.Data = output
	return
}

// Creates one or more listeners for the specified load balancer. If a listener
// with the specified port does not already exist, it is created; otherwise,
// the properties of the new listener must match the properties of the existing
// listener.
//
// For more information, see Add a Listener to Your Load Balancer (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/us-add-listener.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) CreateLoadBalancerListeners(input *CreateLoadBalancerListenersInput) (*CreateLoadBalancerListenersOutput, error) {
	req, out := c.CreateLoadBalancerListenersRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLoadBalancerPolicy = "CreateLoadBalancerPolicy"

// CreateLoadBalancerPolicyRequest generates a request for the CreateLoadBalancerPolicy operation.
func (c *ELB) CreateLoadBalancerPolicyRequest(input *CreateLoadBalancerPolicyInput) (req *request.Request, output *CreateLoadBalancerPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateLoadBalancerPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateLoadBalancerPolicyOutput{}
	req.Data = output
	return
}

// Creates a policy with the specified attributes for the specified load balancer.
//
// Policies are settings that are saved for your load balancer and that can
// be applied to the front-end listener or the back-end application server,
// depending on the policy type.
func (c *ELB) CreateLoadBalancerPolicy(input *CreateLoadBalancerPolicyInput) (*CreateLoadBalancerPolicyOutput, error) {
	req, out := c.CreateLoadBalancerPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLoadBalancer = "DeleteLoadBalancer"

// DeleteLoadBalancerRequest generates a request for the DeleteLoadBalancer operation.
func (c *ELB) DeleteLoadBalancerRequest(input *DeleteLoadBalancerInput) (req *request.Request, output *DeleteLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opDeleteLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteLoadBalancerOutput{}
	req.Data = output
	return
}

// Deletes the specified load balancer.
//
// If you are attempting to recreate a load balancer, you must reconfigure
// all settings. The DNS name associated with a deleted load balancer are no
// longer usable. The name and associated DNS record of the deleted load balancer
// no longer exist and traffic sent to any of its IP addresses is no longer
// delivered to back-end instances.
//
// If the load balancer does not exist or has already been deleted, the call
// to DeleteLoadBalancer still succeeds.
func (c *ELB) DeleteLoadBalancer(input *DeleteLoadBalancerInput) (*DeleteLoadBalancerOutput, error) {
	req, out := c.DeleteLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLoadBalancerListeners = "DeleteLoadBalancerListeners"

// DeleteLoadBalancerListenersRequest generates a request for the DeleteLoadBalancerListeners operation.
func (c *ELB) DeleteLoadBalancerListenersRequest(input *DeleteLoadBalancerListenersInput) (req *request.Request, output *DeleteLoadBalancerListenersOutput) {
	op := &request.Operation{
		Name:       opDeleteLoadBalancerListeners,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerListenersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteLoadBalancerListenersOutput{}
	req.Data = output
	return
}

// Deletes the specified listeners from the specified load balancer.
func (c *ELB) DeleteLoadBalancerListeners(input *DeleteLoadBalancerListenersInput) (*DeleteLoadBalancerListenersOutput, error) {
	req, out := c.DeleteLoadBalancerListenersRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLoadBalancerPolicy = "DeleteLoadBalancerPolicy"

// DeleteLoadBalancerPolicyRequest generates a request for the DeleteLoadBalancerPolicy operation.
func (c *ELB) DeleteLoadBalancerPolicyRequest(input *DeleteLoadBalancerPolicyInput) (req *request.Request, output *DeleteLoadBalancerPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteLoadBalancerPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteLoadBalancerPolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified policy from the specified load balancer. This policy
// must not be enabled for any listeners.
func (c *ELB) DeleteLoadBalancerPolicy(input *DeleteLoadBalancerPolicyInput) (*DeleteLoadBalancerPolicyOutput, error) {
	req, out := c.DeleteLoadBalancerPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterInstancesFromLoadBalancer = "DeregisterInstancesFromLoadBalancer"

// DeregisterInstancesFromLoadBalancerRequest generates a request for the DeregisterInstancesFromLoadBalancer operation.
func (c *ELB) DeregisterInstancesFromLoadBalancerRequest(input *DeregisterInstancesFromLoadBalancerInput) (req *request.Request, output *DeregisterInstancesFromLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opDeregisterInstancesFromLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterInstancesFromLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterInstancesFromLoadBalancerOutput{}
	req.Data = output
	return
}

// Deregisters the specified instances from the specified load balancer. After
// the instance is deregistered, it no longer receives traffic from the load
// balancer.
//
// You can use DescribeLoadBalancers to verify that the instance is deregistered
// from the load balancer.
//
// For more information, see Deregister and Register Amazon EC2 Instances (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_DeReg_Reg_Instances.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) DeregisterInstancesFromLoadBalancer(input *DeregisterInstancesFromLoadBalancerInput) (*DeregisterInstancesFromLoadBalancerOutput, error) {
	req, out := c.DeregisterInstancesFromLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInstanceHealth = "DescribeInstanceHealth"

// DescribeInstanceHealthRequest generates a request for the DescribeInstanceHealth operation.
func (c *ELB) DescribeInstanceHealthRequest(input *DescribeInstanceHealthInput) (req *request.Request, output *DescribeInstanceHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceHealthInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeInstanceHealthOutput{}
	req.Data = output
	return
}

// Describes the state of the specified instances with respect to the specified
// load balancer. If no instances are specified, the call describes the state
// of all instances that are currently registered with the load balancer. If
// instances are specified, their state is returned even if they are no longer
// registered with the load balancer. The state of terminated instances is not
// returned.
func (c *ELB) DescribeInstanceHealth(input *DescribeInstanceHealthInput) (*DescribeInstanceHealthOutput, error) {
	req, out := c.DescribeInstanceHealthRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLoadBalancerAttributes = "DescribeLoadBalancerAttributes"

// DescribeLoadBalancerAttributesRequest generates a request for the DescribeLoadBalancerAttributes operation.
func (c *ELB) DescribeLoadBalancerAttributesRequest(input *DescribeLoadBalancerAttributesInput) (req *request.Request, output *DescribeLoadBalancerAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancerAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancerAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLoadBalancerAttributesOutput{}
	req.Data = output
	return
}

// Describes the attributes for the specified load balancer.
func (c *ELB) DescribeLoadBalancerAttributes(input *DescribeLoadBalancerAttributesInput) (*DescribeLoadBalancerAttributesOutput, error) {
	req, out := c.DescribeLoadBalancerAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLoadBalancerPolicies = "DescribeLoadBalancerPolicies"

// DescribeLoadBalancerPoliciesRequest generates a request for the DescribeLoadBalancerPolicies operation.
func (c *ELB) DescribeLoadBalancerPoliciesRequest(input *DescribeLoadBalancerPoliciesInput) (req *request.Request, output *DescribeLoadBalancerPoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancerPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancerPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLoadBalancerPoliciesOutput{}
	req.Data = output
	return
}

// Describes the specified policies.
//
// If you specify a load balancer name, the action returns the descriptions
// of all policies created for the load balancer. If you specify a policy name
// associated with your load balancer, the action returns the description of
// that policy. If you don't specify a load balancer name, the action returns
// descriptions of the specified sample policies, or descriptions of all sample
// policies. The names of the sample policies have the ELBSample- prefix.
func (c *ELB) DescribeLoadBalancerPolicies(input *DescribeLoadBalancerPoliciesInput) (*DescribeLoadBalancerPoliciesOutput, error) {
	req, out := c.DescribeLoadBalancerPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLoadBalancerPolicyTypes = "DescribeLoadBalancerPolicyTypes"

// DescribeLoadBalancerPolicyTypesRequest generates a request for the DescribeLoadBalancerPolicyTypes operation.
func (c *ELB) DescribeLoadBalancerPolicyTypesRequest(input *DescribeLoadBalancerPolicyTypesInput) (req *request.Request, output *DescribeLoadBalancerPolicyTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancerPolicyTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancerPolicyTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLoadBalancerPolicyTypesOutput{}
	req.Data = output
	return
}

// Describes the specified load balancer policy types.
//
// You can use these policy types with CreateLoadBalancerPolicy to create policy
// configurations for a load balancer.
func (c *ELB) DescribeLoadBalancerPolicyTypes(input *DescribeLoadBalancerPolicyTypesInput) (*DescribeLoadBalancerPolicyTypesOutput, error) {
	req, out := c.DescribeLoadBalancerPolicyTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLoadBalancers = "DescribeLoadBalancers"

// DescribeLoadBalancersRequest generates a request for the DescribeLoadBalancers operation.
func (c *ELB) DescribeLoadBalancersRequest(input *DescribeLoadBalancersInput) (req *request.Request, output *DescribeLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLoadBalancersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLoadBalancersOutput{}
	req.Data = output
	return
}

// Describes the specified the load balancers. If no load balancers are specified,
// the call describes all of your load balancers.
func (c *ELB) DescribeLoadBalancers(input *DescribeLoadBalancersInput) (*DescribeLoadBalancersOutput, error) {
	req, out := c.DescribeLoadBalancersRequest(input)
	err := req.Send()
	return out, err
}

func (c *ELB) DescribeLoadBalancersPages(input *DescribeLoadBalancersInput, fn func(p *DescribeLoadBalancersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeLoadBalancersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeLoadBalancersOutput), lastPage)
	})
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a request for the DescribeTags operation.
func (c *ELB) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTagsOutput{}
	req.Data = output
	return
}

// Describes the tags associated with the specified load balancers.
func (c *ELB) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDetachLoadBalancerFromSubnets = "DetachLoadBalancerFromSubnets"

// DetachLoadBalancerFromSubnetsRequest generates a request for the DetachLoadBalancerFromSubnets operation.
func (c *ELB) DetachLoadBalancerFromSubnetsRequest(input *DetachLoadBalancerFromSubnetsInput) (req *request.Request, output *DetachLoadBalancerFromSubnetsOutput) {
	op := &request.Operation{
		Name:       opDetachLoadBalancerFromSubnets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachLoadBalancerFromSubnetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachLoadBalancerFromSubnetsOutput{}
	req.Data = output
	return
}

// Removes the specified subnets from the set of configured subnets for the
// load balancer.
//
// After a subnet is removed, all EC2 instances registered with the load balancer
// in the removed subnet go into the OutOfService state. Then, the load balancer
// balances the traffic among the remaining routable subnets.
func (c *ELB) DetachLoadBalancerFromSubnets(input *DetachLoadBalancerFromSubnetsInput) (*DetachLoadBalancerFromSubnetsOutput, error) {
	req, out := c.DetachLoadBalancerFromSubnetsRequest(input)
	err := req.Send()
	return out, err
}

const opDisableAvailabilityZonesForLoadBalancer = "DisableAvailabilityZonesForLoadBalancer"

// DisableAvailabilityZonesForLoadBalancerRequest generates a request for the DisableAvailabilityZonesForLoadBalancer operation.
func (c *ELB) DisableAvailabilityZonesForLoadBalancerRequest(input *DisableAvailabilityZonesForLoadBalancerInput) (req *request.Request, output *DisableAvailabilityZonesForLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opDisableAvailabilityZonesForLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableAvailabilityZonesForLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableAvailabilityZonesForLoadBalancerOutput{}
	req.Data = output
	return
}

// Removes the specified Availability Zones from the set of Availability Zones
// for the specified load balancer.
//
// There must be at least one Availability Zone registered with a load balancer
// at all times. After an Availability Zone is removed, all instances registered
// with the load balancer that are in the removed Availability Zone go into
// the OutOfService state. Then, the load balancer attempts to equally balance
// the traffic among its remaining Availability Zones.
//
// For more information, see Disable an Availability Zone from a Load-Balanced
// Application (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_ShrinkLBApp04.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) DisableAvailabilityZonesForLoadBalancer(input *DisableAvailabilityZonesForLoadBalancerInput) (*DisableAvailabilityZonesForLoadBalancerOutput, error) {
	req, out := c.DisableAvailabilityZonesForLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opEnableAvailabilityZonesForLoadBalancer = "EnableAvailabilityZonesForLoadBalancer"

// EnableAvailabilityZonesForLoadBalancerRequest generates a request for the EnableAvailabilityZonesForLoadBalancer operation.
func (c *ELB) EnableAvailabilityZonesForLoadBalancerRequest(input *EnableAvailabilityZonesForLoadBalancerInput) (req *request.Request, output *EnableAvailabilityZonesForLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opEnableAvailabilityZonesForLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAvailabilityZonesForLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableAvailabilityZonesForLoadBalancerOutput{}
	req.Data = output
	return
}

// Adds the specified Availability Zones to the set of Availability Zones for
// the specified load balancer.
//
// The load balancer evenly distributes requests across all its registered
// Availability Zones that contain instances.
//
// For more information, see Add Availability Zone (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_AddLBAvailabilityZone.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) EnableAvailabilityZonesForLoadBalancer(input *EnableAvailabilityZonesForLoadBalancerInput) (*EnableAvailabilityZonesForLoadBalancerOutput, error) {
	req, out := c.EnableAvailabilityZonesForLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opModifyLoadBalancerAttributes = "ModifyLoadBalancerAttributes"

// ModifyLoadBalancerAttributesRequest generates a request for the ModifyLoadBalancerAttributes operation.
func (c *ELB) ModifyLoadBalancerAttributesRequest(input *ModifyLoadBalancerAttributesInput) (req *request.Request, output *ModifyLoadBalancerAttributesOutput) {
	op := &request.Operation{
		Name:       opModifyLoadBalancerAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyLoadBalancerAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyLoadBalancerAttributesOutput{}
	req.Data = output
	return
}

// Modifies the attributes of the specified load balancer.
//
// You can modify the load balancer attributes, such as AccessLogs, ConnectionDraining,
// and CrossZoneLoadBalancing by either enabling or disabling them. Or, you
// can modify the load balancer attribute ConnectionSettings by specifying an
// idle connection timeout value for your load balancer.
//
// For more information, see the following in the Elastic Load Balancing Developer
// Guide:
//
//  Cross-Zone Load Balancing (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#request-routing)
// Connection Draining (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain)
// Access Logs (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/access-log-collection.html)
// Idle Connection Timeout (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#idle-timeout)
func (c *ELB) ModifyLoadBalancerAttributes(input *ModifyLoadBalancerAttributesInput) (*ModifyLoadBalancerAttributesOutput, error) {
	req, out := c.ModifyLoadBalancerAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterInstancesWithLoadBalancer = "RegisterInstancesWithLoadBalancer"

// RegisterInstancesWithLoadBalancerRequest generates a request for the RegisterInstancesWithLoadBalancer operation.
func (c *ELB) RegisterInstancesWithLoadBalancerRequest(input *RegisterInstancesWithLoadBalancerInput) (req *request.Request, output *RegisterInstancesWithLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opRegisterInstancesWithLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterInstancesWithLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterInstancesWithLoadBalancerOutput{}
	req.Data = output
	return
}

// Adds the specified instances to the specified load balancer.
//
// The instance must be a running instance in the same network as the load
// balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances
// and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic
// instances to that VPC and then register the linked EC2-Classic instances
// with the load balancer in the VPC.
//
// Note that RegisterInstanceWithLoadBalancer completes when the request has
// been registered. Instance registration takes a little time to complete. To
// check the state of the registered instances, use DescribeLoadBalancers or
// DescribeInstanceHealth.
//
// After the instance is registered, it starts receiving traffic and requests
// from the load balancer. Any instance that is not in one of the Availability
// Zones registered for the load balancer is moved to the OutOfService state.
// If an Availability Zone is added to the load balancer later, any instances
// registered with the load balancer move to the InService state.
//
// If you stop an instance registered with a load balancer and then start it,
// the IP addresses associated with the instance changes. Elastic Load Balancing
// cannot recognize the new IP address, which prevents it from routing traffic
// to the instances. We recommend that you use the following sequence: stop
// the instance, deregister the instance, start the instance, and then register
// the instance. To deregister instances from a load balancer, use DeregisterInstancesFromLoadBalancer.
//
// For more information, see Deregister and Register EC2 Instances (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_DeReg_Reg_Instances.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) RegisterInstancesWithLoadBalancer(input *RegisterInstancesWithLoadBalancerInput) (*RegisterInstancesWithLoadBalancerOutput, error) {
	req, out := c.RegisterInstancesWithLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a request for the RemoveTags operation.
func (c *ELB) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsOutput{}
	req.Data = output
	return
}

// Removes one or more tags from the specified load balancer.
func (c *ELB) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	err := req.Send()
	return out, err
}

const opSetLoadBalancerListenerSSLCertificate = "SetLoadBalancerListenerSSLCertificate"

// SetLoadBalancerListenerSSLCertificateRequest generates a request for the SetLoadBalancerListenerSSLCertificate operation.
func (c *ELB) SetLoadBalancerListenerSSLCertificateRequest(input *SetLoadBalancerListenerSSLCertificateInput) (req *request.Request, output *SetLoadBalancerListenerSSLCertificateOutput) {
	op := &request.Operation{
		Name:       opSetLoadBalancerListenerSSLCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetLoadBalancerListenerSSLCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetLoadBalancerListenerSSLCertificateOutput{}
	req.Data = output
	return
}

// Sets the certificate that terminates the specified listener's SSL connections.
// The specified certificate replaces any prior certificate that was used on
// the same load balancer and port.
//
// For more information about updating your SSL certificate, see Updating an
// SSL Certificate for a Load Balancer (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/US_UpdatingLoadBalancerSSL.html)
// in the Elastic Load Balancing Developer Guide.
func (c *ELB) SetLoadBalancerListenerSSLCertificate(input *SetLoadBalancerListenerSSLCertificateInput) (*SetLoadBalancerListenerSSLCertificateOutput, error) {
	req, out := c.SetLoadBalancerListenerSSLCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opSetLoadBalancerPoliciesForBackendServer = "SetLoadBalancerPoliciesForBackendServer"

// SetLoadBalancerPoliciesForBackendServerRequest generates a request for the SetLoadBalancerPoliciesForBackendServer operation.
func (c *ELB) SetLoadBalancerPoliciesForBackendServerRequest(input *SetLoadBalancerPoliciesForBackendServerInput) (req *request.Request, output *SetLoadBalancerPoliciesForBackendServerOutput) {
	op := &request.Operation{
		Name:       opSetLoadBalancerPoliciesForBackendServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetLoadBalancerPoliciesForBackendServerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetLoadBalancerPoliciesForBackendServerOutput{}
	req.Data = output
	return
}

// Replaces the set of policies associated with the specified port on which
// the back-end server is listening with a new set of policies. At this time,
// only the back-end server authentication policy type can be applied to the
// back-end ports; this policy type is composed of multiple public key policies.
//
// Each time you use SetLoadBalancerPoliciesForBackendServer to enable the
// policies, use the PolicyNames parameter to list the policies that you want
// to enable.
//
// You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to verify
// that the policy is associated with the back-end server.
func (c *ELB) SetLoadBalancerPoliciesForBackendServer(input *SetLoadBalancerPoliciesForBackendServerInput) (*SetLoadBalancerPoliciesForBackendServerOutput, error) {
	req, out := c.SetLoadBalancerPoliciesForBackendServerRequest(input)
	err := req.Send()
	return out, err
}

const opSetLoadBalancerPoliciesOfListener = "SetLoadBalancerPoliciesOfListener"

// SetLoadBalancerPoliciesOfListenerRequest generates a request for the SetLoadBalancerPoliciesOfListener operation.
func (c *ELB) SetLoadBalancerPoliciesOfListenerRequest(input *SetLoadBalancerPoliciesOfListenerInput) (req *request.Request, output *SetLoadBalancerPoliciesOfListenerOutput) {
	op := &request.Operation{
		Name:       opSetLoadBalancerPoliciesOfListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetLoadBalancerPoliciesOfListenerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetLoadBalancerPoliciesOfListenerOutput{}
	req.Data = output
	return
}

// Associates, updates, or disables a policy with a listener for the specified
// load balancer. You can associate multiple policies with a listener.
func (c *ELB) SetLoadBalancerPoliciesOfListener(input *SetLoadBalancerPoliciesOfListenerInput) (*SetLoadBalancerPoliciesOfListenerOutput, error) {
	req, out := c.SetLoadBalancerPoliciesOfListenerRequest(input)
	err := req.Send()
	return out, err
}

// Information about the AccessLog attribute.
type AccessLog struct {
	_ struct{} `type:"structure"`

	// The interval for publishing the access logs. You can specify an interval
	// of either 5 minutes or 60 minutes.
	//
	// Default: 60 minutes
	EmitInterval *int64 `type:"integer"`

	// Specifies whether access log is enabled for the load balancer.
	Enabled *bool `type:"boolean" required:"true"`

	// The name of the Amazon S3 bucket where the access logs are stored.
	S3BucketName *string `type:"string"`

	// The logical hierarchy you created for your Amazon S3 bucket, for example
	// my-bucket-prefix/prod. If the prefix is not provided, the log is placed at
	// the root level of the bucket.
	S3BucketPrefix *string `type:"string"`
}

// String returns the string representation
func (s AccessLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessLog) GoString() string {
	return s.String()
}

type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer. You can specify one load balancer only.
	LoadBalancerNames []*string `type:"list" required:"true"`

	// The tags.
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// This data type is reserved.
type AdditionalAttribute struct {
	_ struct{} `type:"structure"`

	// This parameter is reserved.
	Key *string `type:"string"`

	// This parameter is reserved.
	Value *string `type:"string"`
}

// String returns the string representation
func (s AdditionalAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdditionalAttribute) GoString() string {
	return s.String()
}

// Information about a policy for application-controlled session stickiness.
type AppCookieStickinessPolicy struct {
	_ struct{} `type:"structure"`

	// The name of the application cookie used for stickiness.
	CookieName *string `type:"string"`

	// The mnemonic name for the policy being created. The name must be unique within
	// a set of policies for this load balancer.
	PolicyName *string `type:"string"`
}

// String returns the string representation
func (s AppCookieStickinessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AppCookieStickinessPolicy) GoString() string {
	return s.String()
}

type ApplySecurityGroupsToLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The IDs of the security groups to associate with the load balancer. Note
	// that you cannot specify the name of the security group.
	SecurityGroups []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ApplySecurityGroupsToLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplySecurityGroupsToLoadBalancerInput) GoString() string {
	return s.String()
}

type ApplySecurityGroupsToLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the security groups associated with the load balancer.
	SecurityGroups []*string `type:"list"`
}

// String returns the string representation
func (s ApplySecurityGroupsToLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplySecurityGroupsToLoadBalancerOutput) GoString() string {
	return s.String()
}

type AttachLoadBalancerToSubnetsInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The IDs of the subnets to add for the load balancer. You can add only one
	// subnet per Availability Zone.
	Subnets []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AttachLoadBalancerToSubnetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancerToSubnetsInput) GoString() string {
	return s.String()
}

type AttachLoadBalancerToSubnetsOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the subnets attached to the load balancer.
	Subnets []*string `type:"list"`
}

// String returns the string representation
func (s AttachLoadBalancerToSubnetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancerToSubnetsOutput) GoString() string {
	return s.String()
}

// Information about the configuration of a back-end server.
type BackendServerDescription struct {
	_ struct{} `type:"structure"`

	// The port on which the back-end server is listening.
	InstancePort *int64 `min:"1" type:"integer"`

	// The names of the policies enabled for the back-end server.
	PolicyNames []*string `type:"list"`
}

// String returns the string representation
func (s BackendServerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BackendServerDescription) GoString() string {
	return s.String()
}

type ConfigureHealthCheckInput struct {
	_ struct{} `type:"structure"`

	// The configuration information for the new health check.
	HealthCheck *HealthCheck `type:"structure" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ConfigureHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigureHealthCheckInput) GoString() string {
	return s.String()
}

type ConfigureHealthCheckOutput struct {
	_ struct{} `type:"structure"`

	// The updated health check.
	HealthCheck *HealthCheck `type:"structure"`
}

// String returns the string representation
func (s ConfigureHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigureHealthCheckOutput) GoString() string {
	return s.String()
}

// Information about the ConnectionDraining attribute.
type ConnectionDraining struct {
	_ struct{} `type:"structure"`

	// Specifies whether connection draining is enabled for the load balancer.
	Enabled *bool `type:"boolean" required:"true"`

	// The maximum time, in seconds, to keep the existing connections open before
	// deregistering the instances.
	Timeout *int64 `type:"integer"`
}

// String returns the string representation
func (s ConnectionDraining) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionDraining) GoString() string {
	return s.String()
}

// Information about the ConnectionSettings attribute.
type ConnectionSettings struct {
	_ struct{} `type:"structure"`

	// The time, in seconds, that the connection is allowed to be idle (no data
	// has been sent over the connection) before it is closed by the load balancer.
	IdleTimeout *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ConnectionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionSettings) GoString() string {
	return s.String()
}

type CreateAppCookieStickinessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the application cookie used for stickiness.
	CookieName *string `type:"string" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The name of the policy being created. Policy names must consist of alphanumeric
	// characters and dashes (-). This name must be unique within the set of policies
	// for this load balancer.
	PolicyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAppCookieStickinessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppCookieStickinessPolicyInput) GoString() string {
	return s.String()
}

type CreateAppCookieStickinessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAppCookieStickinessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppCookieStickinessPolicyOutput) GoString() string {
	return s.String()
}

type CreateLBCookieStickinessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The time period, in seconds, after which the cookie should be considered
	// stale. If you do not specify this parameter, the sticky session lasts for
	// the duration of the browser session.
	CookieExpirationPeriod *int64 `type:"long"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The name of the policy being created. Policy names must consist of alphanumeric
	// characters and dashes (-). This name must be unique within the set of policies
	// for this load balancer.
	PolicyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLBCookieStickinessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLBCookieStickinessPolicyInput) GoString() string {
	return s.String()
}

type CreateLBCookieStickinessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateLBCookieStickinessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLBCookieStickinessPolicyOutput) GoString() string {
	return s.String()
}

type CreateLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// One or more Availability Zones from the same region as the load balancer.
	// Traffic is equally distributed across all specified Availability Zones.
	//
	// You must specify at least one Availability Zone.
	//
	// You can add more Availability Zones after you create the load balancer using
	// EnableAvailabilityZonesForLoadBalancer.
	AvailabilityZones []*string `type:"list"`

	// The listeners.
	//
	// For more information, see Listeners for Your Load Balancer (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-listener-config.html)
	// in the Elastic Load Balancing Developer Guide.
	Listeners []*Listener `type:"list" required:"true"`

	// The name of the load balancer.
	//
	// This name must be unique within your set of load balancers for the region,
	// must have a maximum of 32 characters, must contain only alphanumeric characters
	// or hyphens, and cannot begin or end with a hyphen.
	LoadBalancerName *string `type:"string" required:"true"`

	// The type of a load balancer. Valid only for load balancers in a VPC.
	//
	// By default, Elastic Load Balancing creates an Internet-facing load balancer
	// with a publicly resolvable DNS name, which resolves to public IP addresses.
	// For more information about Internet-facing and Internal load balancers, see
	// Internet-facing and Internal Load Balancers (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/vpc-loadbalancer-types.html)
	// in the Elastic Load Balancing Developer Guide.
	//
	// Specify internal to create an internal load balancer with a DNS name that
	// resolves to private IP addresses.
	Scheme *string `type:"string"`

	// The IDs of the security groups to assign to the load balancer.
	SecurityGroups []*string `type:"list"`

	// The IDs of the subnets in your VPC to attach to the load balancer. Specify
	// one subnet per Availability Zone specified in AvailabilityZones.
	Subnets []*string `type:"list"`

	// A list of tags to assign to the load balancer.
	//
	// For more information about tagging your load balancer, see Tagging (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#tagging-elb)
	// in the Elastic Load Balancing Developer Guide.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerInput) GoString() string {
	return s.String()
}

type CreateLoadBalancerListenersInput struct {
	_ struct{} `type:"structure"`

	// The listeners.
	Listeners []*Listener `type:"list" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLoadBalancerListenersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerListenersInput) GoString() string {
	return s.String()
}

type CreateLoadBalancerListenersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateLoadBalancerListenersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerListenersOutput) GoString() string {
	return s.String()
}

type CreateLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// The DNS name of the load balancer.
	DNSName *string `type:"string"`
}

// String returns the string representation
func (s CreateLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerOutput) GoString() string {
	return s.String()
}

type CreateLoadBalancerPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The attributes for the policy.
	PolicyAttributes []*PolicyAttribute `type:"list"`

	// The name of the load balancer policy to be created. This name must be unique
	// within the set of policies for this load balancer.
	PolicyName *string `type:"string" required:"true"`

	// The name of the base policy type. To get the list of policy types, use DescribeLoadBalancerPolicyTypes.
	PolicyTypeName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLoadBalancerPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerPolicyInput) GoString() string {
	return s.String()
}

type CreateLoadBalancerPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateLoadBalancerPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerPolicyOutput) GoString() string {
	return s.String()
}

// Information about the CrossZoneLoadBalancing attribute.
type CrossZoneLoadBalancing struct {
	_ struct{} `type:"structure"`

	// Specifies whether cross-zone load balancing is enabled for the load balancer.
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s CrossZoneLoadBalancing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CrossZoneLoadBalancing) GoString() string {
	return s.String()
}

type DeleteLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerInput) GoString() string {
	return s.String()
}

type DeleteLoadBalancerListenersInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The client port numbers of the listeners.
	LoadBalancerPorts []*int64 `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerListenersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerListenersInput) GoString() string {
	return s.String()
}

type DeleteLoadBalancerListenersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoadBalancerListenersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerListenersOutput) GoString() string {
	return s.String()
}

type DeleteLoadBalancerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerOutput) GoString() string {
	return s.String()
}

// =
type DeleteLoadBalancerPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The name of the policy.
	PolicyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerPolicyInput) GoString() string {
	return s.String()
}

type DeleteLoadBalancerPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoadBalancerPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerPolicyOutput) GoString() string {
	return s.String()
}

type DeregisterInstancesFromLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the instances.
	Instances []*Instance `type:"list" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterInstancesFromLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterInstancesFromLoadBalancerInput) GoString() string {
	return s.String()
}

type DeregisterInstancesFromLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// The remaining instances registered with the load balancer.
	Instances []*Instance `type:"list"`
}

// String returns the string representation
func (s DeregisterInstancesFromLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterInstancesFromLoadBalancerOutput) GoString() string {
	return s.String()
}

type DescribeInstanceHealthInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the instances.
	Instances []*Instance `type:"list"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInstanceHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceHealthInput) GoString() string {
	return s.String()
}

type DescribeInstanceHealthOutput struct {
	_ struct{} `type:"structure"`

	// Information about the health of the instances.
	InstanceStates []*InstanceState `type:"list"`
}

// String returns the string representation
func (s DescribeInstanceHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceHealthOutput) GoString() string {
	return s.String()
}

type DescribeLoadBalancerAttributesInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeLoadBalancerAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancerAttributesInput) GoString() string {
	return s.String()
}

type DescribeLoadBalancerAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the load balancer attributes.
	LoadBalancerAttributes *LoadBalancerAttributes `type:"structure"`
}

// String returns the string representation
func (s DescribeLoadBalancerAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancerAttributesOutput) GoString() string {
	return s.String()
}

type DescribeLoadBalancerPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The names of the policies.
	PolicyNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeLoadBalancerPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancerPoliciesInput) GoString() string {
	return s.String()
}

type DescribeLoadBalancerPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the policies.
	PolicyDescriptions []*PolicyDescription `type:"list"`
}

// String returns the string representation
func (s DescribeLoadBalancerPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancerPoliciesOutput) GoString() string {
	return s.String()
}

type DescribeLoadBalancerPolicyTypesInput struct {
	_ struct{} `type:"structure"`

	// The names of the policy types. If no names are specified, describes all policy
	// types defined by Elastic Load Balancing.
	PolicyTypeNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeLoadBalancerPolicyTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancerPolicyTypesInput) GoString() string {
	return s.String()
}

type DescribeLoadBalancerPolicyTypesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the policy types.
	PolicyTypeDescriptions []*PolicyTypeDescription `type:"list"`
}

// String returns the string representation
func (s DescribeLoadBalancerPolicyTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancerPolicyTypesOutput) GoString() string {
	return s.String()
}

type DescribeLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The names of the load balancers.
	LoadBalancerNames []*string `type:"list"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `type:"string"`

	// The maximum number of results to return with this call (a number from 1 to
	// 400). The default is 400.
	PageSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DescribeLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancersInput) GoString() string {
	return s.String()
}

type DescribeLoadBalancersOutput struct {
	_ struct{} `type:"structure"`

	// Information about the load balancers.
	LoadBalancerDescriptions []*LoadBalancerDescription `type:"list"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancersOutput) GoString() string {
	return s.String()
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The names of the load balancers.
	LoadBalancerNames []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	TagDescriptions []*TagDescription `type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

type DetachLoadBalancerFromSubnetsInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The IDs of the subnets.
	Subnets []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DetachLoadBalancerFromSubnetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachLoadBalancerFromSubnetsInput) GoString() string {
	return s.String()
}

type DetachLoadBalancerFromSubnetsOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the remaining subnets for the load balancer.
	Subnets []*string `type:"list"`
}

// String returns the string representation
func (s DetachLoadBalancerFromSubnetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachLoadBalancerFromSubnetsOutput) GoString() string {
	return s.String()
}

type DisableAvailabilityZonesForLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zones.
	AvailabilityZones []*string `type:"list" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableAvailabilityZonesForLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAvailabilityZonesForLoadBalancerInput) GoString() string {
	return s.String()
}

type DisableAvailabilityZonesForLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// The remaining Availability Zones for the load balancer.
	AvailabilityZones []*string `type:"list"`
}

// String returns the string representation
func (s DisableAvailabilityZonesForLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableAvailabilityZonesForLoadBalancerOutput) GoString() string {
	return s.String()
}

type EnableAvailabilityZonesForLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zones. These must be in the same region as the load balancer.
	AvailabilityZones []*string `type:"list" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableAvailabilityZonesForLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAvailabilityZonesForLoadBalancerInput) GoString() string {
	return s.String()
}

type EnableAvailabilityZonesForLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// The updated list of Availability Zones for the load balancer.
	AvailabilityZones []*string `type:"list"`
}

// String returns the string representation
func (s EnableAvailabilityZonesForLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableAvailabilityZonesForLoadBalancerOutput) GoString() string {
	return s.String()
}

// Information about a health check.
type HealthCheck struct {
	_ struct{} `type:"structure"`

	// The number of consecutive health checks successes required before moving
	// the instance to the Healthy state.
	HealthyThreshold *int64 `min:"2" type:"integer" required:"true"`

	// The approximate interval, in seconds, between health checks of an individual
	// instance.
	Interval *int64 `min:"1" type:"integer" required:"true"`

	// The instance being checked. The protocol is either TCP, HTTP, HTTPS, or SSL.
	// The range of valid ports is one (1) through 65535.
	//
	// TCP is the default, specified as a TCP: port pair, for example "TCP:5000".
	// In this case, a health check simply attempts to open a TCP connection to
	// the instance on the specified port. Failure to connect within the configured
	// timeout is considered unhealthy.
	//
	// SSL is also specified as SSL: port pair, for example, SSL:5000.
	//
	// For HTTP/HTTPS, you must include a ping path in the string. HTTP is specified
	// as a HTTP:port;/;PathToPing; grouping, for example "HTTP:80/weather/us/wa/seattle".
	// In this case, a HTTP GET request is issued to the instance on the given port
	// and path. Any answer other than "200 OK" within the timeout period is considered
	// unhealthy.
	//
	// The total length of the HTTP ping target must be 1024 16-bit Unicode characters
	// or less.
	Target *string `type:"string" required:"true"`

	// The amount of time, in seconds, during which no response means a failed health
	// check.
	//
	// This value must be less than the Interval value.
	Timeout *int64 `min:"1" type:"integer" required:"true"`

	// The number of consecutive health check failures required before moving the
	// instance to the Unhealthy state.
	UnhealthyThreshold *int64 `min:"2" type:"integer" required:"true"`
}

// String returns the string representation
func (s HealthCheck) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheck) GoString() string {
	return s.String()
}

// The ID of a back-end instance.
type Instance struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// Information about the state of a back-end instance.
type InstanceState struct {
	_ struct{} `type:"structure"`

	// A description of the instance state. This string can contain one or more
	// of the following messages.
	//
	//   N/A
	//
	//   A transient error occurred. Please try again later.
	//
	//   Instance has failed at least the UnhealthyThreshold number of health checks
	// consecutively.
	//
	//   Instance has not passed the configured HealthyThreshold number of health
	// checks consecutively.
	//
	//   Instance registration is still in progress.
	//
	//   Instance is in the EC2 Availability Zone for which LoadBalancer is not
	// configured to route traffic to.
	//
	//   Instance is not currently registered with the LoadBalancer.
	//
	//   Instance deregistration currently in progress.
	//
	//   Disable Availability Zone is currently in progress.
	//
	//   Instance is in pending state.
	//
	//   Instance is in stopped state.
	//
	//   Instance is in terminated state.
	Description *string `type:"string"`

	// The ID of the instance.
	InstanceId *string `type:"string"`

	// Information about the cause of OutOfService instances. Specifically, whether
	// the cause is Elastic Load Balancing or the instance.
	//
	// Valid values: ELB | Instance | N/A
	ReasonCode *string `type:"string"`

	// The current state of the instance.
	//
	// Valid values: InService | OutOfService | Unknown
	State *string `type:"string"`
}

// String returns the string representation
func (s InstanceState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceState) GoString() string {
	return s.String()
}

// Information about a policy for duration-based session stickiness.
type LBCookieStickinessPolicy struct {
	_ struct{} `type:"structure"`

	// The time period, in seconds, after which the cookie should be considered
	// stale. If this parameter is not specified, the stickiness session lasts for
	// the duration of the browser session.
	CookieExpirationPeriod *int64 `type:"long"`

	// The name for the policy being created. The name must be unique within the
	// set of policies for this load balancer.
	PolicyName *string `type:"string"`
}

// String returns the string representation
func (s LBCookieStickinessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LBCookieStickinessPolicy) GoString() string {
	return s.String()
}

// Information about a listener.
//
// For information about the protocols and the ports supported by Elastic Load
// Balancing, see Listener Configurations for Elastic Load Balancing (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-listener-config.html)
// in the Elastic Load Balancing Developer Guide.
type Listener struct {
	_ struct{} `type:"structure"`

	// The port on which the instance is listening.
	InstancePort *int64 `min:"1" type:"integer" required:"true"`

	// The protocol to use for routing traffic to back-end instances: HTTP, HTTPS,
	// TCP, or SSL.
	//
	// If the front-end protocol is HTTP, HTTPS, TCP, or SSL, InstanceProtocol
	// must be at the same protocol.
	//
	// If there is another listener with the same InstancePort whose InstanceProtocol
	// is secure, (HTTPS or SSL), the listener's InstanceProtocol must also be secure.
	//
	// If there is another listener with the same InstancePort whose InstanceProtocol
	// is HTTP or TCP, the listener's InstanceProtocol must be HTTP or TCP.
	InstanceProtocol *string `type:"string"`

	// The port on which the load balancer is listening. On EC2-VPC, you can specify
	// any port from the range 1-65535. On EC2-Classic, you can specify any port
	// from the following list: 25, 80, 443, 465, 587, 1024-65535.
	LoadBalancerPort *int64 `type:"integer" required:"true"`

	// The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP,
	// or SSL.
	Protocol *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the server certificate.
	SSLCertificateId *string `type:"string"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Listener) GoString() string {
	return s.String()
}

// The policies enabled for a listener.
type ListenerDescription struct {
	_ struct{} `type:"structure"`

	// Information about a listener.
	//
	// For information about the protocols and the ports supported by Elastic Load
	// Balancing, see Listener Configurations for Elastic Load Balancing (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-listener-config.html)
	// in the Elastic Load Balancing Developer Guide.
	Listener *Listener `type:"structure"`

	// The policies. If there are no policies enabled, the list is empty.
	PolicyNames []*string `type:"list"`
}

// String returns the string representation
func (s ListenerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListenerDescription) GoString() string {
	return s.String()
}

// The attributes for a load balancer.
type LoadBalancerAttributes struct {
	_ struct{} `type:"structure"`

	// If enabled, the load balancer captures detailed information of all requests
	// and delivers the information to the Amazon S3 bucket that you specify.
	//
	// For more information, see Enable Access Logs (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/enable-access-logs.html)
	// in the Elastic Load Balancing Developer Guide.
	AccessLog *AccessLog `type:"structure"`

	// This parameter is reserved.
	AdditionalAttributes []*AdditionalAttribute `type:"list"`

	// If enabled, the load balancer allows existing requests to complete before
	// the load balancer shifts traffic away from a deregistered or unhealthy back-end
	// instance.
	//
	// For more information, see Enable Connection Draining (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/config-conn-drain.html)
	// in the Elastic Load Balancing Developer Guide.
	ConnectionDraining *ConnectionDraining `type:"structure"`

	// If enabled, the load balancer allows the connections to remain idle (no data
	// is sent over the connection) for the specified duration.
	//
	// By default, Elastic Load Balancing maintains a 60-second idle connection
	// timeout for both front-end and back-end connections of your load balancer.
	// For more information, see Configure Idle Connection Timeout (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/config-idle-timeout.html)
	// in the Elastic Load Balancing Developer Guide.
	ConnectionSettings *ConnectionSettings `type:"structure"`

	// If enabled, the load balancer routes the request traffic evenly across all
	// back-end instances regardless of the Availability Zones.
	//
	// For more information, see Enable Cross-Zone Load Balancing (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/enable-disable-crosszone-lb.html)
	// in the Elastic Load Balancing Developer Guide.
	CrossZoneLoadBalancing *CrossZoneLoadBalancing `type:"structure"`
}

// String returns the string representation
func (s LoadBalancerAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerAttributes) GoString() string {
	return s.String()
}

// Information about a load balancer.
type LoadBalancerDescription struct {
	_ struct{} `type:"structure"`

	// The Availability Zones for the load balancer.
	AvailabilityZones []*string `type:"list"`

	// Information about the back-end servers.
	BackendServerDescriptions []*BackendServerDescription `type:"list"`

	// The Amazon Route 53 hosted zone associated with the load balancer.
	//
	// For more information, see Using Domain Names With Elastic Load Balancing
	// (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/using-domain-names-with-elb.html)
	// in the Elastic Load Balancing Developer Guide.
	CanonicalHostedZoneName *string `type:"string"`

	// The ID of the Amazon Route 53 hosted zone name associated with the load balancer.
	CanonicalHostedZoneNameID *string `type:"string"`

	// The date and time the load balancer was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The external DNS name of the load balancer.
	DNSName *string `type:"string"`

	// Information about the health checks conducted on the load balancer.
	HealthCheck *HealthCheck `type:"structure"`

	// The IDs of the instances for the load balancer.
	Instances []*Instance `type:"list"`

	// The listeners for the load balancer.
	ListenerDescriptions []*ListenerDescription `type:"list"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The policies defined for the load balancer.
	Policies *Policies `type:"structure"`

	// The type of load balancer. Valid only for load balancers in a VPC.
	//
	// If Scheme is internet-facing, the load balancer has a public DNS name that
	// resolves to a public IP address.
	//
	// If Scheme is internal, the load balancer has a public DNS name that resolves
	// to a private IP address.
	Scheme *string `type:"string"`

	// The security groups for the load balancer. Valid only for load balancers
	// in a VPC.
	SecurityGroups []*string `type:"list"`

	// The security group that you can use as part of your inbound rules for your
	// load balancer's back-end application instances. To only allow traffic from
	// load balancers, add a security group rule to your back end instance that
	// specifies this source security group as the inbound source.
	SourceSecurityGroup *SourceSecurityGroup `type:"structure"`

	// The IDs of the subnets for the load balancer.
	Subnets []*string `type:"list"`

	// The ID of the VPC for the load balancer.
	VPCId *string `type:"string"`
}

// String returns the string representation
func (s LoadBalancerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerDescription) GoString() string {
	return s.String()
}

type ModifyLoadBalancerAttributesInput struct {
	_ struct{} `type:"structure"`

	// The attributes of the load balancer.
	LoadBalancerAttributes *LoadBalancerAttributes `type:"structure" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyLoadBalancerAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyLoadBalancerAttributesInput) GoString() string {
	return s.String()
}

type ModifyLoadBalancerAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The attributes for a load balancer.
	LoadBalancerAttributes *LoadBalancerAttributes `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`
}

// String returns the string representation
func (s ModifyLoadBalancerAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyLoadBalancerAttributesOutput) GoString() string {
	return s.String()
}

// The policies for a load balancer.
type Policies struct {
	_ struct{} `type:"structure"`

	// The stickiness policies created using CreateAppCookieStickinessPolicy.
	AppCookieStickinessPolicies []*AppCookieStickinessPolicy `type:"list"`

	// The stickiness policies created using CreateLBCookieStickinessPolicy.
	LBCookieStickinessPolicies []*LBCookieStickinessPolicy `type:"list"`

	// The policies other than the stickiness policies.
	OtherPolicies []*string `type:"list"`
}

// String returns the string representation
func (s Policies) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Policies) GoString() string {
	return s.String()
}

// Information about a policy attribute.
type PolicyAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	AttributeName *string `type:"string"`

	// The value of the attribute.
	AttributeValue *string `type:"string"`
}

// String returns the string representation
func (s PolicyAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyAttribute) GoString() string {
	return s.String()
}

// Information about a policy attribute.
type PolicyAttributeDescription struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	AttributeName *string `type:"string"`

	// The value of the attribute.
	AttributeValue *string `type:"string"`
}

// String returns the string representation
func (s PolicyAttributeDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyAttributeDescription) GoString() string {
	return s.String()
}

// Information about a policy attribute type.
type PolicyAttributeTypeDescription struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	AttributeName *string `type:"string"`

	// The type of the attribute. For example, Boolean or Integer.
	AttributeType *string `type:"string"`

	// The cardinality of the attribute.
	//
	// Valid values:
	//
	//  ONE(1) : Single value required ZERO_OR_ONE(0..1) : Up to one value can
	// be supplied ZERO_OR_MORE(0..*) : Optional. Multiple values are allowed ONE_OR_MORE(1..*0)
	// : Required. Multiple values are allowed
	Cardinality *string `type:"string"`

	// The default value of the attribute, if applicable.
	DefaultValue *string `type:"string"`

	// A description of the attribute.
	Description *string `type:"string"`
}

// String returns the string representation
func (s PolicyAttributeTypeDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyAttributeTypeDescription) GoString() string {
	return s.String()
}

// Information about a policy.
type PolicyDescription struct {
	_ struct{} `type:"structure"`

	// The policy attributes.
	PolicyAttributeDescriptions []*PolicyAttributeDescription `type:"list"`

	// The name of the policy.
	PolicyName *string `type:"string"`

	// The name of the policy type.
	PolicyTypeName *string `type:"string"`
}

// String returns the string representation
func (s PolicyDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyDescription) GoString() string {
	return s.String()
}

// Information about a policy type.
type PolicyTypeDescription struct {
	_ struct{} `type:"structure"`

	// A description of the policy type.
	Description *string `type:"string"`

	// The description of the policy attributes associated with the policies defined
	// by Elastic Load Balancing.
	PolicyAttributeTypeDescriptions []*PolicyAttributeTypeDescription `type:"list"`

	// The name of the policy type.
	PolicyTypeName *string `type:"string"`
}

// String returns the string representation
func (s PolicyTypeDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyTypeDescription) GoString() string {
	return s.String()
}

type RegisterInstancesWithLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the instances.
	Instances []*Instance `type:"list" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterInstancesWithLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterInstancesWithLoadBalancerInput) GoString() string {
	return s.String()
}

type RegisterInstancesWithLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// The updated list of instances for the load balancer.
	Instances []*Instance `type:"list"`
}

// String returns the string representation
func (s RegisterInstancesWithLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterInstancesWithLoadBalancerOutput) GoString() string {
	return s.String()
}

type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer. You can specify a maximum of one load balancer
	// name.
	LoadBalancerNames []*string `type:"list" required:"true"`

	// The list of tag keys to remove.
	Tags []*TagKeyOnly `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

type SetLoadBalancerListenerSSLCertificateInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The port that uses the specified SSL certificate.
	LoadBalancerPort *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the SSL certificate.
	SSLCertificateId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetLoadBalancerListenerSSLCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoadBalancerListenerSSLCertificateInput) GoString() string {
	return s.String()
}

type SetLoadBalancerListenerSSLCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetLoadBalancerListenerSSLCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoadBalancerListenerSSLCertificateOutput) GoString() string {
	return s.String()
}

type SetLoadBalancerPoliciesForBackendServerInput struct {
	_ struct{} `type:"structure"`

	// The port number associated with the back-end server.
	InstancePort *int64 `type:"integer" required:"true"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The names of the policies. If the list is empty, then all current polices
	// are removed from the back-end server.
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s SetLoadBalancerPoliciesForBackendServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoadBalancerPoliciesForBackendServerInput) GoString() string {
	return s.String()
}

type SetLoadBalancerPoliciesForBackendServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetLoadBalancerPoliciesForBackendServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoadBalancerPoliciesForBackendServerOutput) GoString() string {
	return s.String()
}

type SetLoadBalancerPoliciesOfListenerInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string" required:"true"`

	// The external port of the load balancer for the policy.
	LoadBalancerPort *int64 `type:"integer" required:"true"`

	// The names of the policies. If the list is empty, the current policy is removed
	// from the listener.
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s SetLoadBalancerPoliciesOfListenerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoadBalancerPoliciesOfListenerInput) GoString() string {
	return s.String()
}

type SetLoadBalancerPoliciesOfListenerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetLoadBalancerPoliciesOfListenerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoadBalancerPoliciesOfListenerOutput) GoString() string {
	return s.String()
}

// Information about a source security group.
type SourceSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The name of the security group.
	GroupName *string `type:"string"`

	// The owner of the security group.
	OwnerAlias *string `type:"string"`
}

// String returns the string representation
func (s SourceSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceSecurityGroup) GoString() string {
	return s.String()
}

// Information about a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// The tags associated with a load balancer.
type TagDescription struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `type:"string"`

	// The tags.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s TagDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagDescription) GoString() string {
	return s.String()
}

// The key of a tag.
type TagKeyOnly struct {
	_ struct{} `type:"structure"`

	// The name of the key.
	Key *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TagKeyOnly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagKeyOnly) GoString() string {
	return s.String()
}
