package sql

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/satori/uuid"
)

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// ADPassword specifies the ad password state for authentication type.
	ADPassword AuthenticationType = "ADPassword"
	// SQL specifies the sql state for authentication type.
	SQL AuthenticationType = "SQL"
)

// BlobAuditingPolicyState enumerates the values for blob auditing policy
// state.
type BlobAuditingPolicyState string

const (
	// Disabled specifies the disabled state for blob auditing policy state.
	Disabled BlobAuditingPolicyState = "Disabled"
	// Enabled specifies the enabled state for blob auditing policy state.
	Enabled BlobAuditingPolicyState = "Enabled"
)

// CapabilityStatus enumerates the values for capability status.
type CapabilityStatus string

const (
	// CapabilityStatusAvailable specifies the capability status available
	// state for capability status.
	CapabilityStatusAvailable CapabilityStatus = "Available"
	// CapabilityStatusDefault specifies the capability status default state
	// for capability status.
	CapabilityStatusDefault CapabilityStatus = "Default"
	// CapabilityStatusDisabled specifies the capability status disabled state
	// for capability status.
	CapabilityStatusDisabled CapabilityStatus = "Disabled"
	// CapabilityStatusVisible specifies the capability status visible state
	// for capability status.
	CapabilityStatusVisible CapabilityStatus = "Visible"
)

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// Copy specifies the copy state for create mode.
	Copy CreateMode = "Copy"
	// Default specifies the default state for create mode.
	Default CreateMode = "Default"
	// NonReadableSecondary specifies the non readable secondary state for
	// create mode.
	NonReadableSecondary CreateMode = "NonReadableSecondary"
	// OnlineSecondary specifies the online secondary state for create mode.
	OnlineSecondary CreateMode = "OnlineSecondary"
	// PointInTimeRestore specifies the point in time restore state for create
	// mode.
	PointInTimeRestore CreateMode = "PointInTimeRestore"
	// Recovery specifies the recovery state for create mode.
	Recovery CreateMode = "Recovery"
	// Restore specifies the restore state for create mode.
	Restore CreateMode = "Restore"
	// RestoreLongTermRetentionBackup specifies the restore long term retention
	// backup state for create mode.
	RestoreLongTermRetentionBackup CreateMode = "RestoreLongTermRetentionBackup"
)

// DatabaseEdition enumerates the values for database edition.
type DatabaseEdition string

const (
	// Basic specifies the basic state for database edition.
	Basic DatabaseEdition = "Basic"
	// Business specifies the business state for database edition.
	Business DatabaseEdition = "Business"
	// DataWarehouse specifies the data warehouse state for database edition.
	DataWarehouse DatabaseEdition = "DataWarehouse"
	// Free specifies the free state for database edition.
	Free DatabaseEdition = "Free"
	// Premium specifies the premium state for database edition.
	Premium DatabaseEdition = "Premium"
	// Standard specifies the standard state for database edition.
	Standard DatabaseEdition = "Standard"
	// Stretch specifies the stretch state for database edition.
	Stretch DatabaseEdition = "Stretch"
	// System specifies the system state for database edition.
	System DatabaseEdition = "System"
	// System2 specifies the system 2 state for database edition.
	System2 DatabaseEdition = "System2"
	// Web specifies the web state for database edition.
	Web DatabaseEdition = "Web"
)

// ElasticPoolEdition enumerates the values for elastic pool edition.
type ElasticPoolEdition string

const (
	// ElasticPoolEditionBasic specifies the elastic pool edition basic state
	// for elastic pool edition.
	ElasticPoolEditionBasic ElasticPoolEdition = "Basic"
	// ElasticPoolEditionPremium specifies the elastic pool edition premium
	// state for elastic pool edition.
	ElasticPoolEditionPremium ElasticPoolEdition = "Premium"
	// ElasticPoolEditionStandard specifies the elastic pool edition standard
	// state for elastic pool edition.
	ElasticPoolEditionStandard ElasticPoolEdition = "Standard"
)

// ElasticPoolState enumerates the values for elastic pool state.
type ElasticPoolState string

const (
	// ElasticPoolStateCreating specifies the elastic pool state creating state
	// for elastic pool state.
	ElasticPoolStateCreating ElasticPoolState = "Creating"
	// ElasticPoolStateDisabled specifies the elastic pool state disabled state
	// for elastic pool state.
	ElasticPoolStateDisabled ElasticPoolState = "Disabled"
	// ElasticPoolStateReady specifies the elastic pool state ready state for
	// elastic pool state.
	ElasticPoolStateReady ElasticPoolState = "Ready"
)

// MaxSizeUnits enumerates the values for max size units.
type MaxSizeUnits string

const (
	// Gigabytes specifies the gigabytes state for max size units.
	Gigabytes MaxSizeUnits = "Gigabytes"
	// Megabytes specifies the megabytes state for max size units.
	Megabytes MaxSizeUnits = "Megabytes"
	// Petabytes specifies the petabytes state for max size units.
	Petabytes MaxSizeUnits = "Petabytes"
	// Terabytes specifies the terabytes state for max size units.
	Terabytes MaxSizeUnits = "Terabytes"
)

// PerformanceLevelUnit enumerates the values for performance level unit.
type PerformanceLevelUnit string

const (
	// DTU specifies the dtu state for performance level unit.
	DTU PerformanceLevelUnit = "DTU"
)

// ReadScale enumerates the values for read scale.
type ReadScale string

const (
	// ReadScaleDisabled specifies the read scale disabled state for read
	// scale.
	ReadScaleDisabled ReadScale = "Disabled"
	// ReadScaleEnabled specifies the read scale enabled state for read scale.
	ReadScaleEnabled ReadScale = "Enabled"
)

// RecommendedIndexAction enumerates the values for recommended index action.
type RecommendedIndexAction string

const (
	// Create specifies the create state for recommended index action.
	Create RecommendedIndexAction = "Create"
	// Drop specifies the drop state for recommended index action.
	Drop RecommendedIndexAction = "Drop"
	// Rebuild specifies the rebuild state for recommended index action.
	Rebuild RecommendedIndexAction = "Rebuild"
)

// RecommendedIndexState enumerates the values for recommended index state.
type RecommendedIndexState string

const (
	// Active specifies the active state for recommended index state.
	Active RecommendedIndexState = "Active"
	// Blocked specifies the blocked state for recommended index state.
	Blocked RecommendedIndexState = "Blocked"
	// Executing specifies the executing state for recommended index state.
	Executing RecommendedIndexState = "Executing"
	// Expired specifies the expired state for recommended index state.
	Expired RecommendedIndexState = "Expired"
	// Ignored specifies the ignored state for recommended index state.
	Ignored RecommendedIndexState = "Ignored"
	// Pending specifies the pending state for recommended index state.
	Pending RecommendedIndexState = "Pending"
	// PendingRevert specifies the pending revert state for recommended index
	// state.
	PendingRevert RecommendedIndexState = "Pending Revert"
	// Reverted specifies the reverted state for recommended index state.
	Reverted RecommendedIndexState = "Reverted"
	// Reverting specifies the reverting state for recommended index state.
	Reverting RecommendedIndexState = "Reverting"
	// Success specifies the success state for recommended index state.
	Success RecommendedIndexState = "Success"
	// Verifying specifies the verifying state for recommended index state.
	Verifying RecommendedIndexState = "Verifying"
)

// RecommendedIndexType enumerates the values for recommended index type.
type RecommendedIndexType string

const (
	// CLUSTERED specifies the clustered state for recommended index type.
	CLUSTERED RecommendedIndexType = "CLUSTERED"
	// CLUSTEREDCOLUMNSTORE specifies the clusteredcolumnstore state for
	// recommended index type.
	CLUSTEREDCOLUMNSTORE RecommendedIndexType = "CLUSTERED COLUMNSTORE"
	// COLUMNSTORE specifies the columnstore state for recommended index type.
	COLUMNSTORE RecommendedIndexType = "COLUMNSTORE"
	// NONCLUSTERED specifies the nonclustered state for recommended index
	// type.
	NONCLUSTERED RecommendedIndexType = "NONCLUSTERED"
)

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// ReplicationRoleCopy specifies the replication role copy state for
	// replication role.
	ReplicationRoleCopy ReplicationRole = "Copy"
	// ReplicationRoleNonReadableSecondary specifies the replication role non
	// readable secondary state for replication role.
	ReplicationRoleNonReadableSecondary ReplicationRole = "NonReadableSecondary"
	// ReplicationRolePrimary specifies the replication role primary state for
	// replication role.
	ReplicationRolePrimary ReplicationRole = "Primary"
	// ReplicationRoleSecondary specifies the replication role secondary state
	// for replication role.
	ReplicationRoleSecondary ReplicationRole = "Secondary"
	// ReplicationRoleSource specifies the replication role source state for
	// replication role.
	ReplicationRoleSource ReplicationRole = "Source"
)

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// CATCHUP specifies the catchup state for replication state.
	CATCHUP ReplicationState = "CATCH_UP"
	// PENDING specifies the pending state for replication state.
	PENDING ReplicationState = "PENDING"
	// SEEDING specifies the seeding state for replication state.
	SEEDING ReplicationState = "SEEDING"
	// SUSPENDED specifies the suspended state for replication state.
	SUSPENDED ReplicationState = "SUSPENDED"
)

// RestorePointTypes enumerates the values for restore point types.
type RestorePointTypes string

const (
	// CONTINUOUS specifies the continuous state for restore point types.
	CONTINUOUS RestorePointTypes = "CONTINUOUS"
	// DISCRETE specifies the discrete state for restore point types.
	DISCRETE RestorePointTypes = "DISCRETE"
)

// SampleName enumerates the values for sample name.
type SampleName string

const (
	// AdventureWorksLT specifies the adventure works lt state for sample name.
	AdventureWorksLT SampleName = "AdventureWorksLT"
)

// SecurityAlertPolicyEmailAccountAdmins enumerates the values for security
// alert policy email account admins.
type SecurityAlertPolicyEmailAccountAdmins string

const (
	// SecurityAlertPolicyEmailAccountAdminsDisabled specifies the security
	// alert policy email account admins disabled state for security alert
	// policy email account admins.
	SecurityAlertPolicyEmailAccountAdminsDisabled SecurityAlertPolicyEmailAccountAdmins = "Disabled"
	// SecurityAlertPolicyEmailAccountAdminsEnabled specifies the security
	// alert policy email account admins enabled state for security alert
	// policy email account admins.
	SecurityAlertPolicyEmailAccountAdminsEnabled SecurityAlertPolicyEmailAccountAdmins = "Enabled"
)

// SecurityAlertPolicyState enumerates the values for security alert policy
// state.
type SecurityAlertPolicyState string

const (
	// SecurityAlertPolicyStateDisabled specifies the security alert policy
	// state disabled state for security alert policy state.
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	// SecurityAlertPolicyStateEnabled specifies the security alert policy
	// state enabled state for security alert policy state.
	SecurityAlertPolicyStateEnabled SecurityAlertPolicyState = "Enabled"
	// SecurityAlertPolicyStateNew specifies the security alert policy state
	// new state for security alert policy state.
	SecurityAlertPolicyStateNew SecurityAlertPolicyState = "New"
)

// SecurityAlertPolicyUseServerDefault enumerates the values for security alert
// policy use server default.
type SecurityAlertPolicyUseServerDefault string

const (
	// SecurityAlertPolicyUseServerDefaultDisabled specifies the security alert
	// policy use server default disabled state for security alert policy use
	// server default.
	SecurityAlertPolicyUseServerDefaultDisabled SecurityAlertPolicyUseServerDefault = "Disabled"
	// SecurityAlertPolicyUseServerDefaultEnabled specifies the security alert
	// policy use server default enabled state for security alert policy use
	// server default.
	SecurityAlertPolicyUseServerDefaultEnabled SecurityAlertPolicyUseServerDefault = "Enabled"
)

// ServerState enumerates the values for server state.
type ServerState string

const (
	// ServerStateDisabled specifies the server state disabled state for server
	// state.
	ServerStateDisabled ServerState = "Disabled"
	// ServerStateReady specifies the server state ready state for server
	// state.
	ServerStateReady ServerState = "Ready"
)

// ServerVersion enumerates the values for server version.
type ServerVersion string

const (
	// OneTwoFullStopZero specifies the one two full stop zero state for server
	// version.
	OneTwoFullStopZero ServerVersion = "12.0"
	// TwoFullStopZero specifies the two full stop zero state for server
	// version.
	TwoFullStopZero ServerVersion = "2.0"
)

// ServiceObjectiveName enumerates the values for service objective name.
type ServiceObjectiveName string

const (
	// ServiceObjectiveNameBasic specifies the service objective name basic
	// state for service objective name.
	ServiceObjectiveNameBasic ServiceObjectiveName = "Basic"
	// ServiceObjectiveNameElasticPool specifies the service objective name
	// elastic pool state for service objective name.
	ServiceObjectiveNameElasticPool ServiceObjectiveName = "ElasticPool"
	// ServiceObjectiveNameP1 specifies the service objective name p1 state for
	// service objective name.
	ServiceObjectiveNameP1 ServiceObjectiveName = "P1"
	// ServiceObjectiveNameP11 specifies the service objective name p11 state
	// for service objective name.
	ServiceObjectiveNameP11 ServiceObjectiveName = "P11"
	// ServiceObjectiveNameP15 specifies the service objective name p15 state
	// for service objective name.
	ServiceObjectiveNameP15 ServiceObjectiveName = "P15"
	// ServiceObjectiveNameP2 specifies the service objective name p2 state for
	// service objective name.
	ServiceObjectiveNameP2 ServiceObjectiveName = "P2"
	// ServiceObjectiveNameP3 specifies the service objective name p3 state for
	// service objective name.
	ServiceObjectiveNameP3 ServiceObjectiveName = "P3"
	// ServiceObjectiveNameP4 specifies the service objective name p4 state for
	// service objective name.
	ServiceObjectiveNameP4 ServiceObjectiveName = "P4"
	// ServiceObjectiveNameP6 specifies the service objective name p6 state for
	// service objective name.
	ServiceObjectiveNameP6 ServiceObjectiveName = "P6"
	// ServiceObjectiveNameS0 specifies the service objective name s0 state for
	// service objective name.
	ServiceObjectiveNameS0 ServiceObjectiveName = "S0"
	// ServiceObjectiveNameS1 specifies the service objective name s1 state for
	// service objective name.
	ServiceObjectiveNameS1 ServiceObjectiveName = "S1"
	// ServiceObjectiveNameS2 specifies the service objective name s2 state for
	// service objective name.
	ServiceObjectiveNameS2 ServiceObjectiveName = "S2"
	// ServiceObjectiveNameS3 specifies the service objective name s3 state for
	// service objective name.
	ServiceObjectiveNameS3 ServiceObjectiveName = "S3"
	// ServiceObjectiveNameSystem specifies the service objective name system
	// state for service objective name.
	ServiceObjectiveNameSystem ServiceObjectiveName = "System"
	// ServiceObjectiveNameSystem2 specifies the service objective name system
	// 2 state for service objective name.
	ServiceObjectiveNameSystem2 ServiceObjectiveName = "System2"
)

// StorageKeyType enumerates the values for storage key type.
type StorageKeyType string

const (
	// SharedAccessKey specifies the shared access key state for storage key
	// type.
	SharedAccessKey StorageKeyType = "SharedAccessKey"
	// StorageAccessKey specifies the storage access key state for storage key
	// type.
	StorageAccessKey StorageKeyType = "StorageAccessKey"
)

// TransparentDataEncryptionActivityStatus enumerates the values for
// transparent data encryption activity status.
type TransparentDataEncryptionActivityStatus string

const (
	// Decrypting specifies the decrypting state for transparent data
	// encryption activity status.
	Decrypting TransparentDataEncryptionActivityStatus = "Decrypting"
	// Encrypting specifies the encrypting state for transparent data
	// encryption activity status.
	Encrypting TransparentDataEncryptionActivityStatus = "Encrypting"
)

// TransparentDataEncryptionStatus enumerates the values for transparent data
// encryption status.
type TransparentDataEncryptionStatus string

const (
	// TransparentDataEncryptionStatusDisabled specifies the transparent data
	// encryption status disabled state for transparent data encryption status.
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
	// TransparentDataEncryptionStatusEnabled specifies the transparent data
	// encryption status enabled state for transparent data encryption status.
	TransparentDataEncryptionStatusEnabled TransparentDataEncryptionStatus = "Enabled"
)

// Database is represents a database.
type Database struct {
	autorest.Response   `json:"-"`
	ID                  *string             `json:"id,omitempty"`
	Name                *string             `json:"name,omitempty"`
	Type                *string             `json:"type,omitempty"`
	Tags                *map[string]*string `json:"tags,omitempty"`
	Location            *string             `json:"location,omitempty"`
	Kind                *string             `json:"kind,omitempty"`
	*DatabaseProperties `json:"properties,omitempty"`
}

// DatabaseBlobAuditingPolicy is contains information about a database Blob
// Auditing policy.
type DatabaseBlobAuditingPolicy struct {
	autorest.Response                     `json:"-"`
	ID                                    *string `json:"id,omitempty"`
	Name                                  *string `json:"name,omitempty"`
	Type                                  *string `json:"type,omitempty"`
	Location                              *string `json:"location,omitempty"`
	Kind                                  *string `json:"kind,omitempty"`
	*DatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`
}

// DatabaseBlobAuditingPolicyProperties is properties for a database Blob
// Auditing policy.
type DatabaseBlobAuditingPolicyProperties struct {
	State                        BlobAuditingPolicyState `json:"state,omitempty"`
	StorageEndpoint              *string                 `json:"storageEndpoint,omitempty"`
	StorageAccountAccessKey      *string                 `json:"storageAccountAccessKey,omitempty"`
	RetentionDays                *int32                  `json:"retentionDays,omitempty"`
	AuditActionsAndGroups        *[]string               `json:"auditActionsAndGroups,omitempty"`
	StorageAccountSubscriptionID *string                 `json:"storageAccountSubscriptionId,omitempty"`
	IsStorageSecondaryKeyInUse   *bool                   `json:"isStorageSecondaryKeyInUse,omitempty"`
}

// DatabaseListResult is represents the response to a list database request.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Database `json:"value,omitempty"`
}

// DatabaseMetric is represents database metrics.
type DatabaseMetric struct {
	Name          *string    `json:"name,omitempty"`
	ID            *string    `json:"id,omitempty"`
	ResourceName  *string    `json:"resourceName,omitempty"`
	DisplayName   *string    `json:"displayName,omitempty"`
	CurrentValue  *float64   `json:"currentValue,omitempty"`
	Limit         *float64   `json:"limit,omitempty"`
	Unit          *string    `json:"unit,omitempty"`
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// DatabaseMetricListResult is represents the response to a list database
// metrics request.
type DatabaseMetricListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DatabaseMetric `json:"value,omitempty"`
}

// DatabaseProperties is represents the properties of a database.
type DatabaseProperties struct {
	Collation                               *string                      `json:"collation,omitempty"`
	CreationDate                            *date.Time                   `json:"creationDate,omitempty"`
	ContainmentState                        *int64                       `json:"containmentState,omitempty"`
	CurrentServiceObjectiveID               *uuid.UUID                   `json:"currentServiceObjectiveId,omitempty"`
	DatabaseID                              *uuid.UUID                   `json:"databaseId,omitempty"`
	EarliestRestoreDate                     *date.Time                   `json:"earliestRestoreDate,omitempty"`
	CreateMode                              CreateMode                   `json:"createMode,omitempty"`
	SourceDatabaseID                        *string                      `json:"sourceDatabaseId,omitempty"`
	SourceDatabaseDeletionDate              *date.Time                   `json:"sourceDatabaseDeletionDate,omitempty"`
	RestorePointInTime                      *date.Time                   `json:"restorePointInTime,omitempty"`
	RecoveryServicesRecoveryPointResourceID *string                      `json:"recoveryServicesRecoveryPointResourceId,omitempty"`
	Edition                                 DatabaseEdition              `json:"edition,omitempty"`
	MaxSizeBytes                            *string                      `json:"maxSizeBytes,omitempty"`
	RequestedServiceObjectiveID             *uuid.UUID                   `json:"requestedServiceObjectiveId,omitempty"`
	RequestedServiceObjectiveName           ServiceObjectiveName         `json:"requestedServiceObjectiveName,omitempty"`
	ServiceLevelObjective                   ServiceObjectiveName         `json:"serviceLevelObjective,omitempty"`
	Status                                  *string                      `json:"status,omitempty"`
	ElasticPoolName                         *string                      `json:"elasticPoolName,omitempty"`
	DefaultSecondaryLocation                *string                      `json:"defaultSecondaryLocation,omitempty"`
	ServiceTierAdvisors                     *[]ServiceTierAdvisor        `json:"serviceTierAdvisors,omitempty"`
	TransparentDataEncryption               *[]TransparentDataEncryption `json:"transparentDataEncryption,omitempty"`
	RecommendedIndex                        *[]RecommendedIndex          `json:"recommendedIndex,omitempty"`
	FailoverGroupID                         *uuid.UUID                   `json:"failoverGroupId,omitempty"`
	ReadScale                               ReadScale                    `json:"readScale,omitempty"`
	SampleName                              SampleName                   `json:"sampleName,omitempty"`
}

// DatabaseSecurityAlertPolicy is contains information about a database Threat
// Detection policy.
type DatabaseSecurityAlertPolicy struct {
	autorest.Response                      `json:"-"`
	ID                                     *string `json:"id,omitempty"`
	Name                                   *string `json:"name,omitempty"`
	Type                                   *string `json:"type,omitempty"`
	Location                               *string `json:"location,omitempty"`
	Kind                                   *string `json:"kind,omitempty"`
	*DatabaseSecurityAlertPolicyProperties `json:"properties,omitempty"`
}

// DatabaseSecurityAlertPolicyProperties is properties for a database Threat
// Detection policy.
type DatabaseSecurityAlertPolicyProperties struct {
	State                   SecurityAlertPolicyState              `json:"state,omitempty"`
	DisabledAlerts          *string                               `json:"disabledAlerts,omitempty"`
	EmailAddresses          *string                               `json:"emailAddresses,omitempty"`
	EmailAccountAdmins      SecurityAlertPolicyEmailAccountAdmins `json:"emailAccountAdmins,omitempty"`
	StorageEndpoint         *string                               `json:"storageEndpoint,omitempty"`
	StorageAccountAccessKey *string                               `json:"storageAccountAccessKey,omitempty"`
	RetentionDays           *int32                                `json:"retentionDays,omitempty"`
	UseServerDefault        SecurityAlertPolicyUseServerDefault   `json:"useServerDefault,omitempty"`
}

// EditionCapability is the database edition capabilities.
type EditionCapability struct {
	Name                            *string                       `json:"name,omitempty"`
	Status                          CapabilityStatus              `json:"status,omitempty"`
	SupportedServiceLevelObjectives *[]ServiceObjectiveCapability `json:"supportedServiceLevelObjectives,omitempty"`
}

// ElasticPool is represents a database elastic pool.
type ElasticPool struct {
	autorest.Response      `json:"-"`
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	Location               *string             `json:"location,omitempty"`
	*ElasticPoolProperties `json:"properties,omitempty"`
	Kind                   *string `json:"kind,omitempty"`
}

// ElasticPoolActivity is represents the activity on an elastic pool.
type ElasticPoolActivity struct {
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Type                           *string `json:"type,omitempty"`
	Location                       *string `json:"location,omitempty"`
	*ElasticPoolActivityProperties `json:"properties,omitempty"`
}

// ElasticPoolActivityListResult is represents the response to a list elastic
// pool activity request.
type ElasticPoolActivityListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ElasticPoolActivity `json:"value,omitempty"`
}

// ElasticPoolActivityProperties is represents the properties of an elastic
// pool.
type ElasticPoolActivityProperties struct {
	EndTime                       *date.Time `json:"endTime,omitempty"`
	ErrorCode                     *int32     `json:"errorCode,omitempty"`
	ErrorMessage                  *string    `json:"errorMessage,omitempty"`
	ErrorSeverity                 *int32     `json:"errorSeverity,omitempty"`
	Operation                     *string    `json:"operation,omitempty"`
	OperationID                   *uuid.UUID `json:"operationId,omitempty"`
	PercentComplete               *int32     `json:"percentComplete,omitempty"`
	RequestedDatabaseDtuMax       *int32     `json:"requestedDatabaseDtuMax,omitempty"`
	RequestedDatabaseDtuMin       *int32     `json:"requestedDatabaseDtuMin,omitempty"`
	RequestedDtu                  *int32     `json:"requestedDtu,omitempty"`
	RequestedElasticPoolName      *string    `json:"requestedElasticPoolName,omitempty"`
	RequestedStorageLimitInGB     *int64     `json:"requestedStorageLimitInGB,omitempty"`
	ElasticPoolName               *string    `json:"elasticPoolName,omitempty"`
	ServerName                    *string    `json:"serverName,omitempty"`
	StartTime                     *date.Time `json:"startTime,omitempty"`
	State                         *string    `json:"state,omitempty"`
	RequestedStorageLimitInMB     *int32     `json:"requestedStorageLimitInMB,omitempty"`
	RequestedDatabaseDtuGuarantee *int32     `json:"requestedDatabaseDtuGuarantee,omitempty"`
	RequestedDatabaseDtuCap       *int32     `json:"requestedDatabaseDtuCap,omitempty"`
	RequestedDtuGuarantee         *int32     `json:"requestedDtuGuarantee,omitempty"`
}

// ElasticPoolDatabaseActivity is represents the activity on an elastic pool.
type ElasticPoolDatabaseActivity struct {
	ID                                     *string `json:"id,omitempty"`
	Name                                   *string `json:"name,omitempty"`
	Type                                   *string `json:"type,omitempty"`
	Location                               *string `json:"location,omitempty"`
	*ElasticPoolDatabaseActivityProperties `json:"properties,omitempty"`
}

// ElasticPoolDatabaseActivityListResult is represents the response to a list
// elastic pool database activity request.
type ElasticPoolDatabaseActivityListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ElasticPoolDatabaseActivity `json:"value,omitempty"`
}

// ElasticPoolDatabaseActivityProperties is represents the properties of an
// elastic pool database activity.
type ElasticPoolDatabaseActivityProperties struct {
	DatabaseName              *string    `json:"databaseName,omitempty"`
	EndTime                   *date.Time `json:"endTime,omitempty"`
	ErrorCode                 *int32     `json:"errorCode,omitempty"`
	ErrorMessage              *string    `json:"errorMessage,omitempty"`
	ErrorSeverity             *int32     `json:"errorSeverity,omitempty"`
	Operation                 *string    `json:"operation,omitempty"`
	OperationID               *uuid.UUID `json:"operationId,omitempty"`
	PercentComplete           *int32     `json:"percentComplete,omitempty"`
	RequestedElasticPoolName  *string    `json:"requestedElasticPoolName,omitempty"`
	CurrentElasticPoolName    *string    `json:"currentElasticPoolName,omitempty"`
	CurrentServiceObjective   *string    `json:"currentServiceObjective,omitempty"`
	RequestedServiceObjective *string    `json:"requestedServiceObjective,omitempty"`
	ServerName                *string    `json:"serverName,omitempty"`
	StartTime                 *date.Time `json:"startTime,omitempty"`
	State                     *string    `json:"state,omitempty"`
}

// ElasticPoolDtuCapability is the Elastic Pool DTU capability.
type ElasticPoolDtuCapability struct {
	Limit                        *int64                                    `json:"limit,omitempty"`
	MaxDatabaseCount             *int64                                    `json:"maxDatabaseCount,omitempty"`
	Status                       CapabilityStatus                          `json:"status,omitempty"`
	SupportedMaxSizes            *[]MaxSizeCapability                      `json:"supportedMaxSizes,omitempty"`
	IncludedMaxSize              *MaxSizeCapability                        `json:"includedMaxSize,omitempty"`
	SupportedPerDatabaseMaxSizes *[]MaxSizeCapability                      `json:"supportedPerDatabaseMaxSizes,omitempty"`
	SupportedPerDatabaseMaxDtus  *[]ElasticPoolPerDatabaseMaxDtuCapability `json:"supportedPerDatabaseMaxDtus,omitempty"`
}

// ElasticPoolEditionCapability is the elastic pool edition capabilities.
type ElasticPoolEditionCapability struct {
	Name                     *string                     `json:"name,omitempty"`
	Status                   CapabilityStatus            `json:"status,omitempty"`
	SupportedElasticPoolDtus *[]ElasticPoolDtuCapability `json:"supportedElasticPoolDtus,omitempty"`
}

// ElasticPoolListResult is represents the response to a list elastic pool
// request.
type ElasticPoolListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ElasticPool `json:"value,omitempty"`
}

// ElasticPoolPerDatabaseMaxDtuCapability is the max per-database DTU
// capability.
type ElasticPoolPerDatabaseMaxDtuCapability struct {
	Limit                       *int64                                    `json:"limit,omitempty"`
	Status                      CapabilityStatus                          `json:"status,omitempty"`
	SupportedPerDatabaseMinDtus *[]ElasticPoolPerDatabaseMinDtuCapability `json:"supportedPerDatabaseMinDtus,omitempty"`
}

// ElasticPoolPerDatabaseMinDtuCapability is the minimum per-database DTU
// capability.
type ElasticPoolPerDatabaseMinDtuCapability struct {
	Limit  *int64           `json:"limit,omitempty"`
	Status CapabilityStatus `json:"status,omitempty"`
}

// ElasticPoolProperties is represents the properties of an elastic pool.
type ElasticPoolProperties struct {
	CreationDate   *date.Time         `json:"creationDate,omitempty"`
	State          ElasticPoolState   `json:"state,omitempty"`
	Edition        ElasticPoolEdition `json:"edition,omitempty"`
	Dtu            *int32             `json:"dtu,omitempty"`
	DatabaseDtuMax *int32             `json:"databaseDtuMax,omitempty"`
	DatabaseDtuMin *int32             `json:"databaseDtuMin,omitempty"`
	StorageMB      *int32             `json:"storageMB,omitempty"`
}

// ExportRequest is export database parameters.
type ExportRequest struct {
	StorageKeyType             StorageKeyType     `json:"storageKeyType,omitempty"`
	StorageKey                 *string            `json:"storageKey,omitempty"`
	StorageURI                 *string            `json:"storageUri,omitempty"`
	AdministratorLogin         *string            `json:"administratorLogin,omitempty"`
	AdministratorLoginPassword *string            `json:"administratorLoginPassword,omitempty"`
	AuthenticationType         AuthenticationType `json:"authenticationType,omitempty"`
}

// FirewallRule is represents a server firewall rule.
type FirewallRule struct {
	autorest.Response       `json:"-"`
	Name                    *string `json:"name,omitempty"`
	ID                      *string `json:"id,omitempty"`
	Kind                    *string `json:"kind,omitempty"`
	Location                *string `json:"location,omitempty"`
	Type                    *string `json:"type,omitempty"`
	*FirewallRuleProperties `json:"properties,omitempty"`
}

// FirewallRuleListResult is represents the response to a List Firewall Rules
// request.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]FirewallRule `json:"value,omitempty"`
}

// FirewallRuleProperties is represents the properties of a server firewall
// rule.
type FirewallRuleProperties struct {
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	EndIPAddress   *string `json:"endIpAddress,omitempty"`
}

// ImportExportResponse is response for Import/Export Get operation.
type ImportExportResponse struct {
	autorest.Response               `json:"-"`
	ID                              *string `json:"id,omitempty"`
	Name                            *string `json:"name,omitempty"`
	Type                            *string `json:"type,omitempty"`
	*ImportExportResponseProperties `json:"properties,omitempty"`
}

// ImportExportResponseProperties is response for Import/Export Status
// operation.
type ImportExportResponseProperties struct {
	RequestType      *string    `json:"requestType,omitempty"`
	RequestID        *uuid.UUID `json:"requestId,omitempty"`
	ServerName       *string    `json:"serverName,omitempty"`
	DatabaseName     *string    `json:"databaseName,omitempty"`
	Status           *string    `json:"status,omitempty"`
	LastModifiedTime *string    `json:"lastModifiedTime,omitempty"`
	QueuedTime       *string    `json:"queuedTime,omitempty"`
	BlobURI          *string    `json:"blobUri,omitempty"`
	ErrorMessage     *string    `json:"errorMessage,omitempty"`
}

// ImportExtensionProperties is represents the properties for an import
// operation
type ImportExtensionProperties struct {
	StorageKeyType             StorageKeyType     `json:"storageKeyType,omitempty"`
	StorageKey                 *string            `json:"storageKey,omitempty"`
	StorageURI                 *string            `json:"storageUri,omitempty"`
	AdministratorLogin         *string            `json:"administratorLogin,omitempty"`
	AdministratorLoginPassword *string            `json:"administratorLoginPassword,omitempty"`
	AuthenticationType         AuthenticationType `json:"authenticationType,omitempty"`
	OperationMode              *string            `json:"operationMode,omitempty"`
}

// ImportExtensionRequest is import database parameters.
type ImportExtensionRequest struct {
	Name                       *string `json:"name,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*ImportExtensionProperties `json:"properties,omitempty"`
}

// ImportRequest is import database parameters.
type ImportRequest struct {
	StorageKeyType             StorageKeyType       `json:"storageKeyType,omitempty"`
	StorageKey                 *string              `json:"storageKey,omitempty"`
	StorageURI                 *string              `json:"storageUri,omitempty"`
	AdministratorLogin         *string              `json:"administratorLogin,omitempty"`
	AdministratorLoginPassword *string              `json:"administratorLoginPassword,omitempty"`
	AuthenticationType         AuthenticationType   `json:"authenticationType,omitempty"`
	DatabaseName               *string              `json:"databaseName,omitempty"`
	Edition                    DatabaseEdition      `json:"edition,omitempty"`
	ServiceObjectiveName       ServiceObjectiveName `json:"serviceObjectiveName,omitempty"`
	MaxSizeBytes               *string              `json:"maxSizeBytes,omitempty"`
}

// LocationCapabilities is the capabilities for a location.
type LocationCapabilities struct {
	autorest.Response       `json:"-"`
	Name                    *string                    `json:"name,omitempty"`
	Status                  CapabilityStatus           `json:"status,omitempty"`
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
}

// MaxSizeCapability is the maximum size limits for a database.
type MaxSizeCapability struct {
	Limit  *int64           `json:"limit,omitempty"`
	Unit   MaxSizeUnits     `json:"unit,omitempty"`
	Status CapabilityStatus `json:"status,omitempty"`
}

// Operation is sQL REST API operation definition.
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is display metadata associated with the operation.
type OperationDisplay struct {
	Provider  *string `json:"provider,omitempty"`
	Resource  *string `json:"resource,omitempty"`
	Operation *string `json:"operation,omitempty"`
}

// OperationImpact is represents impact of an operation, both in absolute and
// relative terms.
type OperationImpact struct {
	Name                *string  `json:"name,omitempty"`
	Unit                *string  `json:"unit,omitempty"`
	ChangeValueAbsolute *float64 `json:"changeValueAbsolute,omitempty"`
	ChangeValueRelative *float64 `json:"changeValueRelative,omitempty"`
}

// OperationListResult is result of the request to list SQL operations. It
// contains a list of operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// PerformanceLevel is a possible performance level of a service objective
// capability.
type PerformanceLevel struct {
	Unit  PerformanceLevelUnit `json:"unit,omitempty"`
	Value *int32               `json:"value,omitempty"`
}

// ProxyResource is aRM proxy resource.
type ProxyResource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// RecommendedElasticPool is represents a recommented elastic pool.
type RecommendedElasticPool struct {
	autorest.Response                 `json:"-"`
	ID                                *string `json:"id,omitempty"`
	Name                              *string `json:"name,omitempty"`
	Type                              *string `json:"type,omitempty"`
	*RecommendedElasticPoolProperties `json:"properties,omitempty"`
}

// RecommendedElasticPoolListMetricsResult is represents the response to a list
// recommended elastic pool metrics request.
type RecommendedElasticPoolListMetricsResult struct {
	autorest.Response `json:"-"`
	Value             *[]RecommendedElasticPoolMetric `json:"value,omitempty"`
}

// RecommendedElasticPoolListResult is represents the response to a list
// recommended elastic pool request.
type RecommendedElasticPoolListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RecommendedElasticPool `json:"value,omitempty"`
}

// RecommendedElasticPoolMetric is represents recommended elastic pool metric.
type RecommendedElasticPoolMetric struct {
	DateTime *date.Time `json:"dateTime,omitempty"`
	Dtu      *float64   `json:"dtu,omitempty"`
	SizeGB   *float64   `json:"sizeGB,omitempty"`
}

// RecommendedElasticPoolProperties is represents the properties of a
// recommented elastic pool.
type RecommendedElasticPoolProperties struct {
	DatabaseEdition        ElasticPoolEdition              `json:"databaseEdition,omitempty"`
	Dtu                    *float64                        `json:"dtu,omitempty"`
	DatabaseDtuMin         *float64                        `json:"databaseDtuMin,omitempty"`
	DatabaseDtuMax         *float64                        `json:"databaseDtuMax,omitempty"`
	StorageMB              *float64                        `json:"storageMB,omitempty"`
	ObservationPeriodStart *date.Time                      `json:"observationPeriodStart,omitempty"`
	ObservationPeriodEnd   *date.Time                      `json:"observationPeriodEnd,omitempty"`
	MaxObservedDtu         *float64                        `json:"maxObservedDtu,omitempty"`
	MaxObservedStorageMB   *float64                        `json:"maxObservedStorageMB,omitempty"`
	Databases              *[]Database                     `json:"databases,omitempty"`
	Metrics                *[]RecommendedElasticPoolMetric `json:"metrics,omitempty"`
}

// RecommendedIndex is represents a database recommended index.
type RecommendedIndex struct {
	ID                          *string `json:"id,omitempty"`
	Name                        *string `json:"name,omitempty"`
	Type                        *string `json:"type,omitempty"`
	*RecommendedIndexProperties `json:"properties,omitempty"`
}

// RecommendedIndexProperties is represents the properties of a database
// recommended index.
type RecommendedIndexProperties struct {
	Action          RecommendedIndexAction `json:"action,omitempty"`
	State           RecommendedIndexState  `json:"state,omitempty"`
	Created         *date.Time             `json:"created,omitempty"`
	LastModified    *date.Time             `json:"lastModified,omitempty"`
	IndexType       RecommendedIndexType   `json:"indexType,omitempty"`
	Schema          *string                `json:"schema,omitempty"`
	Table           *string                `json:"table,omitempty"`
	Columns         *[]string              `json:"columns,omitempty"`
	IncludedColumns *[]string              `json:"includedColumns,omitempty"`
	IndexScript     *string                `json:"indexScript,omitempty"`
	EstimatedImpact *[]OperationImpact     `json:"estimatedImpact,omitempty"`
	ReportedImpact  *[]OperationImpact     `json:"reportedImpact,omitempty"`
}

// ReplicationLink is represents a database replication link.
type ReplicationLink struct {
	autorest.Response          `json:"-"`
	Name                       *string `json:"name,omitempty"`
	ID                         *string `json:"id,omitempty"`
	Location                   *string `json:"location,omitempty"`
	Type                       *string `json:"type,omitempty"`
	*ReplicationLinkProperties `json:"properties,omitempty"`
}

// ReplicationLinkListResult is represents the response to a List database
// replication link request.
type ReplicationLinkListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ReplicationLink `json:"value,omitempty"`
}

// ReplicationLinkProperties is represents the properties of a database
// replication link.
type ReplicationLinkProperties struct {
	IsTerminationAllowed *bool            `json:"isTerminationAllowed,omitempty"`
	ReplicationMode      *string          `json:"replicationMode,omitempty"`
	PartnerServer        *string          `json:"partnerServer,omitempty"`
	PartnerDatabase      *string          `json:"partnerDatabase,omitempty"`
	PartnerLocation      *string          `json:"partnerLocation,omitempty"`
	Role                 ReplicationRole  `json:"role,omitempty"`
	PartnerRole          ReplicationRole  `json:"partnerRole,omitempty"`
	StartTime            *date.Time       `json:"startTime,omitempty"`
	PercentComplete      *int32           `json:"percentComplete,omitempty"`
	ReplicationState     ReplicationState `json:"replicationState,omitempty"`
}

// Resource is aRM resource.
type Resource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// RestorePoint is represents a database restore point.
type RestorePoint struct {
	ID                      *string `json:"id,omitempty"`
	Name                    *string `json:"name,omitempty"`
	Type                    *string `json:"type,omitempty"`
	*RestorePointProperties `json:"properties,omitempty"`
}

// RestorePointListResult is represents the response to a list database restore
// points request.
type RestorePointListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RestorePoint `json:"value,omitempty"`
}

// RestorePointProperties is represents the properties of a database restore
// point.
type RestorePointProperties struct {
	RestorePointType         RestorePointTypes `json:"restorePointType,omitempty"`
	RestorePointCreationDate *date.Time        `json:"restorePointCreationDate,omitempty"`
	EarliestRestoreDate      *date.Time        `json:"earliestRestoreDate,omitempty"`
}

// Server is represents a server.
type Server struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Kind              *string             `json:"kind,omitempty"`
	*ServerProperties `json:"properties,omitempty"`
}

// ServerListResult is represents the response to a get server request.
type ServerListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Server `json:"value,omitempty"`
}

// ServerMetric is represents server metrics.
type ServerMetric struct {
	Name          *string    `json:"name,omitempty"`
	ResourceName  *string    `json:"resourceName,omitempty"`
	DisplayName   *string    `json:"displayName,omitempty"`
	CurrentValue  *float64   `json:"currentValue,omitempty"`
	Limit         *float64   `json:"limit,omitempty"`
	Unit          *string    `json:"unit,omitempty"`
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// ServerMetricListResult is represents the response to a list server metrics
// request.
type ServerMetricListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ServerMetric `json:"value,omitempty"`
}

// ServerProperties is represents the properties of a server.
type ServerProperties struct {
	FullyQualifiedDomainName   *string       `json:"fullyQualifiedDomainName,omitempty"`
	Version                    ServerVersion `json:"version,omitempty"`
	AdministratorLogin         *string       `json:"administratorLogin,omitempty"`
	AdministratorLoginPassword *string       `json:"administratorLoginPassword,omitempty"`
	ExternalAdministratorSid   *uuid.UUID    `json:"externalAdministratorSid,omitempty"`
	ExternalAdministratorLogin *string       `json:"externalAdministratorLogin,omitempty"`
	State                      ServerState   `json:"state,omitempty"`
}

// ServerVersionCapability is the server capabilities.
type ServerVersionCapability struct {
	Name                         *string                         `json:"name,omitempty"`
	Status                       CapabilityStatus                `json:"status,omitempty"`
	SupportedEditions            *[]EditionCapability            `json:"supportedEditions,omitempty"`
	SupportedElasticPoolEditions *[]ElasticPoolEditionCapability `json:"supportedElasticPoolEditions,omitempty"`
}

// ServiceObjective is represents a database service objective.
type ServiceObjective struct {
	autorest.Response           `json:"-"`
	Name                        *string `json:"name,omitempty"`
	ID                          *string `json:"id,omitempty"`
	*ServiceObjectiveProperties `json:"properties,omitempty"`
}

// ServiceObjectiveCapability is the service objectives capability.
type ServiceObjectiveCapability struct {
	Name              *string          `json:"name,omitempty"`
	Status            CapabilityStatus `json:"status,omitempty"`
	*PerformanceLevel `json:"performanceLevel,omitempty"`
	ID                *uuid.UUID           `json:"id,omitempty"`
	SupportedMaxSizes *[]MaxSizeCapability `json:"supportedMaxSizes,omitempty"`
	IncludedMaxSize   *MaxSizeCapability   `json:"includedMaxSize,omitempty"`
}

// ServiceObjectiveListResult is represents the response to a get database
// service objectives request.
type ServiceObjectiveListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ServiceObjective `json:"value,omitempty"`
}

// ServiceObjectiveProperties is represents the properties of a database
// service objective.
type ServiceObjectiveProperties struct {
	ServiceObjectiveName *string `json:"serviceObjectiveName,omitempty"`
	IsDefault            *bool   `json:"isDefault,omitempty"`
	IsSystem             *bool   `json:"isSystem,omitempty"`
	Description          *string `json:"description,omitempty"`
	Enabled              *bool   `json:"enabled,omitempty"`
}

// ServiceTierAdvisor is represents a Service Tier Advisor.
type ServiceTierAdvisor struct {
	autorest.Response             `json:"-"`
	Name                          *string `json:"name,omitempty"`
	ID                            *string `json:"id,omitempty"`
	*ServiceTierAdvisorProperties `json:"properties,omitempty"`
}

// ServiceTierAdvisorListResult is represents the response to a list service
// tier advisor request.
type ServiceTierAdvisorListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ServiceTierAdvisor `json:"value,omitempty"`
}

// ServiceTierAdvisorProperties is represents the properties of a Service Tier
// Advisor.
type ServiceTierAdvisorProperties struct {
	ObservationPeriodStart                                 *date.Time        `json:"observationPeriodStart,omitempty"`
	ObservationPeriodEnd                                   *date.Time        `json:"observationPeriodEnd,omitempty"`
	ActiveTimeRatio                                        *float64          `json:"activeTimeRatio,omitempty"`
	MinDtu                                                 *float64          `json:"minDtu,omitempty"`
	AvgDtu                                                 *float64          `json:"avgDtu,omitempty"`
	MaxDtu                                                 *float64          `json:"maxDtu,omitempty"`
	MaxSizeInGB                                            *float64          `json:"maxSizeInGB,omitempty"`
	ServiceLevelObjectiveUsageMetrics                      *[]SloUsageMetric `json:"serviceLevelObjectiveUsageMetrics,omitempty"`
	CurrentServiceLevelObjective                           *string           `json:"currentServiceLevelObjective,omitempty"`
	CurrentServiceLevelObjectiveID                         *uuid.UUID        `json:"currentServiceLevelObjectiveId,omitempty"`
	UsageBasedRecommendationServiceLevelObjective          *string           `json:"usageBasedRecommendationServiceLevelObjective,omitempty"`
	UsageBasedRecommendationServiceLevelObjectiveID        *uuid.UUID        `json:"usageBasedRecommendationServiceLevelObjectiveId,omitempty"`
	DatabaseSizeBasedRecommendationServiceLevelObjective   *string           `json:"databaseSizeBasedRecommendationServiceLevelObjective,omitempty"`
	DatabaseSizeBasedRecommendationServiceLevelObjectiveID *uuid.UUID        `json:"databaseSizeBasedRecommendationServiceLevelObjectiveId,omitempty"`
	DisasterPlanBasedRecommendationServiceLevelObjective   *string           `json:"disasterPlanBasedRecommendationServiceLevelObjective,omitempty"`
	DisasterPlanBasedRecommendationServiceLevelObjectiveID *uuid.UUID        `json:"disasterPlanBasedRecommendationServiceLevelObjectiveId,omitempty"`
	OverallRecommendationServiceLevelObjective             *string           `json:"overallRecommendationServiceLevelObjective,omitempty"`
	OverallRecommendationServiceLevelObjectiveID           *uuid.UUID        `json:"overallRecommendationServiceLevelObjectiveId,omitempty"`
	Confidence                                             *float64          `json:"confidence,omitempty"`
}

// SloUsageMetric is represents a Slo Usage Metric.
type SloUsageMetric struct {
	ServiceLevelObjective   ServiceObjectiveName `json:"serviceLevelObjective,omitempty"`
	ServiceLevelObjectiveID *uuid.UUID           `json:"serviceLevelObjectiveId,omitempty"`
	InRangeTimeRatio        *float64             `json:"inRangeTimeRatio,omitempty"`
}

// SubResource is subresource properties
type SubResource struct {
	Name *string `json:"name,omitempty"`
	ID   *string `json:"id,omitempty"`
}

// TrackedResource is aRM tracked top level resource.
type TrackedResource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
	Location *string             `json:"location,omitempty"`
}

// TransparentDataEncryption is represents a database transparent data
// encryption .
type TransparentDataEncryption struct {
	autorest.Response                    `json:"-"`
	Name                                 *string `json:"name,omitempty"`
	ID                                   *string `json:"id,omitempty"`
	*TransparentDataEncryptionProperties `json:"properties,omitempty"`
}

// TransparentDataEncryptionActivity is represents a database transparent data
// encryption Scan.
type TransparentDataEncryptionActivity struct {
	Name                                         *string `json:"name,omitempty"`
	ID                                           *string `json:"id,omitempty"`
	*TransparentDataEncryptionActivityProperties `json:"properties,omitempty"`
}

// TransparentDataEncryptionActivityListResult is represents the response to a
// list database transparent data encryption activity request.
type TransparentDataEncryptionActivityListResult struct {
	autorest.Response `json:"-"`
	Value             *[]TransparentDataEncryptionActivity `json:"value,omitempty"`
}

// TransparentDataEncryptionActivityProperties is represents the properties of
// a database transparent data encryption Scan.
type TransparentDataEncryptionActivityProperties struct {
	Status          TransparentDataEncryptionActivityStatus `json:"status,omitempty"`
	PercentComplete *float64                                `json:"percentComplete,omitempty"`
}

// TransparentDataEncryptionProperties is represents the properties of a
// database transparent data encryption.
type TransparentDataEncryptionProperties struct {
	Status TransparentDataEncryptionStatus `json:"status,omitempty"`
}
