// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/support/common.proto

package common // import "google.golang.org/genproto/googleapis/cloud/support/common"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The current state of this SupportAccount.
type SupportAccount_State int32

const (
	// Account is in an unknown state.
	SupportAccount_STATE_UNSPECIFIED SupportAccount_State = 0
	// Account is in an active state.
	SupportAccount_ACTIVE SupportAccount_State = 1
	// Account has been created but is being provisioned in support systems.
	SupportAccount_PENDING SupportAccount_State = 2
	// Account deletion has been requested by the user.
	SupportAccount_PENDING_DELETION SupportAccount_State = 3
)

var SupportAccount_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "ACTIVE",
	2: "PENDING",
	3: "PENDING_DELETION",
}
var SupportAccount_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"ACTIVE":            1,
	"PENDING":           2,
	"PENDING_DELETION":  3,
}

func (x SupportAccount_State) String() string {
	return proto.EnumName(SupportAccount_State_name, int32(x))
}
func (SupportAccount_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{0, 0}
}

// Pricing model applicable to this support account.
type SupportAccount_PricingModel int32

const (
	// This account is subscribed to an unknown pricing model.
	SupportAccount_PRICING_MODEL_UNKNOWN SupportAccount_PricingModel = 0
	// Package based pricing (Platinum, Gold, Silver, Bronze).
	SupportAccount_PACKAGES SupportAccount_PricingModel = 1
	// Support charges are calculated based on user seats a.k.a,
	// "Pick Your Team" model.
	SupportAccount_USER_ROLES SupportAccount_PricingModel = 2
)

var SupportAccount_PricingModel_name = map[int32]string{
	0: "PRICING_MODEL_UNKNOWN",
	1: "PACKAGES",
	2: "USER_ROLES",
}
var SupportAccount_PricingModel_value = map[string]int32{
	"PRICING_MODEL_UNKNOWN": 0,
	"PACKAGES":              1,
	"USER_ROLES":            2,
}

func (x SupportAccount_PricingModel) String() string {
	return proto.EnumName(SupportAccount_PricingModel_name, int32(x))
}
func (SupportAccount_PricingModel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{0, 1}
}

// The case priority with P0 being the most urgent and P4 the least.
type Case_Priority int32

const (
	// Priority is undefined or has not been set yet.
	Case_PRIORITY_UNSPECIFIED Case_Priority = 0
	// Extreme impact on a production service - Service is hard down.
	Case_P0 Case_Priority = 1
	// Critical impact on a production service - Service is currently unusable.
	Case_P1 Case_Priority = 2
	// Severe impact on a production service - Service is usable but greatly
	// impaired.
	Case_P2 Case_Priority = 3
	// Medium impact on a production service - Service is available, but
	// moderately impaired.
	Case_P3 Case_Priority = 4
	// General questions or minor issues - Production service is fully
	// available.
	Case_P4 Case_Priority = 5
)

var Case_Priority_name = map[int32]string{
	0: "PRIORITY_UNSPECIFIED",
	1: "P0",
	2: "P1",
	3: "P2",
	4: "P3",
	5: "P4",
}
var Case_Priority_value = map[string]int32{
	"PRIORITY_UNSPECIFIED": 0,
	"P0":                   1,
	"P1":                   2,
	"P2":                   3,
	"P3":                   4,
	"P4":                   5,
}

func (x Case_Priority) String() string {
	return proto.EnumName(Case_Priority_name, int32(x))
}
func (Case_Priority) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{1, 0}
}

// The state of a case.
type Case_State int32

const (
	// Case is in an unknown state.
	Case_STATE_UNSPECIFIED Case_State = 0
	// Case has been created but no one is assigned to work on it yet.
	Case_NEW Case_State = 1
	// Case has been assigned to a support agent.
	Case_ASSIGNED Case_State = 2
	// A support agent is currently investigating the case.
	Case_IN_PROGRESS_GOOGLE_SUPPORT Case_State = 3
	// Case has been forwarded to product team for further investigation.
	Case_IN_PROGRESS_GOOGLE_ENG Case_State = 4
	// Case is under investigation and relates to a known issue.
	Case_IN_PROGRESS_KNOWN_ISSUE Case_State = 5
	// Case is waiting for a response from the customer.
	Case_WAITING_FOR_CUSTOMER_RESPONSE Case_State = 6
	// A solution has been offered for the case but it isn't closed yet.
	Case_SOLUTION_OFFERED Case_State = 7
	// Cases has been fully resolved and is in a closed state.
	Case_CLOSED Case_State = 8
)

var Case_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "NEW",
	2: "ASSIGNED",
	3: "IN_PROGRESS_GOOGLE_SUPPORT",
	4: "IN_PROGRESS_GOOGLE_ENG",
	5: "IN_PROGRESS_KNOWN_ISSUE",
	6: "WAITING_FOR_CUSTOMER_RESPONSE",
	7: "SOLUTION_OFFERED",
	8: "CLOSED",
}
var Case_State_value = map[string]int32{
	"STATE_UNSPECIFIED":             0,
	"NEW":                           1,
	"ASSIGNED":                      2,
	"IN_PROGRESS_GOOGLE_SUPPORT":    3,
	"IN_PROGRESS_GOOGLE_ENG":        4,
	"IN_PROGRESS_KNOWN_ISSUE":       5,
	"WAITING_FOR_CUSTOMER_RESPONSE": 6,
	"SOLUTION_OFFERED":              7,
	"CLOSED":                        8,
}

func (x Case_State) String() string {
	return proto.EnumName(Case_State_name, int32(x))
}
func (Case_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{1, 1}
}

// The status of a customer issue.
type CustomerIssue_IssueState int32

const (
	// Issue in an unknown state.
	CustomerIssue_ISSUE_STATE_UNSPECIFIED CustomerIssue_IssueState = 0
	// Issue is currently open but the work on it has not been started.
	CustomerIssue_OPEN CustomerIssue_IssueState = 1
	// Issue is currently being worked on.
	CustomerIssue_IN_PROGRESS CustomerIssue_IssueState = 2
	// Issue is fixed.
	CustomerIssue_FIXED CustomerIssue_IssueState = 3
	// Issue has been marked as invalid.
	CustomerIssue_WONT_FIX CustomerIssue_IssueState = 4
	// Issue verified and in production.
	CustomerIssue_VERIFIED CustomerIssue_IssueState = 5
)

var CustomerIssue_IssueState_name = map[int32]string{
	0: "ISSUE_STATE_UNSPECIFIED",
	1: "OPEN",
	2: "IN_PROGRESS",
	3: "FIXED",
	4: "WONT_FIX",
	5: "VERIFIED",
}
var CustomerIssue_IssueState_value = map[string]int32{
	"ISSUE_STATE_UNSPECIFIED": 0,
	"OPEN":                    1,
	"IN_PROGRESS":             2,
	"FIXED":                   3,
	"WONT_FIX":                4,
	"VERIFIED":                5,
}

func (x CustomerIssue_IssueState) String() string {
	return proto.EnumName(CustomerIssue_IssueState_name, int32(x))
}
func (CustomerIssue_IssueState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{2, 0}
}

// A role which determines the support resources and features a user might
// get access to.
type SupportRole_Role int32

const (
	// An unknown role.
	SupportRole_ROLE_UNSPECIFIED SupportRole_Role = 0
	// The basic support role.
	SupportRole_BASIC SupportRole_Role = 1
	// The developer role.
	SupportRole_DEVELOPER SupportRole_Role = 2
	// The operation role.
	SupportRole_OPERATION SupportRole_Role = 3
	// The site reliability role.
	SupportRole_SITE_RELIABILITY SupportRole_Role = 4
)

var SupportRole_Role_name = map[int32]string{
	0: "ROLE_UNSPECIFIED",
	1: "BASIC",
	2: "DEVELOPER",
	3: "OPERATION",
	4: "SITE_RELIABILITY",
}
var SupportRole_Role_value = map[string]int32{
	"ROLE_UNSPECIFIED": 0,
	"BASIC":            1,
	"DEVELOPER":        2,
	"OPERATION":        3,
	"SITE_RELIABILITY": 4,
}

func (x SupportRole_Role) String() string {
	return proto.EnumName(SupportRole_Role_name, int32(x))
}
func (SupportRole_Role) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{3, 0}
}

// A Google Cloud Platform account that identifies support eligibility for a
// Cloud resource. Currently the Cloud resource can only be an Organization
// but this might change in future.
type SupportAccount struct {
	// The resource name for a support account in format
	// `supportAccounts/{account_id}`.
	// Output only.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Identifier for this entity that gets persisted in storage system. The
	// resource name is populated using this field in format
	// `supportAccounts/{account_id}`.
	AccountId string `protobuf:"bytes,2,opt,name=account_id,json=accountId,proto3" json:"account_id,omitempty"`
	// The Cloud resource with which this support account is associated.
	CloudResource string `protobuf:"bytes,3,opt,name=cloud_resource,json=cloudResource,proto3" json:"cloud_resource,omitempty"`
	// A user friendly display name assigned to this support account.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Indicates the current state of an account.
	State SupportAccount_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.support.common.SupportAccount_State" json:"state,omitempty"`
	// Time when this account was created.
	// Output only.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The resource name of a billing account associated with this support
	// account. For example, `billingAccounts/ABCDEF-012345-567890`.
	BillingAccountName string `protobuf:"bytes,7,opt,name=billing_account_name,json=billingAccountName,proto3" json:"billing_account_name,omitempty"`
	UnifyAccountId     string `protobuf:"bytes,8,opt,name=unify_account_id,json=unifyAccountId,proto3" json:"unify_account_id,omitempty"`
	// The PricingModel applicable to this support account.
	PricingModel         SupportAccount_PricingModel `protobuf:"varint,9,opt,name=pricing_model,json=pricingModel,proto3,enum=google.cloud.support.common.SupportAccount_PricingModel" json:"pricing_model,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *SupportAccount) Reset()         { *m = SupportAccount{} }
func (m *SupportAccount) String() string { return proto.CompactTextString(m) }
func (*SupportAccount) ProtoMessage()    {}
func (*SupportAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{0}
}
func (m *SupportAccount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SupportAccount.Unmarshal(m, b)
}
func (m *SupportAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SupportAccount.Marshal(b, m, deterministic)
}
func (dst *SupportAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SupportAccount.Merge(dst, src)
}
func (m *SupportAccount) XXX_Size() int {
	return xxx_messageInfo_SupportAccount.Size(m)
}
func (m *SupportAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_SupportAccount.DiscardUnknown(m)
}

var xxx_messageInfo_SupportAccount proto.InternalMessageInfo

func (m *SupportAccount) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SupportAccount) GetAccountId() string {
	if m != nil {
		return m.AccountId
	}
	return ""
}

func (m *SupportAccount) GetCloudResource() string {
	if m != nil {
		return m.CloudResource
	}
	return ""
}

func (m *SupportAccount) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *SupportAccount) GetState() SupportAccount_State {
	if m != nil {
		return m.State
	}
	return SupportAccount_STATE_UNSPECIFIED
}

func (m *SupportAccount) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *SupportAccount) GetBillingAccountName() string {
	if m != nil {
		return m.BillingAccountName
	}
	return ""
}

func (m *SupportAccount) GetUnifyAccountId() string {
	if m != nil {
		return m.UnifyAccountId
	}
	return ""
}

func (m *SupportAccount) GetPricingModel() SupportAccount_PricingModel {
	if m != nil {
		return m.PricingModel
	}
	return SupportAccount_PRICING_MODEL_UNKNOWN
}

// A support case created by the user.
type Case struct {
	// The resource name for the Case in format
	// `supportAccounts/{account_id}/cases/{case_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The short summary of the issue reported in this case.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The board description of issue provided with initial summary.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The product component for which this Case is reported.
	Component string `protobuf:"bytes,4,opt,name=component,proto3" json:"component,omitempty"`
	// The product subcomponent for which this Case is reported.
	Subcomponent string `protobuf:"bytes,5,opt,name=subcomponent,proto3" json:"subcomponent,omitempty"`
	// Timezone the client sending this request is in.
	// It should be in a format IANA recognizes: https://www.iana.org/time-zone
	// There is no additional validation done by the API.
	ClientTimezone string `protobuf:"bytes,6,opt,name=client_timezone,json=clientTimezone,proto3" json:"client_timezone,omitempty"`
	// The email addresses that can be copied to receive updates on this case.
	// Users can specify a maximum of 10 email addresses.
	CcAddresses []string `protobuf:"bytes,7,rep,name=cc_addresses,json=ccAddresses,proto3" json:"cc_addresses,omitempty"`
	// The Google Cloud Platform project ID for which this case is created.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// List of customer issues associated with this case.
	Issues []*CustomerIssue `protobuf:"bytes,10,rep,name=issues,proto3" json:"issues,omitempty"`
	// The current priority of this case.
	Priority Case_Priority `protobuf:"varint,11,opt,name=priority,proto3,enum=google.cloud.support.common.Case_Priority" json:"priority,omitempty"`
	// The current state of this case.
	State Case_State `protobuf:"varint,12,opt,name=state,proto3,enum=google.cloud.support.common.Case_State" json:"state,omitempty"`
	// Time when this case was created.
	// Output only.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when this case was last updated.
	// Output only.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,14,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Email address of user who created this case.
	// Output only. It is inferred from credentials supplied during case creation.
	CreatorEmail string `protobuf:"bytes,15,opt,name=creator_email,json=creatorEmail,proto3" json:"creator_email,omitempty"`
	// The issue category applicable to this case.
	Category             string   `protobuf:"bytes,16,opt,name=category,proto3" json:"category,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Case) Reset()         { *m = Case{} }
func (m *Case) String() string { return proto.CompactTextString(m) }
func (*Case) ProtoMessage()    {}
func (*Case) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{1}
}
func (m *Case) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Case.Unmarshal(m, b)
}
func (m *Case) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Case.Marshal(b, m, deterministic)
}
func (dst *Case) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Case.Merge(dst, src)
}
func (m *Case) XXX_Size() int {
	return xxx_messageInfo_Case.Size(m)
}
func (m *Case) XXX_DiscardUnknown() {
	xxx_messageInfo_Case.DiscardUnknown(m)
}

var xxx_messageInfo_Case proto.InternalMessageInfo

func (m *Case) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Case) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Case) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Case) GetComponent() string {
	if m != nil {
		return m.Component
	}
	return ""
}

func (m *Case) GetSubcomponent() string {
	if m != nil {
		return m.Subcomponent
	}
	return ""
}

func (m *Case) GetClientTimezone() string {
	if m != nil {
		return m.ClientTimezone
	}
	return ""
}

func (m *Case) GetCcAddresses() []string {
	if m != nil {
		return m.CcAddresses
	}
	return nil
}

func (m *Case) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Case) GetIssues() []*CustomerIssue {
	if m != nil {
		return m.Issues
	}
	return nil
}

func (m *Case) GetPriority() Case_Priority {
	if m != nil {
		return m.Priority
	}
	return Case_PRIORITY_UNSPECIFIED
}

func (m *Case) GetState() Case_State {
	if m != nil {
		return m.State
	}
	return Case_STATE_UNSPECIFIED
}

func (m *Case) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Case) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Case) GetCreatorEmail() string {
	if m != nil {
		return m.CreatorEmail
	}
	return ""
}

func (m *Case) GetCategory() string {
	if m != nil {
		return m.Category
	}
	return ""
}

// Reference to a Google internal ticket used for investigating a support case.
// Not every support case will have an internal ticket associated with it.
// A support case can have multiple tickets linked to it.
type CustomerIssue struct {
	// Unique identifier for the internal issue.
	// Output only.
	IssueId string `protobuf:"bytes,1,opt,name=issue_id,json=issueId,proto3" json:"issue_id,omitempty"`
	// Represents current status of the internal ticket.
	// Output only.
	State CustomerIssue_IssueState `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.support.common.CustomerIssue_IssueState" json:"state,omitempty"`
	// Time when the internal issue was created.
	// Output only.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time when the internal issue was marked as resolved.
	// Output only.
	ResolveTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=resolve_time,json=resolveTime,proto3" json:"resolve_time,omitempty"`
	// Time when the internal issue was last updated.
	// Output only.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CustomerIssue) Reset()         { *m = CustomerIssue{} }
func (m *CustomerIssue) String() string { return proto.CompactTextString(m) }
func (*CustomerIssue) ProtoMessage()    {}
func (*CustomerIssue) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{2}
}
func (m *CustomerIssue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomerIssue.Unmarshal(m, b)
}
func (m *CustomerIssue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomerIssue.Marshal(b, m, deterministic)
}
func (dst *CustomerIssue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomerIssue.Merge(dst, src)
}
func (m *CustomerIssue) XXX_Size() int {
	return xxx_messageInfo_CustomerIssue.Size(m)
}
func (m *CustomerIssue) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomerIssue.DiscardUnknown(m)
}

var xxx_messageInfo_CustomerIssue proto.InternalMessageInfo

func (m *CustomerIssue) GetIssueId() string {
	if m != nil {
		return m.IssueId
	}
	return ""
}

func (m *CustomerIssue) GetState() CustomerIssue_IssueState {
	if m != nil {
		return m.State
	}
	return CustomerIssue_ISSUE_STATE_UNSPECIFIED
}

func (m *CustomerIssue) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *CustomerIssue) GetResolveTime() *timestamp.Timestamp {
	if m != nil {
		return m.ResolveTime
	}
	return nil
}

func (m *CustomerIssue) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// A message that contains mapping of a user and their role under a support
// account.
type SupportRole struct {
	// Email address of user being added through this Role.
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// The type of role assigned to user.
	Role                 SupportRole_Role `protobuf:"varint,2,opt,name=role,proto3,enum=google.cloud.support.common.SupportRole_Role" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *SupportRole) Reset()         { *m = SupportRole{} }
func (m *SupportRole) String() string { return proto.CompactTextString(m) }
func (*SupportRole) ProtoMessage()    {}
func (*SupportRole) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{3}
}
func (m *SupportRole) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SupportRole.Unmarshal(m, b)
}
func (m *SupportRole) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SupportRole.Marshal(b, m, deterministic)
}
func (dst *SupportRole) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SupportRole.Merge(dst, src)
}
func (m *SupportRole) XXX_Size() int {
	return xxx_messageInfo_SupportRole.Size(m)
}
func (m *SupportRole) XXX_DiscardUnknown() {
	xxx_messageInfo_SupportRole.DiscardUnknown(m)
}

var xxx_messageInfo_SupportRole proto.InternalMessageInfo

func (m *SupportRole) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *SupportRole) GetRole() SupportRole_Role {
	if m != nil {
		return m.Role
	}
	return SupportRole_ROLE_UNSPECIFIED
}

// The comment text associated with a `Case`.
type Comment struct {
	// Text containing a maximum of 3000 characters.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Time when this update was created.
	// Output only.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The email address/name of user who created this comment.
	// Output only.
	Author string `protobuf:"bytes,3,opt,name=author,proto3" json:"author,omitempty"`
	// The resource name for this comment in format
	// `supportAccounts/{account_id}/cases/{case_id}/{comment_id}`.
	// Output only.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Comment) Reset()         { *m = Comment{} }
func (m *Comment) String() string { return proto.CompactTextString(m) }
func (*Comment) ProtoMessage()    {}
func (*Comment) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{4}
}
func (m *Comment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Comment.Unmarshal(m, b)
}
func (m *Comment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Comment.Marshal(b, m, deterministic)
}
func (dst *Comment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Comment.Merge(dst, src)
}
func (m *Comment) XXX_Size() int {
	return xxx_messageInfo_Comment.Size(m)
}
func (m *Comment) XXX_DiscardUnknown() {
	xxx_messageInfo_Comment.DiscardUnknown(m)
}

var xxx_messageInfo_Comment proto.InternalMessageInfo

func (m *Comment) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Comment) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Comment) GetAuthor() string {
	if m != nil {
		return m.Author
	}
	return ""
}

func (m *Comment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Represents the product component taxonomy that is to be used while creating
// or updating a `Case`. A client should obtain the list of issue categories,
// component/subcomponent from this object and specify it in `Case.category`,
// `Case.component` and `Case.subcomponent` fields respectively.
type IssueTaxonomy struct {
	// Map of available categories.
	Categories           map[string]*IssueTaxonomy_Category `protobuf:"bytes,1,rep,name=categories,proto3" json:"categories,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *IssueTaxonomy) Reset()         { *m = IssueTaxonomy{} }
func (m *IssueTaxonomy) String() string { return proto.CompactTextString(m) }
func (*IssueTaxonomy) ProtoMessage()    {}
func (*IssueTaxonomy) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{5}
}
func (m *IssueTaxonomy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IssueTaxonomy.Unmarshal(m, b)
}
func (m *IssueTaxonomy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IssueTaxonomy.Marshal(b, m, deterministic)
}
func (dst *IssueTaxonomy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IssueTaxonomy.Merge(dst, src)
}
func (m *IssueTaxonomy) XXX_Size() int {
	return xxx_messageInfo_IssueTaxonomy.Size(m)
}
func (m *IssueTaxonomy) XXX_DiscardUnknown() {
	xxx_messageInfo_IssueTaxonomy.DiscardUnknown(m)
}

var xxx_messageInfo_IssueTaxonomy proto.InternalMessageInfo

func (m *IssueTaxonomy) GetCategories() map[string]*IssueTaxonomy_Category {
	if m != nil {
		return m.Categories
	}
	return nil
}

// The representation of a product component. It is composed of a canonical
// name for the product (e.g., Google App Engine), languages in which a
// support ticket can be created under this component, a template that
// provides hints on important details to be filled out before submitting a
// case. It also contains an embedded list of product subcomponents that have
// similar attributes as top-level components.
// (e.g., Google App Engine > Memcache).
type IssueTaxonomy_Component struct {
	// User friendly name of this component.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// List of languages in which a support case can be created under this
	// component. Represented by language codes in ISO_639-1 standard.
	Languages []string `protobuf:"bytes,2,rep,name=languages,proto3" json:"languages,omitempty"`
	// Template to be used while filling the description of a support case.
	Template string `protobuf:"bytes,3,opt,name=template,proto3" json:"template,omitempty"`
	// List of subcomponents under this component.
	Subcomponents        []*IssueTaxonomy_Component `protobuf:"bytes,4,rep,name=subcomponents,proto3" json:"subcomponents,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *IssueTaxonomy_Component) Reset()         { *m = IssueTaxonomy_Component{} }
func (m *IssueTaxonomy_Component) String() string { return proto.CompactTextString(m) }
func (*IssueTaxonomy_Component) ProtoMessage()    {}
func (*IssueTaxonomy_Component) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{5, 0}
}
func (m *IssueTaxonomy_Component) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IssueTaxonomy_Component.Unmarshal(m, b)
}
func (m *IssueTaxonomy_Component) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IssueTaxonomy_Component.Marshal(b, m, deterministic)
}
func (dst *IssueTaxonomy_Component) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IssueTaxonomy_Component.Merge(dst, src)
}
func (m *IssueTaxonomy_Component) XXX_Size() int {
	return xxx_messageInfo_IssueTaxonomy_Component.Size(m)
}
func (m *IssueTaxonomy_Component) XXX_DiscardUnknown() {
	xxx_messageInfo_IssueTaxonomy_Component.DiscardUnknown(m)
}

var xxx_messageInfo_IssueTaxonomy_Component proto.InternalMessageInfo

func (m *IssueTaxonomy_Component) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *IssueTaxonomy_Component) GetLanguages() []string {
	if m != nil {
		return m.Languages
	}
	return nil
}

func (m *IssueTaxonomy_Component) GetTemplate() string {
	if m != nil {
		return m.Template
	}
	return ""
}

func (m *IssueTaxonomy_Component) GetSubcomponents() []*IssueTaxonomy_Component {
	if m != nil {
		return m.Subcomponents
	}
	return nil
}

// Represents the category of issue (Technical or Non-Technical)
// reported through a support case.
type IssueTaxonomy_Category struct {
	// User friendly name of this category.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Map of product components under this category.
	Components           map[string]*IssueTaxonomy_Component `protobuf:"bytes,2,rep,name=components,proto3" json:"components,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *IssueTaxonomy_Category) Reset()         { *m = IssueTaxonomy_Category{} }
func (m *IssueTaxonomy_Category) String() string { return proto.CompactTextString(m) }
func (*IssueTaxonomy_Category) ProtoMessage()    {}
func (*IssueTaxonomy_Category) Descriptor() ([]byte, []int) {
	return fileDescriptor_common_f17357843abc5917, []int{5, 1}
}
func (m *IssueTaxonomy_Category) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IssueTaxonomy_Category.Unmarshal(m, b)
}
func (m *IssueTaxonomy_Category) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IssueTaxonomy_Category.Marshal(b, m, deterministic)
}
func (dst *IssueTaxonomy_Category) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IssueTaxonomy_Category.Merge(dst, src)
}
func (m *IssueTaxonomy_Category) XXX_Size() int {
	return xxx_messageInfo_IssueTaxonomy_Category.Size(m)
}
func (m *IssueTaxonomy_Category) XXX_DiscardUnknown() {
	xxx_messageInfo_IssueTaxonomy_Category.DiscardUnknown(m)
}

var xxx_messageInfo_IssueTaxonomy_Category proto.InternalMessageInfo

func (m *IssueTaxonomy_Category) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *IssueTaxonomy_Category) GetComponents() map[string]*IssueTaxonomy_Component {
	if m != nil {
		return m.Components
	}
	return nil
}

func init() {
	proto.RegisterType((*SupportAccount)(nil), "google.cloud.support.common.SupportAccount")
	proto.RegisterType((*Case)(nil), "google.cloud.support.common.Case")
	proto.RegisterType((*CustomerIssue)(nil), "google.cloud.support.common.CustomerIssue")
	proto.RegisterType((*SupportRole)(nil), "google.cloud.support.common.SupportRole")
	proto.RegisterType((*Comment)(nil), "google.cloud.support.common.Comment")
	proto.RegisterType((*IssueTaxonomy)(nil), "google.cloud.support.common.IssueTaxonomy")
	proto.RegisterMapType((map[string]*IssueTaxonomy_Category)(nil), "google.cloud.support.common.IssueTaxonomy.CategoriesEntry")
	proto.RegisterType((*IssueTaxonomy_Component)(nil), "google.cloud.support.common.IssueTaxonomy.Component")
	proto.RegisterType((*IssueTaxonomy_Category)(nil), "google.cloud.support.common.IssueTaxonomy.Category")
	proto.RegisterMapType((map[string]*IssueTaxonomy_Component)(nil), "google.cloud.support.common.IssueTaxonomy.Category.ComponentsEntry")
	proto.RegisterEnum("google.cloud.support.common.SupportAccount_State", SupportAccount_State_name, SupportAccount_State_value)
	proto.RegisterEnum("google.cloud.support.common.SupportAccount_PricingModel", SupportAccount_PricingModel_name, SupportAccount_PricingModel_value)
	proto.RegisterEnum("google.cloud.support.common.Case_Priority", Case_Priority_name, Case_Priority_value)
	proto.RegisterEnum("google.cloud.support.common.Case_State", Case_State_name, Case_State_value)
	proto.RegisterEnum("google.cloud.support.common.CustomerIssue_IssueState", CustomerIssue_IssueState_name, CustomerIssue_IssueState_value)
	proto.RegisterEnum("google.cloud.support.common.SupportRole_Role", SupportRole_Role_name, SupportRole_Role_value)
}

func init() {
	proto.RegisterFile("google/cloud/support/common.proto", fileDescriptor_common_f17357843abc5917)
}

var fileDescriptor_common_f17357843abc5917 = []byte{
	// 1336 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0x61, 0x6e, 0xdb, 0xc6,
	0x12, 0x0e, 0x29, 0xc9, 0x92, 0x46, 0x96, 0xbd, 0x59, 0x38, 0x79, 0x8c, 0x92, 0xbc, 0x38, 0x7a,
	0x78, 0x88, 0x51, 0xa0, 0x72, 0xe2, 0xa4, 0x40, 0x90, 0x20, 0x3f, 0x64, 0x6a, 0x2d, 0xb0, 0x91,
	0x49, 0x82, 0xa4, 0xe3, 0x24, 0x45, 0x41, 0xd0, 0xd4, 0x46, 0x65, 0x43, 0x72, 0x09, 0x92, 0x4a,
	0xa3, 0x1e, 0xa0, 0x3d, 0x45, 0xef, 0xd0, 0x5f, 0xbd, 0x40, 0x7b, 0x83, 0xde, 0xa1, 0xe7, 0x28,
	0x76, 0x49, 0xc9, 0xb2, 0x63, 0xd8, 0x51, 0xfe, 0x68, 0x39, 0xb3, 0x33, 0xb3, 0x33, 0xb3, 0xdf,
	0xb7, 0x63, 0xc3, 0xfd, 0x09, 0x63, 0x93, 0x90, 0xee, 0xfa, 0x21, 0x9b, 0x8e, 0x77, 0xb3, 0x69,
	0x92, 0xb0, 0x34, 0xdf, 0xf5, 0x59, 0x14, 0xb1, 0xb8, 0x97, 0xa4, 0x2c, 0x67, 0xf8, 0x76, 0x61,
	0xd2, 0x13, 0x26, 0xbd, 0xd2, 0xa4, 0x57, 0x98, 0x74, 0xee, 0x94, 0xfe, 0x5e, 0x12, 0xec, 0x7a,
	0x71, 0xcc, 0x72, 0x2f, 0x0f, 0x58, 0x9c, 0x15, 0xae, 0x9d, 0x7b, 0xe5, 0xae, 0x90, 0x4e, 0xa6,
	0xef, 0x76, 0xf3, 0x20, 0xa2, 0x59, 0xee, 0x45, 0x49, 0x61, 0xd0, 0xfd, 0xa7, 0x0a, 0x1b, 0x76,
	0x11, 0xb1, 0xef, 0xfb, 0x6c, 0x1a, 0xe7, 0x18, 0x43, 0x35, 0xf6, 0x22, 0xaa, 0x48, 0xdb, 0xd2,
	0x4e, 0xd3, 0x12, 0xdf, 0xf8, 0x2e, 0x80, 0x57, 0x6c, 0xbb, 0xc1, 0x58, 0x91, 0xc5, 0x4e, 0xb3,
	0xd4, 0x68, 0x63, 0xfc, 0x7f, 0xd8, 0x10, 0xc9, 0xb9, 0x29, 0xcd, 0xd8, 0x34, 0xf5, 0xa9, 0x52,
	0x11, 0x26, 0x6d, 0xa1, 0xb5, 0x4a, 0x25, 0xbe, 0x0f, 0xeb, 0xe3, 0x20, 0x4b, 0x42, 0x6f, 0xe6,
	0x8a, 0x13, 0xaa, 0xc2, 0xa8, 0x55, 0xea, 0x74, 0x7e, 0xd0, 0x10, 0x6a, 0x59, 0xee, 0xe5, 0x54,
	0xa9, 0x6d, 0x4b, 0x3b, 0x1b, 0x7b, 0x8f, 0x7a, 0x97, 0xd4, 0xde, 0x3b, 0x9b, 0x78, 0xcf, 0xe6,
	0x8e, 0x56, 0xe1, 0x8f, 0x9f, 0x43, 0xcb, 0x4f, 0xa9, 0x97, 0x53, 0x97, 0x97, 0xac, 0xac, 0x6d,
	0x4b, 0x3b, 0xad, 0xbd, 0xce, 0x3c, 0xdc, 0xbc, 0x1f, 0x3d, 0x67, 0xde, 0x0f, 0x0b, 0x0a, 0x73,
	0xae, 0xc0, 0x0f, 0x61, 0xeb, 0x24, 0x08, 0xc3, 0x20, 0x9e, 0xb8, 0xf3, 0xb2, 0x45, 0xc2, 0x75,
	0x91, 0x30, 0x2e, 0xf7, 0xca, 0x73, 0x45, 0xde, 0x3b, 0x80, 0xa6, 0x71, 0xf0, 0x6e, 0xe6, 0x2e,
	0xb5, 0xa9, 0x21, 0xac, 0x37, 0x84, 0xbe, 0xbf, 0xe8, 0xd5, 0xf7, 0xd0, 0x4e, 0xd2, 0xc0, 0xe7,
	0xb1, 0x23, 0x36, 0xa6, 0xa1, 0xd2, 0x14, 0x95, 0x3e, 0x5d, 0xa5, 0x52, 0xb3, 0x08, 0x70, 0xc8,
	0xfd, 0xad, 0xf5, 0x64, 0x49, 0xea, 0x1e, 0x42, 0x4d, 0xf4, 0x01, 0xdf, 0x80, 0xeb, 0xb6, 0xd3,
	0x77, 0x88, 0x7b, 0xa4, 0xdb, 0x26, 0x51, 0xb5, 0x03, 0x8d, 0x0c, 0xd0, 0x35, 0x0c, 0xb0, 0xd6,
	0x57, 0x1d, 0xed, 0x15, 0x41, 0x12, 0x6e, 0x41, 0xdd, 0x24, 0xfa, 0x40, 0xd3, 0x87, 0x48, 0xc6,
	0x5b, 0x80, 0x4a, 0xc1, 0x1d, 0x90, 0x11, 0x71, 0x34, 0x43, 0x47, 0x95, 0xee, 0x10, 0xd6, 0x97,
	0x0f, 0xc3, 0xb7, 0xe0, 0x86, 0x69, 0x69, 0x2a, 0xb7, 0x3a, 0x34, 0x06, 0x64, 0xe4, 0x1e, 0xe9,
	0x2f, 0x75, 0xe3, 0x58, 0x47, 0xd7, 0xf0, 0x3a, 0x34, 0xcc, 0xbe, 0xfa, 0xb2, 0x3f, 0x24, 0x36,
	0x92, 0xf0, 0x06, 0xc0, 0x91, 0x4d, 0x2c, 0xd7, 0x32, 0x46, 0xc4, 0x46, 0x72, 0xf7, 0x8f, 0x3a,
	0x54, 0x55, 0x2f, 0xa3, 0x17, 0xc2, 0xeb, 0x3c, 0x30, 0xe4, 0x4f, 0x81, 0xb1, 0x0d, 0xad, 0x31,
	0xcd, 0xfc, 0x34, 0x48, 0x38, 0xbe, 0x4b, 0x7c, 0x2d, 0xab, 0xf0, 0x1d, 0x68, 0xfa, 0x2c, 0x4a,
	0x58, 0x4c, 0xe3, 0xbc, 0x84, 0xd6, 0xa9, 0x02, 0x77, 0x61, 0x3d, 0x9b, 0x9e, 0x9c, 0x1a, 0xd4,
	0x84, 0xc1, 0x19, 0x1d, 0x7e, 0x00, 0x9b, 0x7e, 0x18, 0xd0, 0x38, 0x17, 0x98, 0xf9, 0x99, 0xc5,
	0x05, 0x6e, 0x9a, 0xd6, 0x46, 0xa1, 0x76, 0x4a, 0x2d, 0xcf, 0xd7, 0xf7, 0x5d, 0x6f, 0x3c, 0x4e,
	0x69, 0x96, 0xd1, 0x4c, 0xa9, 0x6f, 0x57, 0x78, 0x36, 0xbe, 0xdf, 0x9f, 0xab, 0x38, 0x63, 0x92,
	0x94, 0xfd, 0x48, 0xfd, 0x25, 0x28, 0x34, 0x4b, 0x8d, 0x36, 0xc6, 0xfb, 0xb0, 0x16, 0x64, 0xd9,
	0x94, 0x66, 0x0a, 0x6c, 0x57, 0x76, 0x5a, 0x7b, 0x5f, 0x5d, 0x7a, 0xfd, 0xea, 0x34, 0xcb, 0x59,
	0x44, 0x53, 0x8d, 0xbb, 0x58, 0xa5, 0x27, 0x3e, 0x80, 0x46, 0x92, 0x06, 0x2c, 0x0d, 0xf2, 0x99,
	0xd2, 0x12, 0x20, 0xba, 0x22, 0x8a, 0x97, 0x51, 0x0e, 0x1d, 0xe1, 0x61, 0x2d, 0x7c, 0xf1, 0x8b,
	0x39, 0xe7, 0xd6, 0x45, 0x90, 0x07, 0x57, 0x07, 0xb9, 0x8c, 0x69, 0xed, 0x95, 0x98, 0xf6, 0x1c,
	0x5a, 0xd3, 0x64, 0xbc, 0x70, 0xde, 0xb8, 0xda, 0xb9, 0x30, 0x17, 0xce, 0xff, 0x83, 0xb6, 0x08,
	0xc5, 0x52, 0x97, 0x46, 0x5e, 0x10, 0x2a, 0x9b, 0xc5, 0xa5, 0x96, 0x4a, 0xc2, 0x75, 0xb8, 0x03,
	0x0d, 0xdf, 0xcb, 0xe9, 0x84, 0xa5, 0x33, 0x05, 0x89, 0xfd, 0x85, 0xdc, 0x1d, 0x41, 0x63, 0xde,
	0x0f, 0xac, 0xc0, 0x96, 0x69, 0x69, 0x86, 0xa5, 0x39, 0x6f, 0xce, 0x51, 0x66, 0x0d, 0x64, 0xf3,
	0x21, 0x92, 0xc4, 0xfa, 0x08, 0xc9, 0x62, 0xdd, 0x43, 0x15, 0xb1, 0x3e, 0x46, 0x55, 0xb1, 0x3e,
	0x41, 0xb5, 0xee, 0xdf, 0xd2, 0x15, 0xdc, 0xab, 0x43, 0x45, 0x27, 0xc7, 0x48, 0xe2, 0x54, 0xe9,
	0xdb, 0xb6, 0x36, 0xd4, 0xc9, 0x00, 0xc9, 0xf8, 0xbf, 0xd0, 0xd1, 0x74, 0xd7, 0xb4, 0x8c, 0xa1,
	0x45, 0x6c, 0xdb, 0x1d, 0x1a, 0xc6, 0x70, 0x44, 0x5c, 0xfb, 0xc8, 0x34, 0x0d, 0xcb, 0x41, 0x15,
	0xdc, 0x81, 0x9b, 0x17, 0xec, 0x13, 0x7d, 0x88, 0xaa, 0xf8, 0x36, 0xfc, 0x67, 0x79, 0x4f, 0x70,
	0xd1, 0xd5, 0x6c, 0xfb, 0x88, 0xa0, 0x1a, 0xbe, 0x0f, 0x77, 0x8f, 0xfb, 0x9a, 0xc3, 0xc9, 0x7a,
	0x60, 0x58, 0xae, 0x7a, 0x64, 0x3b, 0xc6, 0x21, 0xe7, 0x24, 0xb1, 0x4d, 0x43, 0xb7, 0x09, 0x5a,
	0xe3, 0xac, 0xb7, 0x8d, 0xd1, 0x11, 0x67, 0xbb, 0x6b, 0x1c, 0x1c, 0x10, 0x8b, 0x0c, 0x50, 0x9d,
	0x3f, 0x12, 0xea, 0xc8, 0xb0, 0xc9, 0x00, 0x35, 0xba, 0xbf, 0x55, 0xa0, 0x7d, 0x06, 0x7f, 0xf8,
	0x16, 0x34, 0x04, 0x02, 0x39, 0xb0, 0x0b, 0x16, 0xd7, 0x85, 0xac, 0x8d, 0xf1, 0xcb, 0x39, 0x94,
	0x64, 0x01, 0xa5, 0x6f, 0x3e, 0x1f, 0xd5, 0x3d, 0xf1, 0x7b, 0x19, 0xb0, 0x2a, 0x2b, 0x01, 0xeb,
	0x05, 0xac, 0xf3, 0x61, 0x14, 0x7e, 0x28, 0xbd, 0xab, 0x57, 0x7a, 0xb7, 0x4a, 0xfb, 0x8b, 0x70,
	0x59, 0x5b, 0x05, 0x97, 0xdd, 0xf7, 0x00, 0xa7, 0xd5, 0x88, 0x2b, 0xe2, 0x17, 0xe2, 0x5e, 0x04,
	0x89, 0x06, 0x54, 0x0d, 0x93, 0xe8, 0x48, 0xc2, 0x9b, 0xd0, 0x5a, 0xba, 0x49, 0x24, 0xe3, 0x26,
	0xd4, 0x0e, 0xb4, 0xd7, 0x64, 0x80, 0x2a, 0x1c, 0x2f, 0xc7, 0x86, 0xee, 0xb8, 0x07, 0xda, 0x6b,
	0x54, 0xe5, 0xd2, 0x2b, 0x62, 0x15, 0x11, 0x6a, 0xdd, 0x3f, 0x25, 0x68, 0x95, 0xe3, 0xc1, 0x62,
	0x21, 0xc5, 0x5b, 0x50, 0x2b, 0xc8, 0x50, 0x5c, 0x4d, 0x21, 0xe0, 0x3e, 0x54, 0x53, 0x16, 0xce,
	0xef, 0xe5, 0xeb, 0xcf, 0x19, 0x36, 0x3c, 0x5a, 0x8f, 0xff, 0x58, 0xc2, 0xb5, 0xfb, 0x1d, 0x54,
	0xcb, 0x03, 0x10, 0x7f, 0xd4, 0xcf, 0x15, 0xd2, 0x84, 0xda, 0x7e, 0xdf, 0xd6, 0x54, 0x24, 0xe1,
	0x36, 0x34, 0x07, 0xe4, 0x15, 0x19, 0x19, 0x26, 0xb1, 0x90, 0xcc, 0x45, 0xfe, 0xd5, 0x2f, 0x26,
	0x8a, 0x40, 0x9c, 0xe6, 0x10, 0xd7, 0x22, 0x23, 0xad, 0xbf, 0xaf, 0x8d, 0x34, 0xe7, 0x0d, 0xaa,
	0x76, 0x7f, 0x91, 0xa0, 0xae, 0xb2, 0x28, 0xa2, 0xc5, 0x1f, 0x20, 0x39, 0xfd, 0x98, 0xcf, 0x27,
	0x04, 0xff, 0x3e, 0x8f, 0x05, 0x79, 0x25, 0x2c, 0xdc, 0x84, 0x35, 0x6f, 0x9a, 0xff, 0xc0, 0xd2,
	0x72, 0x6c, 0x94, 0xd2, 0x62, 0x14, 0x55, 0x4f, 0x47, 0x51, 0xf7, 0xf7, 0x1a, 0xb4, 0xc5, 0xe5,
	0x39, 0xde, 0x47, 0x16, 0xb3, 0x68, 0x86, 0xdf, 0x02, 0x94, 0x0f, 0x46, 0x40, 0x33, 0x45, 0x12,
	0xcf, 0xf5, 0xb3, 0x4b, 0x1b, 0x78, 0xc6, 0xbf, 0xa7, 0x2e, 0x9c, 0x49, 0x9c, 0xa7, 0x33, 0x6b,
	0x29, 0x5a, 0xe7, 0x2f, 0x09, 0x9a, 0xea, 0x62, 0xfe, 0x9c, 0x1f, 0x83, 0xd2, 0xa7, 0x63, 0xf0,
	0x0e, 0x34, 0x43, 0x2f, 0x9e, 0x4c, 0xbd, 0x09, 0xcd, 0x14, 0x59, 0x8c, 0x9d, 0x53, 0x05, 0x7f,
	0xeb, 0x72, 0x1a, 0x25, 0x21, 0x67, 0x60, 0x51, 0xea, 0x42, 0xc6, 0x6f, 0xa1, 0xbd, 0x3c, 0xec,
	0x32, 0xa5, 0x2a, 0x2a, 0x79, 0xb2, 0x4a, 0x25, 0x73, 0x67, 0xeb, 0x6c, 0xa8, 0xce, 0xaf, 0x32,
	0x34, 0xca, 0x32, 0x67, 0x9f, 0x53, 0x85, 0x0f, 0xb0, 0x94, 0x88, 0x2c, 0x12, 0x51, 0x57, 0x6f,
	0xe9, 0x52, 0x46, 0x8b, 0xde, 0x9e, 0x26, 0x95, 0xc1, 0xe6, 0xb9, 0x6d, 0x8c, 0xa0, 0xf2, 0x9e,
	0xce, 0xca, 0x8c, 0xf8, 0x27, 0xfe, 0x16, 0x6a, 0x1f, 0xbc, 0x70, 0x3a, 0x47, 0xd4, 0x97, 0x75,
	0xa3, 0x08, 0xf1, 0x4c, 0x7e, 0x2a, 0x75, 0x52, 0xd8, 0x3c, 0x77, 0xdf, 0x17, 0x1c, 0xaa, 0x9d,
	0x3d, 0xf4, 0xf1, 0x17, 0x54, 0xbe, 0x74, 0xe6, 0xfe, 0x4f, 0x70, 0xcf, 0x67, 0xd1, 0x65, 0x41,
	0xf6, 0xaf, 0xab, 0x5c, 0x5b, 0x12, 0xdb, 0xe4, 0x6c, 0x79, 0xdb, 0x2f, 0xed, 0x27, 0x8c, 0xe3,
	0xa7, 0xc7, 0xd2, 0xc9, 0xee, 0x84, 0xc6, 0x82, 0x49, 0xbb, 0xc5, 0x96, 0x97, 0x04, 0xd9, 0x85,
	0xff, 0x97, 0x3c, 0x2f, 0x96, 0x93, 0x35, 0x61, 0xfd, 0xf8, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x0c, 0xd0, 0x7b, 0x46, 0xc4, 0x0c, 0x00, 0x00,
}
