// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/ad_group_bid_modifier.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Represents an ad group bid modifier.
type AdGroupBidModifier struct {
	// The resource name of the ad group bid modifier.
	// Ad group bid modifier resource names have the form:
	//
	// `customers/{customer_id}/adGroupBidModifiers/{ad_group_id}_{criterion_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ad group to which this criterion belongs.
	AdGroup *wrappers.StringValue `protobuf:"bytes,2,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The ID of the criterion to bid modify.
	//
	// This field is ignored for mutates.
	CriterionId *wrappers.Int64Value `protobuf:"bytes,3,opt,name=criterion_id,json=criterionId,proto3" json:"criterion_id,omitempty"`
	// The modifier for the bid when the criterion matches. The modifier must be
	// in the range: 0.1 - 10.0. The range is 1.0 - 6.0 for PreferredContent.
	// Use 0 to opt out of a Device type.
	BidModifier *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=bid_modifier,json=bidModifier,proto3" json:"bid_modifier,omitempty"`
	// The base ad group from which this draft/trial adgroup bid modifier was
	// created. If ad_group is a base ad group then this field will be equal to
	// ad_group. If the ad group was created in the draft or trial and has no
	// corresponding base ad group, then this field will be null.
	// This field is readonly.
	BaseAdGroup *wrappers.StringValue `protobuf:"bytes,9,opt,name=base_ad_group,json=baseAdGroup,proto3" json:"base_ad_group,omitempty"`
	// Bid modifier source.
	BidModifierSource enums.BidModifierSourceEnum_BidModifierSource `protobuf:"varint,10,opt,name=bid_modifier_source,json=bidModifierSource,proto3,enum=google.ads.googleads.v0.enums.BidModifierSourceEnum_BidModifierSource" json:"bid_modifier_source,omitempty"`
	// The criterion of this ad group bid modifier.
	//
	// Types that are valid to be assigned to Criterion:
	//	*AdGroupBidModifier_HotelDateSelectionType
	//	*AdGroupBidModifier_HotelAdvanceBookingWindow
	//	*AdGroupBidModifier_HotelLengthOfStay
	//	*AdGroupBidModifier_HotelCheckInDay
	//	*AdGroupBidModifier_Device
	//	*AdGroupBidModifier_PreferredContent
	Criterion            isAdGroupBidModifier_Criterion `protobuf_oneof:"criterion"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *AdGroupBidModifier) Reset()         { *m = AdGroupBidModifier{} }
func (m *AdGroupBidModifier) String() string { return proto.CompactTextString(m) }
func (*AdGroupBidModifier) ProtoMessage()    {}
func (*AdGroupBidModifier) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_bid_modifier_771431a7da3a20c0, []int{0}
}
func (m *AdGroupBidModifier) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupBidModifier.Unmarshal(m, b)
}
func (m *AdGroupBidModifier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupBidModifier.Marshal(b, m, deterministic)
}
func (dst *AdGroupBidModifier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupBidModifier.Merge(dst, src)
}
func (m *AdGroupBidModifier) XXX_Size() int {
	return xxx_messageInfo_AdGroupBidModifier.Size(m)
}
func (m *AdGroupBidModifier) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupBidModifier.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupBidModifier proto.InternalMessageInfo

func (m *AdGroupBidModifier) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupBidModifier) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *AdGroupBidModifier) GetCriterionId() *wrappers.Int64Value {
	if m != nil {
		return m.CriterionId
	}
	return nil
}

func (m *AdGroupBidModifier) GetBidModifier() *wrappers.DoubleValue {
	if m != nil {
		return m.BidModifier
	}
	return nil
}

func (m *AdGroupBidModifier) GetBaseAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.BaseAdGroup
	}
	return nil
}

func (m *AdGroupBidModifier) GetBidModifierSource() enums.BidModifierSourceEnum_BidModifierSource {
	if m != nil {
		return m.BidModifierSource
	}
	return enums.BidModifierSourceEnum_UNSPECIFIED
}

type isAdGroupBidModifier_Criterion interface {
	isAdGroupBidModifier_Criterion()
}

type AdGroupBidModifier_HotelDateSelectionType struct {
	HotelDateSelectionType *common.HotelDateSelectionTypeInfo `protobuf:"bytes,5,opt,name=hotel_date_selection_type,json=hotelDateSelectionType,proto3,oneof"`
}

type AdGroupBidModifier_HotelAdvanceBookingWindow struct {
	HotelAdvanceBookingWindow *common.HotelAdvanceBookingWindowInfo `protobuf:"bytes,6,opt,name=hotel_advance_booking_window,json=hotelAdvanceBookingWindow,proto3,oneof"`
}

type AdGroupBidModifier_HotelLengthOfStay struct {
	HotelLengthOfStay *common.HotelLengthOfStayInfo `protobuf:"bytes,7,opt,name=hotel_length_of_stay,json=hotelLengthOfStay,proto3,oneof"`
}

type AdGroupBidModifier_HotelCheckInDay struct {
	HotelCheckInDay *common.HotelCheckInDayInfo `protobuf:"bytes,8,opt,name=hotel_check_in_day,json=hotelCheckInDay,proto3,oneof"`
}

type AdGroupBidModifier_Device struct {
	Device *common.DeviceInfo `protobuf:"bytes,11,opt,name=device,proto3,oneof"`
}

type AdGroupBidModifier_PreferredContent struct {
	PreferredContent *common.PreferredContentInfo `protobuf:"bytes,12,opt,name=preferred_content,json=preferredContent,proto3,oneof"`
}

func (*AdGroupBidModifier_HotelDateSelectionType) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_HotelAdvanceBookingWindow) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_HotelLengthOfStay) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_HotelCheckInDay) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_Device) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_PreferredContent) isAdGroupBidModifier_Criterion() {}

func (m *AdGroupBidModifier) GetCriterion() isAdGroupBidModifier_Criterion {
	if m != nil {
		return m.Criterion
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelDateSelectionType() *common.HotelDateSelectionTypeInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelDateSelectionType); ok {
		return x.HotelDateSelectionType
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelAdvanceBookingWindow() *common.HotelAdvanceBookingWindowInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelAdvanceBookingWindow); ok {
		return x.HotelAdvanceBookingWindow
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelLengthOfStay() *common.HotelLengthOfStayInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelLengthOfStay); ok {
		return x.HotelLengthOfStay
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelCheckInDay() *common.HotelCheckInDayInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelCheckInDay); ok {
		return x.HotelCheckInDay
	}
	return nil
}

func (m *AdGroupBidModifier) GetDevice() *common.DeviceInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_Device); ok {
		return x.Device
	}
	return nil
}

func (m *AdGroupBidModifier) GetPreferredContent() *common.PreferredContentInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_PreferredContent); ok {
		return x.PreferredContent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AdGroupBidModifier) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AdGroupBidModifier_OneofMarshaler, _AdGroupBidModifier_OneofUnmarshaler, _AdGroupBidModifier_OneofSizer, []interface{}{
		(*AdGroupBidModifier_HotelDateSelectionType)(nil),
		(*AdGroupBidModifier_HotelAdvanceBookingWindow)(nil),
		(*AdGroupBidModifier_HotelLengthOfStay)(nil),
		(*AdGroupBidModifier_HotelCheckInDay)(nil),
		(*AdGroupBidModifier_Device)(nil),
		(*AdGroupBidModifier_PreferredContent)(nil),
	}
}

func _AdGroupBidModifier_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AdGroupBidModifier)
	// criterion
	switch x := m.Criterion.(type) {
	case *AdGroupBidModifier_HotelDateSelectionType:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotelDateSelectionType); err != nil {
			return err
		}
	case *AdGroupBidModifier_HotelAdvanceBookingWindow:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotelAdvanceBookingWindow); err != nil {
			return err
		}
	case *AdGroupBidModifier_HotelLengthOfStay:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotelLengthOfStay); err != nil {
			return err
		}
	case *AdGroupBidModifier_HotelCheckInDay:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotelCheckInDay); err != nil {
			return err
		}
	case *AdGroupBidModifier_Device:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Device); err != nil {
			return err
		}
	case *AdGroupBidModifier_PreferredContent:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PreferredContent); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("AdGroupBidModifier.Criterion has unexpected type %T", x)
	}
	return nil
}

func _AdGroupBidModifier_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AdGroupBidModifier)
	switch tag {
	case 5: // criterion.hotel_date_selection_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.HotelDateSelectionTypeInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupBidModifier_HotelDateSelectionType{msg}
		return true, err
	case 6: // criterion.hotel_advance_booking_window
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.HotelAdvanceBookingWindowInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupBidModifier_HotelAdvanceBookingWindow{msg}
		return true, err
	case 7: // criterion.hotel_length_of_stay
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.HotelLengthOfStayInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupBidModifier_HotelLengthOfStay{msg}
		return true, err
	case 8: // criterion.hotel_check_in_day
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.HotelCheckInDayInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupBidModifier_HotelCheckInDay{msg}
		return true, err
	case 11: // criterion.device
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.DeviceInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupBidModifier_Device{msg}
		return true, err
	case 12: // criterion.preferred_content
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.PreferredContentInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupBidModifier_PreferredContent{msg}
		return true, err
	default:
		return false, nil
	}
}

func _AdGroupBidModifier_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AdGroupBidModifier)
	// criterion
	switch x := m.Criterion.(type) {
	case *AdGroupBidModifier_HotelDateSelectionType:
		s := proto.Size(x.HotelDateSelectionType)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupBidModifier_HotelAdvanceBookingWindow:
		s := proto.Size(x.HotelAdvanceBookingWindow)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupBidModifier_HotelLengthOfStay:
		s := proto.Size(x.HotelLengthOfStay)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupBidModifier_HotelCheckInDay:
		s := proto.Size(x.HotelCheckInDay)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupBidModifier_Device:
		s := proto.Size(x.Device)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupBidModifier_PreferredContent:
		s := proto.Size(x.PreferredContent)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*AdGroupBidModifier)(nil), "google.ads.googleads.v0.resources.AdGroupBidModifier")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/ad_group_bid_modifier.proto", fileDescriptor_ad_group_bid_modifier_771431a7da3a20c0)
}

var fileDescriptor_ad_group_bid_modifier_771431a7da3a20c0 = []byte{
	// 656 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x94, 0xdd, 0x6e, 0xd3, 0x30,
	0x14, 0xc7, 0xe9, 0x06, 0xfb, 0x70, 0x3b, 0x60, 0x06, 0x41, 0x18, 0x13, 0xda, 0x40, 0x48, 0x13,
	0x12, 0x4e, 0xb5, 0x0d, 0x26, 0x81, 0x06, 0xb4, 0x2b, 0x6c, 0x45, 0x7c, 0x4c, 0x2d, 0x1a, 0x12,
	0xaa, 0x64, 0x39, 0xf1, 0x69, 0x1a, 0xad, 0xb1, 0x23, 0xc7, 0x6d, 0xd5, 0x3b, 0x9e, 0x85, 0x4b,
	0x6e, 0x78, 0x0f, 0x9e, 0x81, 0x87, 0x41, 0xb1, 0x93, 0xa8, 0x6c, 0x2b, 0xeb, 0xdd, 0xe9, 0xf1,
	0xf9, 0xfd, 0xff, 0xe7, 0x9c, 0xc6, 0x46, 0xfb, 0x81, 0x94, 0x41, 0x1f, 0x5c, 0xc6, 0x13, 0xd7,
	0x86, 0x69, 0x34, 0xac, 0xba, 0x0a, 0x12, 0x39, 0x50, 0x3e, 0x24, 0x2e, 0xe3, 0x34, 0x50, 0x72,
	0x10, 0x53, 0x2f, 0xe4, 0x34, 0x92, 0x3c, 0xec, 0x86, 0xa0, 0x48, 0xac, 0xa4, 0x96, 0x78, 0xd3,
	0x32, 0x84, 0xf1, 0x84, 0x14, 0x38, 0x19, 0x56, 0x49, 0x81, 0xaf, 0x3d, 0x9d, 0xe6, 0xe0, 0xcb,
	0x28, 0x92, 0xc2, 0xf5, 0x55, 0xa8, 0x41, 0x85, 0xcc, 0x2a, 0xae, 0xed, 0x4d, 0x2b, 0x07, 0x31,
	0x88, 0x12, 0x77, 0xb2, 0x07, 0x6a, 0x2d, 0x32, 0xf0, 0x41, 0x06, 0x9a, 0x5f, 0xde, 0xa0, 0xeb,
	0x8e, 0x14, 0x8b, 0x63, 0x50, 0x89, 0x3d, 0x7f, 0xf8, 0x6b, 0x09, 0xe1, 0x1a, 0x3f, 0x4c, 0x27,
	0xa9, 0x87, 0xfc, 0x63, 0xa6, 0x81, 0x1f, 0xa1, 0x95, 0xbc, 0x57, 0x2a, 0x58, 0x04, 0x4e, 0x69,
	0xa3, 0xb4, 0xb5, 0xdc, 0xaa, 0xe4, 0xc9, 0x4f, 0x2c, 0x02, 0xbc, 0x87, 0x96, 0xf2, 0x2d, 0x38,
	0x73, 0x1b, 0xa5, 0xad, 0xf2, 0xf6, 0x7a, 0x36, 0x2e, 0xc9, 0xed, 0x48, 0x5b, 0xab, 0x50, 0x04,
	0x27, 0xac, 0x3f, 0x80, 0xd6, 0x22, 0xb3, 0x46, 0xf8, 0x15, 0xaa, 0x64, 0xf3, 0x49, 0x41, 0x43,
	0xee, 0xcc, 0x1b, 0xf8, 0xfe, 0x39, 0xb8, 0x29, 0xf4, 0xf3, 0x5d, 0xcb, 0x96, 0x0b, 0xa0, 0xc9,
	0xf1, 0x6b, 0x54, 0x99, 0x9c, 0xd8, 0xb9, 0x3a, 0xc5, 0xbc, 0x21, 0x07, 0x5e, 0x1f, 0x32, 0x01,
	0x6f, 0x62, 0xbc, 0x37, 0x68, 0xc5, 0x63, 0x09, 0xd0, 0xa2, 0xfd, 0xe5, 0x19, 0xda, 0x2f, 0xa7,
	0x48, 0xb6, 0x2b, 0x3c, 0x44, 0xb7, 0x2e, 0x58, 0xba, 0x83, 0x36, 0x4a, 0x5b, 0xd7, 0xb7, 0xdf,
	0x91, 0x69, 0x1f, 0x80, 0xf9, 0xbb, 0xc8, 0xc4, 0xa6, 0xdb, 0x86, 0x7b, 0x2b, 0x06, 0xd1, 0xf9,
	0x6c, 0x6b, 0xd5, 0x3b, 0x9b, 0xc2, 0x23, 0x74, 0xaf, 0x27, 0x35, 0xf4, 0x29, 0x67, 0x1a, 0x68,
	0x02, 0x7d, 0xf0, 0x75, 0xba, 0x45, 0x3d, 0x8e, 0xc1, 0xb9, 0x66, 0xa6, 0x78, 0x31, 0xd5, 0xdd,
	0x7e, 0x5b, 0xe4, 0x28, 0x15, 0x68, 0x30, 0x0d, 0xed, 0x1c, 0xff, 0x32, 0x8e, 0xa1, 0x29, 0xba,
	0xf2, 0xe8, 0x4a, 0xeb, 0x4e, 0xef, 0xc2, 0x53, 0xfc, 0xbd, 0x84, 0xd6, 0xad, 0x33, 0xe3, 0x43,
	0x26, 0x7c, 0xa0, 0x9e, 0x94, 0xa7, 0xa1, 0x08, 0xe8, 0x28, 0x14, 0x5c, 0x8e, 0x9c, 0x05, 0x63,
	0xbe, 0x3f, 0x93, 0x79, 0xcd, 0x4a, 0xd4, 0xad, 0xc2, 0x57, 0x23, 0x90, 0xf9, 0xdb, 0xf1, 0x2e,
	0x2a, 0xc0, 0x3d, 0x74, 0xdb, 0x76, 0xd0, 0x07, 0x11, 0xe8, 0x1e, 0x95, 0x5d, 0x9a, 0x68, 0x36,
	0x76, 0x16, 0x8d, 0xf3, 0xb3, 0x99, 0x9c, 0x3f, 0x18, 0xf4, 0x73, 0xb7, 0xad, 0xd9, 0x38, 0x73,
	0x5c, 0xed, 0x9d, 0x3d, 0xc0, 0x1e, 0xc2, 0xd6, 0xc9, 0xef, 0x81, 0x7f, 0x4a, 0x43, 0x41, 0x39,
	0x1b, 0x3b, 0x4b, 0xc6, 0x67, 0x67, 0x26, 0x9f, 0x83, 0x14, 0x6c, 0x8a, 0x46, 0xe1, 0x72, 0xa3,
	0xf7, 0x6f, 0x1a, 0x37, 0xd0, 0x02, 0x87, 0x61, 0xe8, 0x83, 0x53, 0x36, 0xba, 0x4f, 0x2e, 0xd3,
	0x6d, 0x98, 0xea, 0x4c, 0x2e, 0x63, 0xb1, 0x8f, 0x56, 0x63, 0x05, 0x5d, 0x50, 0x0a, 0x38, 0xf5,
	0xa5, 0xd0, 0x20, 0xb4, 0x53, 0x31, 0x82, 0xbb, 0x97, 0x09, 0x1e, 0xe7, 0xe0, 0x81, 0xe5, 0x32,
	0xe9, 0x9b, 0xf1, 0x99, 0x7c, 0xbd, 0x8c, 0x96, 0x8b, 0xeb, 0x57, 0xff, 0x53, 0x42, 0x8f, 0x7d,
	0x19, 0x91, 0x4b, 0xdf, 0xb8, 0xfa, 0xdd, 0xf3, 0x0f, 0xcb, 0x71, 0x7a, 0xb1, 0x8e, 0x4b, 0xdf,
	0xde, 0x67, 0x74, 0x20, 0xfb, 0x4c, 0x04, 0x44, 0xaa, 0xc0, 0x0d, 0x40, 0x98, 0x6b, 0x97, 0xbf,
	0x6f, 0x71, 0x98, 0xfc, 0xe7, 0xfd, 0x7d, 0x59, 0x44, 0x3f, 0xe6, 0xe6, 0x0f, 0x6b, 0xb5, 0x9f,
	0x73, 0x9b, 0x87, 0x56, 0xb2, 0xc6, 0x13, 0x62, 0xc3, 0x34, 0x3a, 0xa9, 0x92, 0x56, 0x5e, 0xf9,
	0x3b, 0xaf, 0xe9, 0xd4, 0x78, 0xd2, 0x29, 0x6a, 0x3a, 0x27, 0xd5, 0x4e, 0x51, 0xe3, 0x2d, 0x98,
	0x26, 0x76, 0xfe, 0x06, 0x00, 0x00, 0xff, 0xff, 0x54, 0x6c, 0xde, 0x0c, 0x03, 0x06, 0x00, 0x00,
}
