// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/resultstore/v2/action.proto

package resultstore

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Indicates how/where this Action was executed.
type ExecutionStrategy int32

const (
	// The action did not indicate how it was executed.
	ExecutionStrategy_EXECUTION_STRATEGY_UNSPECIFIED ExecutionStrategy = 0
	// The action was executed in some other form.
	ExecutionStrategy_OTHER_ENVIRONMENT ExecutionStrategy = 1
	// The action used a remote build service.
	ExecutionStrategy_REMOTE_SERVICE ExecutionStrategy = 2
	// The action was executed locally, in parallel with other actions.
	ExecutionStrategy_LOCAL_PARALLEL ExecutionStrategy = 3
	// The action was executed locally, without parallelism.
	ExecutionStrategy_LOCAL_SEQUENTIAL ExecutionStrategy = 4
)

var ExecutionStrategy_name = map[int32]string{
	0: "EXECUTION_STRATEGY_UNSPECIFIED",
	1: "OTHER_ENVIRONMENT",
	2: "REMOTE_SERVICE",
	3: "LOCAL_PARALLEL",
	4: "LOCAL_SEQUENTIAL",
}

var ExecutionStrategy_value = map[string]int32{
	"EXECUTION_STRATEGY_UNSPECIFIED": 0,
	"OTHER_ENVIRONMENT":              1,
	"REMOTE_SERVICE":                 2,
	"LOCAL_PARALLEL":                 3,
	"LOCAL_SEQUENTIAL":               4,
}

func (x ExecutionStrategy) String() string {
	return proto.EnumName(ExecutionStrategy_name, int32(x))
}

func (ExecutionStrategy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{0}
}

// Most build systems cache build results to speed up incremental builds.
// Some also cache test results too. This indicates whether the test results
// were found in a cache, and where that cache was located.
type TestCaching int32

const (
	// The implicit default enum value. Should never be set.
	TestCaching_TEST_CACHING_UNSPECIFIED TestCaching = 0
	// The test result was found in a local cache, so it wasn't run again.
	TestCaching_LOCAL_CACHE_HIT TestCaching = 1
	// The test result was found in a remote cache, so it wasn't run again.
	TestCaching_REMOTE_CACHE_HIT TestCaching = 2
	// The test result was not found in any cache, so it had to be run again.
	TestCaching_CACHE_MISS TestCaching = 3
)

var TestCaching_name = map[int32]string{
	0: "TEST_CACHING_UNSPECIFIED",
	1: "LOCAL_CACHE_HIT",
	2: "REMOTE_CACHE_HIT",
	3: "CACHE_MISS",
}

var TestCaching_value = map[string]int32{
	"TEST_CACHING_UNSPECIFIED": 0,
	"LOCAL_CACHE_HIT":          1,
	"REMOTE_CACHE_HIT":         2,
	"CACHE_MISS":               3,
}

func (x TestCaching) String() string {
	return proto.EnumName(TestCaching_name, int32(x))
}

func (TestCaching) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{1}
}

// An action that happened as part of a configured target. This action could be
// a build, a test, or another type of action, as specified in action_type
// oneof.
//
// Each parent ConfiguredTarget resource should have at least one Action as its
// child resource before the invocation is finalized. For a simple build, at
// least one build action should be created to represent the build result, and
// at at least one test action should be created to represent the test result,
// if any.
type Action struct {
	// The resource name.  Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/url_encode(${CONFIG_ID})/actions/${url_encode(ACTION_ID)}
	//
	// See CreateActionRequest proto for more information.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Action. They must match the
	// resource name after proper encoding.
	Id *Action_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The status of the action.
	StatusAttributes *StatusAttributes `protobuf:"bytes,3,opt,name=status_attributes,json=statusAttributes,proto3" json:"status_attributes,omitempty"`
	// The timing of the whole action. For TestActions, the start time may be
	// before the test actually started, and the duration may last until after the
	// test actually finished.
	Timing *Timing `protobuf:"bytes,4,opt,name=timing,proto3" json:"timing,omitempty"`
	// The type of the action. The type of an action may not change over the
	// lifetime of the invocation. If one of these fields is to be set, it must be
	// set in the CreateAction method. It may be set to an empty message that is
	// populated in later methods or post-processing. A generic "untyped" action
	// can be created by not setting any of these fields. An untyped action will
	// be untyped for the lifetime of the invocation.
	//
	// Types that are valid to be assigned to ActionType:
	//	*Action_BuildAction
	//	*Action_TestAction
	ActionType isAction_ActionType `protobuf_oneof:"action_type"`
	// General attributes of the action.
	ActionAttributes *ActionAttributes `protobuf:"bytes,5,opt,name=action_attributes,json=actionAttributes,proto3" json:"action_attributes,omitempty"`
	// A list of resources that this action depended upon. May be used to provide
	// the cause of a build failure in the case of a failed build action.
	ActionDependencies []*Dependency `protobuf:"bytes,14,rep,name=action_dependencies,json=actionDependencies,proto3" json:"action_dependencies,omitempty"`
	// Arbitrary name-value pairs.
	// This is implemented as a multi-map. Multiple properties are allowed with
	// the same key. Properties will be returned in lexicographical order by key.
	Properties []*Property `protobuf:"bytes,7,rep,name=properties,proto3" json:"properties,omitempty"`
	// A list of file references for action level files.
	// The file IDs must be unique within this list. Duplicate file IDs will
	// result in an error. Files will be returned in lexicographical order by ID.
	//
	// Files with the following reserved file IDs cause specific post-processing
	// or have special handling. These files must be immediately available to
	// ResultStore for processing when the reference is uploaded.
	//
	// For build actions:
	// stdout: The stdout of the action
	// stderr: The stderr of the action
	// baseline.lcov: Baseline coverage file to be parsed by the server. This
	//     uses a stripped down implementation of the LCOV standard.
	//     http://ltp.sourceforge.net/coverage/lcov/geninfo.1.php
	//
	// For test actions:
	// test.xml: The test suite / test case data in XML format.
	// test.log: The combined stdout and stderr of the test process.
	// test.lcov: Coverage file to be parsed by the server. This uses a stripped
	//     down implementation of the LCOV standard.
	//     http://ltp.sourceforge.net/coverage/lcov/geninfo.1.php
	Files []*File `protobuf:"bytes,8,rep,name=files,proto3" json:"files,omitempty"`
	// List of names of file sets that are referenced from this Action.
	// Each name must point to a file set under the same Invocation. The name
	// format must be: invocations/${INVOCATION_ID}/fileSets/${FILE_SET_ID}
	FileSets []string `protobuf:"bytes,15,rep,name=file_sets,json=fileSets,proto3" json:"file_sets,omitempty"`
	// Coverage data was collected while running the build or test action. This
	// usually includes line coverage, and may also include branch coverage.
	// For test actions, this is usually only for the source files which were
	// actually executed by that particular action.
	// For build actions, this is the baseline coverage, which captures the
	// instrumented files and lines, without any lines being executed. This
	// ensures files that are never covered at all are included.
	Coverage *ActionCoverage `protobuf:"bytes,11,opt,name=coverage,proto3" json:"coverage,omitempty"`
	// ResultStore will read and parse Files with reserved IDs listed above. Read
	// and parse errors for all these Files are reported here.
	// This is implemented as a map, with one FileProcessingErrors for each file.
	// Typically produced when parsing Files, but may also be provided directly
	// by clients.
	FileProcessingErrors []*FileProcessingErrors `protobuf:"bytes,13,rep,name=file_processing_errors,json=fileProcessingErrors,proto3" json:"file_processing_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Action) Reset()         { *m = Action{} }
func (m *Action) String() string { return proto.CompactTextString(m) }
func (*Action) ProtoMessage()    {}
func (*Action) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{0}
}

func (m *Action) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Action.Unmarshal(m, b)
}
func (m *Action) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Action.Marshal(b, m, deterministic)
}
func (m *Action) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Action.Merge(m, src)
}
func (m *Action) XXX_Size() int {
	return xxx_messageInfo_Action.Size(m)
}
func (m *Action) XXX_DiscardUnknown() {
	xxx_messageInfo_Action.DiscardUnknown(m)
}

var xxx_messageInfo_Action proto.InternalMessageInfo

func (m *Action) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Action) GetId() *Action_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Action) GetStatusAttributes() *StatusAttributes {
	if m != nil {
		return m.StatusAttributes
	}
	return nil
}

func (m *Action) GetTiming() *Timing {
	if m != nil {
		return m.Timing
	}
	return nil
}

type isAction_ActionType interface {
	isAction_ActionType()
}

type Action_BuildAction struct {
	BuildAction *BuildAction `protobuf:"bytes,9,opt,name=build_action,json=buildAction,proto3,oneof"`
}

type Action_TestAction struct {
	TestAction *TestAction `protobuf:"bytes,10,opt,name=test_action,json=testAction,proto3,oneof"`
}

func (*Action_BuildAction) isAction_ActionType() {}

func (*Action_TestAction) isAction_ActionType() {}

func (m *Action) GetActionType() isAction_ActionType {
	if m != nil {
		return m.ActionType
	}
	return nil
}

func (m *Action) GetBuildAction() *BuildAction {
	if x, ok := m.GetActionType().(*Action_BuildAction); ok {
		return x.BuildAction
	}
	return nil
}

func (m *Action) GetTestAction() *TestAction {
	if x, ok := m.GetActionType().(*Action_TestAction); ok {
		return x.TestAction
	}
	return nil
}

func (m *Action) GetActionAttributes() *ActionAttributes {
	if m != nil {
		return m.ActionAttributes
	}
	return nil
}

func (m *Action) GetActionDependencies() []*Dependency {
	if m != nil {
		return m.ActionDependencies
	}
	return nil
}

func (m *Action) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *Action) GetFiles() []*File {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *Action) GetFileSets() []string {
	if m != nil {
		return m.FileSets
	}
	return nil
}

func (m *Action) GetCoverage() *ActionCoverage {
	if m != nil {
		return m.Coverage
	}
	return nil
}

func (m *Action) GetFileProcessingErrors() []*FileProcessingErrors {
	if m != nil {
		return m.FileProcessingErrors
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Action) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Action_BuildAction)(nil),
		(*Action_TestAction)(nil),
	}
}

// The resource ID components that identify the Action.
type Action_Id struct {
	// The Invocation ID.
	InvocationId string `protobuf:"bytes,1,opt,name=invocation_id,json=invocationId,proto3" json:"invocation_id,omitempty"`
	// The Target ID.
	TargetId string `protobuf:"bytes,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// The Configuration ID.
	ConfigurationId string `protobuf:"bytes,3,opt,name=configuration_id,json=configurationId,proto3" json:"configuration_id,omitempty"`
	// The Action ID.
	ActionId             string   `protobuf:"bytes,4,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Action_Id) Reset()         { *m = Action_Id{} }
func (m *Action_Id) String() string { return proto.CompactTextString(m) }
func (*Action_Id) ProtoMessage()    {}
func (*Action_Id) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{0, 0}
}

func (m *Action_Id) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Action_Id.Unmarshal(m, b)
}
func (m *Action_Id) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Action_Id.Marshal(b, m, deterministic)
}
func (m *Action_Id) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Action_Id.Merge(m, src)
}
func (m *Action_Id) XXX_Size() int {
	return xxx_messageInfo_Action_Id.Size(m)
}
func (m *Action_Id) XXX_DiscardUnknown() {
	xxx_messageInfo_Action_Id.DiscardUnknown(m)
}

var xxx_messageInfo_Action_Id proto.InternalMessageInfo

func (m *Action_Id) GetInvocationId() string {
	if m != nil {
		return m.InvocationId
	}
	return ""
}

func (m *Action_Id) GetTargetId() string {
	if m != nil {
		return m.TargetId
	}
	return ""
}

func (m *Action_Id) GetConfigurationId() string {
	if m != nil {
		return m.ConfigurationId
	}
	return ""
}

func (m *Action_Id) GetActionId() string {
	if m != nil {
		return m.ActionId
	}
	return ""
}

// A build action, such as building a java library.
type BuildAction struct {
	// The type of the action.  This is intended to be a clue as to how the output
	// of the action should be parsed. For example "javac" for a Java compile
	// action.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The "primary" input artifact processed by this action.  E.g., the .cc file
	// of a C++ compile action.  Empty string ("") if the action has no input
	// artifacts or no "primary" input artifact.
	PrimaryInputPath string `protobuf:"bytes,2,opt,name=primary_input_path,json=primaryInputPath,proto3" json:"primary_input_path,omitempty"`
	// The "primary" output artifact processed by this action.  E.g., the .o file
	// of a C++ compile action.  Empty string ("") if the action has no output
	// artifacts or no "primary" output artifact.
	PrimaryOutputPath    string   `protobuf:"bytes,3,opt,name=primary_output_path,json=primaryOutputPath,proto3" json:"primary_output_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildAction) Reset()         { *m = BuildAction{} }
func (m *BuildAction) String() string { return proto.CompactTextString(m) }
func (*BuildAction) ProtoMessage()    {}
func (*BuildAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{1}
}

func (m *BuildAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildAction.Unmarshal(m, b)
}
func (m *BuildAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildAction.Marshal(b, m, deterministic)
}
func (m *BuildAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildAction.Merge(m, src)
}
func (m *BuildAction) XXX_Size() int {
	return xxx_messageInfo_BuildAction.Size(m)
}
func (m *BuildAction) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildAction.DiscardUnknown(m)
}

var xxx_messageInfo_BuildAction proto.InternalMessageInfo

func (m *BuildAction) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *BuildAction) GetPrimaryInputPath() string {
	if m != nil {
		return m.PrimaryInputPath
	}
	return ""
}

func (m *BuildAction) GetPrimaryOutputPath() string {
	if m != nil {
		return m.PrimaryOutputPath
	}
	return ""
}

// A test action, such as running a JUnit4 test binary.
type TestAction struct {
	// Timing data for execution of the test action.
	TestTiming *TestTiming `protobuf:"bytes,1,opt,name=test_timing,json=testTiming,proto3" json:"test_timing,omitempty"`
	// If the test is divided up into shards to improve performance, set this to
	// indicate which shard this test action is for. Value must be in interval
	// [0, total_shard_count). Defaults to 0, which is appropriate if all test
	// cases are run in the same process.
	ShardNumber int32 `protobuf:"varint,2,opt,name=shard_number,json=shardNumber,proto3" json:"shard_number,omitempty"`
	// If the user requested that every test be run multiple times, as is often
	// done to measure flakiness, set this to indicate which run this test action
	// is for. Value must be in interval [0, total_run_count). Defaults to 0,
	// which is appropriate if multiple runs were not requested.
	RunNumber int32 `protobuf:"varint,3,opt,name=run_number,json=runNumber,proto3" json:"run_number,omitempty"`
	// If flaky tests are automatically retried, set this to indicate which
	// attempt this test action is for. (e.g. 0 for the first attempt, 1 for
	// second, and so on). Defaults to 0, which is appropriate if this is only
	// attempt.
	AttemptNumber int32 `protobuf:"varint,4,opt,name=attempt_number,json=attemptNumber,proto3" json:"attempt_number,omitempty"`
	// A tree of test suites and test cases that were run by this test action.
	// Each test case has its own status information, including stack traces.
	// Typically produced by parsing an XML Log, but may also be provided directly
	// by clients.
	TestSuite *TestSuite `protobuf:"bytes,5,opt,name=test_suite,json=testSuite,proto3" json:"test_suite,omitempty"`
	// Warnings for this test action.
	Warnings []*TestWarning `protobuf:"bytes,8,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// Estimated memory consumption of the test action, in bytes. A default value
	// of 0 means there is no memory consumption estimate specified.
	EstimatedMemoryBytes int64    `protobuf:"varint,10,opt,name=estimated_memory_bytes,json=estimatedMemoryBytes,proto3" json:"estimated_memory_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestAction) Reset()         { *m = TestAction{} }
func (m *TestAction) String() string { return proto.CompactTextString(m) }
func (*TestAction) ProtoMessage()    {}
func (*TestAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{2}
}

func (m *TestAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestAction.Unmarshal(m, b)
}
func (m *TestAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestAction.Marshal(b, m, deterministic)
}
func (m *TestAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestAction.Merge(m, src)
}
func (m *TestAction) XXX_Size() int {
	return xxx_messageInfo_TestAction.Size(m)
}
func (m *TestAction) XXX_DiscardUnknown() {
	xxx_messageInfo_TestAction.DiscardUnknown(m)
}

var xxx_messageInfo_TestAction proto.InternalMessageInfo

func (m *TestAction) GetTestTiming() *TestTiming {
	if m != nil {
		return m.TestTiming
	}
	return nil
}

func (m *TestAction) GetShardNumber() int32 {
	if m != nil {
		return m.ShardNumber
	}
	return 0
}

func (m *TestAction) GetRunNumber() int32 {
	if m != nil {
		return m.RunNumber
	}
	return 0
}

func (m *TestAction) GetAttemptNumber() int32 {
	if m != nil {
		return m.AttemptNumber
	}
	return 0
}

func (m *TestAction) GetTestSuite() *TestSuite {
	if m != nil {
		return m.TestSuite
	}
	return nil
}

func (m *TestAction) GetWarnings() []*TestWarning {
	if m != nil {
		return m.Warnings
	}
	return nil
}

func (m *TestAction) GetEstimatedMemoryBytes() int64 {
	if m != nil {
		return m.EstimatedMemoryBytes
	}
	return 0
}

// General attributes of an action
type ActionAttributes struct {
	// Strategy used for executing the action.
	ExecutionStrategy ExecutionStrategy `protobuf:"varint,1,opt,name=execution_strategy,json=executionStrategy,proto3,enum=google.devtools.resultstore.v2.ExecutionStrategy" json:"execution_strategy,omitempty"`
	// Exit code of the process that ran the action. A non-zero value means
	// failure.
	ExitCode int32 `protobuf:"varint,2,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// Where the action was run.
	Hostname string `protobuf:"bytes,3,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Information about the input files used in all actions under this configured
	// target.
	InputFileInfo        *InputFileInfo `protobuf:"bytes,4,opt,name=input_file_info,json=inputFileInfo,proto3" json:"input_file_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ActionAttributes) Reset()         { *m = ActionAttributes{} }
func (m *ActionAttributes) String() string { return proto.CompactTextString(m) }
func (*ActionAttributes) ProtoMessage()    {}
func (*ActionAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{3}
}

func (m *ActionAttributes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActionAttributes.Unmarshal(m, b)
}
func (m *ActionAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActionAttributes.Marshal(b, m, deterministic)
}
func (m *ActionAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActionAttributes.Merge(m, src)
}
func (m *ActionAttributes) XXX_Size() int {
	return xxx_messageInfo_ActionAttributes.Size(m)
}
func (m *ActionAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_ActionAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_ActionAttributes proto.InternalMessageInfo

func (m *ActionAttributes) GetExecutionStrategy() ExecutionStrategy {
	if m != nil {
		return m.ExecutionStrategy
	}
	return ExecutionStrategy_EXECUTION_STRATEGY_UNSPECIFIED
}

func (m *ActionAttributes) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

func (m *ActionAttributes) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *ActionAttributes) GetInputFileInfo() *InputFileInfo {
	if m != nil {
		return m.InputFileInfo
	}
	return nil
}

// File count and size information for the input files to a configured target.
type InputFileInfo struct {
	// The number of input files (counting every file, even if a duplicate).
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// The number of distinct input files.
	DistinctCount int64 `protobuf:"varint,2,opt,name=distinct_count,json=distinctCount,proto3" json:"distinct_count,omitempty"`
	// The max number of input files allowed by the build system (counting every
	// file, even if a duplicate).
	CountLimit int64 `protobuf:"varint,3,opt,name=count_limit,json=countLimit,proto3" json:"count_limit,omitempty"`
	// The total size of the distinct input files.
	DistinctBytes int64 `protobuf:"varint,4,opt,name=distinct_bytes,json=distinctBytes,proto3" json:"distinct_bytes,omitempty"`
	// The max allowed total size of the distinct input files.
	DistinctByteLimit    int64    `protobuf:"varint,5,opt,name=distinct_byte_limit,json=distinctByteLimit,proto3" json:"distinct_byte_limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InputFileInfo) Reset()         { *m = InputFileInfo{} }
func (m *InputFileInfo) String() string { return proto.CompactTextString(m) }
func (*InputFileInfo) ProtoMessage()    {}
func (*InputFileInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{4}
}

func (m *InputFileInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputFileInfo.Unmarshal(m, b)
}
func (m *InputFileInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputFileInfo.Marshal(b, m, deterministic)
}
func (m *InputFileInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputFileInfo.Merge(m, src)
}
func (m *InputFileInfo) XXX_Size() int {
	return xxx_messageInfo_InputFileInfo.Size(m)
}
func (m *InputFileInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_InputFileInfo.DiscardUnknown(m)
}

var xxx_messageInfo_InputFileInfo proto.InternalMessageInfo

func (m *InputFileInfo) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *InputFileInfo) GetDistinctCount() int64 {
	if m != nil {
		return m.DistinctCount
	}
	return 0
}

func (m *InputFileInfo) GetCountLimit() int64 {
	if m != nil {
		return m.CountLimit
	}
	return 0
}

func (m *InputFileInfo) GetDistinctBytes() int64 {
	if m != nil {
		return m.DistinctBytes
	}
	return 0
}

func (m *InputFileInfo) GetDistinctByteLimit() int64 {
	if m != nil {
		return m.DistinctByteLimit
	}
	return 0
}

// Timing data for tests executed locally on the machine running the build.
type LocalTestTiming struct {
	// Time taken by the test process, typically surrounded by a small wrapper
	// script.
	TestProcessDuration  *duration.Duration `protobuf:"bytes,1,opt,name=test_process_duration,json=testProcessDuration,proto3" json:"test_process_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *LocalTestTiming) Reset()         { *m = LocalTestTiming{} }
func (m *LocalTestTiming) String() string { return proto.CompactTextString(m) }
func (*LocalTestTiming) ProtoMessage()    {}
func (*LocalTestTiming) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{5}
}

func (m *LocalTestTiming) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocalTestTiming.Unmarshal(m, b)
}
func (m *LocalTestTiming) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocalTestTiming.Marshal(b, m, deterministic)
}
func (m *LocalTestTiming) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalTestTiming.Merge(m, src)
}
func (m *LocalTestTiming) XXX_Size() int {
	return xxx_messageInfo_LocalTestTiming.Size(m)
}
func (m *LocalTestTiming) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalTestTiming.DiscardUnknown(m)
}

var xxx_messageInfo_LocalTestTiming proto.InternalMessageInfo

func (m *LocalTestTiming) GetTestProcessDuration() *duration.Duration {
	if m != nil {
		return m.TestProcessDuration
	}
	return nil
}

// Timing data for one attempt to execute a test action remotely.
type RemoteTestAttemptTiming struct {
	// Idle period before the test process is invoked on the remote machine.
	QueueDuration *duration.Duration `protobuf:"bytes,1,opt,name=queue_duration,json=queueDuration,proto3" json:"queue_duration,omitempty"`
	// Time to upload data dependencies from the local machine to the remote
	// machine running the test, or to the distributed cache.
	UploadDuration *duration.Duration `protobuf:"bytes,2,opt,name=upload_duration,json=uploadDuration,proto3" json:"upload_duration,omitempty"`
	// Time to set up the remote machine.
	// Not to be confused with setup time in
	// xUnit test frameworks, which falls within the test_process_time.
	MachineSetupDuration *duration.Duration `protobuf:"bytes,3,opt,name=machine_setup_duration,json=machineSetupDuration,proto3" json:"machine_setup_duration,omitempty"`
	// Time taken by the test process, typically surrounded by a small wrapper
	// script.
	// For Java tests, this includes JVM setup, flag parsing, class path setup,
	// parsing files to setup the suite, and finally running your test methods.
	// In many cases, only a small fraction of the test process time is spent
	// running the test methods.
	TestProcessDuration *duration.Duration `protobuf:"bytes,4,opt,name=test_process_duration,json=testProcessDuration,proto3" json:"test_process_duration,omitempty"`
	// Time spent retrieving test logs and any other test outputs, back to the
	// local machine.
	DownloadDuration     *duration.Duration `protobuf:"bytes,5,opt,name=download_duration,json=downloadDuration,proto3" json:"download_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *RemoteTestAttemptTiming) Reset()         { *m = RemoteTestAttemptTiming{} }
func (m *RemoteTestAttemptTiming) String() string { return proto.CompactTextString(m) }
func (*RemoteTestAttemptTiming) ProtoMessage()    {}
func (*RemoteTestAttemptTiming) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{6}
}

func (m *RemoteTestAttemptTiming) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteTestAttemptTiming.Unmarshal(m, b)
}
func (m *RemoteTestAttemptTiming) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteTestAttemptTiming.Marshal(b, m, deterministic)
}
func (m *RemoteTestAttemptTiming) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteTestAttemptTiming.Merge(m, src)
}
func (m *RemoteTestAttemptTiming) XXX_Size() int {
	return xxx_messageInfo_RemoteTestAttemptTiming.Size(m)
}
func (m *RemoteTestAttemptTiming) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteTestAttemptTiming.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteTestAttemptTiming proto.InternalMessageInfo

func (m *RemoteTestAttemptTiming) GetQueueDuration() *duration.Duration {
	if m != nil {
		return m.QueueDuration
	}
	return nil
}

func (m *RemoteTestAttemptTiming) GetUploadDuration() *duration.Duration {
	if m != nil {
		return m.UploadDuration
	}
	return nil
}

func (m *RemoteTestAttemptTiming) GetMachineSetupDuration() *duration.Duration {
	if m != nil {
		return m.MachineSetupDuration
	}
	return nil
}

func (m *RemoteTestAttemptTiming) GetTestProcessDuration() *duration.Duration {
	if m != nil {
		return m.TestProcessDuration
	}
	return nil
}

func (m *RemoteTestAttemptTiming) GetDownloadDuration() *duration.Duration {
	if m != nil {
		return m.DownloadDuration
	}
	return nil
}

// Timing data for the part of the test execution that is done remotely.
type RemoteTestTiming struct {
	// Time taken locally to determine what to do.
	LocalAnalysisDuration *duration.Duration `protobuf:"bytes,1,opt,name=local_analysis_duration,json=localAnalysisDuration,proto3" json:"local_analysis_duration,omitempty"`
	// Normally there is only one attempt, but the system may retry on internal
	// errors, leading to multiple attempts.
	Attempts             []*RemoteTestAttemptTiming `protobuf:"bytes,2,rep,name=attempts,proto3" json:"attempts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *RemoteTestTiming) Reset()         { *m = RemoteTestTiming{} }
func (m *RemoteTestTiming) String() string { return proto.CompactTextString(m) }
func (*RemoteTestTiming) ProtoMessage()    {}
func (*RemoteTestTiming) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{7}
}

func (m *RemoteTestTiming) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteTestTiming.Unmarshal(m, b)
}
func (m *RemoteTestTiming) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteTestTiming.Marshal(b, m, deterministic)
}
func (m *RemoteTestTiming) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteTestTiming.Merge(m, src)
}
func (m *RemoteTestTiming) XXX_Size() int {
	return xxx_messageInfo_RemoteTestTiming.Size(m)
}
func (m *RemoteTestTiming) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteTestTiming.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteTestTiming proto.InternalMessageInfo

func (m *RemoteTestTiming) GetLocalAnalysisDuration() *duration.Duration {
	if m != nil {
		return m.LocalAnalysisDuration
	}
	return nil
}

func (m *RemoteTestTiming) GetAttempts() []*RemoteTestAttemptTiming {
	if m != nil {
		return m.Attempts
	}
	return nil
}

// Timing data for execution of a test action. The action may be performed
// locally, on the machine running the build, or remotely.
type TestTiming struct {
	// Test timing for either a local or remote execution.
	//
	// Types that are valid to be assigned to Location:
	//	*TestTiming_Local
	//	*TestTiming_Remote
	Location isTestTiming_Location `protobuf_oneof:"location"`
	// The amount of CPU time spent by the test process executing system calls
	// within the kernel, as opposed to library code. Time the test process spent
	// blocked does not count towards this figure.
	SystemTimeDuration *duration.Duration `protobuf:"bytes,3,opt,name=system_time_duration,json=systemTimeDuration,proto3" json:"system_time_duration,omitempty"`
	// The amount of CPU time spent by the test process executing user-mode code
	// outside the kernel, as opposed to library code. Time the test process
	// spent blocked does not count towards this figure. You can add user_time to
	// system_time to get total CPU time taken by the test process.
	UserTimeDuration *duration.Duration `protobuf:"bytes,4,opt,name=user_time_duration,json=userTimeDuration,proto3" json:"user_time_duration,omitempty"`
	// Most build systems cache build results to speed up incremental builds.
	// Some also cache test results too. This indicates whether the test results
	// were found in a cache, and where that cache was located.
	TestCaching          TestCaching `protobuf:"varint,5,opt,name=test_caching,json=testCaching,proto3,enum=google.devtools.resultstore.v2.TestCaching" json:"test_caching,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *TestTiming) Reset()         { *m = TestTiming{} }
func (m *TestTiming) String() string { return proto.CompactTextString(m) }
func (*TestTiming) ProtoMessage()    {}
func (*TestTiming) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{8}
}

func (m *TestTiming) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestTiming.Unmarshal(m, b)
}
func (m *TestTiming) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestTiming.Marshal(b, m, deterministic)
}
func (m *TestTiming) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestTiming.Merge(m, src)
}
func (m *TestTiming) XXX_Size() int {
	return xxx_messageInfo_TestTiming.Size(m)
}
func (m *TestTiming) XXX_DiscardUnknown() {
	xxx_messageInfo_TestTiming.DiscardUnknown(m)
}

var xxx_messageInfo_TestTiming proto.InternalMessageInfo

type isTestTiming_Location interface {
	isTestTiming_Location()
}

type TestTiming_Local struct {
	Local *LocalTestTiming `protobuf:"bytes,1,opt,name=local,proto3,oneof"`
}

type TestTiming_Remote struct {
	Remote *RemoteTestTiming `protobuf:"bytes,2,opt,name=remote,proto3,oneof"`
}

func (*TestTiming_Local) isTestTiming_Location() {}

func (*TestTiming_Remote) isTestTiming_Location() {}

func (m *TestTiming) GetLocation() isTestTiming_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *TestTiming) GetLocal() *LocalTestTiming {
	if x, ok := m.GetLocation().(*TestTiming_Local); ok {
		return x.Local
	}
	return nil
}

func (m *TestTiming) GetRemote() *RemoteTestTiming {
	if x, ok := m.GetLocation().(*TestTiming_Remote); ok {
		return x.Remote
	}
	return nil
}

func (m *TestTiming) GetSystemTimeDuration() *duration.Duration {
	if m != nil {
		return m.SystemTimeDuration
	}
	return nil
}

func (m *TestTiming) GetUserTimeDuration() *duration.Duration {
	if m != nil {
		return m.UserTimeDuration
	}
	return nil
}

func (m *TestTiming) GetTestCaching() TestCaching {
	if m != nil {
		return m.TestCaching
	}
	return TestCaching_TEST_CACHING_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TestTiming) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TestTiming_Local)(nil),
		(*TestTiming_Remote)(nil),
	}
}

// A warning from a test execution.
type TestWarning struct {
	// Contains the message detailing the warning.
	WarningMessage       string   `protobuf:"bytes,1,opt,name=warning_message,json=warningMessage,proto3" json:"warning_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestWarning) Reset()         { *m = TestWarning{} }
func (m *TestWarning) String() string { return proto.CompactTextString(m) }
func (*TestWarning) ProtoMessage()    {}
func (*TestWarning) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{9}
}

func (m *TestWarning) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestWarning.Unmarshal(m, b)
}
func (m *TestWarning) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestWarning.Marshal(b, m, deterministic)
}
func (m *TestWarning) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestWarning.Merge(m, src)
}
func (m *TestWarning) XXX_Size() int {
	return xxx_messageInfo_TestWarning.Size(m)
}
func (m *TestWarning) XXX_DiscardUnknown() {
	xxx_messageInfo_TestWarning.DiscardUnknown(m)
}

var xxx_messageInfo_TestWarning proto.InternalMessageInfo

func (m *TestWarning) GetWarningMessage() string {
	if m != nil {
		return m.WarningMessage
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.devtools.resultstore.v2.ExecutionStrategy", ExecutionStrategy_name, ExecutionStrategy_value)
	proto.RegisterEnum("google.devtools.resultstore.v2.TestCaching", TestCaching_name, TestCaching_value)
	proto.RegisterType((*Action)(nil), "google.devtools.resultstore.v2.Action")
	proto.RegisterType((*Action_Id)(nil), "google.devtools.resultstore.v2.Action.Id")
	proto.RegisterType((*BuildAction)(nil), "google.devtools.resultstore.v2.BuildAction")
	proto.RegisterType((*TestAction)(nil), "google.devtools.resultstore.v2.TestAction")
	proto.RegisterType((*ActionAttributes)(nil), "google.devtools.resultstore.v2.ActionAttributes")
	proto.RegisterType((*InputFileInfo)(nil), "google.devtools.resultstore.v2.InputFileInfo")
	proto.RegisterType((*LocalTestTiming)(nil), "google.devtools.resultstore.v2.LocalTestTiming")
	proto.RegisterType((*RemoteTestAttemptTiming)(nil), "google.devtools.resultstore.v2.RemoteTestAttemptTiming")
	proto.RegisterType((*RemoteTestTiming)(nil), "google.devtools.resultstore.v2.RemoteTestTiming")
	proto.RegisterType((*TestTiming)(nil), "google.devtools.resultstore.v2.TestTiming")
	proto.RegisterType((*TestWarning)(nil), "google.devtools.resultstore.v2.TestWarning")
}

func init() {
	proto.RegisterFile("google/devtools/resultstore/v2/action.proto", fileDescriptor_e98e32542f2d3836)
}

var fileDescriptor_e98e32542f2d3836 = []byte{
	// 1446 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0x4b, 0x73, 0xdb, 0x46,
	0x12, 0x36, 0x49, 0x49, 0x4b, 0x36, 0x45, 0x0a, 0x1a, 0xc9, 0x36, 0x57, 0xbb, 0xeb, 0xd5, 0x72,
	0xf3, 0x90, 0xec, 0x98, 0x74, 0x14, 0x57, 0x52, 0x71, 0xaa, 0x52, 0xa1, 0x28, 0x58, 0x82, 0x4d,
	0x51, 0xf2, 0x90, 0x72, 0x5e, 0x95, 0x82, 0x21, 0x62, 0x44, 0x4d, 0x8a, 0xc0, 0xd0, 0x98, 0x81,
	0x6c, 0x9e, 0x72, 0x49, 0x55, 0x0e, 0x49, 0xe5, 0x92, 0x7f, 0x93, 0x73, 0xce, 0xf9, 0x4d, 0xa9,
	0x79, 0x00, 0xa4, 0x14, 0x3b, 0xa0, 0x73, 0xe3, 0x74, 0x7f, 0xdf, 0x37, 0x3d, 0x3d, 0xdd, 0x3d,
	0x20, 0xdc, 0x19, 0x32, 0x36, 0x1c, 0x91, 0xa6, 0x4f, 0x2e, 0x04, 0x63, 0x23, 0xde, 0x8c, 0x08,
	0x8f, 0x47, 0x82, 0x0b, 0x16, 0x91, 0xe6, 0xc5, 0x4e, 0xd3, 0x1b, 0x08, 0xca, 0xc2, 0xc6, 0x38,
	0x62, 0x82, 0xa1, 0x5b, 0x1a, 0xdc, 0x48, 0xc0, 0x8d, 0x19, 0x70, 0xe3, 0x62, 0x67, 0x23, 0x4b,
	0x6c, 0xc0, 0x82, 0x20, 0x11, 0xdb, 0xb8, 0x9b, 0x09, 0xbe, 0x20, 0x91, 0x37, 0x24, 0x06, 0xbe,
	0x9d, 0x01, 0x3f, 0xa3, 0xa3, 0x04, 0xfa, 0x60, 0x0e, 0xa8, 0x3b, 0x8e, 0xd8, 0x80, 0x70, 0x4e,
	0xc3, 0xa1, 0x4b, 0xa2, 0x88, 0x45, 0x86, 0xdb, 0xcc, 0xe0, 0x0a, 0xc2, 0x85, 0xcb, 0x63, 0x2a,
	0x92, 0xcd, 0x4c, 0x4e, 0x9a, 0x6a, 0x75, 0x1a, 0x9f, 0x35, 0xfd, 0x38, 0xf2, 0xa6, 0x39, 0xab,
	0xff, 0x5e, 0x84, 0xa5, 0x96, 0x4a, 0x22, 0x42, 0xb0, 0x10, 0x7a, 0x01, 0xa9, 0xe5, 0x36, 0x73,
	0x5b, 0x25, 0xac, 0x7e, 0xa3, 0x8f, 0x21, 0x4f, 0xfd, 0x5a, 0x7e, 0x33, 0xb7, 0x55, 0xde, 0xd9,
	0x6e, 0xfc, 0x75, 0x7e, 0x1b, 0x5a, 0xa7, 0xe1, 0xf8, 0x38, 0x4f, 0x7d, 0xf4, 0x0d, 0xac, 0x72,
	0xe1, 0x89, 0x98, 0xbb, 0x9e, 0x10, 0x11, 0x3d, 0x8d, 0x05, 0xe1, 0xb5, 0x82, 0x52, 0xba, 0x97,
	0xa5, 0xd4, 0x53, 0xc4, 0x56, 0xca, 0xc3, 0x16, 0xbf, 0x62, 0x41, 0x9f, 0xc2, 0x92, 0xa0, 0x01,
	0x0d, 0x87, 0xb5, 0x05, 0xa5, 0xf9, 0x4e, 0x96, 0x66, 0x5f, 0xa1, 0xb1, 0x61, 0xa1, 0x63, 0x58,
	0x3e, 0x8d, 0xe9, 0xc8, 0x77, 0x75, 0x09, 0xd5, 0x4a, 0x4a, 0xe5, 0x4e, 0x96, 0xca, 0xae, 0xe4,
	0xe8, 0x83, 0x1e, 0x5c, 0xc3, 0xe5, 0xd3, 0xe9, 0x12, 0x1d, 0x42, 0x59, 0xa5, 0xdf, 0x08, 0x82,
	0x12, 0xbc, 0x9d, 0x19, 0x16, 0xe1, 0x22, 0xd5, 0x03, 0x91, 0xae, 0x64, 0xfe, 0xb4, 0xd2, 0x6c,
	0xfe, 0x16, 0xe7, 0xcb, 0x9f, 0x96, 0x98, 0xcd, 0x9f, 0x77, 0xc5, 0x82, 0xbe, 0x86, 0x35, 0x23,
	0xef, 0x93, 0x31, 0x09, 0x7d, 0x12, 0x0e, 0x28, 0xe1, 0xb5, 0xea, 0x66, 0x61, 0x9e, 0xa8, 0xf7,
	0x12, 0xce, 0x04, 0x23, 0x2d, 0xb3, 0x37, 0xa3, 0x82, 0x0e, 0x00, 0xc6, 0x11, 0x1b, 0x93, 0x48,
	0x48, 0xcd, 0x7f, 0x28, 0xcd, 0xad, 0x2c, 0xcd, 0x63, 0xcd, 0x98, 0xe0, 0x19, 0x2e, 0x7a, 0x00,
	0x8b, 0xb2, 0x1f, 0x78, 0xad, 0xa8, 0x44, 0xde, 0xca, 0x12, 0x79, 0x48, 0x47, 0x04, 0x6b, 0x0a,
	0xfa, 0x17, 0x94, 0x54, 0x2f, 0x71, 0x22, 0x78, 0x6d, 0x65, 0xb3, 0xb0, 0x55, 0xc2, 0x45, 0x69,
	0xe8, 0x11, 0xc1, 0xd1, 0x23, 0x28, 0x26, 0x2d, 0x5c, 0x2b, 0xab, 0xac, 0x36, 0xe6, 0xcb, 0x6a,
	0xdb, 0xb0, 0x70, 0xca, 0x47, 0xdf, 0xc2, 0x8d, 0x57, 0x36, 0x2d, 0xaf, 0x55, 0x54, 0xd4, 0xf7,
	0xe7, 0x89, 0xfa, 0x38, 0x25, 0xdb, 0x8a, 0x8b, 0xd7, 0xcf, 0x5e, 0x61, 0xdd, 0xf8, 0x39, 0x07,
	0x79, 0xc7, 0x47, 0xff, 0x87, 0x0a, 0x0d, 0x2f, 0xd8, 0x40, 0xf5, 0xb2, 0x4b, 0x7d, 0xd3, 0xb5,
	0xcb, 0x53, 0xa3, 0xe3, 0xcb, 0x04, 0x08, 0x2f, 0x1a, 0x12, 0xe1, 0x9a, 0x26, 0x2e, 0xe1, 0xa2,
	0x36, 0x38, 0x3e, 0xda, 0x06, 0x6b, 0xc0, 0xc2, 0x33, 0x3a, 0x34, 0x03, 0x41, 0x62, 0x0a, 0x0a,
	0xb3, 0x72, 0xc9, 0xae, 0x75, 0x4c, 0xad, 0x50, 0x5f, 0xb5, 0x5b, 0x09, 0x17, 0xb5, 0xc1, 0xf1,
	0x77, 0x2b, 0x50, 0x36, 0x4e, 0x31, 0x19, 0x93, 0xfa, 0x77, 0x50, 0x9e, 0xe9, 0x11, 0x39, 0x54,
	0xa4, 0x39, 0x19, 0x2a, 0xf2, 0x37, 0x7a, 0x0f, 0xd0, 0x38, 0xa2, 0x81, 0x17, 0x4d, 0x5c, 0x1a,
	0x8e, 0x63, 0xe1, 0x8e, 0x3d, 0x71, 0x6e, 0xe2, 0xb3, 0x8c, 0xc7, 0x91, 0x8e, 0x63, 0x4f, 0x9c,
	0xa3, 0x06, 0xac, 0x25, 0x68, 0x16, 0x8b, 0x14, 0xae, 0x43, 0x5d, 0x35, 0xae, 0x23, 0xe5, 0x91,
	0xf8, 0xfa, 0x8f, 0x05, 0x80, 0x69, 0x53, 0xa1, 0xc7, 0xa6, 0x2b, 0xcd, 0xb0, 0xc8, 0xcd, 0xdf,
	0x95, 0x66, 0x60, 0xa8, 0x9e, 0xd4, 0xbf, 0xd1, 0xff, 0x60, 0x99, 0x9f, 0x7b, 0x91, 0xef, 0x86,
	0x71, 0x70, 0x4a, 0x22, 0x15, 0xf3, 0x22, 0x2e, 0x2b, 0x5b, 0x57, 0x99, 0xd0, 0x7f, 0x00, 0xa2,
	0x38, 0x4c, 0x00, 0x05, 0x05, 0x28, 0x45, 0x71, 0x68, 0xdc, 0x6f, 0x43, 0xd5, 0x13, 0x82, 0x04,
	0x63, 0x91, 0x40, 0x16, 0x14, 0xa4, 0x62, 0xac, 0x06, 0x76, 0x00, 0x30, 0x1d, 0xe5, 0xa6, 0xeb,
	0xb7, 0xe7, 0x09, 0xba, 0x27, 0x09, 0xb8, 0x24, 0x92, 0x9f, 0x68, 0x1f, 0x8a, 0x2f, 0xbc, 0x28,
	0xa4, 0xe1, 0x30, 0xe9, 0xa1, 0x3b, 0xf3, 0xe8, 0x7c, 0xae, 0x39, 0x38, 0x25, 0xa3, 0xfb, 0x70,
	0x83, 0x70, 0x41, 0x03, 0x4f, 0x10, 0xdf, 0x0d, 0x48, 0xc0, 0xa2, 0x89, 0x7b, 0x3a, 0x91, 0x43,
	0x49, 0x4e, 0xba, 0x02, 0x5e, 0x4f, 0xbd, 0x87, 0xca, 0xb9, 0x2b, 0x7d, 0xf5, 0xef, 0xf3, 0x60,
	0x5d, 0x9d, 0x46, 0xe8, 0x19, 0x20, 0xf2, 0x92, 0x0c, 0x62, 0x55, 0x35, 0x5c, 0x44, 0x9e, 0x20,
	0xc3, 0x89, 0xba, 0x9a, 0xea, 0xce, 0xfb, 0x59, 0xd1, 0xd9, 0x09, 0xb3, 0x67, 0x88, 0x78, 0x95,
	0x5c, 0x35, 0xc9, 0x8a, 0x25, 0x2f, 0xa9, 0x70, 0x07, 0xcc, 0x27, 0xe6, 0x96, 0x8a, 0xd2, 0xd0,
	0x66, 0x3e, 0x41, 0x1b, 0x50, 0x3c, 0x67, 0x5c, 0xa8, 0xc7, 0x4e, 0x97, 0x51, 0xba, 0x46, 0x27,
	0xb0, 0xa2, 0x6b, 0x52, 0x35, 0x34, 0x0d, 0xcf, 0x98, 0x79, 0x5f, 0xee, 0x66, 0xc5, 0xa5, 0x2a,
	0x56, 0x36, 0xb2, 0x13, 0x9e, 0x31, 0x5c, 0xa1, 0xb3, 0xcb, 0xfa, 0x6f, 0x39, 0xa8, 0x5c, 0x02,
	0xa0, 0x75, 0x58, 0x1c, 0xb0, 0x38, 0x14, 0xea, 0xd8, 0x05, 0xac, 0x17, 0xb2, 0x3c, 0x7c, 0xca,
	0x05, 0x0d, 0x07, 0x32, 0x76, 0xe9, 0xce, 0x2b, 0x77, 0x25, 0xb1, 0xb6, 0x15, 0xec, 0xbf, 0x50,
	0x56, 0x5e, 0x77, 0x44, 0x03, 0x2a, 0xd4, 0x21, 0x0a, 0x18, 0x94, 0xa9, 0x23, 0x2d, 0x97, 0x74,
	0xf4, 0x25, 0x2d, 0x5c, 0xd6, 0x51, 0xb7, 0x23, 0x7b, 0xeb, 0x12, 0xcc, 0xe8, 0x2d, 0x2a, 0xec,
	0xea, 0x2c, 0x56, 0xc9, 0xd6, 0x9f, 0xc1, 0x4a, 0x87, 0x0d, 0xbc, 0xd1, 0xb4, 0x3d, 0xd0, 0x21,
	0x5c, 0x57, 0x95, 0x6a, 0x66, 0x9f, 0x9b, 0x7c, 0x5f, 0x98, 0x4e, 0xfb, 0x67, 0x92, 0xb6, 0xe4,
	0x03, 0xa4, 0xb1, 0x67, 0x00, 0x78, 0x4d, 0xf2, 0xcc, 0x7c, 0x4b, 0x8c, 0xf5, 0x1f, 0x0a, 0x70,
	0x13, 0x93, 0x80, 0x09, 0xa2, 0x7a, 0x58, 0x37, 0x85, 0xd9, 0xea, 0x33, 0xa8, 0x3e, 0x8f, 0x49,
	0x4c, 0xde, 0x60, 0x8f, 0x8a, 0x22, 0x24, 0x4b, 0xb4, 0x0b, 0x2b, 0xf1, 0x78, 0xc4, 0x3c, 0x7f,
	0x2a, 0x91, 0xcf, 0x92, 0xa8, 0x6a, 0x46, 0xaa, 0x71, 0x04, 0x37, 0x02, 0x6f, 0x70, 0x4e, 0x43,
	0xf5, 0xb0, 0xc4, 0xe3, 0xa9, 0x54, 0x21, 0x4b, 0x6a, 0xdd, 0x10, 0x7b, 0x92, 0x97, 0x0a, 0xbe,
	0x36, 0x83, 0x0b, 0x7f, 0x27, 0x83, 0xe8, 0x21, 0xac, 0xfa, 0xec, 0x45, 0x78, 0xf9, 0x94, 0x8b,
	0x59, 0x52, 0x56, 0xc2, 0x49, 0x6f, 0xe2, 0xd7, 0x1c, 0x58, 0xd3, 0x9b, 0x30, 0x57, 0xf0, 0x04,
	0x6e, 0x8e, 0x64, 0x01, 0xb8, 0x5e, 0xe8, 0x8d, 0x26, 0x9c, 0xbe, 0xc9, 0x7d, 0x5f, 0x57, 0xcc,
	0x96, 0x21, 0xa6, 0xf1, 0xf6, 0xa0, 0x68, 0x66, 0x1f, 0xaf, 0xe5, 0xd5, 0x80, 0xfa, 0x28, 0xab,
	0xd5, 0x5e, 0x53, 0x20, 0x38, 0x15, 0xaa, 0xff, 0x62, 0x1e, 0x01, 0x13, 0xf6, 0x3e, 0x2c, 0xaa,
	0xcd, 0x4d, 0x90, 0xcd, 0xac, 0x0d, 0xae, 0x14, 0xf9, 0xc1, 0x35, 0xac, 0xf9, 0xe8, 0x11, 0x2c,
	0x45, 0x6a, 0x73, 0x53, 0x37, 0xf7, 0xe6, 0x0f, 0x35, 0x95, 0x32, 0x0a, 0xe8, 0x31, 0xac, 0xf3,
	0x09, 0x17, 0x24, 0x90, 0x6f, 0x13, 0x79, 0x83, 0x32, 0x42, 0x9a, 0xd6, 0xa7, 0xc1, 0xb4, 0xb2,
	0xf7, 0x01, 0xc5, 0x9c, 0x44, 0x57, 0xa4, 0x32, 0x2b, 0xc8, 0x92, 0xa4, 0x4b, 0x42, 0x5d, 0x58,
	0x56, 0xd5, 0x38, 0x50, 0xa5, 0x3a, 0x54, 0x95, 0x53, 0x9d, 0xef, 0xcd, 0x68, 0x6b, 0x0a, 0x56,
	0x0f, 0xae, 0x59, 0xec, 0x02, 0x14, 0x47, 0xe6, 0x8b, 0xa4, 0xfe, 0x21, 0x94, 0x67, 0xde, 0x16,
	0xf4, 0x2e, 0xac, 0x98, 0xd7, 0xc5, 0x0d, 0x08, 0xe7, 0xf2, 0x4b, 0x4c, 0x7f, 0x26, 0x54, 0x8d,
	0xf9, 0x50, 0x5b, 0x6f, 0xff, 0x94, 0x83, 0xd5, 0x3f, 0x8d, 0x7d, 0x54, 0x87, 0x5b, 0xf6, 0x17,
	0x76, 0xfb, 0xa4, 0xef, 0x1c, 0x75, 0xdd, 0x5e, 0x1f, 0xb7, 0xfa, 0xf6, 0xfe, 0x97, 0xee, 0x49,
	0xb7, 0x77, 0x6c, 0xb7, 0x9d, 0x87, 0x8e, 0xbd, 0x67, 0x5d, 0x43, 0xd7, 0x61, 0xf5, 0xa8, 0x7f,
	0x60, 0x63, 0xd7, 0xee, 0x3e, 0x75, 0xf0, 0x51, 0xf7, 0xd0, 0xee, 0xf6, 0xad, 0x1c, 0x42, 0x50,
	0xc5, 0xf6, 0xe1, 0x51, 0xdf, 0x76, 0x7b, 0x36, 0x7e, 0xea, 0xb4, 0x6d, 0x2b, 0x2f, 0x6d, 0x9d,
	0xa3, 0x76, 0xab, 0xe3, 0x1e, 0xb7, 0x70, 0xab, 0xd3, 0xb1, 0x3b, 0x56, 0x01, 0xad, 0x83, 0xa5,
	0x6d, 0x3d, 0xfb, 0xc9, 0x89, 0xdd, 0xed, 0x3b, 0xad, 0x8e, 0xb5, 0x70, 0xfb, 0x4c, 0x1f, 0xc3,
	0x9c, 0x10, 0xfd, 0x1b, 0x6a, 0x7d, 0xbb, 0xd7, 0x77, 0xdb, 0xad, 0xf6, 0x81, 0xd3, 0xdd, 0xbf,
	0x12, 0xc1, 0x1a, 0xac, 0x68, 0x09, 0xe9, 0xb6, 0xdd, 0x03, 0x47, 0xee, 0xbf, 0x0e, 0x96, 0xd9,
	0x7f, 0x6a, 0xcd, 0xa3, 0x2a, 0x80, 0x5e, 0x1e, 0x3a, 0xbd, 0x9e, 0x55, 0xd8, 0x7d, 0x0e, 0xf5,
	0x01, 0x0b, 0x32, 0x32, 0x7f, 0x9c, 0xfb, 0xca, 0x31, 0x88, 0x21, 0x1b, 0x79, 0xe1, 0xb0, 0xc1,
	0xa2, 0x61, 0x73, 0x48, 0x42, 0x75, 0xd9, 0xe6, 0xff, 0xa2, 0x37, 0xa6, 0xfc, 0x75, 0xff, 0x19,
	0x3f, 0x99, 0x59, 0x9e, 0x2e, 0x29, 0xd6, 0x07, 0x7f, 0x04, 0x00, 0x00, 0xff, 0xff, 0x1e, 0xcc,
	0x20, 0xf5, 0x78, 0x0f, 0x00, 0x00,
}
