; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=loop-vectorize -mtriple=riscv64 -mattr=+zve32x,+zvl1024b -S | FileCheck %s

; This element type isn't a supported SEW so this shouldn't be interleaved
define void @load_store_zve32x(ptr %p) {
; CHECK-LABEL: @load_store_zve32x(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[I:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[NEXTI:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[OFFSET0:%.*]] = shl i64 [[I]], 1
; CHECK-NEXT:    [[Q0:%.*]] = getelementptr i64, ptr [[P:%.*]], i64 [[OFFSET0]]
; CHECK-NEXT:    [[X0:%.*]] = load i64, ptr [[Q0]], align 8
; CHECK-NEXT:    [[Y0:%.*]] = add i64 [[X0]], 1
; CHECK-NEXT:    store i64 [[Y0]], ptr [[Q0]], align 8
; CHECK-NEXT:    [[OFFSET1:%.*]] = add i64 [[OFFSET0]], 1
; CHECK-NEXT:    [[Q1:%.*]] = getelementptr i64, ptr [[P]], i64 [[OFFSET1]]
; CHECK-NEXT:    [[X1:%.*]] = load i64, ptr [[Q1]], align 8
; CHECK-NEXT:    [[Y1:%.*]] = add i64 [[X1]], 2
; CHECK-NEXT:    store i64 [[Y1]], ptr [[Q1]], align 8
; CHECK-NEXT:    [[NEXTI]] = add i64 [[I]], 1
; CHECK-NEXT:    [[DONE:%.*]] = icmp eq i64 [[NEXTI]], 1024
; CHECK-NEXT:    br i1 [[DONE]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %i = phi i64 [0, %entry], [%nexti, %loop]

  %offset0 = shl i64 %i, 1
  %q0 = getelementptr i64, ptr %p, i64 %offset0
  %x0 = load i64, ptr %q0
  %y0 = add i64 %x0, 1
  store i64 %y0, ptr %q0

  %offset1 = add i64 %offset0, 1
  %q1 = getelementptr i64, ptr %p, i64 %offset1
  %x1 = load i64, ptr %q1
  %y1 = add i64 %x1, 2
  store i64 %y1, ptr %q1

  %nexti = add i64 %i, 1
  %done = icmp eq i64 %nexti, 1024
  br i1 %done, label %exit, label %loop
exit:
  ret void
}
