{ Printing routine, included in wbibbrws.pas }

type
  PrintHookProc = function(Wnd: HWnd; Msg, wParam: Word;
                           lParam: Longint): integer;

{$F+}
function PrintDlgHook(Wnd: HWnd; Msg, wParam: Word;
                      lParam: Longint): integer; export;
var
  i: integer;
begin
  PrintDlgHook:=0;
  case Msg of
    wm_InitDialog:
      begin
        if UseCtl3d and Win95 and Win95_3d then
          SetWindowLong(Wnd,gwl_Style,
             GetWindowLong(Wnd,gwl_Style) or DS_3DLOOK);
        if EditOnlyStrings then
        begin
          EnableWindow(GetDlgItem(Wnd,dl_PrintFields),false);
        end;
      end;
    wm_Command:
      if wParam=dl_PrintFields then
      begin
        if (Application^.ExecDialog(New(PExpFieldsDlg,init(MainW,PrintingFields,
                          @PrintUndecFields,'Print fields')))=id_ok) then
          for i:=OrigFieldLast+1 to MaxField do
              PrintingFields^[i]:=PrintUndecFields;
        SetActiveWindow(Wnd);
        PrintDlgHook:=1;
      end;
    bib_DlgHelp:
      begin
        WinHelp(HMainW,HelpFile,Help_Context,hc_Printing);
        PrintDlgHook:=1;
      end;
    wm_EnterIdle:
      if (wParam=msgf_DialogBox) and (GetKeyState(vk_F1)<0) then
      begin
        SendMessage(LoWord(lParam),bib_DlgHelp,0,0);
        PrintDlgHook:=1;
      end;
  end;
end;                          { PrintDlgHook }

function PrintSetupHook(Wnd: HWnd; Msg, wParam: Word;
                        lParam: Longint): integer; export;
begin
  PrintSetupHook:=0;
  case Msg of
    wm_InitDialog:
      begin
        if UseCtl3d and Win95 and Win95_3d then
          SetWindowLong(Wnd,gwl_Style,
             GetWindowLong(Wnd,gwl_Style) or DS_3DLOOK);
        {
        SetDlgItemInt(Wnd,dl_PrintSetupLeftMargin,  LeftMargin,  true);
        SetDlgItemInt(Wnd,dl_PrintSetupRightMargin, RightMargin, true);
        SetDlgItemInt(Wnd,dl_PrintSetupTopMargin,   TopMargin,   true);
        SetDlgItemInt(Wnd,dl_PrintSetupBottomMargin,BottomMargin,true);
        SetDlgItemInt(Wnd,dl_PrintSetupSeparation,  Word(EntrySeparation),true);
        if PrintPageHeader then
          CheckDlgButton(Wnd,dl_PrintPageHeader,bf_Checked);
        }
        {
        if PrintTheHeader then
          CheckDlgButton(Wnd,dl_PrintSetupDoHeader,bf_Checked);
        }
      end;
    {
    wm_Command:
      if wParam=id_ok then
      begin
        LeftMargin  :=GetDlgItemInt(Wnd,dl_PrintSetupLeftMargin,   Nil,true);
        RightMargin :=GetDlgItemInt(Wnd,dl_PrintSetupRightMargin,  Nil,true);
        TopMargin   :=GetDlgItemInt(Wnd,dl_PrintSetupTopMargin,    Nil,true);
        BottomMargin:=GetDlgItemInt(Wnd,dl_PrintSetupBottomMargin, Nil,true);
        EntrySeparation:=integer(GetDlgItemInt(Wnd,dl_PrintSetupSeparation,Nil,true));
        if EntrySeparation<0 then EntrySeparation:=-1;
        [
        PrintTheHeader:=IsDlgButtonChecked(Wnd,dl_PrintSetupDoHeader)=bf_Checked;
        ]
        PrintPageHeader:=IsDlgButtonChecked(Wnd,dl_PrintPageHeader)=bf_Checked;
        OptionsModified.WindowsParams:=true;
      end;
      }
    bib_DlgHelp:
      begin
        WinHelp(HMainW,HelpFile,Help_Context,hc_Printing);
        PrintSetupHook:=1;
      end;
  end;
end;                          { PrintSetupHook }
{$F-}

procedure TBrowseWindow.PrintFile(var Msg: TMessage);
var
  PrintInfo,F,FF: array[0..80] of char;
  Temp,PrintDrv,PrintType,PrintPort,PrintDevice: PChar;
  PrinterDC: HDC;
  Rect: TRect;
  TD: TDocInfo;
  i,DevModeLen: integer;
  ENum,EReal,EBeg,CurNum,NPrinted: longint;
  TPD: TPrintDlg;
  DevNames: PDevNames;
  DevModes: PDevMode;
  HDriver: THandle;
  {lpfnExtDeviceMode,}PHook,SHook: TFarProc;
  DevModeOutput: PDevMode;
  PrintAll,PrintRange,PrintCurrent,UseTagged,ok,UseTheIndex,Continue: boolean;
  OldPrintToFile: boolean;
  PrintFirst,PrintLast: word;
  PrinterStats: TPrinterStats;
  Srec: SortRecType;

begin
  FillChar(TPD,sizeof(TPD),0);
  PHook:=MakeProcInstance(TFarProc(@PrintDlgHook),HInstance);
  SHook:=MakeProcInstance(TFarProc(@PrintSetupHook),HInstance);
  OldPrintToFile:=PrintToFile;
  with TPD do
  begin
    lstructSize:=sizeof(TPD);
    HWndOwner  :=HWindow;
    hDevMode   :=HPDevMode; 
    hDevNames  :=HPDevNames;
    flags      :=pd_EnablePrintTemplate or
                 pd_EnablePrintHook     or
                 {pd_EnableSetupTemplate or}
                 {pd_EnableSetupHook     or}  
                 pd_ReturnDC            or
                 pd_UseDevModeCopies;
    if PrintToFile then flags:=flags or pd_PrintToFile;
    if Entry^.entrynum=0 then flags:=flags or pd_AllPages
    else flags:=flags or pd_PageNums;
    nFromPage  :=Entry^.EntryNum;
    nToPage    :=Entry^.EntryNum;
    nMinPage   :=0;
    nMaxPage   :=$FFFF;
    nCopies    :=1;
    lpPrintTemplateName:=PChar(rc_PrintDlg);
    lpfnPrintHook:=PrintHookProc(PHook);
    lpSetupTemplateName:=PChar(rc_PrintSetupDlg);
    lpfnSetupHook:=PrintHookProc(SHook);
  end;
  TPD.hInstance:=hInstance;

  continue:=true;
  if not PrintDlg(TPD) then
  begin
    i:=CommDlgExtendedError;
    if (i=PDERR_PRINTERNOTFOUND) then
    begin
      if TPD.hDevNames=0 then
      begin
        ErrorMessageRC(Str_DefPrinterNotFound,''); continue:=false;
      end else if YesNoRC(Str_PrinterNotFound,'') then
      begin
        OptionsModified.WindowsParams:=true;
        GlobalFree(HPDevNames); HPDevNames:=0; TPD.hDevNames:=HPDevNames;
        if not PrintDlg(TPD) then
        begin
          i:=CommDlgExtendedError;
          if (i=PDERR_PRINTERNOTFOUND) then
            ErrorMessageRC(Str_DefPrinterNotFound,'')
          else if i<>0 then ErrorMessageRC(Str_PrintDlgError,num2str(i));
          continue:=false;
        end;
      end else continue:=false;
    end else
    begin
      if i<>0 then ErrorMessageRC(Str_PrintDlgError,num2str(i));
      continue:=false;
    end;
  end;
  if continue then
  begin
    HPDevMode:=TPD.hDevMode;
    HPDevNames:=TPD.hDevNames;
    PrintToFile:=(TPD.Flags and pd_PrintToFile)<>0;
    UseTagged :=(TPD.flags and pd_Selection)<>0;
    PrintAll  :=(TPD.flags and pd_AllPages )<>0;
    PrintFirst:=1; PrintLast:=$FFFF;
    PrintRange:=(TPD.Flags and pd_PageNums )<>0;
    if PrintRange then
    begin
      PrintFirst:=TPD.nFromPage;
      PrintLast:=TPD.nToPage;
      if PrintFirst=$FFFF then PrintFirst:=1;
    end;
    PrintCurrent:=PrintRange and (PrintFirst=Entry^.EntryNum) and
                  (PrintLast=Entry^.EntryNum);

    PrinterDC:=TPD.hDC;
    StrPCopy(F,bibname^);
    TD.cbSize:=sizeof(TD);
    TD.lpszDocName:=@F;
    TD.lpszOutput:=Nil;
    if (PrinterDC<>0) and (StartDoc(PrinterDC,TD)<>sp_Error) then
    begin
      UpdateWindow(HWindow);
      for i:=PrintLabelFont to PrintNormalFont+16 do
      if Fonts^[i].Initialized then
      begin
        DeleteObject(Fonts^[i].Font);
        Fonts^[i].Initialized:=false;
      end;

      SetMapMode(PrinterDC,MM_AnIsotropic);
      with PrinterStats do
      begin
        FirstTime:=true;
        XExtent:=GetDeviceCaps(PrinterDC,HorzRes);
        XRes:=   GetDeviceCaps(PrinterDC,LogPixelsX);
        YExtent:=GetDeviceCaps(PrinterDC,VertRes);
        YRes:=   GetDeviceCaps(PrinterDC,LogPixelsY);
        Width:=MulDiv(XExtent,720,XRes);
        Height:=MulDiv(YExtent,720,YRes);
        XPos:=0; YPos:=0;
        LeftMar:=MulDiv(LeftMargin,7200,254);
        RightMar:=MulDiv(RightMargin,7200,254);
        TopMar:=MulDiv(TopMargin,7200,254);
        BottomMar:=MulDiv(BottomMargin,7200,254);
        SetWindowExt(PrinterDC,Width,Height);
        SetViewportExt(PrinterDC,XExtent,YExtent);
      end;

      StartPage(PrinterDC);

      if PrintCurrent then
      begin
        DisplayArea^.PaintIt(PrinterDC,@PrinterStats);
      end else
      begin
        WaitingMessage('Printing...');
        ENum:=Entry^.EntryNum; EReal:=Entry^.RealNum; EBeg:=Entry^.beginning;
        ok:=true;
        NPrinted:=0;
        if ENum<>PrintFirst then
        begin
          UseTheIndex:=false;
          ok:=true;
          if MakeUseOfIndex(Pattern) then
          begin
            UseTheIndex:=true;
            if PrintFirst>NumberOfEntries then ok:=false
            else FindSortRec(Srec,PrintFirst,UseTheIndex);
          end;
          if UseTheIndex then
          begin
            if ok then
            begin
              ReachEntry(Entry,PrintFirst,PrintFirst,Srec.place,false);
            end;
          end else
          begin
            if PrintFirst<Entry^.entrynum then ResetBib(Entry);
            GetEntry(Entry,Nil,PrintFirst,true,Pattern,ok);
          end;
          if Entry^.EntryNum<>PrintFirst then ok:=false;
        end;
        CurNum:=Entry^.EntryNum;
        AbortFlag:=false;
        while ok and (Entry^.EntryNum<=PrintLast) and (Entry^.EntryNum=CurNum)
          and not AbortFlag do
        begin
          if (not UseTagged) or IsTagged(Entry^.RealNum,Tags) then
          begin
            DisplayArea^.PaintIt(PrinterDC,@PrinterStats);
            inc(NPrinted);
            WaitingMessage('Printed '+num2str(NPrinted)+'...');
          end;
          GetEntry(Entry,Nil,Entry^.EntryNum+1,true,Pattern,ok);
          inc(CurNum);
          TrapAbort;
        end;
        ReachEntry(Entry,EReal,ENum,EBeg,false);
        WaitingOff;
      end;
      if AbortFlag then AbortDoc(PrinterDC)
      else begin
        EndPage(PrinterDC);
        EndDoc(PrinterDC);
      end;
      for i:=PrintLabelFont to PrintNormalFont+16 do
      if Fonts^[i].Initialized then
      begin
        DeleteObject(Fonts^[i].Font);
        Fonts^[i].Initialized:=false;
      end;
      Update;
    end;
    DeleteDC(PrinterDC);
  end;
  FreeProcInstance(PHook); FreeProcInstance(SHook);
  AbortFlag:=false;
  if PrintToFile<>OldPrintToFile then
    OptionsModified.WindowsParams:=true;
end;                         { TBrowseWindow.PrintFile }

type
  PPageSetupDlg = ^TPageSetupDlg;
  TPageSetupDlg = object(TBasicDialog)
    constructor init(AParent: PWindowsObject);
    procedure SetupWindow; virtual;
    procedure ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

constructor TPageSetupDlg.init(AParent: PWindowsObject);
begin
  TBasicDialog.init(AParent,PChar(rc_PageSetupDlg));
  HelpContext:=hc_Printing;
end;

procedure TPageSetupDlg.SetupWindow;
begin
  TBasicDialog.SetupWindow;
  InitPos;
  SetDlgItemInt(HWindow,dl_PrintSetupLeftMargin,  LeftMargin,  true);
  SetDlgItemInt(HWindow,dl_PrintSetupRightMargin, RightMargin, true);
  SetDlgItemInt(HWindow,dl_PrintSetupTopMargin,   TopMargin,   true);
  SetDlgItemInt(HWindow,dl_PrintSetupBottomMargin,BottomMargin,true);
  SetDlgItemInt(HWindow,dl_PrintSetupSeparation,  Word(EntrySeparation),true);
  if PrintPageHeader then
          CheckDlgButton(HWindow,dl_PrintPageHeader,bf_Checked);
  if PrintEntryHeader then
          CheckDlgButton(HWindow,dl_PrintSetupDoHeader,bf_Checked);
end;                { TPageSetupDlg.SetupWindow }

procedure TPageSetupDlg.ok(var Msg: TMessage);
begin
  if not CanClose then Exit;
  LeftMargin  :=GetDlgItemInt(HWindow,dl_PrintSetupLeftMargin,   Nil,true);
  RightMargin :=GetDlgItemInt(HWindow,dl_PrintSetupRightMargin,  Nil,true);
  TopMargin   :=GetDlgItemInt(HWindow,dl_PrintSetupTopMargin,    Nil,true);
  BottomMargin:=GetDlgItemInt(HWindow,dl_PrintSetupBottomMargin, Nil,true);
  EntrySeparation:=integer(GetDlgItemInt(HWindow,dl_PrintSetupSeparation,Nil,true));
  if EntrySeparation<0 then EntrySeparation:=-1;
  PrintEntryHeader:=IsDlgButtonChecked(HWindow,dl_PrintSetupDoHeader)=bf_Checked;
  PrintPageHeader:=IsDlgButtonChecked(HWindow,dl_PrintPageHeader)=bf_Checked;
  OptionsModified.WindowsParams:=true;
  EndDlg(id_ok);
end;                { TPageSetupDlg.ok }

procedure TBrowseWindow.PageSetup(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PPageSetupDlg,init(@Self)));
end;

procedure TBrowseWindow.PrintSetup(var Msg: TMessage);
var
  TPD: TPrintDlg;
  SHook: TFarProc;
  i: integer;
begin
  FillChar(TPD,sizeof(TPD),0);
  SHook:=MakeProcInstance(TFarProc(@PrintSetupHook),HInstance);
  with TPD do
  begin
    lstructSize:=sizeof(TPD);
    HWndOwner  :=HWindow;
    hDevMode   :=HPDevMode;
    hDevNames  :=HPDevNames;
    flags      :={pd_EnableSetupTemplate or
                 pd_EnableSetupHook     or}
                 pd_PrintSetup;
    lpSetupTemplateName:=PChar(rc_PrintSetupDlg);
    lpfnSetupHook:=PrintHookProc(SHook);
  end;
  TPD.hInstance:=hInstance;

  if PrintDlg(TPD) then
  begin
    HPDevMode:=TPD.hDevMode;
    HPDevNames:=TPD.hDevNames;
  end else
  begin
    i:=CommDlgExtendedError;
    if (i=PDERR_PRINTERNOTFOUND) then
    begin
      if TPD.hDevNames=0 then
      begin
        ErrorMessageRC(Str_DefPrinterNotFound,'');
      end else if YesNoRC(Str_PrinterNotFound,'') then
      begin
        OptionsModified.WindowsParams:=true;
        GlobalFree(HPDevNames); HPDevNames:=0; TPD.hDevNames:=HPDevNames;
        if not PrintDlg(TPD) then
        begin
          i:=CommDlgExtendedError;
          if (i=PDERR_PRINTERNOTFOUND) then
            ErrorMessageRC(Str_DefPrinterNotFound,'')
          else if i<>0 then ErrorMessageRC(Str_PrintDlgError,num2str(i));
        end;
      end;
    end;
  end;
  FreeProcInstance(SHook);
end;                      { TBrowseWindow.PrintSetup }
