{$N-,V-,W-,G+}

Unit wbibupdt;

Interface

Uses
  Wobjects, WinTypes, WinProcs, strings, bibvars, rc_id, wbibdisp, bibstrg,
  wbibgui, bibutil, bibstrm, bibfile, bibcache, lfnunit;

const
  MaxFnameLen=50;

type
  MenuItemRec = record
    name: PChar;
    id: integer;
  end;  

var
  AddPopup: HMenu;
  AddSortItem: MenuItemRec;


procedure ChangeMenuState(H: HMenu; id: integer; Status: boolean);
procedure CheckMenu(H: HMenu; id: integer; on: boolean);
function  SearchForMenuInt(M: HMenu; S: string): integer;
function  SearchForMenuItem(M: HMenu; S: string): HMenu;
procedure CheckMainMenu(W: PWindow);
procedure UpdateFileList(W: PWindow);
procedure GrayMainMenu(W: PWindow);
procedure SelectBrowseMenu(W: PWindow);
procedure SetBrowseWindowCaption(H: HWnd);

Implementation

procedure ChangeMenuState(H: HMenu; id: integer; Status: boolean);
var
  flag: integer;
begin
  if Status then flag:=mf_Enabled else flag:=mf_Grayed;
  if id>0 then flag:=flag or mf_ByCommand
  else begin
    flag:=flag or mf_ByPosition; id:=-id;
  end;
  EnableMenuItem(H,id,flag);
end;

procedure CheckMenu(H: HMenu; id: integer; on: boolean);
var
  flag: integer;
begin
  if H=0 then Exit;
  if on then flag:=mf_Checked else flag:=mf_Unchecked;
  if id>0 then flag:=flag or mf_ByCommand
  else begin
    flag:=flag or mf_ByPosition; id:=-id;
  end;
  CheckMenuItem(H,id,flag);
end;

function SearchForMenuInt(M: HMenu; S: String): integer;
var
  Buf: array[0..31] of char;
  Nelems,i,MenuFlags: Word;
  l: integer;
  Foundit: boolean;
  Sbuf: string[31];
begin
  Foundit:=false;
  SearchForMenuInt:=-1;
  if M=0 then Exit;
  Nelems:=GetMenuItemCount(M);
  i:=0; l:=0; StrLwr(S);
  while (i<=Nelems) and (l>=0) and (not FoundIt) do
  begin
    l:=0; Buf[0]:=#0;
    if GetMenuItemID(M,i)=Word(-1) then   { its a popup }
    begin
      l:=GetMenuString(M,i,Buf,31,mf_ByPosition);
      if l>0 then
      begin
        Sbuf:=StrPas(Buf); ChrDel(Sbuf,'&'); StrLwr(Sbuf);
        if S=Sbuf then
        begin
          SearchForMenuInt:=i;
          Foundit:=true;
        end;
      end;
    end;
    inc(i);
  end; 
end;                               { SearchForMenuItem }

function SearchForMenuItem(M: HMenu; S: string): HMenu;
var
  Ind: integer;
begin
  SearchForMenuItem:=0; Ind:=-1;
  Ind:=SearchForMenuInt(M,S);
  if Ind>-1 then SearchForMenuItem:=GetSubMenu(M,Ind);
end;

procedure CheckMainMenu(W: PWindow);
var
  H: HMenu;
  i,j: integer;
  btmp,Other: boolean;
begin
  for i:=1 to MaxBibFiles do
  begin
    if Linked then
    begin
      j:=1;
      while (j<=BibRingNum) and (BibRing[j]<>i) do inc(j);
      CheckMenu(W^.Attr.Menu,mi_BrFile1+i-1,j<=BibRingNum);
    end else
      CheckMenu(W^.Attr.Menu,mi_BrFile1+i-1,(CurrentBibFile=i) and (bibname^<>''));
  end;

  CheckMenu(W^.Attr.Menu, mi_BrMiscLinked,     Linked);
  CheckMenu(W^.Attr.Menu, mi_BrMiscReadOnly,   BibReadOnly or Linked);
  CheckMenu(W^.Attr.Menu, mi_BrMiscStrings,    EditOnlyStrings);
  CheckMenu(W^.Attr.Menu, mi_BrMiscView,       not FirstShowBuf);
  CheckMenu(W^.Attr.Menu, mi_BrMiscTagNew,     TagNewEntries);
  CheckMenu(W^.Attr.Menu, mi_BrMiscSaveOnExit, SaveOptsOnExit);
  CheckMenu(W^.Attr.Menu, mi_BrPatternOn,      Pattern^.on);
  CheckMenu(W^.Attr.Menu, mi_BrMiscSaveOnExit, SaveOptsOnExit);
  CheckMenu(W^.Attr.Menu, mi_BrMiscSaveWOnExit,SaveWinOptsOnExit);
end;                              { CheckMainMenu }

procedure UpdateFileList(W: PWindow);
var
  i: integer;
  F: array[0..255] of char;
begin
  for i:=1 to MaxBibFiles do
  begin
    StrPCopy(F,
      '&'+num2str(i)+': '+TruncateFilename(bibfiles^[i].name,MaxFnameLen));
    ModifyMenu(W^.Attr.Menu,mi_BrFileChange1+i-1,mf_ByCommand,mi_BrFileChange1+i-1,F);
    StrPCopy(F,
        '&'+num2str(i)+': '+TruncateFilename(bibfiles^[i].name,MaxFNameLen)
           +#9'Alt+'+num2str(i));
    ModifyMenu(W^.Attr.Menu,mi_BrFile1+i-1,mf_ByCommand,mi_BrFile1+i-1,F);
  end;
end;                      { UpdateFileList }

procedure GrayMainMenu(W: PWindow);
var
  H: HMenu;
  i,j,MenuPos: integer;
  IsEntry,CanEdit,canCopy,CanPaste,CanAdd,CanChange,FileIsSorted: boolean;
  CanDump,PattTag,NoFile: boolean;
  tmp: string[64];
  F: array[0..64] of char;
begin
  NoFile:=(CurrentBibFile=0) or (bibname^='');
  if EditOnlyStrings then
    FileIsSorted:=(CurrentSortMode^.StringNameSort<>StrSortOff)
  else FileIsSorted:=CurrentSortMode^.SortingOn;
  IsEntry:=(not NoFile) and BibFileExists and (entry^.EntryNum>0);
  CanEdit:=(not NoFile) and IsEntry and not (Linked or BibReadOnly or (TempDirList^=''));
  CanCopy:=(not NoFile) and IsEntry;
  CanAdd:=not (Linked or BibReadOnly or NoFile);
  CanChange:=(not NoFile) and BibFileExists and CanAdd;
  CanPaste:=not (NoFile or Linked or BibReadOnly or ClipboardEmpty or (TempDirList^='') or
                            (ClipboardString and not EditOnlyStrings) or
                            (EditOnlyStrings and not ClipboardString));
  CanDump:=(not NoFile) and (DumpName^<>'');

  { Files menu }
  ChangeMenuState(W^.Attr.Menu,mi_BrFileOpen,     not Linked);
  ChangeMenuState(W^.Attr.Menu,mi_BrFileClose,    not NoFile);
  ChangeMenuState(W^.Attr.Menu,mi_BrFileCount,    BibFileExists and not NoFile);
  ChangeMenuState(W^.Attr.Menu,mi_BrFileDupsCurrent,BibFileExists and not NoFile
                  and not Linked);
  ChangeMenuState(W^.Attr.Menu,mi_BrFileDupsAll,  BibFileExists and not NoFile);
  ChangeMenuState(W^.Attr.Menu,mi_BrFileSort,     CanChange);
  ChangeMenuState(W^.Attr.Menu,mi_BrFileReformat, CanChange);
  ChangeMenuState(W^.Attr.Menu,mi_BrFileIndex,    CanChange);
  ChangeMenuState(W^.Attr.Menu,mi_BrFileTranslate,CanChange);
  ChangeMenuState(W^.Attr.Menu,mi_BrFilePrint,    BibFileExists and not NoFile);

  H:=SearchForMenuItem(W^.Attr.menu,'File');
  i:=SearchForMenuInt(H,'Change');
  if i>-1 then ChangeMenuState(H,-i,not Linked);
  for i:=0 to MaxBibFiles-1 do
    ChangeMenuState(W^.Attr.Menu,mi_BrFile1+i,not Linked);

  i:=SearchForMenuInt(H,'Modify');
  if i>-1 then ChangeMenuState(H,-i,CanChange);

  { Edit menu }

  PattTag:=ContainsTags(Pattern);
  if NoFile then   { no file }
    EnableMenuItem(W^.Attr.Menu,1,mf_ByPosition or mf_Grayed)
  else begin
    EnableMenuItem(W^.Attr.Menu,1,mf_ByPosition or mf_Enabled);

    ChangeMenuState(W^.Attr.Menu,mi_BrEditCopyField,IsEntry);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditBookmark, IsEntry);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditTag,      IsEntry);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditTagAll,   IsEntry and not PattTag);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditTagTeX,   IsEntry and not PattTag);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditUntagAll, IsEntry and not PattTag);

    ChangeMenuState(W^.Attr.Menu,mi_BrEditEdit,     CanEdit);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditStrings,  CanEdit or
                                 not (BibFileExists or NoFile));
    ChangeMenuState(W^.Attr.Menu,mi_BrEditDelAll,   CanEdit);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditDelTagged,CanEdit);

    ChangeMenuState(W^.Attr.Menu,mi_BrEditHeaderString,not EditOnlyStrings);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditCut,    CanEdit and CanCopy);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditCopy,   CanCopy);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditPaste,  CanPaste);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditReplace,CanCopy and CanPaste);
    ChangeMenuState(W^.Attr.Menu,mi_BrEditClear,  CanEdit);

    MenuPos:=-1;
    H:=SearchForMenuItem(W^.Attr.Menu,'edit');
    for i:=0 to GetMenuItemCount(H)-1 do
    begin
      GetMenuString(H,i,F,64,mf_ByPosition);
      tmp:=StrPas(F); ChrDel(tmp,'&'); StrLwr(tmp);
      if tmp='copy name' then MenuPos:=i;
    end;
    ChangeMenuState(H,-MenuPos,IsEntry);
  end;

  { Goto menu }
  if NoFile then   { no file }
    EnableMenuItem(W^.Attr.Menu,2,mf_ByPosition or mf_Grayed)
  else begin
    EnableMenuItem(W^.Attr.Menu,2,mf_ByPosition or mf_Enabled);
    H:=SearchForMenuItem(W^.Attr.menu,'Goto');
    for i:=0 to GetMenuItemCount(H)-1 do ChangeMenuState(H,-i,BibFileExists);
    if BibFileExists then
    begin
      ChangeMenuState(W^.Attr.menu,mi_BrGotoBack,WrapEOF2BOF or (Entry^.entrynum>1));
      ChangeMenuState(W^.Attr.menu,mi_BrGotoFirst,     Entry^.entrynum>1     );
      ChangeMenuState(W^.Attr.menu,mi_BrGotoLast, not (
         EntryCache^.UseCache(Pattern) and (EntryCache^.Last>-1) and
                                         (Entry^.EntryNum=EntryCache^.Last)));
      ChangeMenuState(W^.Attr.menu,mi_BrGotoBookmark,  Bookmark^<>''         );
      ChangeMenuState(W^.Attr.menu,mi_BrGotoLabelNext, LabelSearchString^<>'');
      ChangeMenuState(W^.Attr.menu,mi_BrGotoSearchNext,
                                     UseSearchFields or (SearchString^<>''));
    end;
  end;

  { Add menu }
  if NoFile then   { no file }
    EnableMenuItem(W^.Attr.Menu,3,mf_ByPosition or mf_Grayed)
  else begin
    EnableMenuItem(W^.Attr.Menu,3,mf_ByPosition or mf_Enabled);
    ChangeMenuState(W^.Attr.menu,mi_BrAddSorted,      CanAdd);
    ChangeMenuState(W^.Attr.menu,mi_BrAddEOF,         CanAdd);
    ChangeMenuState(W^.Attr.menu,mi_BrAddCurrent,     CanAdd);
    ChangeMenuState(W^.Attr.menu,mi_BrAddAfterCurrent,CanAdd);
    ChangeMenuState(W^.Attr.menu,mi_BrAddNumber,      CanAdd);
    ChangeMenuState(W^.Attr.menu,mi_BrAddBeforeEntry, CanAdd);
    ChangeMenuState(W^.Attr.menu,mi_BrAddFirst,       CanAdd);
  end;

  { Import }
  ChangeMenuState(W^.Attr.Menu,mi_BrImport,(not NoFile) and CanAdd);

  { Export }
  ChangeMenuState(W^.Attr.Menu,mi_BrExp,not NoFile);

  { Pattern menu }
  ChangeMenuState(W^.Attr.Menu,mi_BrPatternOn,   ActivePattern(Pattern));

  { Options menu }
  ChangeMenuState(W^.Attr.Menu,mi_BrMiscSaveCache,
    (not AutoSaveCache) and
    (Pattern<>Nil) and (Pattern^.noper>0) and (Pattern^.on) and
    EntryCache^.on and ((EntryCache^.CurrentCol>0) or (EntryCache^.Last>-1))  );
  ChangeMenuState(W^.Attr.Menu,mi_BrMiscClearCache,CacheDir^<>'');
  ChangeMenuState(W^.Attr.Menu,mi_BrMiscView,IsEntry);
  ChangeMenuState(W^.Attr.Menu,mi_BrMiscSortCurrent,not (Linked or BibReadOnly));
  ChangeMenuState(W^.Attr.Menu,mi_BrMiscReadOnly,BibFileExists and not Linked);
end;                        { GrayMainMenu }

procedure SelectBrowseMenu(W: PWindow);
var
  UseSortedMenu,SortedExpFile,NameOnly: boolean;
  i: integer;
begin
  { Select proper Sorted/Unsorted menu to use }

  if EditOnlyStrings then
    UseSortedMenu:=(CurrentSortMode^.StringNameSort<>StrSortOff)
  else UseSortedMenu:=CurrentSortMode^.SortingOn;

  NameOnly:=true; SortedExpFile:=false;
  for i:=1 to maxfield do if DumpFields[i] then NameOnly:=false;
  if DumpUndecFields then NameOnly:=false;
  if (ExportSortMode^.SortingOn)
       and not (NameOnly or (ExportFormat<>BibTeXFormat))  then
         SortedExpFile:=true;
  if ExportFormat<>BibTeXFormat then SortedExpFile:=true;   { Correction }

  if UseSortedMenu and not UsingSortedMenu then
  begin
    AddPopup:=GetSubMenu(W^.Attr.Menu,3);
    RemoveMenu(W^.Attr.menu,3,mf_ByPosition);
    with AddSortItem do
      InsertMenu(W^.Attr.Menu,3,mf_ByPosition or mf_String,id,Name);
  end else if UsingSortedMenu and not UseSortedMenu then
  begin
    RemoveMenu(W^.Attr.Menu,3,mf_ByPosition);
    InsertMenu(W^.Attr.Menu,3,mf_ByPosition or mf_Popup or mf_String,
               AddPopup,AddSortItem.name);
  end;

  UsingSortedMenu:=UseSortedMenu;
  DrawMenuBar(W^.HWindow);
end;                          { SelectBrowseMenu }

procedure SetBrowseWindowCaption(H: HWnd);
var
  S,N,E: Pstring;
begin
  { Set proper window caption }
  if not IsWindow(H) then Exit;
  AllocStrings(true,@S,@N,@E,Nil);
  S^:='for Windows';
  if (CurrentBibFile>0) and (BibName^<>'') then
  begin
    if IsIconic(H) then
    begin
      LFNFSplit(BibFiles^[CurrentBibFile].name,Nil,N,E);
      S^:=N^+E^;
    end else 
      S^:='['+TruncateFilename(bibname^,MaxFNameLen)+'] ('+num2str(CurrentBibFile)+')';
    S^:='- '+S^;
  end;
  S^:='BibDB '+S^;
  GetWindowText(H,PChar(N),255);
  if S^<>StrPas(PChar(N)) then SetWindowText(H,PString2PChar(S));
  AllocStrings(false,@S,@N,@E,Nil);
end;                            { SetBrowseWindowCaption }


end.
