#ifndef __DVICHK_H
#  define __DVICHK_H
/*
*  dvichk.h:  Program specific macros, typedefs, prototypes...
*
*
*  Copyright (c) 2000 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for ANY damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*
*    Free Software Foundation, Inc.
*    59 Temple Place - Suite 330
*    Boston, MA 02111-1307,  USA
*/



/*
*  $Id: dvichk.h 0.04 2000/06/06 00:00:04 tom Exp $
*/



/*
*  Common statements.
*/
/* Character which indicates to quit program when using the GETKEY() macro. */
#  define  QUITCHAR                 "q"
#  define  SCREEN_ROWS              24

#  define  COLUMNS_DFLT             4
#  define  COLUMNS_MIN              0
#  define  COLUMNS_MAX              9
#  define  COLUMN_WIDTH             8

#  define  FONTS_MAX                128

#  define  PAGES_MAX                MAXLEN_MAX

#  define  LINESIZE                 MAXLEN_MAX

#  define  BLOCKSIZE                16384

#  define  DVI_FN_EXTENSION         ".dvi"
#  define  DVI_SUBNUMBER_DELIMITER  "."
#  define  DVI_MAGIC1               247
#  define  DVI_MAGIC2               2
#  define  DVI_MAGIC3               3
#  define  DVI_MAGIC4               4
#  define  DVI_COMMENT_OFFSET       14
#  define  DVI_PAGENUMBER_BYTES     4
#  define  DVI_PAGENUMBER_MAX       10
#  define  DVI_BOP                  139
#  define  DVI_EOP                  140
#  define  DVI_POST                 248
#  define  DVI_POST_POST            249
#  define  DVI_FNT_DEF1             243
#  define  DVI_FNT_DEF2             244
#  define  DVI_FNT_DEF3             245
#  define  DVI_FNT_DEF4             246
#  define  DVI_NOP                  138
#  define  DVI_FILLER               223

#  define  LOG_FN_EXTENSION         ".log"
#  define  LOG_BOP                  '['
#  define  LOG_EOP                  ']'



typedef
  enum checkmode_type
   {
     check_dvi=1,
     check_log
   }
  Checkmode_enum;


typedef
  struct the_options_type
   {
     int              columns;
     Bool             no_info;
     Bool             font_info;
     Bool             total_only;
     Bool             pager;
   }
  The_options_struct;



/*
*  GLOBAL functions prototypes.
*/
__BEGIN_DECLARATIONS
/*
************************************************** Defined in `dvichk.c'.
*/
EXPORT int
run_dvichk __P_((int   argc,
                 char *argv[]));
__END_DECLARATIONS
#endif /* __DVICHK_H */
