/*	         L I B R A R Y   F O R   P C 3			*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*									   */
/* Standard functions and procedures available in Pascal, translated to C  */
/*									   */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


# define ARCTAN(X)      atan((double)(X))

# define COS(X)         cos((double)(X))

# define SIN(X)         sin((double)(X))

# define EXP(X)         exp((double)(X))

# define LN(X)          log((double)(X))

# define SQRT(X)        sqrt((double)(X))

# define SQR(X)         _sqr((long)(X))

# define RSQR(X)        _rsqr(X)

# define DSQR(X)        _dsqr(X)

# define ABS(X)         _abs(X)

# define LABS(X)        _labs(X)

# define RABS(X)        _rabs(X)

# define DABS(X)        _dabs(X)

# define ROUND(X)       _round((double)(X))

# define ODD(X)         ((X)%2)

# define SUCC(X)        ((X)+1)

# define PRED(X)        ((X)-1)

# define TRUNC(X)       ((long)(X))

# define ORD(X)         ((long)(X))

# define CHR(X)         ((char)(X))

# define PACK(X,Y,Z)    /* empty */

# define UNPACK(X,Y,Z)  /* empty */

# define NEW(X,T,S)     X = (T)malloc(sizeof(S))

# define DISPOSE(X)     free(X)

# define TRUE           1

# define FALSE          0

# define MAXINT         32767

# define BOOLEAN        char


extern long _round();
extern int _abs();
extern long _labs();
extern float _rabs();
extern double _dabs();
extern long _sqr();
extern float _rsqr();
extern double _dsqr();

extern double sqrt();
extern double sin();
extern double cos();
extern double atan();
extern double exp();
extern double log();

char *malloc();


/* * * * * * * * * * * * * * * * * * * * * * * */
/*					       */
/* Input and output in Pascal, translated to C */
/*					       */
/* * * * * * * * * * * * * * * * * * * * * * * */

extern struct {
	        FILE *fp;
                BOOLEAN eof,eoln,validbuffer;
                char buffer;
              }
                INPUT, OUTPUT, STDERR;

# define PAGE(F)        fprintf(F.fp,"%c",26)

# define RESET_1(F,N)   F.fp = fopen(N,"r");                                  \
                        F.eoln = F.eof = F.validbuffer = FALSE

# define RESET_2(F,N)   F.fp = fopen(N,"r");                                  \
                        if (read(F.fp->_file,F.buffer,sizeof(F.buffer)) <     \
                            sizeof(F.buffer))                                 \
                          F.eof = TRUE;                                       \
                        else                                                  \
                          F.eof = FALSE;

# define RESET_3(F,N)   F.fp = fopen(N,"r");                                  \
                        if (read(F.fp->_file,&F.buffer,sizeof(F.buffer)) <    \
                            sizeof(F.buffer))                                 \
                          F.eof = TRUE;                                       \
                        else                                                  \
                          F.eof = FALSE

# define REWRIT_2(F,N)  F.fp = fopen(N,"w"); F.eof = TRUE

# define REWRIT_1(F,N)  F.fp = fopen(N,"w"); F.eoln = F.eof = F.validbuffer = TRUE

# define CLOSE_2(F)     fclose(F.fp); F.eof = FALSE

# define CLOSE_1(F)     fclose(F.fp); F.eof = FALSE; F.validbuffer = TRUE

# define EOF_(F)        F.eof

# define PUT_1(F)       write(F.fp->_file,F.buffer,sizeof(F.buffer))

# define PUT_2(F)       write(F.fp->_file,&F.buffer,sizeof(F.buffer))

# define GET_1(F)       if (read(F.fp->_file,F.buffer,sizeof(F.buffer)) <   \
                            sizeof(F.buffer))                               \
                          F.eof=TRUE

# define GET_2(F)       if (read(F.fp->_file,&F.buffer,sizeof(F.buffer)) <  \
                            sizeof(F.buffer))                               \
                          F.eof=TRUE

# define WRITE_1(F,A)   F.buffer = A;                                       \
                        write(F.fp->_file,&F.buffer,sizeof(F.buffer))

# define WRITE_2(F,A)   _copy(F.buffer,A,sizeof(F.buffer));                 \
                        write(F.fp->_file,F.buffer,sizeof(F.buffer))

# define WRITE_3(F,A)   _copy(&F.buffer,&A,sizeof(F.buffer));               \
                        write(F.fp->_file,&F.buffer,sizeof(F.buffer))

# define READ_1(F,A)    A = F.buffer;                                       \
                        if (read(F.fp->_file,&F.buffer,sizeof(F.buffer)) <  \
                            sizeof(F.buffer))                               \
                          F.eof=TRUE
                        
# define READ_2(F,A)    _copy(A,F.buffer,sizeof(F.buffer));                 \
                        if (read(F.fp->_file,F.buffer,sizeof(F.buffer)) <   \
                            sizeof(F.buffer))                               \
                          F.eof=TRUE

# define READ_3(F,A)    _copy(&A,&F.buffer,sizeof(F.buffer));               \
                        if (read(F.fp->_file,&F.buffer,sizeof(F.buffer)) <  \
                            sizeof(F.buffer))                               \
                          F.eof=TRUE


# define INTEGER        1
# define CHAR           2
# define REAL           3
# define STRING         4
# define LONGINT        5
# define DOUBLE         6

extern char *_con_str();
extern char *_printbool();
extern _writearchar();

extern char _format[30];

extern BOOLEAN _eoln();
extern BOOLEAN _eof();
extern _read();
extern _readln();
extern _get();
extern char _textbuffer();
extern _readarchar();
extern _readstring();


/* * * * * * * * * */
/*		   */
/* Set-operations  */
/*		   */
/* * * * * * * * * */

# define SETSIZE (256/(sizeof(int)*8))

extern int *_intersect();
extern int *_sum();
extern int *_diff();
extern int *_setcpy();
extern int *_insert();
extern int *_add();
extern _set_ass();
extern _in();
extern _eq();
extern _ne();
extern _le();
extern _lt();
extern _ge();
extern _gt();
extern int *_emptyset();
extern int *_entersubrange();
extern int *_addsubrange();
extern int *_complement();


/* * * * * * * * */
/*	         */
/* Pc3 routines  */
/*	         */
/* * * * * * * * */

extern _copy();
extern char *_tostring();

extern _moveleft();
extern _moveright();

# define POINTER(X)	(&(X))


/* * * * * * * * * * */
/*		     */
/* String-operations */
/*		     */
/* * * * * * * * * * */

extern _sinsert();
extern _delete();
extern _string_ass();
extern int _length();
extern char *_concat();
extern char *_scopy();
extern int _pos();
extern int _scanne();
extern int _scaneq();
