/* REXX */

/*
  File makeplaintex.cmd -- Creating a plain TeX format file using `huge TeX'
  
  This is part of emTeX/TDS v0.55
  
  Copyright (C) Walter Schmidt 1998--2001
  
*/

call setlocal

emtexdir = value("EMTEXDIR", , "OS2ENVIRONMENT")
workdir = strip(strip(emtexdir, "T", ";")) || "\HTEXFMTS"
call directory(workdir)

ret=value("TEXINPUT", "\texmf\tex\generic!!;\texmf\tex\plain!!;", "OS2ENVIRONMENT")

signal on error name initexfailure
"@htex386 -i -mt65500 plain \input plain.cfg; \dump"
if stream("plain.fmt", C, "QUERY EXISTS") = "" then signal initexfailure
exit

initexfailure:
say "*** IniTeX failed."

