#!/usr/local/bin/tclsh
if {[catch "kanji defaultInputCode EUC" errormsg]}\
   {puts "Running $argv0 without Japanese support."
    puts "For Japanese support, you need to use a Japanized"
    puts "Tcl interpreter.\n"}\
   {}
# This script parses a database in the format used by
# the Insidious Big Brother Database for Emacs.  It can
# be adapted to output LaTeX lists of contents and so forth.
set format [lindex $argv 0]
set range [lindex $argv 1]
set condition [lindex $argv 2]
set usage "Usage is: $argv0 \<SIZE\> \[<RANGE>\] \[<CONDITION>\]\
\n(Square braces are literal)\
\n(\<SIZE\> is one of \"Mieko\" or \"Frank\")"
if {[string match $format "Mieko"]+\
    [string match $format "Frank"]==0}\
   {puts "$usage"; exit}\
   {}
if {[regexp {\[.*\]} $condition ignore]==0}\
   {puts "$usage"; exit}\
   {}
if {[regexp {\[.*\]} $range ignore]==0}\
   {puts "$usage"; exit}\
   {}
puts "Creating LaTeX2e file mkaddr.tex ..."
regexp {\[(.*)\]} $condition ignore condition
set condition "\\\[$condition\\\]"
set ifh [open "/home/bennett/.bbdb"]
set ofh [open "./mkaddr.tex" w+]
set counter 0
set temp ""
# Let's grab the content of a header file
set header [open "/etc/mkaddr.$format" r]
while 1 {
  if {[gets $header line] == -1} break
  if {[string match $line "%%BODY%%"]} break
  puts $ofh $line
}
while 1 {
  if {[gets $ifh line] == -1} break
  regsub -all {([ "])\\"} $line {\1``} line
  regsub -all {\\"([^A-Za-z])} $line {''\1} line
  regsub -all {\\n} $line { } line
  regsub -all {([^\])%} $line {\1\\%} line
  regsub -all {([^\])&} $line {\1\\\&} line
set fn nil
set ln nil
set aka nil
set co nil
set ph nil
set ad nil
set net nil
set op nil
  regexp {
*(nil|\"[^"]*\")\
+(nil|\"[^"]*\")\
+(nil|\(\".*\"\))\
+(nil|\"[^"]*\")\
+(nil|\(\[.*\]\))\
+(nil|\(\[.*\]\))\
+(nil|\(\".*\"\))\
+(nil|\(\(.*\)\)|\"[^"]*\")\
+nil} $line ignore fn ln aka co ph ad net op
#
# Make lone first names into lone last names
if {[string match $ln "nil"]}\
   {set ln $fn
    set fn nil}\
   {}
# Check that we're in the range specified
if {[regexp "\"$range" $ln ignore]}\
   {}\
   {if {[string match $ln nil]}\
       {if {[regexp "\"$range" $co ignore]}\
           {}\
           {continue}}\
       {continue}}
#
# Fish out the notes field so we can check whether this
# record matches the specified conditions
set tempone ""
set temptwo ""
regexp {\(notes \. \"([^"]*)\"|\"([^"]*)\"$} $op \
       ignore tempone temptwo
if {[string match $temptwo ""]} \
   {set notes $tempone} \
   {set notes $temptwo}
if {[string match "*$condition*" $notes]} {} {continue}
#
# Are all three names missing?  If so, skip it.
  if { [expr 3 == \
       [string match $fn "nil"]+\
       [string match $ln "nil"]+\
       [string match $co "nil"]] }\
         {}\
         {
# Each entry is put in a parbox to keep it on one page.
# The parbox opens with a vskip to make a little room
# at the top of the page and between entries.
puts $ofh "\\entry\{%"
# Are both the first and last name missing?  If so,
# we skip that line.
  set counter [expr $counter + 1]
  if { [expr 2 == \
       [string match $fn "nil"]+\
       [string match $ln "nil"]] }\
         {}\
         {regexp {\"(.*)\"} $fn ignore fn
          regexp {\"(.*)\"} $ln ignore ln
puts -nonewline "$fn $ln"
          set ln " \\textbf\{$ln\}"
          puts $ofh "$fn$ln\\\\"}
# Is the company name missing?  If so, we'll
# skip that line.
  if { [string match $co "nil"] }\
       {}\
       {regexp {\"(.*)\"} $co ignore co
        puts $ofh "\\textbf\{$co\}\\\\"
        puts -nonewline $co}
puts ""
# Spit out any telephone numbers for this entry.
if {[string match $ph nil]} {set ph ""} {}
regexp {\((\[.*\])\)} $ph ignore ph
while {[string match $ph ""] == 0} {
  set temp ""
  regexp {\[([^]]*)\](.*)} $ph ignore temp ph
  regexp {\"([^"]*)\" *\"([^"]*)\"} $temp ignore temp number
  puts -nonewline $ofh "  \{\\small $number ($temp)\}"
  if {[string match $ph ""] == 0}\
     {puts $ofh "\\\\"}\
     {if {[string match $ad nil]+[string match $net nil]==2}\
         {puts $ofh ""}\
         {puts $ofh "\\\\"}}
  }
# Spit out any addresses for this entry.
if {[string match $ad nil]} {set ad ""} {}
while {[string match $ad ""] == 0} {
  set temp ""
  set lineone ""
  set linetwo ""
  set linethree ""
  set city ""
  set state ""
  set zip ""
  set bridge ""
  regexp {\(\[([^]]*)\](.*)\)} $ad ignore ad temp
  regexp {\"([^"]*)\"\
+\"([^"]*)\"\
+\"([^"]*)\"\
+\"([^"]*)\"\
+\"([^"]*)\"\
+\"([^"]*)\"\
+([0-9]*)} $ad ignore ad lineone linetwo linethree city state zip
if {$zip == 0} {set zip ""} {}
set comp [expr [string match $city ""]+[string match $state ""]]
if {$comp==2}\
   {}\
   {if {$comp==1}\
       {set bridge " "
        set zip " $zip"}\
       {if {$comp==0}\
           {set bridge ", "
            set zip " $zip"}\
           {}}}
  puts $ofh "  \\address\{$ad\}\{\%"
  if {[string match $lineone ""]}\
     {puts $ofh "\\mygobble"}\
     {puts $ofh "    $lineone"}
  if {[string match $linetwo ""]}\
     {}\
     {puts $ofh "    \\\\$linetwo"}
  if {[string match $linethree ""]}\
     {}\
     {puts $ofh "    \\\\$linethree"}
  if {[string match "$city$state$zip" ""]}\
     {}\
     {puts $ofh "    \\\\$city$bridge$state$zip"}
  puts $ofh "  \}"
  set ad $temp
  }
# Spit out any email addresses associated with this person
if {[string match $net nil]} {set net ""} {}
regexp {\((\".*\")\)} $net ignore net
while {[string match $net ""] == 0} {
  set temp ""
  regexp {\"([^"]*)\"(.*)} $net ignore net temp
  puts -nonewline $ofh "\\url\{$net\}"
  set net $temp
  if {[string match $net ""] == 0} {puts $ofh "\\\\"} {puts $ofh ""}
  }
puts $ofh "\}\n"
}
}
# Once everything's finished, we send along the footer
while 1 {
  if {[gets $header line] == -1} break
  puts $ofh $line
}
puts "Done."
exit
