{$IFDEF WINDOWS}
{$N-,V-,W-,G+}
{$ELSE}
{$E-,N-,V-}
{$ENDIF}

Unit wbibclip;

Interface

uses
  Wobjects, WinTypes, WinProcs, Strings, streams,
  wHugeMem,
  bibstrg, bibstrm, bibutil, rc_strng, bibvars, bibreadb, bibwritb, bibfile,
  bibreadt, bibreadd;

const
  ClipErr_none = 0; ClipErr_NotString = 1; ClipErr_NotEntry = 2;
  ClipErr_CantRead = 3;

function EntryToClipboard(Entry: EntryRecPtr): boolean;
function ClipboardToEntry(Entry: EntryRecPtr): boolean;
function WinClipToEntry(Entry: EntryRecPtr; ShouldBeString: boolean): integer;

implementation

var
  EntryClipboard: PHugeMemStream;
  OldExitProc: Pointer;

function EntryToClipboard(Entry: EntryRecPtr): boolean;
var
  RAM : PHugeMemStream;
  Null: PNulStream;
  ClipLen: longint;
  ch: char;
begin
  EntryToClipboard:=false;
  if (Entry=Nil) or (Entry^.Nentry=0) then Exit;

  { Measure length of record }
  New(Null,Init($FF));
  if not WriteBibEntry(Null,Entry,Nil,false) then
  begin
    Dispose(Null,Done); Exit;
  end;
  ClipLen:=Null^.GetSize; Dispose(Null,Done);

  { Copy to Windows clipboard }
  New(RAM,init(ClipLen+1));
  WriteBibEntry(RAM,Entry,Nil,false);
  ch:=#0; RAM^.write(ch,1);
  OpenClipboard(HMainW);
  EmptyClipboard;
  SetClipboardData(CF_TEXT,RAM^.Handle);
  CloseClipboard;
  RAM^.Owner:=false; Dispose(RAM,Done);

  { Copy to internal clipboard }
  if EntryClipboard=Nil then New(EntryClipboard,Init(100))
  else begin
    EntryClipboard^.seek(0); EntryClipboard^.Truncate;
  end;
  if StoreEntry(EntryClipboard,Entry) then
  begin
    ClipboardEmpty:=false;
    ClipboardName^:=Entry^.name;
    EntryToClipboard:=true;
  end else
  begin
    ClipboardEmpty:=true;
    ClipboardName^:='';
    EntryClipboard^.Reset; EntryClipboard^.seek(0); EntryClipboard^.Truncate;
  end;
  ClipboardString:=EditOnlyStrings;
end;                     { EntryToClipboard }

function ClipboardToEntry(Entry: EntryRecPtr): boolean;
begin
  ClipboardToEntry:=false;
  if (not ClipboardEmpty) and (ClipboardName^<>'')
    and (EditOnlyStrings=ClipboardString) then
  begin
    EntryClipboard^.Reset; EntryClipboard^.seek(0);
    LoadEntry(EntryClipboard,Entry);
    ClipboardToEntry:=true;
  end;
end;                  { ClipboardToEntry }

function WinClipToEntry(Entry: EntryRecPtr; ShouldBeString: boolean): integer;
var
  T: THandle;
  RAM: PHugeMemStream;
  Disaster: PHugeMemStream;
  Null: PNulStream;
  ok,IsString: boolean;
  ClipLen,OldVerb: longint;
  ch: char;
  OldReachedEOL,oldStartFile: boolean;
  OldLastRead: PString;
begin
  WinClipToEntry:=ClipErr_CantRead;
  if not IsClipboardFormatAvailable(cf_text) then Exit;

  { Disaster prevention }
  ClipLen:=0; Disaster:=Nil;
  if Entry^.nentry>0 then
  begin
    New(Null,Init($FF));
    if not WriteBibEntry(Null,Entry,Nil,false) then Dispose(Null,Done)
    else begin
      ClipLen:=Null^.GetSize; Dispose(Null,Done);
      New(Disaster,init(ClipLen+1));
      WriteBibEntry(Disaster,Entry,Nil,false);
      ch:=#0; Disaster^.write(ch,1);
    end;
  end;

  { Get clipboard data and set up the data stream }
  OpenClipboard(HMainW);
  T:=GetClipboardData(cf_text);
  New(RAM,InitExt(T,-1,false));

  { Read it in }
  ok:=true;
  RAM^.seek(0);

  { Store values }
  OldLastRead:=NewStr(LastReadLine^);
  OldReachedEOL:=ReachedEOL; OldStartFile:=AtStartOfFile;
  LastReadLine^:='';
  ReachedEOL:=false; AtStartOfFile:=true;

  OldVerb:=Verbosity; Verbosity:=1;
  GotoStart(RAM,Entry);
  GetEntry(Entry,RAM,1,true,Nil,ok);
  if not ok then
  begin
    GotoStart(RAM,Entry);
    GetTibEntry(Entry,RAM,1,ReferFormat,'',Nil,ok);
  end;
  if not ok then
  begin
    GotoStart(RAM,Entry);
    GetTibEntry(Entry,RAM,1,TibFormat,'',Nil,ok);
  end;
  if not ok then
  begin
    GotoStart(RAM,Entry);
    GetDBEntry(Entry,RAM,1,'',Nil,ok);
  end;

  Verbosity:=OldVerb;

  if ok then
  begin
    IsString:=(Entry^.EntryType=TypeEntry^[StringTypeInd]);
    if IsString<>ShouldBeString then
    begin
      if ShouldBeString then WinClipToEntry:=ClipErr_NotString
      else WinClipToEntry:=ClipErr_NotEntry;
      ok:=false
    end else WinClipToEntry:=ClipErr_none;
  end;
  if not ok then            { some kind of error }
  begin
    Entry^.nentry:=0;
    if Disaster<>Nil then
    begin
      GotoStart(Disaster,Entry);
      GetEntry(Entry,Disaster,1,true,Nil,ok);
      if not ok then Entry^.nentry:=0;
    end;
  end;

  { Tidy up }

  { restore values }
  ReachedEOL:=OldReachedEOL; AtStartOfFile:=OldStartFile;
  LastReadLine^:=''; if OldLastRead<>Nil then LastReadLine^:=OldLastRead^;
  DisposeStr(OldLastRead);

  Dispose(RAM,Done);
  if Disaster<>Nil then Dispose(Disaster,Done);
  CloseClipboard;
end;              { WinClipToEntry }

{$F+}
procedure CExitProc; far;
begin
  ExitProc:=OldExitProc;
  if EntryClipboard<>Nil then
  begin
    EntryClipboard^.Reset;
    Dispose(EntryClipboard,Done);
  end;
end;
{$F-}

begin
  OldExitProc   := ExitProc;
  ExitProc      := @CExitProc;
  EntryClipboard:= Nil;
end.


