# command  args optional
set style_dir $env(L2X)

set cmdlist {
  {@                 0 0 NoOp}
  {@writefile        2}
  {" "  0 0 space}
  {# 0 0 hash}
  {' 1 0 acute}
  {& 0 0 amp}
  {% 0 0 percent}
  {LARGE}
  {LaTeX}
  {Large}
  {\"   1 0 umlaut}
  {\$ 0 0 dollar}
  {\\ 0 1 backslash}
  {"\\["}
  {_}
  {`    1 0 grave}
  {aa}
  {abstract          1}
  {alpha}
  {appendix          0 0}
  {author            1}
  {begin             1 0 begin r}
  {beta}
  {bibitem           1}
  {bibstyle          1}
  {bibcite           2 0 bibcite e}
  {bibdata           1}
  {bibliography      1}
  {bibliographystyle 1}
  {bf} 
  {c 1}
  {caption           1 1}
  {cdot}
  {center            1}
  {centerline        0 0 1}
  {chapter           1 1}
  {chapter*          1}
  {citation          1}
  {cite              1 1}
  {cite*             1 1}
  {contentsline      3}
  {delta}
  {description}
  {documentclass     1 1}
  {documentstyle     1 1}
  {document}
  {dots}
  {em}
  {emph              1 0}
  {end               1}
  {enumerate}
  {figure            1 1}
  {flushleft         1}
  {flushright        1}
  {footnote          1}
  {footnotesize      0 0 "Property .SM .NL"}
  {gamma} 
  {hline}
  {hyphenation       1}
  {include           1}
  {input             1}
  {ignorespaces}
  {item              0 1}
  {itemize} 
  {it}
  {label             1}
  {large} 
  {ldots} 
  {lquote}
  {maketitle}
  {mbox              1 0 ReturnArg}
  {mu}
  {multicolumn       3 0}
  {newblock}
  {newcommand        2 1 newcommand e}
  {newlabel          2 0 newlabel   e}
  {newpage}
  {nocite            1}
  {normalsize} 
  {numberline}
  {pageref           1}
  {paragraph         1 1 "Section  4"}
  {paragraph*        1 0 "Section* 4"}
  {par}
  {parbox            2}
  {part              1 1}
  {part*             1}
  {protect           0}
  {ref               1}
  {relax}
  {rm}
  {rquote}
  {samepage}
  {sc}
  {section           1 1 "Section  1"}
  {section*          1 0 "Section* 1"}
  {sf}
  {sloppypar         1}
  {small             0 0 "Property .SM .NL"}
  {subsection        1 1 "Section  2"}
  {subsection*       1 0 "Section* 2"}
  {subsubsection     1 1 "Section  3"}
  {subsubsection*    1 0 "Section* 3"}
  {table             1 1}
  {tableofcontents}
  {tabular           2 1}
  {textwidth}
  {thanks            1}
  {thebibliography   2 1}
  {tiny}
  {title             1}
  {today} 
  {tt                0 0 "Property .R .R"}
  {usepackage        1 1}
  {verb              1}
  {verbatim}
  {vspace            1 0 NoOp}
  {vspace*           1 0 NoOp}
}

foreach e {footnote equation table figure} {
  set counter($e) 0
}

set counter(0) 0
set counter(1) 0
set counter(2) 0
set counter(3) 0
set counter(4) 0
set counter(5) 0
set toc 0
set counter(appendix) 0

foreach e $cmdlist {
  parser_init [lindex $e 0] [lindex $e 1] \
              [lindex $e 2] [lindex $e 3] [lindex $e 4]
}

# generic routines
#
# call environment with 'begin' or 'end'
proc begin {type opt cmd {arg ""}} {
  eval $cmd begin "{$opt}" $arg
}

proc end {type opt cmd} {
  eval $cmd end $opt
}

proc undefined {args} {
  global tex_file tex_line

  puts stderr "$tex_file:$tex_line: Undefined $args"
}

proc Property {on off args} {
  global prop g
  lappend prop($g) "\n$off\n"
  return "\n$on\n"
}

#
# Primitive conversion to eqn commands
#
proc mathematics {type equ} {
  global counter

  if {$type == "begin"} {
    parser_suspend $type "\\end
    return ""
  }

  incr counter(equation)

  regsub -all {\^} $equ " sup " equ
  regsub -all {_} $equ " sub " equ
  return ".EQ
  $equ
  .EN
  "
}

# just return argument
proc ReturnArg {type opt arg} {
  return $arg
}

proc NoOp {type args} {
  return ""
}


# generic sectioning
proc Section {level type opt arg} {
  global counter

  if {$opt == ""} {
    set opt $arg
  }
  incr counter($level)

  # reset counters at lower levels
  for {set i [expr $level + 1]} {$i <= 6} {incr i} {
    set counter($i) 0
  }

  # create label; handle appendix by changing numbers to letters
  set label ""
  for {set i 1} {$i <= $level} {incr i} {
    if {$counter($i) > 0} {
      if {$label != ""} {append label "."}
      if {$i == 1 && $counter(appendix)} {
        set label [string index "ABCDEFGHIJKLMNOPQRSTUVWXYZ" [expr $counter(1) - 1]]
      } else {
        append label $counter($i)
      }
    }
  }
  # append spaces
  set elabel $label
  for {set i [string length $label]} {$i < 10} {incr i} {
    append elabel " "
  }

  return "
.LP
.ti 0
$label ${arg}
.XS
$elabel ${opt}
.XE
.in 3
.LP
"
}

proc Section* {level type opt arg} {
  return ".SH $level\n${arg}\n.LP\n"
}

# specific routines
# commands are invoked with command type (command, begin, end)
#   and optional and fixed arguments
set authors ""
set title   ""
set llevel  0
set in_tabular 0

proc @writefile {type opt file what} {
  return ""
}

proc $ {} {
  parser_suspend math "$"
}

proc \[ {type opt} {
  parser_suspend displaymath "\\]"
}

proc abstract {type {opt ""}} {
  if {$type == "begin"} {
    return "\n.AB\n"
  } else {
    return "\n.AE\n.in 3\n"
  }
}

proc amp {type opt} {
  return "&"
}

# ampersand in tables: return itself
proc ampersand {} {
  return "&"
}

proc appendix {type opt} {
  global counter

  set counter(appendix) 1
  set counter(1) 0
  return ""
}
   
proc author {type opt arg} {
  global authors
  set authors $arg
  return ""
}

proc backslash {type opt} {
  global in_tabular
  if {$in_tabular} {return "\n"} {return "\n.br\n"}
}

proc bf {type opt} {
  global prop g
  lappend prop($g) "\n.R\n"
  return "\n.B\n"
}

proc bibcite {type opt arg1 arg2} {
  global c

  set c($arg1) $arg2
  return ""
}

proc bibdata {type opt arg} {
}

proc bibitem {type opt arg} {
  global bcount

  incr bcount
  return "\[$bcount\] "
}

proc bibliography {type opt arg} {
  global file

  return [include command {} ${file}.bbl]
}

proc bibliographystyle {type opt arg} {
}

proc bibstyle {type opt arg} {
}

proc caption {type opt txt} {
  global counter float_type

  if {$float_type == "table"} {
    incr counter($float_type)
    return ".LP
Table $counter($float_type): $txt
"
  } else {
    incr counter($float_type)
    return ".LP
Figure $counter($float_type): $txt
"
  }
}

proc cdot {type {opt ""}} {
  return "."
}

proc center {type {opt ""} {arg ""}} {
  if {$type == "begin"} {return "\n.ce 100"} {return "\n.ce 0"}
}
   
proc citation {type opt arg} {
  return ""
}

# \cite{c1, c2, ...}
proc cite {type opt clist} {
  global c

  set clist [split $clist ,]
  foreach e $clist {
    lappend nlist $c([string trim $e])
  }
  return "\[[join $nlist ,]\]"
}

proc contentsline {type opt level text page} {
  return ""
}

proc dash {c} {
  if {$c == 1} {return "-"}
  return "\\*-"
}

proc description {type {opt ""}} {
  global llevel ltype

  set v ""
  if {$type == "begin"} {
    incr llevel
    set ltype($llevel) description
    # if {$llevel >= 1} {set v "\n.RS\n"}
  } else {
    # if {$llevel >= 1} {set v "\n.RE\n"}
    incr llevel -1
  }
  return $v
}

# \begin{displaymath} \end{displaymath}
proc displaymath {type {equ ""}} {
  if {$type == "begin"} {
    parser_suspend displaymath "\\end{displaymath}"
  } else {
    mathematics displaymath "$equ"
  }
}

proc dollar {type opt} {
  return "$"
}

proc dots {type opt} {
  return "..."
}

set initial ".nr PO 0
.AM
.EQ
delim $$
.EN
.pl 100i
.nr LL 7i
.nr HF 0i
.nr FM 0i
.ds CH
.ds CF
"

proc document {type {opt ""}} {
  global initial file toc

  if {$type == "begin"} {
    # include auxiliary file (.aux) if available
    # do now rather than earlier to give usepackage, etc. a chance
    catch {include command {} ${file}.aux} msg
    return $initial
  }

  if {$type == "end"} {
    if {$toc == 1} {return "\n.PX\n"}
    return ""
  }
}

proc documentstyle {type opt arg} {
  global errorInfo style_dir

  set plist [split $opt ,]
  foreach e $plist {
    if {[catch "source ${e}.tcl" msg]} {
      if {[catch "source ${style_dir}/ms/${e}.tcl" msg]} {
      }
    }
  }
  return ""
}

proc documentclass {type opt arg} {
}

proc em {type {opt ""}} {
  global prop g

  case $type in {
    begin   {set v "\n.I\n"}
    end     {set v "\n.R\n"}
    command {lappend prop($g) "\n.R\n"; set v "\n.I\n"}
  }
  return $v
}

proc emph {type opt arg} {
  return "\n.I\n$arg\n.R\n"
}

proc enumerate {type {opt ""}} {
  global llevel ltype lcount

  set v ""
  if {$type == "begin"} {
    incr llevel
    set ltype($llevel) enumerate
    set lcount($llevel) 0
    if {$llevel >= 1} {set v "\n.RS\n"}
  } else {
    if {$llevel >= 1} {set v "\n.RE\n"}
    incr llevel -1
  }
  return $v
}

proc figure {type {opt ""}} {
  global float_type

  if {$type == "begin"} {
    set float_type figure
    return ".KF\n"
  } else {
    return ".KE\n"
  }
  return ""
}

proc flushleft {type {opt ""}} {
  if {$type == "begin"} {
    return "\n.LP"
  } else {
    return ".LP"
  }
  return ""
}

proc flushright {type {opt ""}} {
  return ""
}

proc footnote {type opt arg} {
  return "\\**\n.FS\n${arg}\n.FE\n" 
}

proc footnotesize {type {opt ""} {arg ""}} {
  if {$type == "begin"} {return "\n.SM\n"} {return "\n.NL\n"}
}

proc group {type level} {
  global prop g

  set g $level
  if {$type == "begin"} {
    set prop($g) ""
    return ""
  } else {
    set s ""
    foreach e $prop($g) {
      set s "$s$e\n"
    }
    return $s
  }
}

proc gt {} {
  return ">"
}

proc hash {type opt} {
  return "#"
}

proc hline {type opt} {
  return "_\n"
}

proc hyphenation {type opt arg} {
  return ""
}

proc it {type {opt ""}} {
  global prop g
  lappend prop($g) "\n.R\n"
  return "
.I
"
}

proc item {type {opt ""}} {
  global llevel ltype lcount

  case $ltype($llevel) in {
    itemize     {
          if {$llevel == 1} {return ".IP \\(bu 1\n"}
          if {$llevel >= 2} {return ".IP - 1\n"}
                }
    enumerate   {
          incr lcount($llevel)
          return ".IP $lcount($llevel).\n"
                }
    description {return "\n.XP\n$opt"}
  }
}

proc ignorespaces {type opt} {
}

proc itemize {type {opt ""}} {
  global llevel ltype

  set v ""
  if {$type == "begin"} {
    incr llevel
    set ltype($llevel) itemize
    if {$llevel >= 1} {set v "\n.RS\n"}
  } else {
    if {$llevel >= 1} {set v "\n.RE\n"}
    if {$llevel == 1} {set v "$v.LP\n"}
    incr llevel -1
  }
  return $v
}

proc label {type opt arg} {
  return ""
}

proc LaTeX {type opt} {
  return "LaTeX"
}

proc ldots {type opt} {
  return "..."
}

proc lquote {} {
  return "\\*Q"
}

proc lt {} {
  return "<"
}

proc maketitle {type opt {arg ""}} {
  global title authors
  return "\n.TL\n$title\n.AU\n$authors\n"
}

# handle inline equation; we simply pass it to eqn and hope that it
# does something useful; could probably do some simple substitutions
# like _ -> sub or \alpha -> alpha.
proc math {cmd equ} {
  regsub -all {\^} $equ " sup " equ
  regsub -all {_} $equ " sub " equ
  return "\$$equ\$"
}

proc mu {args} {
  return "mu"
}

proc multicolumn {type opt arg1 arg2 arg3} {
  return "$arg3"
}

proc newblock {type opt} {
  return ""
}

# create a new procedure
proc newcommand {type argc cmd f} {
  set cmd [string range $cmd 1 end]
  set out [open "newcommand" w]
  puts $out "proc $cmd \{" nonewline
  lappend args type opt
  for {set i 1} {$i <= $argc} {incr i} {
    lappend args arg$i
  }
  # for reasons unknown, regsub turns \\ into \ (single)
  puts $out "$args\} \{"
  #regsub -all {\\} $f {\\\\} f
  puts $out "  set x \[substitute \{$f\} " nonewline 
  for {set i 1} {$i <= $argc} {incr i} {
    puts $out "\$arg$i " nonewline
  }
  puts $out {]}
  puts $out "  return \[parse \$x\]"
  puts $out "\}"
  close $out
  source "newcommand"
  exec rm "newcommand"
  parser_init $cmd $argc 0 $cmd e
  return ""
}

# \newlabel{label}{{1}{9}}
proc newlabel {type opt label sec_pg} {
  global r
  regsub -all {[{}]} $sec_pg " " sec_pg
  set r($label) $sec_pg 
  return ""
}

proc newpage {type opt} {
  return ""
}

proc numberline {type opt} {
}

proc par {{type ""} {opt ""}} {
  return "\n.LP\n"
}

proc pageref {type opt label} {
  global r

  lindex $r($label) 1
}

proc parbox {type opt size txt} {
  $txt
}

proc percent {type opt} {
  return "%"
}

#ignore
proc protect {type opt} {
}

proc quotation {type {opt ""} {arg ""}} {
  if {$type == "begin"} {return "\n.QP"} {return "\n"}
}

proc relax {type opt} {
}

proc ref {type opt label} {
  global r

  lindex $r($label) 0
}

proc rquote {} {
  return "\\*U"
}

proc samepage {type opt} {
  return ""
}

proc sf {type opt} {
  return ""
}

proc sloppypar {type {opt ""} {arg ""}} {
  if {$type == "begin"} {return ""} {return ""}
}

proc space {type opt} {
  return " "
}

proc table {type {opt ""}} {
  global float_type

  if {$type == "begin"} {
    set float_type table
    return ".KF\n"
  } else {
    return ".sp\n.KE\n"
  }
  return ""
}

proc tableofcontents {type {opt ""}} {
  global toc

  set toc 1
  return ""
}

# We don't use vertical bars since they don't come out right in
# the ASCII version.
proc tabular {type {opt ""} {arg ""}} {
  global in_tabular

  if {$type == "begin"} {
    set in_tabular 1
    set d [split $arg {}]  
    set t "\n.TS\ntab(&);\n"
    foreach e $d {
      case $e in {
        l {set t "$t L"}
        r {set t "$t R"}
        c {set t "$t C"}
        | {set t "$t"}
      }
    }
    return "$t .\n"
  } else {
    set in_tabular 0
    return "\n.TE\n"
  }
}

proc thanks {type {opt ""} {arg ""}} {
  return "\\**\n.FS\n${arg}\n.FE\n" 
}

proc thebibliography {type {opt ""} {arg ""}} {
  global bcount

  if {$type == "begin"} {
    set bcount 0
    return [Section 1 cmd "" Bibliography]
  }
  return ""
}

proc tie {} {
  return " "
}

proc textwidth {type opt} {
}

proc title {type opt {arg ""}} {
  global title
  set title $arg
  return ""
}

proc today {type opt} {
  return "\\*(DY"
}

proc tt {type {opt ""}} {
  global prop g
  lappend prop($g) "\n.R\n"
  return "\n.R\n"
}

proc umlaut {type opt arg} {
  return "${arg}\\*:"
}

proc usepackage {type opt arg} {
  global errorInfo style_dir

  set plist [split $arg ,]
  foreach e $plist {
    if {[catch "source ./${e}.tcl" msg] \
     && [catch "source ${style_dir}/ms/${e}.tcl" msg] \
     && [catch "include command {} ${e}.sty" msg]} {
      puts stderr "$e: $msg"
    }
  }
  return ""
}

proc verb {type opt {arg ""}} {
  if {$type == "command"} {
    parser_suspend verb $arg
  } elseif {$type == "body"} {
    parser_resume
    return "\n.eo\n$opt\n.ec\n"
  }
}

proc verbatim {type {arg ""}} {
  if {$type == "begin"} {
    parser_suspend verbatim "\\end{verbatim}"
    return "\n.LD\001\n"
  } elseif {$type == "body"} {
    return "$arg\n.DE\001"
  }
}

proc _ {type opt} {
  return "_"
}

#
# Process input file(s)
#

if {$argv != ""} {
  set dir [file rootname ./$argv]
  catch {exec mkdir $dir}
  set file [file rootname [lindex $argv 0]]
  puts [include command {} ${file}.tex]
} else {
  set dir .
  set file -
  puts [include command {} ${file}]
}
