//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 25th September, 2014
//
//
package worker4math.hktex2;

import java.util.ArrayList;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseBooleanArray;

public class Parseeqnarray {

	public static volatile SparseArray<Float> thisypos = new SparseArray<Float>();
	public static volatile SparseBooleanArray error = new SparseBooleanArray();
	public static volatile SparseArray<String> errormessage = new SparseArray<String>();
    
    public void parseeqnarray(Canvas canvas, Block block, Integer tid, Integer containerwidth, Integer containerheight, int superblocknumber, SuperBlock superblock ,SparseArray<ArrayList<String>> superblockline,SparseIntArray superblocknumline,SparseIntArray superblockstartline, SparseIntArray superblockendline, ArrayList<Typeface> tf , String columnspec, Float ypos, String attribute) {
      	
    	int i,j,ii;
	    int numcolumn = columnspec.length();
	    int tid2=tid*1000;
	    
	    float linegap = Header.linegap;
	    float columngap=Header.columngap;	    
		float totalwidth=0;
		float adjusty=ypos;
		float adjustx=0;
		float adjustx2=0;
		float shiftx=0;
		
		String blockline = new String();	
		String rawblockline = new String();
		String thisattribute=attribute;
		
		    ArrayList<Float> columnwidth = new ArrayList<Float>();
		    ArrayList<Float> lineheight = new ArrayList<Float>();
		    ArrayList<Float> linedepth = new ArrayList<Float>();
		   
            ArrayList<Float> blockwidth = new ArrayList<Float>();
            ArrayList<Float> blockheight = new ArrayList<Float>();
            ArrayList<Float> blockdepth = new ArrayList<Float>();
            
    	    columnwidth.clear();lineheight.clear();linedepth.clear();
		    error.put(tid,false);
		    errormessage.put(tid,"");
		    
			Paint textpaint = new Paint();
		    Rect textbounds = new Rect();
			textpaint.setTextSize(Integer.parseInt(attribute.substring(1,4)));
			textpaint.setTypeface(tf.get(Integer.parseInt(attribute.substring(4,7))));
			textpaint.getTextBounds("Aj",0,"Aj".length(),textbounds);
			float spacewidth=textpaint.measureText(" ");
			float spaceheight=textbounds.height();
			float spacedepth=textbounds.bottom;
			
            	  for (i=0;i<=superblockendline.get(superblocknumber)-superblockstartline.get(superblocknumber);i++){
            		  lineheight.add(0.0f);
            		  linedepth.add(0.0f);
            		  synchronized(this){superblock.create(tid);}
                      
                 String currentsuperblockline=superblockline.get(superblocknumber).get(i);
                 
            	  for (ii=0;ii<=numcolumn-1;ii++){                                // First parse
            		  if (i==0) columnwidth.add(0.0f);
            		  if (ii<=numcolumn-2){
                      j=currentsuperblockline.indexOf("&");
                      if (j<0){error.put(tid, true);errormessage.put(tid, "Format error in eqnarray, parse failed !!");return;};
                      rawblockline=currentsuperblockline.substring(0,j); currentsuperblockline=currentsuperblockline.substring(j+1);
                      
                      if (rawblockline.equals("")){rawblockline="!dno ";};
            		  } else {
            			  rawblockline=currentsuperblockline;
            			  if (rawblockline.equals("")){rawblockline="!dno ";};            			 
            		  }
 
            		  Parsepreparation prepareblockline = new Parsepreparation();
    	              blockline=prepareblockline.parsepreparation(rawblockline,Symbol.symboltype,Symbol.matchsymbol);	  	                
  
            		  Parseblock parseblockline = new Parseblock();
	            	  parseblockline.parseblock(tid,canvas,block,blockline,tf,thisattribute);	                      
                      if (Block.error.get(tid)==true){error.put(tid, true); errormessage.put(tid,Block.errormessage.get(tid)); return;};
                      blockwidth.add(Math.max(Block.blockwidth2.get(tid),spacewidth));
                      blockheight.add(Math.max(Block.blockheight2.get(tid),spaceheight));
                      blockdepth.add(Math.max(Block.blockdepth2.get(tid),spacedepth));
                     
                      synchronized(this){superblock.add(tid,Block.subblock2, Block.subblockxpos2, Block.subblockypos2, Block.subblockattribute2, blockwidth.get(blockwidth.size()-1), blockheight.get(blockheight.size()-1), blockdepth.get(blockdepth.size()-1),'e',ii);}                     
                      columnwidth.set(ii,Math.max(columnwidth.get(ii), blockwidth.get(blockwidth.size()-1)));
            	  } 
            	  }
            	  
            	  i=superblockstartline.get(superblocknumber);
            	  int index=tid2+i;
            	  adjusty=adjusty+SuperBlock.superblocklineheight.get(tid).get(i)-SuperBlock.superblocklinedepth.get(tid).get(i);
            	  for (ii=0;ii<=SuperBlock.blockatom.get(index).size()-1;ii++){            			  
            		  SuperBlock.blockypos.get(index).set(ii, SuperBlock.blockypos.get(index).get(ii)+adjusty);            		 
                      }
            	  thisypos.put(tid, adjusty+SuperBlock.superblocklinedepth.get(tid).get(i)+linegap);
            	  for (i=superblockstartline.get(superblocknumber)+1;i<=superblockstartline.get(superblocknumber)+superblocknumline.get(superblocknumber)-1;i++){
            		  index=tid2+i;
            		  adjusty=adjusty+SuperBlock.superblocklinedepth.get(tid).get(i-1)+linegap+SuperBlock.superblocklineheight.get(tid).get(i)-SuperBlock.superblocklinedepth.get(tid).get(i);
            		  for (ii=0;ii<=SuperBlock.blockatom.get(index).size()-1;ii++){            			             			  
                		  SuperBlock.blockypos.get(index).set(ii, SuperBlock.blockypos.get(index).get(ii)+adjusty);
                          }              
            		  thisypos.put(tid, adjusty+SuperBlock.superblocklinedepth.get(tid).get(i)+linegap);
            	  } 
            	  
            	  for (ii=0;ii<=numcolumn-1;ii++){  
                	  totalwidth=totalwidth+columnwidth.get(ii)+columngap;
                	  }
            	  int viewportwidth=containerwidth-Header.leftsidemargin-Header.rightsidemargin;
            	  
            	  if (viewportwidth>totalwidth){shiftx=(viewportwidth-totalwidth)/2;}
            	  else {shiftx=0;};
            	  
            	  for (i=superblockstartline.get(superblocknumber);i<=superblockendline.get(superblocknumber);i++){
            		  adjustx=shiftx+Header.leftsidemargin;
            		  int columnnum=0;
            		  index=tid2+i;
            	  for (ii=0;ii<=SuperBlock.blockatom.get(index).size()-1;ii++){           		                       
            		  if (columnnum != SuperBlock.blockcolumnnum.get(index).get(ii)){ 
            			  columnnum=SuperBlock.blockcolumnnum.get(index).get(ii);
            			  adjustx=adjustx+columngap+columnwidth.get(columnnum-1);            			  
            		  };       
            			 
            		  if (columnspec.charAt(columnnum)=='l'){SuperBlock.blockxpos.get(index).set(ii, SuperBlock.blockxpos.get(index).get(ii)+adjustx);}            			  
            		  else if (columnspec.charAt(columnnum)=='c'){adjustx2=(columnwidth.get(columnnum)-blockwidth.get((i-superblockstartline.get(superblocknumber))*numcolumn+columnnum))/2; SuperBlock.blockxpos.get(index).set(ii, SuperBlock.blockxpos.get(index).get(ii)+adjustx+adjustx2);}
            		  else if (columnspec.charAt(columnnum)=='r'){adjustx2=columnwidth.get(columnnum)-blockwidth.get((i-superblockstartline.get(superblocknumber))*numcolumn+columnnum);SuperBlock.blockxpos.get(index).set(ii, SuperBlock.blockxpos.get(index).get(ii)+adjustx+adjustx2);};} 
            	  }
            	  
}}
    
