/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl	 
 * 
 *	FILE: "member_events.h"
 *								   created:	28/5/96 {8:41:13 pm}
 *								   last update: 05/08/98 {10:09:54 AM}
 *	Author:	  Vince	Darley 
 *	 E-mail: darley@fas.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	1/24/95	  VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_member_events_
#define _Cpptcl_member_events_

#include "cpptcl.h"
#include "sockets_events.h"

/* 
 * You create an event,	and	store a	pointer	to the event.
 * All the event function has to do	is call	the	trigger	function
 * of that event pointer. Cpptclextra handles the rest.
 */

#ifndef _Cpptcl_cpptcl_member_base_
#include "cpptcl_member_base.h"
#endif

//@Section: Cpptclextra library
///
DLL_IMPORT_EXPORT
class cpp_trigger_mem: public cpp_mem {
	friend class cpp_member_info;
  protected:
	cpp_trigger_mem(const cpp_trigger_mem& c):cpp_mem(c) {}
  public:
	///
	virtual cpp_trigger& trigger(void)=0;
	///
	virtual cpp_trigger& trigger(tcl_object*)=0;
	Cpptcl_BaseClass(cpp_trigger_mem);
	cpp_trigger_mem(const char* n):cpp_mem(n) {}
	virtual ~cpp_trigger_mem(void) {}
    ///
	void tcl_get(tcl_object* , tcl_obj& ) const {}
	///
	int parse_tcl_command(tcl_args& arg);
	///
	void get_syntax(tcl_args& arg) const;
    ///
    void conversion_error(tcl_args&) const {}
	///
	cpp_socket_mem* find_socket(cpp_socket_t*, tcl_object*) const;
	/// 
	bool ensemble_behaviour(void) const { return true;}
	
};

//@Section: Cpptclextra library
///
DLL_IMPORT_EXPORT
class cpp_event_mem: public cpp_trigger_mem {
	friend class cpp_member_info;
  protected:
    ///
	cpp_mem* copy(void) const {return new cpp_event_mem(*this);}
	///
	cpp_event_mem(const cpp_event_mem& c):cpp_trigger_mem(c) {}
  public:
	///
	cpp_trigger& trigger(void) { return container->*event;}
	///
	cpp_trigger& trigger(tcl_object* o) { return o->*event;}
	Cpptcl_BaseClass(cpp_event_mem);
	///
	cpp_event_ptr event;
	///
	cpp_event_mem(const char* n,cpp_event_ptr e):cpp_trigger_mem(n),event(e) {}
	~cpp_event_mem(void) {}
    ///
	void tcl_get(tcl_object* , tcl_obj& ) const {}
    ///
    void conversion_error(tcl_args&) const {}
	///
	bool private_data(const cpp_private& data) const {
		return (data == (cpp_mptr)event);
	}
};

//@Section: Cpptclextra library
///
DLL_IMPORT_EXPORT
class cpp_socket_mem: public cpp_trigger_mem {
	friend class cpp_member_info;
  protected:
    ///
	cpp_mem* copy(void) const {return new cpp_socket_mem(*this);}
	cpp_socket_mem(const cpp_socket_mem& c)
	:cpp_trigger_mem(c),socket_(c.socket_) {}
  public:
	///
	cpp_socket_t& socket(void) {return container->*socket_;}
	///
	cpp_socket_t& socket(tcl_object* o) {return o->*socket_;}
	///
	cpp_trigger& trigger(void) { return container->*socket_;}
	///
	cpp_trigger& trigger(tcl_object* o) { return o->*socket_;}
	Cpptcl_BaseClass(cpp_socket_mem);
	///
	cpp_socket_ptr socket_;
	///
	cpp_socket_mem(const char* n,cpp_socket_ptr f):cpp_trigger_mem(n),socket_(f) {}
	~cpp_socket_mem(void) {}
	///
	int parse_tcl_command(tcl_args& arg);
	///
	void get_syntax(tcl_args& arg) const;
    ///
    void conversion_error(tcl_args&) const {}
	///
	cpp_trigger_mem* find_trigger(cpp_trigger*, tcl_object*) const;
	///
	virtual bool private_data(const cpp_private& data) const {
		return (data == (cpp_mptr)socket_);
	}
};


#endif
