/* vgotoxy.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

#if defined (IF_WIN32)
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

void v_gotoxy (int x, int y)
{
  if ((unsigned)x < _v_width && (unsigned)y < _v_height)
    {
      _v_x = x; _v_y = y;
#if defined (IF_WIN32)
      IF_WIN32
	{
	  COORD cc;
	  cc.X = x;
	  cc.Y = y;
	  SetConsoleCursorPosition(GetStdHandle(STD_OUTPUT_HANDLE), cc);
	}
#endif
#if defined (IF_DOS)
      IF_DOS
	{
	  union REGS r;

	  r.h.ah = 0x02;
	  r.h.bh = 0x00;
	  r.h.dl = (unsigned char)x;
	  r.h.dh = (unsigned char)y;
	  _int86 (0x10, &r, &r);
	}
#endif
    }
}
