/*
 * SOURCE:  video.h
 * PROJECT: EasyTeX
 *
 * PURPOSE: function prototypes and defines
 *
 * UPDATES: 08/15/1991 - major rewrite
 *
 * (c)M.Schollmeyer
 */
#ifndef VIDEO_H
#define VIDEO_H

#include <dos.h>

#ifndef BIOS_H
#include "bios.h"
#endif

#ifndef MACROS_H
#include "macros.h"
#endif
/*
#define BLACK        0x00
#define BLUE         0x01
#define GREEN        0x02
#define CYAN         0x03
#define RED          0x04
#define MAGENTA      0x05
#define BROWN        0x06
#define WHITE        0x07
#define GRAY         0x08
#define LIGHTBLUE    0x09
#define LIGHTGREEN   0x0a
#define LIGHTCYAN    0x0b
#define LIGHTRED     0x0c
#define LIGHTMAGENTA 0x0d
#define YELLOW       0x0e
#define BRIGHTWHITE  0x0f

#define ATTR( bk, fg )   (((bk)<<4)|fg)
#define BKCOLOR( attr )  ((attr>>4)&0xf)
#define PENCOLOR( attr ) (attr&0xf)
*/
/*  color palette

    color registers by order of meaning

        text window
            normal text ....................... TEXTCOLOR
            marked text ....................... MARKCOLOR
            hilited text ...................... TEXTHILITE
        help window
            normal text ....................... HELPCOLOR
            button text ....................... HELPBUTTON
            boldface text ..................... HELPBOLD
            italic text ....................... HELPITALIC
        menu colors
            title and windows ................. MENUCOLOR
            menu bar .......................... MENUBAR
            hot key ........................... MENUHOTKEY
            hot key on menu bar ............... MENUBARHOT
            disabled menu or item ............. MENUDISABLE
        window colors
            dialog box ........................ WINDOWCOLOR
            border and title .................. BORDERCOLOR
            window text ....................... WINDOWTEXT
            window shadow ..................... SHADOWCOLOR
        gadget colors
            boolean gadget .................... BOOLGADCOLOR
            selected boolean gadget ........... BOOLGADSELECT
            hot char in selected bool gadget .. BOOLGADSELHOT
            text gadget ....................... TEXTGADGET
            activated text gadget ............. TEXTGADACTIVATED
            gadget hot key .................... GADHOTKEY
            list box color .................... LISTCOLOR
            current item in list box .......... LISTBARCOLOR
            hilited item in list box .......... LISTHILITE
            italic item in list box ........... LISTITALIC
            list bar and arrows ............... LISTBAR
            list knob ......................... LISTKNOB
            selected list knob ................ LISTKNOBSELECT
            disabled gadget ................... GADGETDISABLE
        error colors
            window for error messages ......... ERRORWINDOW
            gadget in error window ............ ERRORGADCOLOR
            selected gadget ................... ERRORGADSELECT
        status colors
            normal text in status line ........ STATUSCOLOR
            hilited text ...................... STATUSHILITE
            error color ....................... STATUSERROR
        flag colors
            enabled flags ..................... FLAGCOLOR
            disabled flags .................... FLAGDISABLE
            hilited flags ..................... FLAGHILITE
        dos screen colors
            normal text ....................... DOSCOLOR
        special
            special color ..................... SPECIAL

    color registers by order of register value

                                       default color
        register name    value       pen         paper           */

#define CR_TEXT             0x00    /*  BLACK       WHITE           */
#define CR_MARK             0x01    /*  BRIGHTWHITE RED             */
#define CR_TEXTHILITE       0x02    /*  RED         WHITE           */
#define CR_HELP             0x03    /*  BRIGHTWHITE CYAN            */
#define CR_HELPBUTTON       0x04    /*  YELLOW      CYAN            */
#define CR_HELPBOLD         0x05    /*  BLACK       CYAN            */
#define CR_HELPITALIC       0x06    /*  GRAY        CYAN            */
#define CR_MENU             0x07    /*  BRIGHTWHITE CYAN            */
#define CR_MENUBAR          0x08    /*  BRIGHTWHITE RED             */
#define CR_MENUHOTKEY       0x09    /*  RED         CYAN            */
#define CR_MENUBARHOT       0x0a    /*  LIGHTRED    RED             */
#define CR_MENUDISABLE      0x0b    /*  GRAY        CYAN            */
#define CR_WINDOW           0x0c    /*  BRIGHTWHITE CYAN            */
#define CR_BORDER           0x0d    /*  BRIGHTWHITE CYAN            */
#define CR_WINDOWTEXT       0x0e    /*  BRIGHTWHITE CYAN            */
#define CR_SHADOW           0x0f    /*  BLACK       GRAY            */
#define CR_BOOLGADGET       0x10    /*  BRIGHTWHITE CYAN            */
#define CR_BOOLGADSELECT    0x11    /*  CYAN        RED             */
#define CR_TEXTGADGET       0x12    /*  BRIGHTWHITE BLACK           */
#define CR_TEXTGADACTIVATED 0x13    /*  BLACK       WHITE           */
#define CR_GADHOTKEY        0x14    /*  RED         CYAN            */
#define CR_GADSELHOT        0x15    /*  LIGHTRED    RED             */
#define CR_LIST             0x16    /*  BRIGHTWHITE BLACK           */
#define CR_LISTBAR          0x17    /*  BLACK       WHITE           */
#define CR_LISTHILITE       0x18    /*  WHITE       BLACK           */
#define CR_LISTITALIC       0x19    /*  YELLOW      BLACK           */
#define CR_LISTKNOB         0x1a    /*  BLACK       WHITE           */
#define CR_LISTKNOBSELECT   0x1b    /*  BLACK       RED             */
#define CR_GADGETDISABLE    0x1c    /*  GRAY        CYAN            */
#define CR_ERRORWINDOW      0x1d    /*  BRIGHTWHITE RED             */
#define CR_ERRORGAD         0x1e    /*  BRIGHTWHITE RED             */
#define CR_ERRORGADSELECT   0x1f    /*  RED         BRIGHTWHITE     */
#define CR_ERRORGADHOT      0x20    /*  CYAN        RED             */
#define CR_ERRORGADSELHOT   0x21    /*  RED         LIGHTRED        */
#define CR_STATUS           0x22    /*  GRAY        WHITE           */
#define CR_STATUSHILITE     0x23    /*  BRIGHTWHITE CYAN            */
#define CR_STATUSERROR      0x24    /*  RED         WHITE           */
#define CR_FLAG             0x25    /*  BRIGHTWHITE CYAN            */
#define CR_FLAGDISABLE      0x26    /*  GRAY        CYAN            */
#define CR_FLAGHILITE       0x27    /*  RED         CYAN            */
#define CR_DOS              0x28    /*  BRIGHTWHITE BLACK           */
#define CR_SPECIAL          0x29    /*  ?           ?               */

#define CR_MAXVAL             42

typedef unsigned int colorreg;

#define SCREEN_WIDTH 80
#define SCREEN_HEIGHT 25

        /* flags for VideoInv */
#define VINV_BACK 0x7000
#define VINV_FORE 0x0f00

/*
#define _VGA_PAGE0 0xb800
#define _VGA_PAGE1 0xb900
#define _VGA_PAGE2 0xba00
*/

    // Adapter Types
#define VIDEO_COLOR (1<<0)
#define VIDEO_MONO  (1<<1)
#define VIDEO_HERC  (1<<2)
#define VIDEO_EGAVGA (1<<3)

struct VideoBase {
    unsigned int Mode;
    unsigned int OldMode;
    unsigned char ScreenWidth;
    unsigned char ScreenHeight;
    unsigned int BufferStart;   // where the buffer starts physically
    unsigned int Segment;       // where the actual page starts
    unsigned int BufferLen;
    unsigned int Adapter;
    unsigned char *Palette;
};

extern struct VideoBase *VideoBase;

struct VideoBase *InitVideo( int );
void VideoSetPage( int );

void VideoExc( unsigned int _far *, unsigned int, unsigned int,
               unsigned int, unsigned int );
void VideoFill( colorreg, unsigned int, unsigned int,
                unsigned int, unsigned int );
void VideoOut( colorreg, unsigned char, unsigned int, unsigned int );
void VideoStr( colorreg, unsigned char *, unsigned int, unsigned int );
void VideoPut( unsigned int, unsigned int, unsigned int );
void VideoAttr( colorreg, unsigned int, unsigned int );
unsigned int VideoGet( unsigned int, unsigned int );
void VideoInv( int, int, int, int, unsigned int );

#endif
