procedure ReadCommandLine;
var i, ind : integer;
    ptrV   : ptrVarRecord;
    ss, s, sch  : string;
    sDir   : DirStr;
    sNam   : NameStr;
    sExt   : ExtStr;
    id     : char;
    ic     : byte;
    fl     : boolean;
begin

     while OneParmMore do
     begin

          s:=ReturnParm(id);

          case id of
          ' ' : if (s <> '') and (s <> ' ') then
          begin
                {Input File Name or variable}
                i:=pos('=',s);
                if i=0 then
                begin
                     {Input File Name}
                     if (TableNameGlb <> '') and (TableNameGlb <> ' ') then
                     begin
                          ErrorLog('*** There are two input files : '
                                  +TableNameGlb+','+s);
                     end
                     else begin
                          TableNameGlb:=s;
                     end;
                end
                else if i=1 then
                begin
                     ErrorLog('*** No variable name in /'+id+':'+s);
                end
                else begin
                     {Variable Name}
                     ss:=copy(s,1,i-1);
                     delete(s,1,i);

                     FixVarName(ss);

                     i:=pos('/',s);
                     if (i > 0) and (i < ord(s[0])) then
                     begin
                          sch:=s[i+1]+' ';
                          case s[i+1] of
                          'R', 'r' : ic:=ord(VarReal);
                          'F', 'D', 'H', 'O', 'B', 'C' : ic:=ord(VarInt);
                          'f', 'd', 'h', 'o', 'b', 'c' : ic:=ord(VarChar);
                          '@' : begin
                                     ic:=ord(VarStr);
                                     if (i+1) < ord(s[0])
                                        then sch:='@ '+UpCase(s[i+2])
                                        else sch:='@ D';
                                end;
                          else begin
                               ErrorLog('*** Error : Index /'+sch+' for '+ss+'= ... has no meaning.');
                               ErrorLog('            String variable is assumed for '+ss);
                               ic:=ord(VarStr); sch:='';
                          end;
                          end; {case}
                     end
                     else begin
                          ic:=ord(VarStr); sch:='';
                     end;

                     if i > 0 then s[0]:=chr(i-1);
                     {
                     if (s = '') or (s = ' ') then
                     begin
                         ErrorLog('*** Warning : VARIABLE '+ss+'=... is without value');
                     end;
                     }
                     s:=sch+s;

                     ptrV:=ptrVariableGlb; fl:=true;
                     while (ptrV <> nil) and fl do
                     begin
                         if ptrV^.VName = ss
                            then fl:=false
                            else ptrV:=ptrV^.ptrNext;
                     end; {while}

                     if fl then
                     begin
                          new(ptrV); ptrV^.psval:=nil;
                          ptrV^.ptrNext:=ptrVariableGlb;
                          ptrVariableGlb:=ptrV;
                     end
                     else begin
                          ErrorLog('*** Warning : VARIABLE '+ss+' is redefined');
                          if ptrV^.VType = VarStr then dispose(ptrV^.psval);
                          ptrV^.psval:=nil;
                          LogReadState;
                     end;

                     with ptrV^ do
                     begin
                          VName:=ss;
                          VType:=VarNone;
                          case VarType(ic) of
                          VarChar : cval:=ConvFromByte(s,true);
                          VarInt  : jval:=ConvFromLongInt(s,true);
                          VarReal : rval:=ConvFromReal(s,true);
                          VarStr  : begin
                                       if psval = nil then new(psval);
                                       psval^:=ConvFromString(s,true);
                                    end;
                          else ic:=ord(VarNone);
                          end; {case}
                          VType:=VarType(ic);
                     end;

                end; {variable}
          end;
          'U', 'u' : begin {Default Directory}
                     if (s = '') or (s = ' ') then
                     begin
                         ErrorLog('*** Empty parameter /U ');
                     end
                     else begin
                         while (s <> '') and (s <> ' ') do
                         begin
                              ind:=pos(';',s);
                              if ind = 0 then
                              begin
                                   ss:=s; s:='';
                              end
                              else begin
                                   ss:=copy(s,1,ind-1);
                                   s:=copy(s,ind+1,ord(s[0])-ind);
                              end;
                              if NDirectory < MaxDirectory then
                              begin
                                   NDirectory:=NDirectory+1;
                                   DefDirectory[NDirectory]:=ss;
                              end
                              else begin
                                   ErrorLog('*** Number of default directories is too large');
                                   s:=''; ss:='';
                              end;
                         end; {while}
                     end;
                end;
          'L', 'l' : begin {LOG File}
                     if FlagLog then
                     begin
                         ErrorLog('*** Warning: LOG file is already opened');
                     end
                     else begin
                         FileSplit(s,sDir,sNam,sExt);
                         if (sNam = '') or (sNam = ' ')
                            then sNam:='NONAME';
                         if (sDir = '') or (sDir = ' ')
                            then sDir:=OutputDirFile;
                         if (sExt = '') or (sExt = ' ')
                            then sExt:='.LOG';
                         s:=PathConcat(sDir,sNam+sExt);
                         assign(fnLog,s);
                         {$I-} rewrite(fnLog); {$I+}
                         if IOResult <> 0
                            then writeln('*** Error: file ('+s+') cannot be opened')
                            else FlagLog:=true;
                     end;
                end;
          'O', 'o' : begin {output file name}
                         OutputDirFile:=s;
                end;
          else begin
                     ErrorLog('*** Unknown option /'+id);
               end;
          end; {case}

     end; {while}
end; {ReadCommandLine}

