/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerBlock;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "getNextLineFromConstraints", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "interruptsParagraph", "", "Companion", "markdown"})
@SourceDebugExtension(value={"SMAP\nGitHubTableMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubTableMarkerProvider.kt\norg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1567#2:114\n1598#2,4:115\n1782#2,4:119\n*S KotlinDebug\n*F\n+ 1 GitHubTableMarkerProvider.kt\norg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerProvider\n*L\n26#1:114\n26#1:115,4\n27#1:119,4\n*E\n"})
public final class GitHubTableMarkerProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        int numberOfHeaderCells;
        int n;
        void $this$count$iv;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(productionHolder, "productionHolder");
        Intrinsics.checkNotNullParameter(stateInfo, "stateInfo");
        MarkdownConstraints currentConstraints = stateInfo.getCurrentConstraints();
        if (!Intrinsics.areEqual(stateInfo.getNextConstraints(), currentConstraints)) {
            return CollectionsKt.emptyList();
        }
        CharSequence currentLineFromPosition = pos.getCurrentLineFromPosition();
        if (!StringsKt.contains$default(currentLineFromPosition, '|', false, 2, null)) {
            return CollectionsKt.emptyList();
        }
        List<String> split = GitHubTableMarkerBlock.Companion.splitByPipes(currentLineFromPosition);
        Iterable iterable = split;
        boolean $i$f$mapIndexed = false;
        void var10_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void s;
            void i;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(i > 0 && i < CollectionsKt.getLastIndex(split) || !StringsKt.isBlank((CharSequence)s));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean it = (Boolean)element$iv;
                boolean bl = false;
                if (!it || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = numberOfHeaderCells = count$iv;
        }
        if (numberOfHeaderCells == 0) {
            return CollectionsKt.emptyList();
        }
        CharSequence charSequence = this.getNextLineFromConstraints(pos, currentConstraints);
        if (charSequence == null) {
            return CollectionsKt.emptyList();
        }
        CharSequence nextLine = charSequence;
        if (Companion.countSecondLineCells(nextLine) == numberOfHeaderCells) {
            return CollectionsKt.listOf(new GitHubTableMarkerBlock(pos, currentConstraints, productionHolder, numberOfHeaderCells));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        return false;
    }

    private final CharSequence getNextLineFromConstraints(LookaheadText.Position pos, MarkdownConstraints constraints) {
        String string = pos.getNextLine();
        if (string == null) {
            return null;
        }
        String line = string;
        MarkdownConstraints nextLineConstraints = constraints.applyToNextLine(pos.nextLinePosition());
        if (MarkdownConstraintsKt.extendsPrev(nextLineConstraints, constraints)) {
            return MarkdownConstraintsKt.eatItselfFromString(nextLineConstraints, line);
        }
        return null;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerProvider$Companion;", "", "()V", "countSecondLineCells", "", "line", "", "passWhiteSpaces", "offset", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        public final int countSecondLineCells(@NotNull CharSequence line) {
            Intrinsics.checkNotNullParameter(line, "line");
            int offset = this.passWhiteSpaces(line, 0);
            if (offset < line.length() && line.charAt(offset) == '|') {
                ++offset;
            }
            int result2 = 0;
            while (offset < line.length()) {
                if ((offset = this.passWhiteSpaces(line, offset)) < line.length() && line.charAt(offset) == ':') {
                    ++offset;
                    offset = this.passWhiteSpaces(line, offset);
                }
                int dashes = 0;
                while (offset < line.length() && line.charAt(offset) == '-') {
                    ++offset;
                    ++dashes;
                }
                if (dashes < 1) {
                    return 0;
                }
                ++result2;
                if ((offset = this.passWhiteSpaces(line, offset)) < line.length() && line.charAt(offset) == ':') {
                    ++offset;
                    offset = this.passWhiteSpaces(line, offset);
                }
                if (offset >= line.length() || line.charAt(offset) != '|') break;
                ++offset;
                offset = this.passWhiteSpaces(line, offset);
            }
            if (offset == line.length()) {
                return result2;
            }
            return 0;
        }

        public final int passWhiteSpaces(@NotNull CharSequence line, int offset) {
            int curOffset;
            Intrinsics.checkNotNullParameter(line, "line");
            for (curOffset = offset; curOffset < line.length() && (line.charAt(curOffset) == ' ' || line.charAt(curOffset) == '\t'); ++curOffset) {
            }
            return curOffset;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

