---
title: "crossrefenum"
subtitle: "Smart typesetting of enumerated cross-references for various TeX formats"
author: Bastien Dumont
email: bastien [dot] dumont [at] posteo [dot] net
date: "2025/08/07"
version: 1.2
lang: en-US
toc: true
license: true
---

_crossrefenum_ lets TeX manage the formatting
of bunches of cross-references for you. It features:

  * Automatic collapsing of references;
  * Support for references by various criteria:
    
      * page and note number;
      * in ConTeXt: line number;
      * in LaTeX, when used in conjunction with _reledmac_: edpage and edline.

  * Handling of references combining two criteria
    (e.g. by page and note number);
  * Extension mechanisms to add support to other types of references
    without modifying the internal macros.

Note that sorting is not supported.
I assume that users know in what order
the labels they refer to appear in their document.

It is written in Plain TeX as much as possible
in order to make it compatible with a wide array of formats.
For the moment, it works out of the box with ConTeXt and LaTeX.
Its only (optional) dependency is [`expkv`](https://ctan.org/pkg/expkv-bundle),
but it may require other packages to work properly in some formats
(e.g. [`zref`](https://ctan.org/pkg/zref) in LaTeX).

The file `main-test.pdf` provides a showcase of the abilities of _crossrefenum_.

## Loading

To load _crossrefenum_, provided that
`crossrefenum.tex`, `crossrefenum.sty` and `t-crossrefenum.tex`
are installed in a directory where TeX will find them
(presumably under the `tex/generic/crossrefenum` directory of one of your _texmf_ trees),
you can do:

  * `\input{crossrefenum}` (generic);
  * `\usepackage{crossrefenum}` (LaTeX;
    must be called after _nameref_ if you use _hyperref_`\kern1.5pt`{=context});
  * `\usemodule[crossrefenum]` (ConTeXt).

## Summary {#summary}

  * [`\crossrefenum`](#macro-crossrefenum): the main macro
  
  * [`\crfnmsetup`](#crfnmsetup-macro): configuration macro (default of per type)

```{=context}
\vskip\medskipamount
```

+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|**Configuration  |**Configuration macro (with `\def`)**          |**Meaning**          |**Example**   |**Page**                      |
|key (with        |                                               |                     |              |                              |
|`\crfnmsetup`)** |                                               |                     |              |                              |
+=================+===============================================+=====================+==============+==============================+
|`<type>` _is a single type_                                                            |`page`                                       |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`sg`             |`\crfnm<type>`                                 |Singular prefix      |`{p. }`       |`\at[prefixes]`{=context}     |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`pl`             |`\crfnm<type>s`                                |Plural prefix        |`{pp. }`      |`\at[prefixes]`{=context}     |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`delimiter`      |`\crfnm<type>EnumDelim`                        |Delimiter between    |`{, }`        |`\at[delimiters]`{=context}   |
|                 |                                               |references           |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`before last     |`\crfnm<type>BeforeLastInEnum`                 |Delimiter before the |`{ and }`     |`\at[delimiters]`{=context}   |
|reference`       |                                               |last reference       |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`range separator`|`\crfnm<type>RangeSep`                         |Separator between the|`{\tt         |`\at[range-sep]`{=context}    |
|                 |                                               |two values in a range|`{=context} – |                              |
|                 |                                               |                     |`}`{=context} |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`collapsable?`   |`\crfnm<type>Collapsable`                      |Should consecutive   |`yes` or `no` |`\at[collapsable]`{=context}  |
|                 |                                               |numbers (e.g. 2, 3,  |              |                              |
|                 |                                               |4) be merged into a  |              |                              |
|                 |                                               |range?               |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`<type>` _is a double type_                                                            |`pagenote`                                   |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`subtypes        |`\crfnm<type>SubtypesSep`                      |Separator between the|`{, }`        |`\at[subtypes-sep]`{=context} |
|separator`       |                                               |two types of         |              |                              |
|                 |                                               |references in a      |              |                              |
|                 |                                               |double reference     |              |                              |
|                 |                                               |(e.g. between the    |              |                              |
|                 |                                               |page and note numbers|              |                              |
|                 |                                               |in a reference to a  |              |                              |
|                 |                                               |note including the   |              |                              |
|                 |                                               |page number)         |              |                              |
|                 |                                               |                     |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`print prefix of |`\crfnm<type>PrintFirstPrefix`                 |Should the numbers of|`always` or   |`\at[fst-pref-dbl]`{=context} |
|first subtype`   |                                               |the first subtype be |`once`        |                              |
|                 |                                               |prefixed always or   |              |                              |
|                 |                                               |only for the first   |              |                              |
|                 |                                               |reference in an      |              |                              |
|                 |                                               |enumeration?         |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`group subtypes?`|`\crfnm<type>GroupSubtypes`                    |Sould all the values |`yes` or `no` |`\at[group-subt]`{=context}   |
|                 |                                               |for each subtype be  |              |                              |
|                 |                                               |printed separately?  |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`order`          |`\crfnm<type>Order`                            |Whether the subtypes |`normal` or   |`\at[order]`{=context}        |
|                 |                                               |are printed in the   |`inverted`    |                              |
|                 |                                               |same order as in the |              |                              |
|                 |                                               |name of the double   |              |                              |
|                 |                                               |type                 |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`<type>` _is a single type; the following options apply when it is used as the second  |`page`                                       |
|subtype of a double type_                                                              |                                             |
|                                                                                       |                                             |
|                                                                                       |                                             |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`formatting when |`\crfnm<type>FormatInSecond`                   |`{}` or a macro that |`\textbf`     |`\at[fmt-sec-subt]`{=context} |
|second subtype`  |                                               |takes the prefixes   |              |                              |
|                 |                                               |and numbers as its   |              |                              |
|                 |                                               |argument             |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`print prefix    |`\crfnm<type>PrintPrefixInSecond`              |Should the prefix be |`yes` or `no` |`\at[rep-pref-dbl]`{=context} |
|when second      |                                               |printed?             |              |                              |
|subtype?`        |                                               |                     |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`delimiter when  |`\crfnm<type>EnumDelimInSecond`                |Delimiter between    |`{, }`        |`\at[delim-sec-dbl]`{=context}|
|second subtype`  |                                               |references           |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`before last     |`\crfnm<type>BeforeLastInSecond`               |Delimiter before the |`{ and }`     |`\at[delim-sec-dbl]`{=context}|
|reference when   |                                               |last reference       |              |                              |
|second subtype`  |                                               |                     |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+
|`continuous      |`\crfnm<type>NumberingContinuousAcrossDocument`|Is the numbering for |`yes` or `no` |`\at[numb-contin]`{=context}  |
|numbering?`      |                                               |this type continuous |              |                              |
|                 |                                               |(i.e. not reset at   |              |                              |
|                 |                                               |every                |              |                              |
|                 |                                               |page/chapter/etc.)?  |              |                              |
+-----------------+-----------------------------------------------+---------------------+--------------+------------------------------+

## Basic invocation {#macro-crossrefenum}

The macro `\crossrefenum` has the following syntax:

  > \\crossrefenum[\<type\>][\<print prefix?\>]{\<enumeration\>}

  * _type_ is the type of the references. Built-in possible values are:
    * For LaTeX and ConTeXt: `page`, `note`, `pagenote`;
    * For ConTeXt only: `line`, `pageline`;
    * For LaTeX with _reledmac_: `edpage`, `edline`, `edpageline`.
  * _print prefix?_ indicates whether the prefix (like “p. ”) should be printed or not: true if set to `withprefix` or `yes`;
  * _enumeration_ is a group containing one or more _single_ labels (e.g. `mylabel`) or _ranges_ (e.g. `lbl-begin to lbl-end`).
    Ranges cannot be used with `note` and `pagenote` types.
    Two syntaxes are supported: lists of groups and comma-delimited lists (see below).

_type_ and _print prefix?_ are optional. _type_ defaults to `page` and _print prefix_ to `withprefix`.

Here are some valid invocations with the comma-delimited syntax:

  * `\crossrefenum[note][withprefix]{lblone, lbltwo, lblthree}`
  * `\crossrefenum[edline][noprefix]{lblone, lbltwo, lblthree}`
  * `\crossrefenum[page]{lblone to lbltwo, lblthree}`
  * `\crossrefenum[noprefix]{lblone, lbltwo, lblthree}` (_type_ defaults to `page`)
  * `\crossrefenum[note]{lblone, lbltwo, lblthree}` (_print prefix?_ defaults to `withprefix`)
  * `\crossrefenum{lblone, lbltwo, lblthree}` (_type_ defaults to `page` and _print prefix?_ defaults to `withprefix`)
  * `\crossrefenum{only-one}`

The same invocations with the group-based syntax:

  * `\crossrefenum[note][withprefix]{{lblone}{lbltwo}{lblthree}}`
  * `\crossrefenum[edline][noprefix]{{lblone}{lbltwo}{lblthree}}`
  * `\crossrefenum[page]{{lblone to lbltwo}{lblthree}}`
  * `\crossrefenum[noprefix]{{lblone}{lbltwo}{lblthree}}`
  * `\crossrefenum[note]{{lblone}{lbltwo}{lblthree}}`
  * `\crossrefenum{{lblone}{lbltwo}{lblthree}}`
  * `\crossrefenum{{only-one}}` (even if the enumeration is limited to one item, it can be inside its own group)

## Customization {#crfnmsetup-macro}

There are two configuration interfaces:
one based on key-value lists, the other on (re)defining macros.
These two interfaces can be used concurrently.
If you are not interested in using the key-value interface
or prefer not to depend on the `expkv` package,
you can deactivate it by defining `\crfnmNoKV` to anything other than `\relax`
before loading `crossrefenum`.

After having explained the general principles,
we will present the options related to single types
before we turn to the options specific to double types and their subtypes.
For each configuration option, I will show
first how to use the key-value interface using `\crfnmsetup`,
and second how to do the same thing with the low-level macros.

### General principles {#specialize-config-macros}

In this manual, “default” means “not type-specific”.
In this respect, “default” settings may be set be the user.

The key-value interface has the following syntax:

  > \\crfnmsetup[<“default” or type>]{ \<key1\> = \<value1\>, <…> }

_type_ is a single or a double type (e.g. `page` or `pagenote`).
The spaces around the equal signs and the commas are optional and ignored;
if a value contains leading or trailing spaces, it must be put inside a group
(e.g. `delimiter = {, }`).

Under the hood, `\crfnmsetup` (re)defines the low-level configuration macros,
which you can also manipulate directly.

When successive calls to `\crfnmsetup` contradict one another, the last one prevails,
except that type-specific settings always have precedence over the default ones.

In the following subsections, I will generally present the low-level macros
corresponding to the default settings, which have `Default` in their name.
If you want to redefine a macro for a specific type,
simply replace `Default` with the (capitalized) name of the type
(e.g. `\crfnmPageEnumDelim` instead of `\crfnmDefaultEnumDelim`).

Setting a value in the key-value interface or a macro to `\relax`
will cause `\crossrefenum` to fall back to the default value.
To set a configuration option to an absence of operation,
use an empty group (e.g. `\def\crfnmPageEnumDelim{}`
if you really don't want any delimiter between page numbers
while the default delimiter is a comma followed by a space).

Unless specified otherwise, the examples in the following subsections
correspond to the built-in configuration.

### Prefixes, delimiters and separators

You can define the [singular and plural prefixes]{#prefixes}
printed before the value of the reference like this:

```{.tex}
\crfnmsetup[page]{sg={p.~}, pl={pp.~}}
\crfnmsetup[note]{sg={n.~}, pl={nn.~}}
\crfnmsetup[edpage]{sg={p.~}, pl={pp.~}}
\crfnmsetup[edline]{sg={l.~}, pl={ll.~}}
```
`\noindentation`{=context} which almost amounts to the built-in configuration:

```{.tex}
\def\crfnmPage{p.~}
\def\crfnmPages{pp.~}
\def\crfnmNote{n.~}
\def\crfnmNotes{nn.~}
\let\crfnmEdpage\crfnmPage
\let\crfnmEdpages\crfnmPages
\def\crfnmEdline{l.~}
\def\crfnmEdlines{ll.~}
```

`\noindentation`{=context} (it would have been more accurate to write
`\crfnmsetup[edpage]{sg=\crfnmPage, pl=\crfnmPages}`).

The [delimiters]{#delimiters} printed respectively between the successive references in an enumeration
and before the last one are set so:

```{.tex}
\crfnmsetup[default]{
  delimiter = {, },
  before last reference = { and }
}
```
`\noindentation`{=context} which amounts to:

```{.tex}
\def\crfnmDefaultEnumDelim{, }
\def\crfnmDefaultBeforeLastInEnum{ and }
```

The [separator in a range]{#range-sep} is set like this:

```{.tex}
\crfnmsetup[default]{range separator = –}
```
`\noindentation`{=context} which amounts to:

```{.tex}
\def\crfnmDefaultRangeSep{–}
```

### Collapsable and non-collapsable types {#collapsable}

The configuration option `collapsable?` and
the macro `\crfnmDefaultCollapsable` define if ranges are allowed.
The built-in configuration corresponds to:

```{.tex}
\crfnmsetup[default]{collapsable?=yes}
\crfnmsetup[note]{collapsable?=no}
```
`\noindentation`{=context} which amounts to:

```{.tex}
\def\crfnmDefaultCollapsable{yes}
\def\crfnmNoteCollapsable{no}
```

Thus, unless you change that, a reference to consecutive notes
is formatted like “nn. 3, 4 and 5”, not like “nn. 3–5”.

Ranges are not accepted in the argument of `\crossrefenum` for non-collapsable types.
This extends to double types that include a non-collapsable type
(such as `pagenote` in the built-in configuration).

### Double types

You can set like this [the separator between the two values in a double reference]{#subtypes-sep}
(e.g. the page and the note numbers in a `pagenote` reference):

```{.tex}
\crfnmsetup[default]{subtypes separator={, }}
```
`\noindentation`{=context} which amounts to:

```{.tex}
\def\crfnmDefaultSubtypesSep{, }
```

When more than one reference is cited in an enumeration,
[you may not want the first prefix to be repeated every time]{#fst-pref-dbl}
(e.g. you may prefer “pp. 5, n. 2; 7, n. 4” to “p. 5, n. 2; p. 7, n. 4”).
In this case, set `print prefix of first subtype`
or `\crfnmDefaultPrintFirstPrefix` to `once`.
Otherwise you will get:

```{.tex}
\crfnmsetup[default]{
  print prefix of first subtype = always
}
```
`\noindentation`{=context} which amounts to:

```{.tex}
\def\crfnmDefaultPrintFirstPrefix{always}
```

If you want to [format the second subtype]{#fmt-sec-subt} in a special way (e.g. in superscript),
set the key `formatting when second subtype` either to `{}` (no formatting)
or to a macro which will take the reference number and all its affixes as its only argument (e.g. `\textsuperscript`).
Alternatively, you can define `\crfnmDefaultFormatInSecond` with one argument.
What `\crossrefenum` comes with is:

```{.tex}
\crfnmsetup[default]{formatting when second subtype = {}}
```
`\noindentation`{=context} which amounts to:

```{.tex}
\def\crfnmDefaultFormatInSecond#1{#1}
```

[If you don't want any prefix to be printed in the second term of a double reference]{#rep-pref-dbl},
set `print prefix when second subtype?`
or `\crfnmDefaultPrintPrefixInSecond` to `no` (built-in: yes).

Here is how you can print the line number in superscript
when it comes after the corresponding page number:

```{.tex}
\crfnmsetup[edline]{
  formatting when second subtype = \textsuperscript,
  print prefix when second subtype? = no
}
```
`\noindentation`{=context} which amounts to:

```{.tex}
\def\crfnmEdlineFormatInSecond#1{\textsuperscript{#1}}
\def\crfnmEdlinePrintPrefixInSecond{no}
```

After that, `\crossrefenum[edpageline]{mylabel}` may return “p. 5^10^”,
whereas `\crossrefenum[edline]{mylabel}` would return “l. 10”.

You can specify a [specific delimiter for the second part of double references]{#delim-sec-dbl}
and a specific string to be printed before the last reference of the second subtype in a double reference
(e.g. the last reference to a line in “p. 5, l. 10, 13, 16”, which is “16”).
For instance, you may want to use the word “and”
before the last note number if the reference type is a simple one (`note`)
and a comma if it is comes in second in a double reference (e.g. in `pagenote`).
To achieve this, you can set `delimiter when second subtype` (= `\crfnmDefaultEnumDelimInSecond`)
and `before last reference when second subtype`
(= `\crfnmDefaultBeforeLastInSecond`).
In the built-in configuration, there is no difference between a simple type used alone
and the same simple type taken as the second subtype of a double type,
but we could imagine the following:

```{.tex}
\crfnmsetup[note]{
  delimiter = {; },
  before last reference = { and },
  delimiter when second subtype = {, },
  before last reference when second subtype = {, }
}
\crossrefenum[note]{lbl1, lbl2, lbl3}
= \crossrefenum[pagenote]{lbl1, lbl2, lbl3}
```
`\noindentation`{=context} which may yield: “n. 1; 2 and 5 = p. 8, n. 1, 2, 5”.

[When citing a range, the two parts of the reference]{#group-subt} can
be either split (e.g. “p. 5, l. 3 – p. 7, l. 44”)
or grouped (“p. 5–7, l. 3–44”).
This is controlled via `group subtypes?` (= `\crfnmDefaultGroupSubtypes`),
which can be set to `yes` or `no`.
This works only with [collapsable types](#collapsable):

```{.tex}
\crfnmsetup[default]{group subtypes? = no}
```
`\noindentation`{=context} which amounts to:

```{.tex}
\def\crfnmDefaultGroupSubtypes{no}
```

To know if a reference to “p. 6, l. 34” should be merged with “p. 7, l. 35”,
_crossrefenum_ needs to know if the lineation is
[continuous]{#numb-contin} (in this case, these lines are consecutive)
or per page (they are not, so they should not be merged).
You can set accordingly `continuous numbering?`
(= `\crfnmDefaultNumberingContinuousAcrossDocument`)[^line-numbering]
to `yes` (built-in) or `no`.
Note that _crossrefenum_ cannot merge a reference
to the last line of a page and the first line of the following page
if the lineation is not continuous.

[^line-numbering]: In this case, you could set more specifically
  `\crfnmLineNumberingContinuousAcrossDocument`
  or `\crfnmEdlineNumberingContinuousAcrossDocument`
  or use `\crfnmsetup` with `[line]` and `[edline]`.

In the built-in configuration, the [order of the subtypes]{#order} in the name of a subtype
(e.g. “page” and “note” in “pagenote”) determines by default
the order in which they are printed (e.g. “p. 6, n. 2” instead of “n. 2, p. 6”).
If you want to change this, set `order` (= `\crfnmDefaultOrder`) to `inverted` (built-in: `normal`).

## How to extend crossrefenum with other types and formats {#extending}

Adding support for new types consists in defining the related macros in your preamble.
Here is a commented example that would add support for references to lines in ConTeXt
if this feature were not already included in _crossrefenum_.
I suppose that the labels are inserted in the document using the standard ConTeXt macros,
i.e. `\someline` for line references and `\pagereference` for page references.

```{.tex}
% Register the types. Take care about capitalization!

%% Set the names of the types and their corresponding macros:
%% the control sequence should always be lowercase
%% and the name of the type capitalized.
\def\crfnm@line{Line}
\def\crfnm@pageline{Pageline}

%% Add them to the lists of known types.
\crfnm@declareType[simple][\crfnm@line]
\crfnm@declareType[double][\crfnm@pageline]
```

```{.tex}
%% For the double types, set the primary and the secondary type.
%% The primary type corresponds to the widest typographic unit
%% (“page” for “pagenote”, “section” for “sectionpage”...).
\let\crfnm@PagelinePrimary\crfnm@page
\let\crfnm@PagelineSecondary\crfnm@line

% Define the macro used to typeset the reference number.
\def\crfnm@LineRef#1{\in[lr:b:#1]}

% Define the macro used by \crossrefenum internally
% to retrieve the raw reference number without typesetting it.
% This macro must be purely expandable.
% If you want to support multiple formats,
% see how the macro \crfnm@case is used in crossrefenum.tex.
% Note: the Lua function get_raw_ref_number is defined
% in crossrefenum.tex for ConTeXt.
\def\crfnm@getLineNumber#1{\directlua{get_raw_ref_number('lr:b:#1', 'linenumber')}}

% Define all specific configuration options in the regular way.
% Instead of the following, you can use \crfnmsetup.
```

```{.tex}
%% Required
\def\crfnmLine{l.~}
\def\crfnmLines{ll.~}

%% If it differs from the defaults.
\def\crfnmLineCollapsable{yes}
\def\crfnmLineBeforeLastInSecond{, }
\def\crfnmPagelineSubtypesSep{}
\def\crfnmPagelinePrintFirstPrefix{once}
\def\crfnmLineFormatInSecond#1{\crfnmSuperscript{#1}}
\def\crfnmLinePrintPrefixInSecond{no}
```

Adding support for additional formats is far less trivial,
not least because most of them do not provide a straightforward way
to get reference numbers via purely expandable macros,
which is required for _crossrefenum_ to perform its calculations.
If you have wishes or hints about this, please contact me.

## Compatibility issues

With LaTeX, the _nameref_ package (required by _hyperref_`\kern1.5pt`{=context})
must be loaded explicitely before _crossrefenum_.
However, if the links in the output of `\crossrefenum` (not the numbers)
point to a wrong location, you may wish to patch the macro
to disable _hyperref_ locally:

``` {.tex}
\makeatletter
\let\oldcrfnm@enum\crfnm@enum
\def\crfnm@enum[#1][#2]#3{%
  \begin{NoHyper}\oldcrfnm@enum[#1][#2]{#3}\end{NoHyper}%
}
\makeatother
```

<!--
                GNU Free Documentation License
                 Version 1.3, 3 November 2008


 Copyright (C) 2000, 2001, 2002, 2007, 2008 Free Software Foundation, Inc.
     <https://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

0. PREAMBLE

The purpose of this License is to make a manual, textbook, or other
functional and useful document "free" in the sense of freedom: to
assure everyone the effective freedom to copy and redistribute it,
with or without modifying it, either commercially or noncommercially.
Secondarily, this License preserves for the author and publisher a way
to get credit for their work, while not being considered responsible
for modifications made by others.

This License is a kind of "copyleft", which means that derivative
works of the document must themselves be free in the same sense.  It
complements the GNU General Public License, which is a copyleft
license designed for free software.

We have designed this License in order to use it for manuals for free
software, because free software needs free documentation: a free
program should come with manuals providing the same freedoms that the
software does.  But this License is not limited to software manuals;
it can be used for any textual work, regardless of subject matter or
whether it is published as a printed book.  We recommend this License
principally for works whose purpose is instruction or reference.


1. APPLICABILITY AND DEFINITIONS

This License applies to any manual or other work, in any medium, that
contains a notice placed by the copyright holder saying it can be
distributed under the terms of this License.  Such a notice grants a
world-wide, royalty-free license, unlimited in duration, to use that
work under the conditions stated herein.  The "Document", below,
refers to any such manual or work.  Any member of the public is a
licensee, and is addressed as "you".  You accept the license if you
copy, modify or distribute the work in a way requiring permission
under copyright law.

A "Modified Version" of the Document means any work containing the
Document or a portion of it, either copied verbatim, or with
modifications and/or translated into another language.

A "Secondary Section" is a named appendix or a front-matter section of
the Document that deals exclusively with the relationship of the
publishers or authors of the Document to the Document's overall
subject (or to related matters) and contains nothing that could fall
directly within that overall subject.  (Thus, if the Document is in
part a textbook of mathematics, a Secondary Section may not explain
any mathematics.)  The relationship could be a matter of historical
connection with the subject or with related matters, or of legal,
commercial, philosophical, ethical or political position regarding
them.

The "Invariant Sections" are certain Secondary Sections whose titles
are designated, as being those of Invariant Sections, in the notice
that says that the Document is released under this License.  If a
section does not fit the above definition of Secondary then it is not
allowed to be designated as Invariant.  The Document may contain zero
Invariant Sections.  If the Document does not identify any Invariant
Sections then there are none.

The "Cover Texts" are certain short passages of text that are listed,
as Front-Cover Texts or Back-Cover Texts, in the notice that says that
the Document is released under this License.  A Front-Cover Text may
be at most 5 words, and a Back-Cover Text may be at most 25 words.

A "Transparent" copy of the Document means a machine-readable copy,
represented in a format whose specification is available to the
general public, that is suitable for revising the document
straightforwardly with generic text editors or (for images composed of
pixels) generic paint programs or (for drawings) some widely available
drawing editor, and that is suitable for input to text formatters or
for automatic translation to a variety of formats suitable for input
to text formatters.  A copy made in an otherwise Transparent file
format whose markup, or absence of markup, has been arranged to thwart
or discourage subsequent modification by readers is not Transparent.
An image format is not Transparent if used for any substantial amount
of text.  A copy that is not "Transparent" is called "Opaque".

Examples of suitable formats for Transparent copies include plain
ASCII without markup, Texinfo input format, LaTeX input format, SGML
or XML using a publicly available DTD, and standard-conforming simple
HTML, PostScript or PDF designed for human modification.  Examples of
transparent image formats include PNG, XCF and JPG.  Opaque formats
include proprietary formats that can be read and edited only by
proprietary word processors, SGML or XML for which the DTD and/or
processing tools are not generally available, and the
machine-generated HTML, PostScript or PDF produced by some word
processors for output purposes only.

The "Title Page" means, for a printed book, the title page itself,
plus such following pages as are needed to hold, legibly, the material
this License requires to appear in the title page.  For works in
formats which do not have any title page as such, "Title Page" means
the text near the most prominent appearance of the work's title,
preceding the beginning of the body of the text.

The "publisher" means any person or entity that distributes copies of
the Document to the public.

A section "Entitled XYZ" means a named subunit of the Document whose
title either is precisely XYZ or contains XYZ in parentheses following
text that translates XYZ in another language.  (Here XYZ stands for a
specific section name mentioned below, such as "Acknowledgements",
"Dedications", "Endorsements", or "History".)  To "Preserve the Title"
of such a section when you modify the Document means that it remains a
section "Entitled XYZ" according to this definition.

The Document may include Warranty Disclaimers next to the notice which
states that this License applies to the Document.  These Warranty
Disclaimers are considered to be included by reference in this
License, but only as regards disclaiming warranties: any other
implication that these Warranty Disclaimers may have is void and has
no effect on the meaning of this License.

2. VERBATIM COPYING

You may copy and distribute the Document in any medium, either
commercially or noncommercially, provided that this License, the
copyright notices, and the license notice saying this License applies
to the Document are reproduced in all copies, and that you add no
other conditions whatsoever to those of this License.  You may not use
technical measures to obstruct or control the reading or further
copying of the copies you make or distribute.  However, you may accept
compensation in exchange for copies.  If you distribute a large enough
number of copies you must also follow the conditions in section 3.

You may also lend copies, under the same conditions stated above, and
you may publicly display copies.


3. COPYING IN QUANTITY

If you publish printed copies (or copies in media that commonly have
printed covers) of the Document, numbering more than 100, and the
Document's license notice requires Cover Texts, you must enclose the
copies in covers that carry, clearly and legibly, all these Cover
Texts: Front-Cover Texts on the front cover, and Back-Cover Texts on
the back cover.  Both covers must also clearly and legibly identify
you as the publisher of these copies.  The front cover must present
the full title with all words of the title equally prominent and
visible.  You may add other material on the covers in addition.
Copying with changes limited to the covers, as long as they preserve
the title of the Document and satisfy these conditions, can be treated
as verbatim copying in other respects.

If the required texts for either cover are too voluminous to fit
legibly, you should put the first ones listed (as many as fit
reasonably) on the actual cover, and continue the rest onto adjacent
pages.

If you publish or distribute Opaque copies of the Document numbering
more than 100, you must either include a machine-readable Transparent
copy along with each Opaque copy, or state in or with each Opaque copy
a computer-network location from which the general network-using
public has access to download using public-standard network protocols
a complete Transparent copy of the Document, free of added material.
If you use the latter option, you must take reasonably prudent steps,
when you begin distribution of Opaque copies in quantity, to ensure
that this Transparent copy will remain thus accessible at the stated
location until at least one year after the last time you distribute an
Opaque copy (directly or through your agents or retailers) of that
edition to the public.

It is requested, but not required, that you contact the authors of the
Document well before redistributing any large number of copies, to
give them a chance to provide you with an updated version of the
Document.


4. MODIFICATIONS

You may copy and distribute a Modified Version of the Document under
the conditions of sections 2 and 3 above, provided that you release
the Modified Version under precisely this License, with the Modified
Version filling the role of the Document, thus licensing distribution
and modification of the Modified Version to whoever possesses a copy
of it.  In addition, you must do these things in the Modified Version:

A. Use in the Title Page (and on the covers, if any) a title distinct
   from that of the Document, and from those of previous versions
   (which should, if there were any, be listed in the History section
   of the Document).  You may use the same title as a previous version
   if the original publisher of that version gives permission.
B. List on the Title Page, as authors, one or more persons or entities
   responsible for authorship of the modifications in the Modified
   Version, together with at least five of the principal authors of the
   Document (all of its principal authors, if it has fewer than five),
   unless they release you from this requirement.
C. State on the Title page the name of the publisher of the
   Modified Version, as the publisher.
D. Preserve all the copyright notices of the Document.
E. Add an appropriate copyright notice for your modifications
   adjacent to the other copyright notices.
F. Include, immediately after the copyright notices, a license notice
   giving the public permission to use the Modified Version under the
   terms of this License, in the form shown in the Addendum below.
G. Preserve in that license notice the full lists of Invariant Sections
   and required Cover Texts given in the Document's license notice.
H. Include an unaltered copy of this License.
I. Preserve the section Entitled "History", Preserve its Title, and add
   to it an item stating at least the title, year, new authors, and
   publisher of the Modified Version as given on the Title Page.  If
   there is no section Entitled "History" in the Document, create one
   stating the title, year, authors, and publisher of the Document as
   given on its Title Page, then add an item describing the Modified
   Version as stated in the previous sentence.
J. Preserve the network location, if any, given in the Document for
   public access to a Transparent copy of the Document, and likewise
   the network locations given in the Document for previous versions
   it was based on.  These may be placed in the "History" section.
   You may omit a network location for a work that was published at
   least four years before the Document itself, or if the original
   publisher of the version it refers to gives permission.
K. For any section Entitled "Acknowledgements" or "Dedications",
   Preserve the Title of the section, and preserve in the section all
   the substance and tone of each of the contributor acknowledgements
   and/or dedications given therein.
L. Preserve all the Invariant Sections of the Document,
   unaltered in their text and in their titles.  Section numbers
   or the equivalent are not considered part of the section titles.
M. Delete any section Entitled "Endorsements".  Such a section
   may not be included in the Modified Version.
N. Do not retitle any existing section to be Entitled "Endorsements"
   or to conflict in title with any Invariant Section.
O. Preserve any Warranty Disclaimers.

If the Modified Version includes new front-matter sections or
appendices that qualify as Secondary Sections and contain no material
copied from the Document, you may at your option designate some or all
of these sections as invariant.  To do this, add their titles to the
list of Invariant Sections in the Modified Version's license notice.
These titles must be distinct from any other section titles.

You may add a section Entitled "Endorsements", provided it contains
nothing but endorsements of your Modified Version by various
parties--for example, statements of peer review or that the text has
been approved by an organization as the authoritative definition of a
standard.

You may add a passage of up to five words as a Front-Cover Text, and a
passage of up to 25 words as a Back-Cover Text, to the end of the list
of Cover Texts in the Modified Version.  Only one passage of
Front-Cover Text and one of Back-Cover Text may be added by (or
through arrangements made by) any one entity.  If the Document already
includes a cover text for the same cover, previously added by you or
by arrangement made by the same entity you are acting on behalf of,
you may not add another; but you may replace the old one, on explicit
permission from the previous publisher that added the old one.

The author(s) and publisher(s) of the Document do not by this License
give permission to use their names for publicity for or to assert or
imply endorsement of any Modified Version.


5. COMBINING DOCUMENTS

You may combine the Document with other documents released under this
License, under the terms defined in section 4 above for modified
versions, provided that you include in the combination all of the
Invariant Sections of all of the original documents, unmodified, and
list them all as Invariant Sections of your combined work in its
license notice, and that you preserve all their Warranty Disclaimers.

The combined work need only contain one copy of this License, and
multiple identical Invariant Sections may be replaced with a single
copy.  If there are multiple Invariant Sections with the same name but
different contents, make the title of each such section unique by
adding at the end of it, in parentheses, the name of the original
author or publisher of that section if known, or else a unique number.
Make the same adjustment to the section titles in the list of
Invariant Sections in the license notice of the combined work.

In the combination, you must combine any sections Entitled "History"
in the various original documents, forming one section Entitled
"History"; likewise combine any sections Entitled "Acknowledgements",
and any sections Entitled "Dedications".  You must delete all sections
Entitled "Endorsements".


6. COLLECTIONS OF DOCUMENTS

You may make a collection consisting of the Document and other
documents released under this License, and replace the individual
copies of this License in the various documents with a single copy
that is included in the collection, provided that you follow the rules
of this License for verbatim copying of each of the documents in all
other respects.

You may extract a single document from such a collection, and
distribute it individually under this License, provided you insert a
copy of this License into the extracted document, and follow this
License in all other respects regarding verbatim copying of that
document.


7. AGGREGATION WITH INDEPENDENT WORKS

A compilation of the Document or its derivatives with other separate
and independent documents or works, in or on a volume of a storage or
distribution medium, is called an "aggregate" if the copyright
resulting from the compilation is not used to limit the legal rights
of the compilation's users beyond what the individual works permit.
When the Document is included in an aggregate, this License does not
apply to the other works in the aggregate which are not themselves
derivative works of the Document.

If the Cover Text requirement of section 3 is applicable to these
copies of the Document, then if the Document is less than one half of
the entire aggregate, the Document's Cover Texts may be placed on
covers that bracket the Document within the aggregate, or the
electronic equivalent of covers if the Document is in electronic form.
Otherwise they must appear on printed covers that bracket the whole
aggregate.


8. TRANSLATION

Translation is considered a kind of modification, so you may
distribute translations of the Document under the terms of section 4.
Replacing Invariant Sections with translations requires special
permission from their copyright holders, but you may include
translations of some or all Invariant Sections in addition to the
original versions of these Invariant Sections.  You may include a
translation of this License, and all the license notices in the
Document, and any Warranty Disclaimers, provided that you also include
the original English version of this License and the original versions
of those notices and disclaimers.  In case of a disagreement between
the translation and the original version of this License or a notice
or disclaimer, the original version will prevail.

If a section in the Document is Entitled "Acknowledgements",
"Dedications", or "History", the requirement (section 4) to Preserve
its Title (section 1) will typically require changing the actual
title.


9. TERMINATION

You may not copy, modify, sublicense, or distribute the Document
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense, or distribute it is void, and
will automatically terminate your rights under this License.

However, if you cease all violation of this License, then your license
from a particular copyright holder is reinstated (a) provisionally,
unless and until the copyright holder explicitly and finally
terminates your license, and (b) permanently, if the copyright holder
fails to notify you of the violation by some reasonable means prior to
60 days after the cessation.

Moreover, your license from a particular copyright holder is
reinstated permanently if the copyright holder notifies you of the
violation by some reasonable means, this is the first time you have
received notice of violation of this License (for any work) from that
copyright holder, and you cure the violation prior to 30 days after
your receipt of the notice.

Termination of your rights under this section does not terminate the
licenses of parties who have received copies or rights from you under
this License.  If your rights have been terminated and not permanently
reinstated, receipt of a copy of some or all of the same material does
not give you any rights to use it.


10. FUTURE REVISIONS OF THIS LICENSE

The Free Software Foundation may publish new, revised versions of the
GNU Free Documentation License from time to time.  Such new versions
will be similar in spirit to the present version, but may differ in
detail to address new problems or concerns.  See
https://www.gnu.org/licenses/.

Each version of the License is given a distinguishing version number.
If the Document specifies that a particular numbered version of this
License "or any later version" applies to it, you have the option of
following the terms and conditions either of that specified version or
of any later version that has been published (not as a draft) by the
Free Software Foundation.  If the Document does not specify a version
number of this License, you may choose any version ever published (not
as a draft) by the Free Software Foundation.  If the Document
specifies that a proxy can decide which future versions of this
License can be used, that proxy's public statement of acceptance of a
version permanently authorizes you to choose that version for the
Document.

11. RELICENSING

"Massive Multiauthor Collaboration Site" (or "MMC Site") means any
World Wide Web server that publishes copyrightable works and also
provides prominent facilities for anybody to edit those works.  A
public wiki that anybody can edit is an example of such a server.  A
"Massive Multiauthor Collaboration" (or "MMC") contained in the site
means any set of copyrightable works thus published on the MMC site.

"CC-BY-SA" means the Creative Commons Attribution-Share Alike 3.0 
license published by Creative Commons Corporation, a not-for-profit 
corporation with a principal place of business in San Francisco, 
California, as well as future copyleft versions of that license 
published by that same organization.

"Incorporate" means to publish or republish a Document, in whole or in 
part, as part of another Document.

An MMC is "eligible for relicensing" if it is licensed under this 
License, and if all works that were first published under this License 
somewhere other than this MMC, and subsequently incorporated in whole or 
in part into the MMC, (1) had no cover texts or invariant sections, and 
(2) were thus incorporated prior to November 1, 2008.

The operator of an MMC Site may republish an MMC contained in the site
under CC-BY-SA on the same site at any time before August 1, 2009,
provided the MMC is eligible for relicensing.


ADDENDUM: How to use this License for your documents

To use this License in a document you have written, include a copy of
the License in the document and put the following copyright and
license notices just after the title page:

    Copyright (c)  YEAR  YOUR NAME.
    Permission is granted to copy, distribute and/or modify this document
    under the terms of the GNU Free Documentation License, Version 1.3
    or any later version published by the Free Software Foundation;
    with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.
    A copy of the license is included in the section entitled "GNU
    Free Documentation License".

If you have Invariant Sections, Front-Cover Texts and Back-Cover Texts,
replace the "with...Texts." line with this:

    with the Invariant Sections being LIST THEIR TITLES, with the
    Front-Cover Texts being LIST, and with the Back-Cover Texts being LIST.

If you have Invariant Sections without Cover Texts, or some other
combination of the three, merge those two alternatives to suit the
situation.

If your document contains nontrivial examples of program code, we
recommend releasing these examples in parallel under your choice of
free software license, such as the GNU General Public License,
to permit their use in free software.
-->
