/**
 * Authors : quentin.vaney@gmail.com;xavier.frelechoz@gmail.com
 * Version : V1
 */

package LaTexScreenshooter;
import java.util.Objects;

public class LaTeXScreenshooter {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("No arguments were passed.");
        } else {
            String url = args[0];
            int width = args.length > 1 ? Integer.parseInt(args[1]) : 600;
            int height = args.length > 2 ? Integer.parseInt(args[2]) : 600;
            String fileName = args.length > 3 ? args[3] : "Screenshot";
            String path = args.length > 3 ? args[4] : System.getProperty("user.dir");

            String os = System.getProperty("os.name").toLowerCase();
            String slash = "";
            if (os.contains("win")) {
                slash = "\\";
            } else {
                slash = "/";
            }

            if (!path.endsWith("\\") && !path.endsWith("/")) {
                path = path + slash;
            }

            path = PathValidator.isPathValid(path) ? path : System.getProperty("user.dir") + slash;
            System.out.println(path);
            String sessionType = System.getenv("XDG_SESSION_TYPE");
            if (Objects.equals(sessionType, "wayland")) {
                WaylandScreenshooter.captureScreenshot(url, width, height, fileName, path);
            } else {
                System.out.println("Unable to determine the session type.");
                ScreenShooter.captureScreenshot(url, width, height, fileName, path);
            }
        }
    }
}
